/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collections;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.b;
import org.apache.lucene.codecs.e;
import org.apache.lucene.codecs.i;
import org.apache.lucene.codecs.n;
import org.apache.lucene.codecs.p;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentCoreReaders;
import org.apache.lucene.index.SegmentDocValues;
import org.apache.lucene.index.SegmentDocValuesProducer;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.c;
import org.apache.lucene.util.Bits;

public final class SegmentReader
extends CodecReader {
    private final SegmentCommitInfo si;
    private final Bits liveDocs;
    private final int numDocs;
    final SegmentCoreReaders core;
    final SegmentDocValues segDocValues;
    final b docValuesProducer;
    final FieldInfos fieldInfos;

    public SegmentReader(SegmentCommitInfo segmentCommitInfo, IOContext object) throws IOException {
        this.si = segmentCommitInfo;
        this.core = new SegmentCoreReaders(this, segmentCommitInfo.info.dir, segmentCommitInfo, (IOContext)object);
        this.segDocValues = new SegmentDocValues();
        object = segmentCommitInfo.info.getCodec();
        try {
            if (segmentCommitInfo.hasDeletions()) {
                this.liveDocs = ((Codec)object).liveDocsFormat().readLiveDocs(this.directory(), segmentCommitInfo, IOContext.READONCE);
            } else {
                assert (segmentCommitInfo.getDelCount() == 0);
                this.liveDocs = null;
            }
            this.numDocs = segmentCommitInfo.info.maxDoc() - segmentCommitInfo.getDelCount();
            this.fieldInfos = this.initFieldInfos();
            this.docValuesProducer = this.initDocValuesProducer();
            return;
        }
        catch (Throwable throwable) {
            this.doClose();
            throw throwable;
        }
    }

    SegmentReader(SegmentCommitInfo segmentCommitInfo, SegmentReader segmentReader) throws IOException {
        this(segmentCommitInfo, segmentReader, segmentCommitInfo.info.getCodec().liveDocsFormat().readLiveDocs(segmentCommitInfo.info.dir, segmentCommitInfo, IOContext.READONCE), segmentCommitInfo.info.maxDoc() - segmentCommitInfo.getDelCount());
    }

    SegmentReader(SegmentCommitInfo segmentCommitInfo, SegmentReader segmentReader, Bits bits, int n2) throws IOException {
        if (n2 > segmentCommitInfo.info.maxDoc()) {
            throw new IllegalArgumentException("numDocs=" + n2 + " but maxDoc=" + segmentCommitInfo.info.maxDoc());
        }
        if (bits != null && bits.length() != segmentCommitInfo.info.maxDoc()) {
            throw new IllegalArgumentException("maxDoc=" + segmentCommitInfo.info.maxDoc() + " but liveDocs.size()=" + bits.length());
        }
        this.si = segmentCommitInfo;
        this.liveDocs = bits;
        this.numDocs = n2;
        this.core = segmentReader.core;
        this.core.incRef();
        this.segDocValues = segmentReader.segDocValues;
        try {
            this.fieldInfos = this.initFieldInfos();
            this.docValuesProducer = this.initDocValuesProducer();
            return;
        }
        catch (Throwable throwable) {
            this.doClose();
            throw throwable;
        }
    }

    private b initDocValuesProducer() throws IOException {
        c c2;
        c c3 = c2 = this.core.cfsReader != null ? this.core.cfsReader : this.si.info.dir;
        if (!this.fieldInfos.hasDocValues()) {
            return null;
        }
        if (this.si.hasFieldUpdates()) {
            return new SegmentDocValuesProducer(this.si, c2, this.core.coreFieldInfos, this.fieldInfos, this.segDocValues);
        }
        return this.segDocValues.getDocValuesProducer(-1L, this.si, c2, this.fieldInfos);
    }

    private FieldInfos initFieldInfos() throws IOException {
        if (!this.si.hasFieldUpdates()) {
            return this.core.coreFieldInfos;
        }
        org.apache.lucene.codecs.c c2 = this.si.info.getCodec().fieldInfosFormat();
        String string = Long.toString(this.si.getFieldInfosGen(), 36);
        return c2.read(this.si.info.dir, this.si.info, string, IOContext.READONCE);
    }

    @Override
    public final Bits getLiveDocs() {
        this.ensureOpen();
        return this.liveDocs;
    }

    @Override
    protected final void doClose() throws IOException {
        try {
            this.core.decRef();
        }
        catch (Throwable throwable) {
            try {
                super.doClose();
            }
            finally {
                if (this.docValuesProducer instanceof SegmentDocValuesProducer) {
                    this.segDocValues.decRef(((SegmentDocValuesProducer)this.docValuesProducer).dvGens);
                } else if (this.docValuesProducer != null) {
                    this.segDocValues.decRef(Collections.singletonList(-1L));
                }
            }
            throw throwable;
        }
        try {
            super.doClose();
        }
        catch (Throwable throwable) {
            if (this.docValuesProducer instanceof SegmentDocValuesProducer) {
                this.segDocValues.decRef(((SegmentDocValuesProducer)this.docValuesProducer).dvGens);
            } else if (this.docValuesProducer != null) {
                this.segDocValues.decRef(Collections.singletonList(-1L));
            }
            throw throwable;
        }
        if (this.docValuesProducer instanceof SegmentDocValuesProducer) {
            this.segDocValues.decRef(((SegmentDocValuesProducer)this.docValuesProducer).dvGens);
            return;
        }
        if (this.docValuesProducer != null) {
            this.segDocValues.decRef(Collections.singletonList(-1L));
            return;
        }
    }

    @Override
    public final FieldInfos getFieldInfos() {
        this.ensureOpen();
        return this.fieldInfos;
    }

    @Override
    public final int numDocs() {
        return this.numDocs;
    }

    @Override
    public final int maxDoc() {
        return this.si.info.maxDoc();
    }

    @Override
    public final p getTermVectorsReader() {
        this.ensureOpen();
        return this.core.termVectorsLocal.get();
    }

    @Override
    public final n getFieldsReader() {
        this.ensureOpen();
        return this.core.fieldsReaderLocal.get();
    }

    @Override
    public final i getNormsReader() {
        this.ensureOpen();
        return this.core.normsProducer;
    }

    @Override
    public final b getDocValuesReader() {
        this.ensureOpen();
        return this.docValuesProducer;
    }

    @Override
    public final e getPostingsReader() {
        this.ensureOpen();
        return this.core.fields;
    }

    public final String toString() {
        return this.si.toString(this.si.info.maxDoc() - this.numDocs - this.si.getDelCount());
    }

    public final String getSegmentName() {
        return this.si.info.name;
    }

    public final SegmentCommitInfo getSegmentInfo() {
        return this.si;
    }

    public final c directory() {
        return this.si.info.dir;
    }
}

