/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.codecs.TermVectorsWriter;
import org.apache.lucene.codecs.d;
import org.apache.lucene.codecs.g;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.c;
import org.apache.lucene.util.InfoStream;

final class SegmentMerger {
    private final c directory;
    private final Codec codec;
    private final IOContext context;
    final MergeState mergeState;
    private final FieldInfos.Builder fieldInfosBuilder;

    SegmentMerger(List<CodecReader> list, SegmentInfo segmentInfo, InfoStream infoStream, c c2, FieldInfos.FieldNumbers fieldNumbers, IOContext iOContext) throws IOException {
        if (iOContext.context != IOContext.Context.MERGE) {
            throw new IllegalArgumentException("IOContext.context should be MERGE; got: " + (Object)((Object)iOContext.context));
        }
        this.mergeState = new MergeState(list, segmentInfo, infoStream);
        this.directory = c2;
        this.codec = segmentInfo.getCodec();
        this.context = iOContext;
        this.fieldInfosBuilder = new FieldInfos.Builder(fieldNumbers);
    }

    final boolean shouldMerge() {
        return this.mergeState.segmentInfo.maxDoc() > 0;
    }

    final MergeState merge() throws IOException {
        long l2;
        if (!this.shouldMerge()) {
            throw new IllegalStateException("Merge would result in 0 document segment");
        }
        this.mergeFieldInfos();
        long l3 = 0L;
        if (this.mergeState.infoStream.isEnabled("SM")) {
            l3 = System.nanoTime();
        }
        int n2 = this.mergeFields();
        if (this.mergeState.infoStream.isEnabled("SM")) {
            long l4 = System.nanoTime();
            this.mergeState.infoStream.message("SM", (l4 - l3) / 1000000L + " msec to merge stored fields [" + n2 + " docs]");
        }
        assert (n2 == this.mergeState.segmentInfo.maxDoc()) : "numMerged=" + n2 + " vs mergeState.segmentInfo.maxDoc()=" + this.mergeState.segmentInfo.maxDoc();
        SegmentWriteState segmentWriteState = new SegmentWriteState(this.mergeState.infoStream, this.directory, this.mergeState.segmentInfo, this.mergeState.mergeFieldInfos, null, this.context);
        if (this.mergeState.infoStream.isEnabled("SM")) {
            l3 = System.nanoTime();
        }
        this.mergeTerms(segmentWriteState);
        if (this.mergeState.infoStream.isEnabled("SM")) {
            l2 = System.nanoTime();
            this.mergeState.infoStream.message("SM", (l2 - l3) / 1000000L + " msec to merge postings [" + n2 + " docs]");
        }
        if (this.mergeState.infoStream.isEnabled("SM")) {
            l3 = System.nanoTime();
        }
        if (this.mergeState.mergeFieldInfos.hasDocValues()) {
            this.mergeDocValues(segmentWriteState);
        }
        if (this.mergeState.infoStream.isEnabled("SM")) {
            l2 = System.nanoTime();
            this.mergeState.infoStream.message("SM", (l2 - l3) / 1000000L + " msec to merge doc values [" + n2 + " docs]");
        }
        if (this.mergeState.mergeFieldInfos.hasNorms()) {
            if (this.mergeState.infoStream.isEnabled("SM")) {
                l3 = System.nanoTime();
            }
            this.mergeNorms(segmentWriteState);
            if (this.mergeState.infoStream.isEnabled("SM")) {
                l2 = System.nanoTime();
                this.mergeState.infoStream.message("SM", (l2 - l3) / 1000000L + " msec to merge norms [" + n2 + " docs]");
            }
        }
        if (this.mergeState.mergeFieldInfos.hasVectors()) {
            if (this.mergeState.infoStream.isEnabled("SM")) {
                l3 = System.nanoTime();
            }
            n2 = this.mergeVectors();
            if (this.mergeState.infoStream.isEnabled("SM")) {
                l2 = System.nanoTime();
                this.mergeState.infoStream.message("SM", (l2 - l3) / 1000000L + " msec to merge vectors [" + n2 + " docs]");
            }
            assert (n2 == this.mergeState.segmentInfo.maxDoc());
        }
        if (this.mergeState.infoStream.isEnabled("SM")) {
            l3 = System.nanoTime();
        }
        this.codec.fieldInfosFormat().write(this.directory, this.mergeState.segmentInfo, "", this.mergeState.mergeFieldInfos, this.context);
        if (this.mergeState.infoStream.isEnabled("SM")) {
            l2 = System.nanoTime();
            this.mergeState.infoStream.message("SM", (l2 - l3) / 1000000L + " msec to write field infos [" + n2 + " docs]");
        }
        return this.mergeState;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void mergeDocValues(SegmentWriteState object) throws IOException {
        object = this.codec.docValuesFormat().fieldsConsumer((SegmentWriteState)object);
        Throwable throwable = null;
        try {
            ((DocValuesConsumer)object).merge(this.mergeState);
            if (object == null) return;
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (object == null) throw throwable4;
                if (throwable != null) {
                    try {
                        object.close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable4;
                } else {
                    object.close();
                }
                throw throwable4;
            }
        }
        object.close();
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void mergeNorms(SegmentWriteState object) throws IOException {
        object = this.codec.normsFormat().normsConsumer((SegmentWriteState)object);
        Throwable throwable = null;
        try {
            ((g)object).merge(this.mergeState);
            if (object == null) return;
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (object == null) throw throwable4;
                if (throwable != null) {
                    try {
                        object.close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable4;
                } else {
                    object.close();
                }
                throw throwable4;
            }
        }
        object.close();
        return;
    }

    public final void mergeFieldInfos() throws IOException {
        FieldInfos[] fieldInfosArray = this.mergeState.fieldInfos;
        int n2 = this.mergeState.fieldInfos.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            for (FieldInfo fieldInfo : fieldInfosArray[i2]) {
                this.fieldInfosBuilder.add(fieldInfo);
            }
        }
        this.mergeState.mergeFieldInfos = this.fieldInfosBuilder.finish();
    }

    private int mergeFields() throws IOException {
        int n2;
        block9: {
            StoredFieldsWriter storedFieldsWriter = this.codec.storedFieldsFormat().fieldsWriter(this.directory, this.mergeState.segmentInfo, this.context);
            Throwable throwable = null;
            try {
                n2 = storedFieldsWriter.merge(this.mergeState);
                if (storedFieldsWriter == null) break block9;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (storedFieldsWriter != null) {
                        if (throwable != null) {
                            try {
                                storedFieldsWriter.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            storedFieldsWriter.close();
                        }
                    }
                    throw throwable4;
                }
            }
            storedFieldsWriter.close();
        }
        return n2;
    }

    private int mergeVectors() throws IOException {
        int n2;
        block9: {
            TermVectorsWriter termVectorsWriter = this.codec.termVectorsFormat().vectorsWriter(this.directory, this.mergeState.segmentInfo, this.context);
            Throwable throwable = null;
            try {
                n2 = termVectorsWriter.merge(this.mergeState);
                if (termVectorsWriter == null) break block9;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (termVectorsWriter != null) {
                        if (throwable != null) {
                            try {
                                termVectorsWriter.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            termVectorsWriter.close();
                        }
                    }
                    throw throwable4;
                }
            }
            termVectorsWriter.close();
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void mergeTerms(SegmentWriteState object) throws IOException {
        object = this.codec.postingsFormat().fieldsConsumer((SegmentWriteState)object);
        Throwable throwable = null;
        try {
            ((d)object).merge(this.mergeState);
            if (object == null) return;
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (object == null) throw throwable4;
                if (throwable != null) {
                    try {
                        ((d)object).close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable4;
                } else {
                    ((d)object).close();
                }
                throw throwable4;
            }
        }
        ((d)object).close();
        return;
    }
}

