/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.g;
import org.apache.lucene.index.i;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.b;
import org.apache.lucene.store.c;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.Version;

public final class SegmentInfos
implements Cloneable,
Iterable<SegmentCommitInfo> {
    public int counter;
    public long version;
    private long generation;
    private long lastGeneration;
    public Map<String, String> userData = Collections.emptyMap();
    private List<SegmentCommitInfo> segments = new ArrayList<SegmentCommitInfo>();
    private static PrintStream infoStream = null;
    private byte[] id;
    private Version luceneVersion;
    private Version minSegmentLuceneVersion;
    private static final List<String> unsupportedCodecs = Arrays.asList("Lucene3x");
    boolean pendingCommit;

    public final SegmentCommitInfo info(int n2) {
        return this.segments.get(n2);
    }

    public static long getLastCommitGeneration(String[] stringArray) {
        long l2 = -1L;
        for (String string : stringArray) {
            long l3;
            if (!string.startsWith("segments") || string.equals("segments.gen") || (l3 = SegmentInfos.generationFromSegmentsFileName(string)) <= l2) continue;
            l2 = l3;
        }
        return l2;
    }

    public static String getLastCommitSegmentsFileName(String[] stringArray) {
        return IndexFileNames.fileNameFromGeneration("segments", "", SegmentInfos.getLastCommitGeneration(stringArray));
    }

    public final String getSegmentsFileName() {
        return IndexFileNames.fileNameFromGeneration("segments", "", this.lastGeneration);
    }

    public static long generationFromSegmentsFileName(String string) {
        if (string.equals("segments")) {
            return 0L;
        }
        if (string.startsWith("segments")) {
            return Long.parseLong(string.substring(9), 36);
        }
        throw new IllegalArgumentException("fileName \"" + string + "\" is not a segments file");
    }

    private long getNextPendingGeneration() {
        if (this.generation == -1L) {
            return 1L;
        }
        return this.generation + 1L;
    }

    /*
     * Unable to fully structure code
     */
    public static final SegmentInfos readCommit(c var0, String var1_2) throws IOException {
        block38: {
            var2_4 = SegmentInfos.generationFromSegmentsFileName((String)var1_2);
            var1_2 = var0.openChecksumInput((String)var1_2, IOContext.READ);
            var4_6 = null;
            try {
                var5_7 = var1_2.readInt();
                if (var5_7 != 1071082519) {
                    throw new IndexFormatTooOldException((DataInput)var1_2, var5_7, 1071082519, 1071082519);
                }
                var5_7 = CodecUtil.checkHeaderNoMagic((DataInput)var1_2, "segments", 0, 6);
                var6_9 = null;
                if (var5_7 >= 4) {
                    var6_9 = new byte[16];
                    var1_2.readBytes((byte[])var6_9, 0, 16);
                    CodecUtil.checkIndexHeaderSuffix((DataInput)var1_2, Long.toString(var2_4, 36));
                }
                var7_11 = new SegmentInfos();
                new SegmentInfos().id = var6_9;
                var7_11.generation = var2_4;
                var7_11.lastGeneration = var2_4;
                if (var5_7 >= 6) {
                    var7_11.luceneVersion = Version.fromBits(var1_2.readVInt(), var1_2.readVInt(), var1_2.readVInt());
                }
                var7_11.version = var1_2.readLong();
                var7_11.counter = var1_2.readInt();
                var2_5 = var1_2.readInt();
                if (var2_5 < 0) {
                    throw new CorruptIndexException("invalid segment count: " + var2_5, (DataInput)var1_2);
                }
                if (var5_7 >= 6 && var2_5 > 0) {
                    var7_11.minSegmentLuceneVersion = Version.fromBits(var1_2.readVInt(), var1_2.readVInt(), var1_2.readVInt());
                    if (!var7_11.minSegmentLuceneVersion.onOrAfter(Version.LUCENE_4_0_0_ALPHA)) {
                        throw new IndexFormatTooOldException((DataInput)var1_2, "this index contains a too-old segment (version: " + var7_11.minSegmentLuceneVersion + ")");
                    }
                }
                var11_12 = 0L;
                for (var13_13 = 0; var13_13 < var2_5; ++var13_13) {
                    var14_24 = var1_2.readString();
                    if (var5_7 < 4) ** GOTO lbl41
                    var16_28 = var1_2.readByte();
                    if (var16_28 == 1) {
                        var15_25 = new byte[16];
                        var1_2.readBytes(var15_25, 0, 16);
                    } else {
                        if (var16_28 != 0) {
                            throw new CorruptIndexException("invalid hasID byte, got: " + var16_28, (DataInput)var1_2);
                        }
lbl41:
                        // 3 sources

                        var15_25 = null;
                    }
                    var16_27 = SegmentInfos.readCodec((DataInput)var1_2, var5_7 < 6);
                    var3_16 = var16_27.segmentInfoFormat().read(var0, var14_24, var15_25, IOContext.READ);
                    var3_16.setCodec(var16_27);
                    var11_12 += (long)var3_16.maxDoc();
                    var17_29 = var1_2.readLong();
                    var6_10 = var1_2.readInt();
                    if (var6_10 < 0 || var6_10 > var3_16.maxDoc()) {
                        throw new CorruptIndexException("invalid deletion count: " + var6_10 + " vs maxDoc=" + var3_16.maxDoc(), (DataInput)var1_2);
                    }
                    var19_30 = -1L;
                    if (var5_7 > 0) {
                        var19_30 = var1_2.readLong();
                    }
                    var21_31 = var5_7 >= 3 ? var1_2.readLong() : var19_30;
                    var6_9 = new SegmentCommitInfo(var3_16, var6_10, var17_29, var19_30, var21_31);
                    if (var5_7 > 0) {
                        if (var5_7 < 3) {
                            var8_18 = var1_2.readInt();
                            if (var8_18 == 0) {
                                var9_20 = Collections.emptyMap();
                            } else {
                                var9_20 = new HashMap<K, V>(var8_18);
                                for (var10_22 = 0; var10_22 < var8_18; ++var10_22) {
                                    var9_20.put(var1_2.readLong(), var1_2.readStringSet());
                                }
                            }
                            var6_9.setGenUpdatesFiles(var9_20);
                        } else {
                            if (var5_7 >= 5) {
                                var6_9.setFieldInfosFiles(var1_2.readSetOfStrings());
                            } else {
                                var6_9.setFieldInfosFiles(Collections.unmodifiableSet(var1_2.readStringSet()));
                            }
                            var9_21 = var1_2.readInt();
                            if (var9_21 == 0) {
                                var8_17 = Collections.emptyMap();
                            } else {
                                var10_23 = new HashMap<Integer, Set<String>>(var9_21);
                                for (var8_19 = 0; var8_19 < var9_21; ++var8_19) {
                                    if (var5_7 >= 5) {
                                        var10_23.put(var1_2.readInt(), var1_2.readSetOfStrings());
                                        continue;
                                    }
                                    var10_23.put(var1_2.readInt(), Collections.unmodifiableSet(var1_2.readStringSet()));
                                }
                                var8_17 = Collections.unmodifiableMap(var10_23);
                            }
                            var6_9.setDocValuesUpdatesFiles((Map<Integer, Set<String>>)var8_17);
                        }
                    }
                    var7_11.add((SegmentCommitInfo)var6_9);
                    var8_17 = var3_16.getVersion();
                    if (var5_7 < 6) {
                        if (var7_11.minSegmentLuceneVersion != null && var8_17.onOrAfter(var7_11.minSegmentLuceneVersion)) continue;
                        var7_11.minSegmentLuceneVersion = var8_17;
                        continue;
                    }
                    if (var8_17.onOrAfter(var7_11.minSegmentLuceneVersion)) continue;
                    throw new CorruptIndexException("segments file recorded minSegmentLuceneVersion=" + var7_11.minSegmentLuceneVersion + " but segment=" + var3_16 + " has older version=" + var8_17, (DataInput)var1_2);
                }
                var7_11.userData = var5_7 >= 5 ? var1_2.readMapOfStrings() : Collections.unmodifiableMap(var1_2.readStringStringMap());
                if (var5_7 >= 2) {
                    CodecUtil.checkFooter((b)var1_2);
                } else {
                    var13_14 = var1_2.getChecksum();
                    if (var13_14 != (var15_26 = var1_2.readLong())) {
                        throw new CorruptIndexException("checksum failed (hardware problem?) : expected=" + Long.toHexString(var15_26) + " actual=" + Long.toHexString(var13_14), (DataInput)var1_2);
                    }
                    CodecUtil.checkEOF((IndexInput)var1_2);
                }
                if (var11_12 > (long)IndexWriter.getActualMaxDocs()) {
                    throw new CorruptIndexException("Too many documents: an index cannot exceed " + IndexWriter.getActualMaxDocs() + " but readers have total maxDoc=" + var11_12, (DataInput)var1_2);
                }
                var13_15 = var7_11;
                if (var1_2 == null) break block38;
            }
            catch (Throwable v0) {
                try {
                    var5_8 = v0;
                    var4_6 = v0;
                    throw var5_8;
                }
                catch (Throwable var0_1) {
                    if (var1_2 != null) {
                        if (var4_6 != null) {
                            try {
                                var1_2.close();
                            }
                            catch (Throwable var1_3) {
                                var4_6.addSuppressed(var1_3);
                            }
                        } else {
                            var1_2.close();
                        }
                    }
                    throw var0_1;
                }
            }
            var1_2.close();
        }
        return var13_15;
    }

    private static Codec readCodec(DataInput object, boolean bl) throws IOException {
        String string = ((DataInput)object).readString();
        try {
            return Codec.forName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (unsupportedCodecs.contains(string)) {
                assert (bl);
                object = new IndexFormatTooOldException((DataInput)object, "Codec '" + string + "' is too old");
                ((Throwable)object).initCause(illegalArgumentException);
                throw object;
            }
            if (string.startsWith("Lucene")) {
                throw new IllegalArgumentException("Could not load codec '" + string + "'.  Did you forget to add lucene-backward-codecs.jar?", illegalArgumentException);
            }
            throw illegalArgumentException;
        }
    }

    public static final SegmentInfos readLatestCommit(c c2) throws IOException {
        return (SegmentInfos)new FindSegmentsFile<SegmentInfos>(c2){

            @Override
            protected final /* synthetic */ Object doBody(String string) throws IOException {
                return SegmentInfos.readCommit(this.directory, string);
            }
        }.run();
    }

    private void write(c c2) throws IOException {
        long l2 = this.getNextPendingGeneration();
        String string = IndexFileNames.fileNameFromGeneration("pending_segments", "", l2);
        this.generation = l2;
        IndexOutput indexOutput = null;
        try {
            indexOutput = c2.createOutput(string, IOContext.DEFAULT);
            CodecUtil.writeIndexHeader(indexOutput, "segments", 6, StringHelper.randomId(), Long.toString(l2, 36));
            indexOutput.writeVInt(Version.LATEST.major);
            indexOutput.writeVInt(Version.LATEST.minor);
            indexOutput.writeVInt(Version.LATEST.bugfix);
            indexOutput.writeLong(this.version);
            indexOutput.writeInt(this.counter);
            indexOutput.writeInt(this.size());
            if (this.size() > 0) {
                Version version = null;
                Object object = this.iterator();
                while (object.hasNext()) {
                    Version version2 = object.next().info.getVersion();
                    if (version != null && version2.onOrAfter(version)) continue;
                    version = version2;
                }
                indexOutput.writeVInt(version.major);
                indexOutput.writeVInt(version.minor);
                indexOutput.writeVInt(version.bugfix);
            }
            for (Object object : this) {
                Object object2 = ((SegmentCommitInfo)object).info;
                indexOutput.writeString(((SegmentInfo)object2).name);
                byte[] byArray = ((SegmentInfo)object2).getId();
                if (byArray == null) {
                    indexOutput.writeByte((byte)0);
                } else {
                    if (byArray.length != 16) {
                        throw new IllegalStateException("cannot write segment: invalid id segment=" + ((SegmentInfo)object2).name + "id=" + StringHelper.idToString(byArray));
                    }
                    indexOutput.writeByte((byte)1);
                    indexOutput.writeBytes(byArray, byArray.length);
                }
                indexOutput.writeString(((SegmentInfo)object2).getCodec().getName());
                indexOutput.writeLong(((SegmentCommitInfo)object).getDelGen());
                int n2 = ((SegmentCommitInfo)object).getDelCount();
                if (n2 < 0 || n2 > ((SegmentInfo)object2).maxDoc()) {
                    throw new IllegalStateException("cannot write segment: invalid maxDoc segment=" + ((SegmentInfo)object2).name + " maxDoc=" + ((SegmentInfo)object2).maxDoc() + " delCount=" + n2);
                }
                indexOutput.writeInt(n2);
                indexOutput.writeLong(((SegmentCommitInfo)object).getFieldInfosGen());
                indexOutput.writeLong(((SegmentCommitInfo)object).getDocValuesGen());
                indexOutput.writeSetOfStrings(((SegmentCommitInfo)object).getFieldInfosFiles());
                object = ((SegmentCommitInfo)object).getDocValuesUpdatesFiles();
                indexOutput.writeInt(object.size());
                object = object.entrySet().iterator();
                while (object.hasNext()) {
                    object2 = (Map.Entry)object.next();
                    indexOutput.writeInt((Integer)object2.getKey());
                    indexOutput.writeSetOfStrings((Set)object2.getValue());
                }
            }
            indexOutput.writeMapOfStrings(this.userData);
            CodecUtil.writeFooter(indexOutput);
            indexOutput.close();
            c2.sync(Collections.singleton(string));
            this.pendingCommit = true;
            return;
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(indexOutput);
            IOUtils.deleteFilesIgnoringExceptions(c2, string);
            throw throwable;
        }
    }

    public final SegmentInfos clone() {
        try {
            SegmentInfos segmentInfos = (SegmentInfos)super.clone();
            ((SegmentInfos)super.clone()).segments = new ArrayList<SegmentCommitInfo>(this.size());
            for (SegmentCommitInfo segmentCommitInfo : this) {
                assert (segmentCommitInfo.info.getCodec() != null);
                segmentInfos.add(segmentCommitInfo.clone());
            }
            segmentInfos.userData = new HashMap<String, String>(this.userData);
            return segmentInfos;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("should not happen", cloneNotSupportedException);
        }
    }

    public final long getVersion() {
        return this.version;
    }

    public final long getGeneration() {
        return this.generation;
    }

    public final long getLastGeneration() {
        return this.lastGeneration;
    }

    private static void message(String string) {
        infoStream.println("SIS [" + Thread.currentThread().getName() + "]: " + string);
    }

    final void updateGeneration(SegmentInfos segmentInfos) {
        this.lastGeneration = segmentInfos.lastGeneration;
        this.generation = segmentInfos.generation;
    }

    final void updateGenerationVersionAndCounter(SegmentInfos segmentInfos) {
        this.updateGeneration(segmentInfos);
        this.version = segmentInfos.version;
        this.counter = segmentInfos.counter;
    }

    final void setNextWriteGeneration(long l2) {
        assert (l2 >= this.generation);
        this.generation = l2;
    }

    final void rollbackCommit(c c2) {
        if (this.pendingCommit) {
            this.pendingCommit = false;
            String string = IndexFileNames.fileNameFromGeneration("pending_segments", "", this.generation);
            IOUtils.deleteFilesIgnoringExceptions(c2, string);
        }
    }

    final void prepareCommit(c c2) throws IOException {
        if (this.pendingCommit) {
            throw new IllegalStateException("prepareCommit was already called");
        }
        this.write(c2);
    }

    public final Collection<String> files(boolean n2) throws IOException {
        String string;
        HashSet<String> hashSet = new HashSet<String>();
        if (n2 && (string = this.getSegmentsFileName()) != null) {
            hashSet.add(string);
        }
        n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SegmentCommitInfo segmentCommitInfo = this.info(i2);
            hashSet.addAll(segmentCommitInfo.files());
        }
        return hashSet;
    }

    final String finishCommit(c c2) throws IOException {
        String string;
        if (!this.pendingCommit) {
            throw new IllegalStateException("prepareCommit was not called");
        }
        try {
            String string2 = IndexFileNames.fileNameFromGeneration("pending_segments", "", this.generation);
            string = IndexFileNames.fileNameFromGeneration("segments", "", this.generation);
            c2.renameFile(string2, string);
        }
        catch (Throwable throwable) {
            this.rollbackCommit(c2);
            throw throwable;
        }
        this.pendingCommit = false;
        this.lastGeneration = this.generation;
        return string;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getSegmentsFileName()).append(": ");
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(' ');
            }
            SegmentCommitInfo segmentCommitInfo = this.info(i2);
            stringBuilder.append(segmentCommitInfo.toString(0));
        }
        return stringBuilder.toString();
    }

    public final Map<String, String> getUserData() {
        return this.userData;
    }

    final void replace(SegmentInfos segmentInfos) {
        this.rollbackSegmentInfos(segmentInfos.asList());
        this.lastGeneration = segmentInfos.lastGeneration;
    }

    public final int totalMaxDoc() {
        long l2 = 0L;
        for (SegmentCommitInfo segmentCommitInfo : this) {
            l2 += (long)segmentCommitInfo.info.maxDoc();
        }
        assert (l2 <= (long)IndexWriter.getActualMaxDocs());
        return (int)l2;
    }

    public final void changed() {
        ++this.version;
    }

    final void applyMergeChanges(MergePolicy.OneMerge oneMerge, boolean bl) {
        HashSet<SegmentCommitInfo> hashSet = new HashSet<SegmentCommitInfo>(oneMerge.segments);
        boolean bl2 = false;
        int n2 = 0;
        int n3 = this.segments.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            assert (i2 >= n2);
            SegmentCommitInfo segmentCommitInfo = this.segments.get(i2);
            if (hashSet.contains(segmentCommitInfo)) {
                if (bl2 || bl) continue;
                this.segments.set(i2, oneMerge.info);
                bl2 = true;
                ++n2;
                continue;
            }
            this.segments.set(n2, segmentCommitInfo);
            ++n2;
        }
        this.segments.subList(n2, this.segments.size()).clear();
        if (!bl2 && !bl) {
            this.segments.add(0, oneMerge.info);
        }
    }

    final List<SegmentCommitInfo> createBackupSegmentInfos() {
        ArrayList<SegmentCommitInfo> arrayList = new ArrayList<SegmentCommitInfo>(this.size());
        for (SegmentCommitInfo segmentCommitInfo : this) {
            assert (segmentCommitInfo.info.getCodec() != null);
            arrayList.add(segmentCommitInfo.clone());
        }
        return arrayList;
    }

    final void rollbackSegmentInfos(List<SegmentCommitInfo> list) {
        this.clear();
        this.addAll(list);
    }

    @Override
    public final Iterator<SegmentCommitInfo> iterator() {
        return this.asList().iterator();
    }

    public final List<SegmentCommitInfo> asList() {
        return Collections.unmodifiableList(this.segments);
    }

    public final int size() {
        return this.segments.size();
    }

    public final void add(SegmentCommitInfo segmentCommitInfo) {
        this.segments.add(segmentCommitInfo);
    }

    public final void addAll(Iterable<SegmentCommitInfo> object) {
        object = object.iterator();
        while (object.hasNext()) {
            SegmentCommitInfo segmentCommitInfo = (SegmentCommitInfo)object.next();
            this.add(segmentCommitInfo);
        }
    }

    public final void clear() {
        this.segments.clear();
    }

    public final void remove(SegmentCommitInfo segmentCommitInfo) {
        this.segments.remove(segmentCommitInfo);
    }

    final void remove(int n2) {
        this.segments.remove(n2);
    }

    final boolean contains(SegmentCommitInfo segmentCommitInfo) {
        return this.segments.contains(segmentCommitInfo);
    }

    final int indexOf(SegmentCommitInfo segmentCommitInfo) {
        return this.segments.indexOf(segmentCommitInfo);
    }

    public static abstract class FindSegmentsFile<T> {
        final c directory;

        public FindSegmentsFile(c c2) {
            this.directory = c2;
        }

        public T run() throws IOException {
            return this.run(null);
        }

        public T run(g object) throws IOException {
            if (object != null) {
                if (this.directory != ((g)object).getDirectory()) {
                    throw new IOException("the specified commit does not match the specified Directory");
                }
                return this.doBody(((g)object).getSegmentsFileName());
            }
            long l2 = -1L;
            object = null;
            while (true) {
                long l3 = l2;
                Object[] objectArray = this.directory.listAll();
                Object[] objectArray2 = this.directory.listAll();
                Arrays.sort(objectArray);
                Arrays.sort(objectArray2);
                if (!Arrays.equals(objectArray, objectArray2)) continue;
                l2 = SegmentInfos.getLastCommitGeneration((String[])objectArray);
                if (infoStream != null) {
                    SegmentInfos.message("directory listing gen=" + l2);
                }
                if (l2 == -1L) {
                    throw new i("no segments* file found in " + this.directory + ": files: " + Arrays.toString(objectArray));
                }
                if (l2 <= l3) break;
                String string = IndexFileNames.fileNameFromGeneration("segments", "", l2);
                try {
                    T t2 = this.doBody(string);
                    if (infoStream != null) {
                        SegmentInfos.message("success on " + string);
                    }
                    return t2;
                }
                catch (IOException iOException) {
                    if (object == null) {
                        object = iOException;
                    }
                    if (infoStream == null) continue;
                    SegmentInfos.message("primary Exception on '" + string + "': " + iOException + "'; will retry: gen = " + l2);
                    continue;
                }
                break;
            }
            throw object;
        }

        protected abstract T doBody(String var1) throws IOException;
    }
}

