/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.portmobile.util.Objects;
import org.apache.lucene.store.TrackingDirectoryWrapper;
import org.apache.lucene.store.c;
import org.apache.lucene.util.Version;

public final class SegmentInfo {
    public final String name;
    private int maxDoc;
    public final c dir;
    private boolean isCompoundFile;
    private final byte[] id;
    private Codec codec;
    private Map<String, String> diagnostics;
    private final Map<String, String> attributes;
    private Version version;
    private Set<String> setFiles;

    final void setDiagnostics(Map<String, String> map) {
        this.diagnostics = Objects.requireNonNull(map);
    }

    public final Map<String, String> getDiagnostics() {
        return this.diagnostics;
    }

    public SegmentInfo(c c2, Version version, String string, int n2, boolean bl, Codec codec, Map<String, String> map, byte[] byArray, Map<String, String> map2) {
        assert (!(c2 instanceof TrackingDirectoryWrapper));
        this.dir = Objects.requireNonNull(c2);
        this.version = Objects.requireNonNull(version);
        this.name = Objects.requireNonNull(string);
        this.maxDoc = n2;
        this.isCompoundFile = bl;
        this.codec = codec;
        this.diagnostics = Objects.requireNonNull(map);
        this.id = byArray;
        if (byArray != null && byArray.length != 16) {
            throw new IllegalArgumentException("invalid id: " + Arrays.toString(byArray));
        }
        this.attributes = Objects.requireNonNull(map2);
    }

    final void setUseCompoundFile(boolean bl) {
        this.isCompoundFile = bl;
    }

    public final boolean getUseCompoundFile() {
        return this.isCompoundFile;
    }

    public final void setCodec(Codec codec) {
        assert (this.codec == null);
        if (codec == null) {
            throw new IllegalArgumentException("codec must be non-null");
        }
        this.codec = codec;
    }

    public final Codec getCodec() {
        return this.codec;
    }

    public final int maxDoc() {
        if (this.maxDoc == -1) {
            throw new IllegalStateException("maxDoc isn't set yet");
        }
        return this.maxDoc;
    }

    final void setMaxDoc(int n2) {
        if (this.maxDoc != -1) {
            throw new IllegalStateException("maxDoc was already set: this.maxDoc=" + this.maxDoc + " vs maxDoc=" + n2);
        }
        this.maxDoc = n2;
    }

    public final Set<String> files() {
        if (this.setFiles == null) {
            throw new IllegalStateException("files were not computed yet");
        }
        return Collections.unmodifiableSet(this.setFiles);
    }

    public final String toString() {
        return this.toString(0);
    }

    public final String toString(int n2) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name).append('(').append(this.version == null ? "?" : this.version).append(')').append(':');
        char c2 = this.getUseCompoundFile() ? (char)'c' : 'C';
        stringBuilder.append(c2);
        stringBuilder.append(this.maxDoc);
        if (n2 != 0) {
            stringBuilder.append('/').append(n2);
        }
        if ((string = this.diagnostics.get("sorter")) != null) {
            stringBuilder.append(":[");
            stringBuilder.append("sorter");
            stringBuilder.append('=');
            stringBuilder.append(string);
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SegmentInfo) {
            object = (SegmentInfo)object;
            return ((SegmentInfo)object).dir == this.dir && ((SegmentInfo)object).name.equals(this.name);
        }
        return false;
    }

    public final int hashCode() {
        return this.dir.hashCode() + this.name.hashCode();
    }

    public final Version getVersion() {
        return this.version;
    }

    public final byte[] getId() {
        if (this.id == null) {
            return null;
        }
        return (byte[])this.id.clone();
    }

    public final void setFiles(Collection<String> collection) {
        this.setFiles = new HashSet<String>();
        this.addFiles(collection);
    }

    public final void addFiles(Collection<String> object) {
        this.checkFileNames((Collection<String>)object);
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            this.setFiles.add(this.namedForThisSegment(string));
        }
    }

    public final void addFile(String string) {
        this.checkFileNames(Collections.singleton(string));
        this.setFiles.add(this.namedForThisSegment(string));
    }

    private void checkFileNames(Collection<String> object) {
        Matcher matcher = IndexFileNames.CODEC_FILE_PATTERN.matcher("");
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            matcher.reset(string);
            if (matcher.matches()) continue;
            throw new IllegalArgumentException("invalid codec filename '" + string + "', must match: " + IndexFileNames.CODEC_FILE_PATTERN.pattern());
        }
    }

    final String namedForThisSegment(String string) {
        return this.name + IndexFileNames.stripSegmentName(string);
    }

    public final String getAttribute(String string) {
        return this.attributes.get(string);
    }

    public final String putAttribute(String string, String string2) {
        return this.attributes.put(string, string2);
    }

    public final Map<String, String> getAttributes() {
        return this.attributes;
    }
}

