/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.a;
import org.apache.lucene.index.m;
import org.apache.lucene.index.p;
import org.apache.lucene.store.c;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.Version;
import org.apache.lucene.util.b;

class SegmentDocValuesProducer
extends org.apache.lucene.codecs.b {
    private static final long LONG_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Long.class);
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SegmentDocValuesProducer.class);
    final Map<String, org.apache.lucene.codecs.b> dvProducersByField = new HashMap<String, org.apache.lucene.codecs.b>();
    final Set<org.apache.lucene.codecs.b> dvProducers = Collections.newSetFromMap(new IdentityHashMap());
    final List<Long> dvGens = new ArrayList<Long>();

    SegmentDocValuesProducer(SegmentCommitInfo segmentCommitInfo, c c2, FieldInfos fieldInfos, FieldInfos iterator, SegmentDocValues segmentDocValues) throws IOException {
        try {
            Object object = segmentCommitInfo.info.getVersion();
            if (object != null && ((Version)object).onOrAfter(Version.LUCENE_4_9_0)) {
                object = null;
                iterator = ((FieldInfos)((Object)iterator)).iterator();
                while (iterator.hasNext()) {
                    FieldInfo fieldInfo = (FieldInfo)iterator.next();
                    if (fieldInfo.getDocValuesType() == DocValuesType.NONE) continue;
                    long l2 = fieldInfo.getDocValuesGen();
                    if (l2 == -1L) {
                        if (object == null) {
                            object = segmentDocValues.getDocValuesProducer(l2, segmentCommitInfo, c2, fieldInfos);
                            this.dvGens.add(l2);
                            this.dvProducers.add((org.apache.lucene.codecs.b)object);
                        }
                        this.dvProducersByField.put(fieldInfo.name, (org.apache.lucene.codecs.b)object);
                        continue;
                    }
                    assert (!this.dvGens.contains(l2));
                    org.apache.lucene.codecs.b b2 = segmentDocValues.getDocValuesProducer(l2, segmentCommitInfo, c2, new FieldInfos(new FieldInfo[]{fieldInfo}));
                    this.dvGens.add(l2);
                    this.dvProducers.add(b2);
                    this.dvProducersByField.put(fieldInfo.name, b2);
                }
                return;
            }
            object = new HashMap();
            iterator = ((FieldInfos)((Object)iterator)).iterator();
            while (iterator.hasNext()) {
                FieldInfo object2 = (FieldInfo)iterator.next();
                if (object2.getDocValuesType() == DocValuesType.NONE) continue;
                ArrayList<FieldInfo> arrayList = (ArrayList<FieldInfo>)object.get(object2.getDocValuesGen());
                if (arrayList == null) {
                    arrayList = new ArrayList<FieldInfo>();
                    object.put(object2.getDocValuesGen(), arrayList);
                }
                arrayList.add(object2);
            }
            for (Map.Entry entry : object.entrySet()) {
                long l3 = (Long)entry.getKey();
                Object object2 = (List)entry.getValue();
                object = l3 == -1L ? segmentDocValues.getDocValuesProducer(l3, segmentCommitInfo, c2, fieldInfos) : segmentDocValues.getDocValuesProducer(l3, segmentCommitInfo, c2, new FieldInfos(object2.toArray(new FieldInfo[object2.size()])));
                this.dvGens.add(l3);
                this.dvProducers.add((org.apache.lucene.codecs.b)object);
                Iterator iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    object2 = (FieldInfo)iterator2.next();
                    this.dvProducersByField.put(((FieldInfo)object2).name, (org.apache.lucene.codecs.b)object);
                }
            }
            return;
        }
        catch (Throwable throwable) {
            try {
                segmentDocValues.decRef(this.dvGens);
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
    }

    @Override
    public m getNumeric(FieldInfo fieldInfo) throws IOException {
        org.apache.lucene.codecs.b b2 = this.dvProducersByField.get(fieldInfo.name);
        assert (b2 != null);
        return b2.getNumeric(fieldInfo);
    }

    @Override
    public a getBinary(FieldInfo fieldInfo) throws IOException {
        org.apache.lucene.codecs.b b2 = this.dvProducersByField.get(fieldInfo.name);
        assert (b2 != null);
        return b2.getBinary(fieldInfo);
    }

    @Override
    public SortedDocValues getSorted(FieldInfo fieldInfo) throws IOException {
        org.apache.lucene.codecs.b b2 = this.dvProducersByField.get(fieldInfo.name);
        assert (b2 != null);
        return b2.getSorted(fieldInfo);
    }

    @Override
    public p getSortedNumeric(FieldInfo fieldInfo) throws IOException {
        org.apache.lucene.codecs.b b2 = this.dvProducersByField.get(fieldInfo.name);
        assert (b2 != null);
        return b2.getSortedNumeric(fieldInfo);
    }

    @Override
    public SortedSetDocValues getSortedSet(FieldInfo fieldInfo) throws IOException {
        org.apache.lucene.codecs.b b2 = this.dvProducersByField.get(fieldInfo.name);
        assert (b2 != null);
        return b2.getSortedSet(fieldInfo);
    }

    @Override
    public Bits getDocsWithField(FieldInfo fieldInfo) throws IOException {
        org.apache.lucene.codecs.b b2 = this.dvProducersByField.get(fieldInfo.name);
        assert (b2 != null);
        return b2.getDocsWithField(fieldInfo);
    }

    @Override
    public void checkIntegrity() throws IOException {
        Iterator<org.apache.lucene.codecs.b> iterator = this.dvProducers.iterator();
        while (iterator.hasNext()) {
            iterator.next().checkIntegrity();
        }
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long ramBytesUsed() {
        long l2 = BASE_RAM_BYTES_USED + (long)this.dvGens.size() * LONG_RAM_BYTES_USED + (long)(this.dvProducers.size() * RamUsageEstimator.NUM_BYTES_OBJECT_REF) + (long)((this.dvProducersByField.size() << 1) * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
        for (org.apache.lucene.codecs.b b2 : this.dvProducers) {
            l2 += b2.ramBytesUsed();
        }
        return l2;
    }

    @Override
    public Collection<org.apache.lucene.util.a> getChildResources() {
        ArrayList<org.apache.lucene.util.a> arrayList = new ArrayList<org.apache.lucene.util.a>();
        for (org.apache.lucene.util.a a2 : this.dvProducers) {
            arrayList.add(b.a("delegate", a2));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(producers=" + this.dvProducers.size() + ")";
    }
}

