/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.e;
import org.apache.lucene.codecs.i;
import org.apache.lucene.codecs.n;
import org.apache.lucene.codecs.p;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.a;
import org.apache.lucene.store.c;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.IOUtils;

final class SegmentCoreReaders {
    private final AtomicInteger ref = new AtomicInteger(1);
    final e fields;
    final i normsProducer;
    final n fieldsReaderOrig;
    final p termVectorsReaderOrig;
    final c cfsReader;
    final FieldInfos coreFieldInfos;
    final CloseableThreadLocal<n> fieldsReaderLocal = new FieldsReaderLocal();
    final CloseableThreadLocal<p> termVectorsLocal = new TermVectorsLocal();
    private final Set<Object> coreClosedListeners = Collections.synchronizedSet(new LinkedHashSet());

    SegmentCoreReaders(SegmentReader object, c c2, SegmentCommitInfo segmentCommitInfo, IOContext iOContext) throws IOException {
        object = segmentCommitInfo.info.getCodec();
        try {
            if (segmentCommitInfo.info.getUseCompoundFile()) {
                c2 = this.cfsReader = ((Codec)object).compoundFormat().getCompoundReader(c2, segmentCommitInfo.info, iOContext);
            } else {
                this.cfsReader = null;
            }
            this.coreFieldInfos = ((Codec)object).fieldInfosFormat().read(c2, segmentCommitInfo.info, "", iOContext);
            SegmentReadState segmentReadState = new SegmentReadState(c2, segmentCommitInfo.info, this.coreFieldInfos, iOContext);
            PostingsFormat postingsFormat = ((Codec)object).postingsFormat();
            this.fields = postingsFormat.fieldsProducer(segmentReadState);
            assert (this.fields != null);
            if (this.coreFieldInfos.hasNorms()) {
                this.normsProducer = ((Codec)object).normsFormat().normsProducer(segmentReadState);
                assert (this.normsProducer != null);
            } else {
                this.normsProducer = null;
            }
            this.fieldsReaderOrig = segmentCommitInfo.info.getCodec().storedFieldsFormat().fieldsReader(c2, segmentCommitInfo.info, this.coreFieldInfos, iOContext);
            if (this.coreFieldInfos.hasVectors()) {
                this.termVectorsReaderOrig = segmentCommitInfo.info.getCodec().termVectorsFormat().vectorsReader(c2, segmentCommitInfo.info, this.coreFieldInfos, iOContext);
                return;
            }
            this.termVectorsReaderOrig = null;
            return;
        }
        catch (Throwable throwable) {
            this.decRef();
            throw throwable;
        }
    }

    final void incRef() {
        int n2;
        while ((n2 = this.ref.get()) > 0) {
            if (!this.ref.compareAndSet(n2, n2 + 1)) continue;
            return;
        }
        throw new a("SegmentCoreReaders is already closed");
    }

    final void decRef() throws IOException {
        if (this.ref.decrementAndGet() == 0) {
            try {
                IOUtils.close(this.termVectorsLocal, this.fieldsReaderLocal, this.fields, this.termVectorsReaderOrig, this.fieldsReaderOrig, this.cfsReader, this.normsProducer);
                this.notifyCoreClosedListeners(null);
                return;
            }
            catch (Throwable throwable) {
                this.notifyCoreClosedListeners(throwable);
                return;
            }
            catch (Throwable throwable) {
                this.notifyCoreClosedListeners(null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCoreClosedListeners(Throwable throwable) {
        Set<Object> set = this.coreClosedListeners;
        synchronized (set) {
            Iterator<Object> iterator = this.coreClosedListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next();
            }
            IOUtils.reThrowUnchecked(throwable);
            return;
        }
    }

    class TermVectorsLocal
    extends CloseableThreadLocal<p> {
        TermVectorsLocal() {
        }

        @Override
        protected p initialValue() {
            if (SegmentCoreReaders.this.termVectorsReaderOrig == null) {
                return null;
            }
            return SegmentCoreReaders.this.termVectorsReaderOrig.clone();
        }
    }

    class FieldsReaderLocal
    extends CloseableThreadLocal<n> {
        FieldsReaderLocal() {
        }

        @Override
        protected n initialValue() {
            return SegmentCoreReaders.this.fieldsReaderOrig.clone();
        }
    }
}

