/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.f;
import org.apache.lucene.index.BinaryDocValuesFieldUpdates;
import org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.NumericDocValuesFieldUpdates;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.a;
import org.apache.lucene.index.m;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.TrackingDirectoryWrapper;
import org.apache.lucene.store.c;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.i;

class ReadersAndUpdates {
    public final SegmentCommitInfo info;
    private final AtomicInteger refCount = new AtomicInteger(1);
    private final IndexWriter writer;
    private SegmentReader reader;
    private Bits liveDocs;
    private int pendingDeleteCount;
    private boolean liveDocsShared;
    private boolean isMerging = false;
    private final Map<String, DocValuesFieldUpdates> mergingDVUpdates = new HashMap<String, DocValuesFieldUpdates>();

    public ReadersAndUpdates(IndexWriter indexWriter, SegmentCommitInfo segmentCommitInfo) {
        this.writer = indexWriter;
        this.info = segmentCommitInfo;
        this.liveDocsShared = true;
    }

    public ReadersAndUpdates(IndexWriter indexWriter, SegmentReader segmentReader) {
        this.writer = indexWriter;
        this.reader = segmentReader;
        this.info = segmentReader.getSegmentInfo();
        this.liveDocs = segmentReader.getLiveDocs();
        this.liveDocsShared = true;
        this.pendingDeleteCount = segmentReader.numDeletedDocs() - this.info.getDelCount();
        assert (this.pendingDeleteCount >= 0) : "got " + this.pendingDeleteCount + " reader.numDeletedDocs()=" + segmentReader.numDeletedDocs() + " info.getDelCount()=" + this.info.getDelCount() + " maxDoc=" + segmentReader.maxDoc() + " numDocs=" + segmentReader.numDocs();
    }

    public void incRef() {
        int n2 = this.refCount.incrementAndGet();
        assert (n2 > 1);
    }

    public void decRef() {
        int n2 = this.refCount.decrementAndGet();
        assert (n2 >= 0);
    }

    public int refCount() {
        int n2 = this.refCount.get();
        assert (n2 >= 0);
        return n2;
    }

    public synchronized int getPendingDeleteCount() {
        return this.pendingDeleteCount;
    }

    public synchronized boolean verifyDocCounts() {
        int n2;
        if (this.liveDocs != null) {
            n2 = 0;
            for (int i2 = 0; i2 < this.info.info.maxDoc(); ++i2) {
                if (!this.liveDocs.get(i2)) continue;
                ++n2;
            }
        } else {
            n2 = this.info.info.maxDoc();
        }
        assert (this.info.info.maxDoc() - this.info.getDelCount() - this.pendingDeleteCount == n2) : "info.maxDoc=" + this.info.info.maxDoc() + " info.getDelCount()=" + this.info.getDelCount() + " pendingDeleteCount=" + this.pendingDeleteCount + " count=" + n2;
        return true;
    }

    public SegmentReader getReader(IOContext iOContext) throws IOException {
        if (this.reader == null) {
            this.reader = new SegmentReader(this.info, iOContext);
            if (this.liveDocs == null) {
                this.liveDocs = this.reader.getLiveDocs();
            }
        }
        this.reader.incRef();
        return this.reader;
    }

    public synchronized void release(SegmentReader segmentReader) throws IOException {
        assert (this.info == segmentReader.getSegmentInfo());
        segmentReader.decRef();
    }

    public synchronized boolean delete(int n2) {
        assert (this.liveDocs != null);
        assert (Thread.holdsLock(this.writer));
        assert (n2 >= 0 && n2 < this.liveDocs.length()) : "out of bounds: docid=" + n2 + " liveDocsLength=" + this.liveDocs.length() + " seg=" + this.info.info.name + " maxDoc=" + this.info.info.maxDoc();
        assert (!this.liveDocsShared);
        boolean bl = this.liveDocs.get(n2);
        if (bl) {
            ((i)this.liveDocs).clear(n2);
            ++this.pendingDeleteCount;
        }
        return bl;
    }

    public synchronized void dropReaders() throws IOException {
        if (this.reader != null) {
            try {
                this.reader.decRef();
            }
            finally {
                this.reader = null;
            }
        }
        this.decRef();
    }

    public synchronized SegmentReader getReadOnlyClone(IOContext iOContext) throws IOException {
        if (this.reader == null) {
            this.getReader(iOContext).decRef();
            assert (this.reader != null);
        }
        this.liveDocsShared = true;
        if (this.liveDocs != null) {
            return new SegmentReader(this.reader.getSegmentInfo(), this.reader, this.liveDocs, this.info.info.maxDoc() - this.info.getDelCount() - this.pendingDeleteCount);
        }
        assert (this.reader.getLiveDocs() == null);
        this.reader.incRef();
        return this.reader;
    }

    public synchronized void initWritableLiveDocs() throws IOException {
        assert (Thread.holdsLock(this.writer));
        assert (this.info.info.maxDoc() > 0);
        if (this.liveDocsShared) {
            f f2 = this.info.info.getCodec().liveDocsFormat();
            this.liveDocs = this.liveDocs == null ? f2.newLiveDocs(this.info.info.maxDoc()) : f2.newLiveDocs(this.liveDocs);
            this.liveDocsShared = false;
        }
    }

    public synchronized Bits getLiveDocs() {
        assert (Thread.holdsLock(this.writer));
        return this.liveDocs;
    }

    public synchronized Bits getReadOnlyLiveDocs() {
        assert (Thread.holdsLock(this.writer));
        this.liveDocsShared = true;
        return this.liveDocs;
    }

    public synchronized void dropChanges() {
        this.pendingDeleteCount = 0;
        this.dropMergingUpdates();
    }

    public synchronized boolean writeLiveDocs(c c2) throws IOException {
        assert (Thread.holdsLock(this.writer));
        if (this.pendingDeleteCount == 0) {
            return false;
        }
        assert (this.liveDocs.length() == this.info.info.maxDoc());
        TrackingDirectoryWrapper trackingDirectoryWrapper = new TrackingDirectoryWrapper(c2);
        try {
            this.info.info.getCodec().liveDocsFormat().writeLiveDocs((i)this.liveDocs, trackingDirectoryWrapper, this.info, this.pendingDeleteCount, IOContext.DEFAULT);
        }
        catch (Throwable throwable) {
            this.info.advanceNextWriteDelGen();
            for (String string : trackingDirectoryWrapper.getCreatedFiles()) {
                IOUtils.deleteFilesIgnoringExceptions(c2, string);
            }
            throw throwable;
        }
        this.info.advanceDelGen();
        this.info.setDelCount(this.info.getDelCount() + this.pendingDeleteCount);
        this.pendingDeleteCount = 0;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleNumericDVUpdates(FieldInfos object, Map<String, NumericDocValuesFieldUpdates> iterator, c c2, DocValuesFormat docValuesFormat, final SegmentReader segmentReader, Map<Integer, Set<String>> map) throws IOException {
        iterator = iterator.entrySet().iterator();
        while (iterator.hasNext()) {
            TrackingDirectoryWrapper trackingDirectoryWrapper;
            FieldInfo fieldInfo;
            block10: {
                Map.Entry entry = iterator.next();
                final String string = (String)entry.getKey();
                final NumericDocValuesFieldUpdates numericDocValuesFieldUpdates = (NumericDocValuesFieldUpdates)entry.getValue();
                long l2 = this.info.getNextDocValuesGen();
                Object object2 = Long.toString(l2, 36);
                long l3 = numericDocValuesFieldUpdates.ramBytesPerDoc() * (long)this.info.info.maxDoc();
                Object object3 = new IOContext(new FlushInfo(this.info.info.maxDoc(), l3));
                fieldInfo = ((FieldInfos)object).fieldInfo(string);
                assert (fieldInfo != null);
                fieldInfo.setDocValuesGen(l2);
                FieldInfos fieldInfos = new FieldInfos(new FieldInfo[]{fieldInfo});
                trackingDirectoryWrapper = new TrackingDirectoryWrapper(c2);
                object2 = new SegmentWriteState(null, trackingDirectoryWrapper, this.info.info, fieldInfos, null, (IOContext)object3, (String)object2);
                object2 = docValuesFormat.fieldsConsumer((SegmentWriteState)object2);
                object3 = null;
                try {
                    ((DocValuesConsumer)object2).addNumericField(fieldInfo, new Iterable<Number>(){
                        final m currentValues;
                        final Bits docsWithField;
                        final int maxDoc;
                        final NumericDocValuesFieldUpdates.Iterator updatesIter;
                        {
                            this.currentValues = segmentReader.getNumericDocValues(string);
                            this.docsWithField = segmentReader.getDocsWithField(string);
                            this.maxDoc = segmentReader.maxDoc();
                            this.updatesIter = numericDocValuesFieldUpdates.iterator();
                        }

                        @Override
                        public Iterator<Number> iterator() {
                            this.updatesIter.reset();
                            return new Iterator<Number>(){
                                int curDoc = -1;
                                int updateDoc;
                                {
                                    this.updateDoc = updatesIter.nextDoc();
                                }

                                @Override
                                public boolean hasNext() {
                                    return this.curDoc < maxDoc - 1;
                                }

                                @Override
                                public Number next() {
                                    if (++this.curDoc >= maxDoc) {
                                        throw new NoSuchElementException("no more documents to return values for");
                                    }
                                    if (this.curDoc == this.updateDoc) {
                                        Long l2 = updatesIter.value();
                                        this.updateDoc = updatesIter.nextDoc();
                                        return l2;
                                    }
                                    assert (this.curDoc < this.updateDoc);
                                    if (currentValues != null && docsWithField.get(this.curDoc)) {
                                        return currentValues.get(this.curDoc);
                                    }
                                    return null;
                                }

                                @Override
                                public void remove() {
                                    throw new UnsupportedOperationException("this iterator does not support removing elements");
                                }
                            };
                        }
                    });
                    if (object2 == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        object = throwable;
                        object3 = throwable;
                        throw object;
                    }
                    catch (Throwable throwable2) {
                        if (object2 == null) throw throwable2;
                        if (object3 == null) {
                            object2.close();
                            throw throwable2;
                        }
                        try {
                            object2.close();
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            ((Throwable)object3).addSuppressed(throwable3);
                            throw throwable2;
                        }
                    }
                }
                object2.close();
            }
            this.info.advanceDocValuesGen();
            assert (!map.containsKey(fieldInfo.number));
            map.put(fieldInfo.number, trackingDirectoryWrapper.getCreatedFiles());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleBinaryDVUpdates(FieldInfos object, Map<String, BinaryDocValuesFieldUpdates> iterator, TrackingDirectoryWrapper trackingDirectoryWrapper, DocValuesFormat docValuesFormat, final SegmentReader segmentReader, Map<Integer, Set<String>> map) throws IOException {
        iterator = iterator.entrySet().iterator();
        while (iterator.hasNext()) {
            TrackingDirectoryWrapper trackingDirectoryWrapper2;
            FieldInfo fieldInfo;
            block10: {
                Map.Entry entry = iterator.next();
                final String string = (String)entry.getKey();
                final BinaryDocValuesFieldUpdates binaryDocValuesFieldUpdates = (BinaryDocValuesFieldUpdates)entry.getValue();
                long l2 = this.info.getNextDocValuesGen();
                Object object2 = Long.toString(l2, 36);
                long l3 = binaryDocValuesFieldUpdates.ramBytesPerDoc() * (long)this.info.info.maxDoc();
                Object object3 = new IOContext(new FlushInfo(this.info.info.maxDoc(), l3));
                fieldInfo = ((FieldInfos)object).fieldInfo(string);
                assert (fieldInfo != null);
                fieldInfo.setDocValuesGen(l2);
                FieldInfos fieldInfos = new FieldInfos(new FieldInfo[]{fieldInfo});
                trackingDirectoryWrapper2 = new TrackingDirectoryWrapper(trackingDirectoryWrapper);
                object2 = new SegmentWriteState(null, trackingDirectoryWrapper2, this.info.info, fieldInfos, null, (IOContext)object3, (String)object2);
                object2 = docValuesFormat.fieldsConsumer((SegmentWriteState)object2);
                object3 = null;
                try {
                    ((DocValuesConsumer)object2).addBinaryField(fieldInfo, new Iterable<BytesRef>(){
                        final a currentValues;
                        final Bits docsWithField;
                        final int maxDoc;
                        final BinaryDocValuesFieldUpdates.Iterator updatesIter;
                        {
                            this.currentValues = segmentReader.getBinaryDocValues(string);
                            this.docsWithField = segmentReader.getDocsWithField(string);
                            this.maxDoc = segmentReader.maxDoc();
                            this.updatesIter = binaryDocValuesFieldUpdates.iterator();
                        }

                        @Override
                        public Iterator<BytesRef> iterator() {
                            this.updatesIter.reset();
                            return new Iterator<BytesRef>(){
                                int curDoc = -1;
                                int updateDoc;
                                {
                                    this.updateDoc = updatesIter.nextDoc();
                                }

                                @Override
                                public boolean hasNext() {
                                    return this.curDoc < maxDoc - 1;
                                }

                                @Override
                                public BytesRef next() {
                                    if (++this.curDoc >= maxDoc) {
                                        throw new NoSuchElementException("no more documents to return values for");
                                    }
                                    if (this.curDoc == this.updateDoc) {
                                        BytesRef bytesRef = updatesIter.value();
                                        this.updateDoc = updatesIter.nextDoc();
                                        return bytesRef;
                                    }
                                    assert (this.curDoc < this.updateDoc);
                                    if (currentValues != null && docsWithField.get(this.curDoc)) {
                                        return currentValues.get(this.curDoc);
                                    }
                                    return null;
                                }

                                @Override
                                public void remove() {
                                    throw new UnsupportedOperationException("this iterator does not support removing elements");
                                }
                            };
                        }
                    });
                    if (object2 == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        object = throwable;
                        object3 = throwable;
                        throw object;
                    }
                    catch (Throwable throwable2) {
                        if (object2 == null) throw throwable2;
                        if (object3 == null) {
                            object2.close();
                            throw throwable2;
                        }
                        try {
                            object2.close();
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            ((Throwable)object3).addSuppressed(throwable3);
                            throw throwable2;
                        }
                    }
                }
                object2.close();
            }
            this.info.advanceDocValuesGen();
            assert (!map.containsKey(fieldInfo.number));
            map.put(fieldInfo.number, trackingDirectoryWrapper2.getCreatedFiles());
        }
    }

    private Set<String> writeFieldInfosGen(FieldInfos fieldInfos, c c2, DocValuesFormat object, org.apache.lucene.codecs.c c3) throws IOException {
        object = Long.toString(this.info.getNextFieldInfosGen(), 36);
        long l2 = 40 + 90 * fieldInfos.size();
        IOContext iOContext = new IOContext(new FlushInfo(this.info.info.maxDoc(), l2));
        c2 = new TrackingDirectoryWrapper(c2);
        c3.write(c2, this.info.info, (String)object, fieldInfos, iOContext);
        this.info.advanceFieldInfosGen();
        return ((TrackingDirectoryWrapper)c2).getCreatedFiles();
    }

    public synchronized void writeFieldUpdates(c c2, DocValuesFieldUpdates.Container container) throws IOException {
        Set<String> set;
        Object object;
        Object object2;
        assert (Thread.holdsLock(this.writer));
        assert (container.any());
        TrackingDirectoryWrapper trackingDirectoryWrapper = new TrackingDirectoryWrapper(c2);
        HashMap<Integer, Set<String>> object32 = new HashMap<Integer, Set<String>>();
        try {
            object2 = this.info.info.getCodec();
            SegmentReader segmentReader = this.reader == null ? new SegmentReader(this.info, IOContext.READONCE) : this.reader;
            try {
                object = new FieldInfos.Builder(this.writer.globalFieldNumberMap);
                for (FieldInfo fieldInfo : segmentReader.getFieldInfos()) {
                    FieldInfo fieldInfo2 = ((FieldInfos.Builder)object).add(fieldInfo);
                    for (Map.Entry<String, String> entry : fieldInfo.attributes().entrySet()) {
                        fieldInfo2.putAttribute(entry.getKey(), entry.getValue());
                    }
                    fieldInfo2.setDocValuesGen(fieldInfo.getDocValuesGen());
                }
                for (String string : container.numericDVUpdates.keySet()) {
                    ((FieldInfos.Builder)object).getOrAdd(string).setDocValuesType(DocValuesType.NUMERIC);
                }
                for (String string : container.binaryDVUpdates.keySet()) {
                    ((FieldInfos.Builder)object).getOrAdd(string).setDocValuesType(DocValuesType.BINARY);
                }
                FieldInfos fieldInfos = ((FieldInfos.Builder)object).finish();
                DocValuesFormat docValuesFormat = ((Codec)object2).docValuesFormat();
                this.handleNumericDVUpdates(fieldInfos, container.numericDVUpdates, trackingDirectoryWrapper, docValuesFormat, segmentReader, object32);
                this.handleBinaryDVUpdates(fieldInfos, container.binaryDVUpdates, trackingDirectoryWrapper, docValuesFormat, segmentReader, object32);
                set = this.writeFieldInfosGen(fieldInfos, trackingDirectoryWrapper, docValuesFormat, ((Codec)object2).fieldInfosFormat());
            }
            finally {
                if (segmentReader != this.reader) {
                    segmentReader.close();
                }
            }
        }
        catch (Throwable throwable) {
            this.info.advanceNextWriteFieldInfosGen();
            this.info.advanceNextWriteDocValuesGen();
            for (String string : trackingDirectoryWrapper.getCreatedFiles()) {
                IOUtils.deleteFilesIgnoringExceptions(c2, string);
            }
            throw throwable;
        }
        if (this.isMerging) {
            for (Map.Entry entry : container.numericDVUpdates.entrySet()) {
                object = this.mergingDVUpdates.get(entry.getKey());
                if (object == null) {
                    this.mergingDVUpdates.put((String)entry.getKey(), (DocValuesFieldUpdates)entry.getValue());
                    continue;
                }
                ((DocValuesFieldUpdates)object).merge((DocValuesFieldUpdates)entry.getValue());
            }
            for (Map.Entry<Object, Object> entry : container.binaryDVUpdates.entrySet()) {
                object = this.mergingDVUpdates.get(entry.getKey());
                if (object == null) {
                    this.mergingDVUpdates.put((String)entry.getKey(), (DocValuesFieldUpdates)entry.getValue());
                    continue;
                }
                ((DocValuesFieldUpdates)object).merge((DocValuesFieldUpdates)entry.getValue());
            }
        }
        assert (set != null);
        this.info.setFieldInfosFiles(set);
        assert (!object32.isEmpty());
        for (Map.Entry<Object, Object> entry : this.info.getDocValuesUpdatesFiles().entrySet()) {
            if (object32.containsKey(entry.getKey())) continue;
            object32.put((Integer)entry.getKey(), (Set<String>)entry.getValue());
        }
        this.info.setDocValuesUpdatesFiles(object32);
        this.writer.checkpoint();
        if (this.reader != null) {
            object2 = new SegmentReader(this.info, this.reader, this.liveDocs, this.info.info.maxDoc() - this.info.getDelCount() - this.pendingDeleteCount);
            try {
                this.reader.decRef();
                this.reader = object2;
                return;
            }
            catch (Throwable throwable) {
                ((IndexReader)object2).decRef();
                throw throwable;
            }
        }
    }

    synchronized SegmentReader getReaderForMerge(IOContext iOContext) throws IOException {
        assert (Thread.holdsLock(this.writer));
        this.isMerging = true;
        return this.getReader(iOContext);
    }

    public synchronized void dropMergingUpdates() {
        this.mergingDVUpdates.clear();
        this.isMerging = false;
    }

    public synchronized Map<String, DocValuesFieldUpdates> getMergingFieldUpdates() {
        return this.mergingDVUpdates;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ReadersAndLiveDocs(seg=").append(this.info);
        stringBuilder.append(" pendingDeleteCount=").append(this.pendingDeleteCount);
        stringBuilder.append(" liveDocsShared=").append(this.liveDocsShared);
        return stringBuilder.toString();
    }
}

