/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.e;
import org.apache.lucene.portmobile.util.Objects;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RAMFile;
import org.apache.lucene.store.RAMInputStream;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.a;

public class PrefixCodedTerms
implements a {
    final RAMFile buffer;
    private final long size;
    private long delGen;

    private PrefixCodedTerms(RAMFile rAMFile, long l2) {
        this.buffer = Objects.requireNonNull(rAMFile);
        this.size = l2;
    }

    @Override
    public long ramBytesUsed() {
        return this.buffer.ramBytesUsed() + 16L;
    }

    @Override
    public Collection<a> getChildResources() {
        return Collections.emptyList();
    }

    public void setDelGen(long l2) {
        this.delGen = l2;
    }

    public TermIterator iterator() {
        return new TermIterator(this.delGen, this.buffer);
    }

    public long size() {
        return this.size;
    }

    public int hashCode() {
        return this.buffer.hashCode() * 31 + (int)(this.delGen ^ this.delGen >>> 32);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (PrefixCodedTerms)object;
        return this.buffer.equals(((PrefixCodedTerms)object).buffer) && this.delGen == ((PrefixCodedTerms)object).delGen;
    }

    public static class TermIterator
    extends e {
        final IndexInput input;
        final BytesRefBuilder builder = new BytesRefBuilder();
        final BytesRef bytes = this.builder.get();
        final long end;
        final long delGen;
        String field = "";

        private TermIterator(long l2, RAMFile rAMFile) {
            try {
                this.input = new RAMInputStream("MergedPrefixCodedTermsIterator", rAMFile);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            this.end = this.input.length();
            this.delGen = l2;
        }

        @Override
        public BytesRef next() {
            if (this.input.getFilePointer() < this.end) {
                try {
                    int n2 = this.input.readVInt();
                    if ((n2 & 1) != 0) {
                        this.field = this.input.readString();
                    }
                    int n3 = this.input.readVInt();
                    this.readTermBytes(n2 >>>= 1, n3);
                    return this.bytes;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            this.field = null;
            return null;
        }

        private void readTermBytes(int n2, int n3) throws IOException {
            this.builder.grow(n2 + n3);
            this.input.readBytes(this.builder.bytes(), n2, n3);
            this.builder.setLength(n2 + n3);
        }

        @Override
        public String field() {
            return this.field;
        }

        @Override
        public long delGen() {
            return this.delGen;
        }
    }

    public static class Builder {
        private RAMFile buffer = new RAMFile();
        private RAMOutputStream output = new RAMOutputStream(this.buffer, false);
        private Term lastTerm = new Term("");
        private BytesRefBuilder lastTermBytes = new BytesRefBuilder();
        private long size;

        public void add(Term term) {
            assert (this.lastTerm.equals(new Term("")) || term.compareTo(this.lastTerm) > 0);
            try {
                int n2 = this.sharedPrefix(this.lastTerm.bytes, term.bytes);
                int n3 = term.bytes.length - n2;
                if (term.field.equals(this.lastTerm.field)) {
                    this.output.writeVInt(n2 << 1);
                } else {
                    this.output.writeVInt(n2 << 1 | 1);
                    this.output.writeString(term.field);
                }
                this.output.writeVInt(n3);
                this.output.writeBytes(term.bytes.bytes, term.bytes.offset + n2, n3);
                this.lastTermBytes.copyBytes(term.bytes);
                this.lastTerm.bytes = this.lastTermBytes.get();
                this.lastTerm.field = term.field;
                ++this.size;
                return;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        public PrefixCodedTerms finish() {
            try {
                this.output.close();
                return new PrefixCodedTerms(this.buffer, this.size);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        private int sharedPrefix(BytesRef bytesRef, BytesRef bytesRef2) {
            int n2 = 0;
            int n3 = 0 + Math.min(bytesRef.length, bytesRef2.length);
            int n4 = 0;
            while (n2 < n3) {
                if (bytesRef.bytes[bytesRef.offset + n2] != bytesRef2.bytes[bytesRef2.offset + n4]) {
                    return n2;
                }
                ++n2;
                ++n4;
            }
            return n2;
        }
    }
}

