/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.util.ArrayUtil;

class ParallelPostingsArray {
    final int size;
    final int[] textStarts;
    final int[] intStarts;
    final int[] byteStarts;

    ParallelPostingsArray(int n2) {
        this.size = n2;
        this.textStarts = new int[n2];
        this.intStarts = new int[n2];
        this.byteStarts = new int[n2];
    }

    int bytesPerPosting() {
        return 12;
    }

    ParallelPostingsArray newInstance(int n2) {
        return new ParallelPostingsArray(n2);
    }

    final ParallelPostingsArray grow() {
        int n2 = ArrayUtil.oversize(this.size + 1, this.bytesPerPosting());
        ParallelPostingsArray parallelPostingsArray = this.newInstance(n2);
        this.copyTo(parallelPostingsArray, this.size);
        return parallelPostingsArray;
    }

    void copyTo(ParallelPostingsArray parallelPostingsArray, int n2) {
        System.arraycopy(this.textStarts, 0, parallelPostingsArray.textStarts, 0, n2);
        System.arraycopy(this.intStarts, 0, parallelPostingsArray.intStarts, 0, n2);
        System.arraycopy(this.byteStarts, 0, parallelPostingsArray.byteStarts, 0, n2);
    }
}

