/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.c;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedLongValues;

class NumericDocValuesWriter
extends c {
    private PackedLongValues.Builder pending = PackedLongValues.deltaPackedBuilder(0.0f);
    private final Counter iwBytesUsed;
    private long bytesUsed;
    private FixedBitSet docsWithField = new FixedBitSet(64);
    private final FieldInfo fieldInfo;

    public NumericDocValuesWriter(FieldInfo fieldInfo, Counter counter) {
        this.bytesUsed = this.pending.ramBytesUsed() + this.docsWithFieldBytesUsed();
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = counter;
        counter.addAndGet(this.bytesUsed);
    }

    public void addValue(int n2, long l2) {
        if ((long)n2 < this.pending.size()) {
            throw new IllegalArgumentException("DocValuesField \"" + this.fieldInfo.name + "\" appears more than once in this document (only one value is allowed per field)");
        }
        for (int i2 = (int)this.pending.size(); i2 < n2; ++i2) {
            this.pending.add(0L);
        }
        this.pending.add(l2);
        this.docsWithField = FixedBitSet.ensureCapacity(this.docsWithField, n2);
        this.docsWithField.set(n2);
        this.updateBytesUsed();
    }

    private long docsWithFieldBytesUsed() {
        return RamUsageEstimator.sizeOf(this.docsWithField.getBits()) + 64L;
    }

    private void updateBytesUsed() {
        long l2 = this.pending.ramBytesUsed() + this.docsWithFieldBytesUsed();
        this.iwBytesUsed.addAndGet(l2 - this.bytesUsed);
        this.bytesUsed = l2;
    }

    @Override
    public void finish(int n2) {
    }

    @Override
    public void flush(SegmentWriteState segmentWriteState, DocValuesConsumer docValuesConsumer) throws IOException {
        final int n2 = segmentWriteState.segmentInfo.maxDoc();
        final PackedLongValues packedLongValues = this.pending.build();
        docValuesConsumer.addNumericField(this.fieldInfo, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                return new NumericIterator(n2, packedLongValues, NumericDocValuesWriter.this.docsWithField);
            }
        });
    }

    private static class NumericIterator
    implements Iterator<Number> {
        final PackedLongValues.Iterator iter;
        final FixedBitSet docsWithField;
        final int size;
        final int maxDoc;
        int upto;

        NumericIterator(int n2, PackedLongValues packedLongValues, FixedBitSet fixedBitSet) {
            this.maxDoc = n2;
            this.iter = packedLongValues.iterator();
            this.size = (int)packedLongValues.size();
            this.docsWithField = fixedBitSet;
        }

        @Override
        public boolean hasNext() {
            return this.upto < this.maxDoc;
        }

        @Override
        public Number next() {
            Long l2;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.upto < this.size) {
                long l3 = this.iter.next();
                l2 = this.docsWithField.get(this.upto) ? Long.valueOf(l3) : null;
            } else {
                l2 = null;
            }
            ++this.upto;
            return l2;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

