/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.util.f;
import org.apache.lucene.util.packed.PackedInts;
import org.apache.lucene.util.packed.PagedGrowableWriter;
import org.apache.lucene.util.packed.PagedMutable;

class NumericDocValuesFieldUpdates
extends DocValuesFieldUpdates {
    private final int bitsPerValue;
    private PagedMutable docs;
    private PagedGrowableWriter values;
    private int size;

    public NumericDocValuesFieldUpdates(String string, int n2) {
        super(string, DocValuesType.NUMERIC);
        this.bitsPerValue = PackedInts.bitsRequired(n2 - 1);
        this.docs = new PagedMutable(1L, 1024, this.bitsPerValue, 0.0f);
        this.values = new PagedGrowableWriter(1L, 1024, 1, 0.5f);
        this.size = 0;
    }

    @Override
    public void add(int n2, Object object) {
        if (this.size == Integer.MAX_VALUE) {
            throw new IllegalStateException("cannot support more than Integer.MAX_VALUE doc/value entries");
        }
        object = (Long)object;
        if (this.docs.size() == (long)this.size) {
            this.docs = (PagedMutable)this.docs.grow(this.size + 1);
            this.values = (PagedGrowableWriter)this.values.grow(this.size + 1);
        }
        this.docs.set(this.size, n2);
        this.values.set(this.size, (Long)object);
        ++this.size;
    }

    @Override
    public Iterator iterator() {
        final PagedMutable pagedMutable = this.docs;
        final PagedGrowableWriter pagedGrowableWriter = this.values;
        new f(){

            @Override
            protected void swap(int n2, int n3) {
                long l2 = pagedMutable.get(n3);
                pagedMutable.set(n3, pagedMutable.get(n2));
                pagedMutable.set(n2, l2);
                long l3 = pagedGrowableWriter.get(n3);
                pagedGrowableWriter.set(n3, pagedGrowableWriter.get(n2));
                pagedGrowableWriter.set(n2, l3);
            }

            @Override
            protected int compare(int n2, int n3) {
                if ((n2 = (int)pagedMutable.get(n2)) < (n3 = (int)pagedMutable.get(n3))) {
                    return -1;
                }
                if (n2 == n3) {
                    return 0;
                }
                return 1;
            }
        }.sort(0, this.size);
        return new Iterator(this.size, pagedGrowableWriter, pagedMutable);
    }

    @Override
    public void merge(DocValuesFieldUpdates docValuesFieldUpdates) {
        assert (docValuesFieldUpdates instanceof NumericDocValuesFieldUpdates);
        docValuesFieldUpdates = (NumericDocValuesFieldUpdates)docValuesFieldUpdates;
        if (this.size + ((NumericDocValuesFieldUpdates)docValuesFieldUpdates).size > Integer.MAX_VALUE) {
            throw new IllegalStateException("cannot support more than Integer.MAX_VALUE doc/value entries; size=" + this.size + " other.size=" + ((NumericDocValuesFieldUpdates)docValuesFieldUpdates).size);
        }
        this.docs = (PagedMutable)this.docs.grow(this.size + ((NumericDocValuesFieldUpdates)docValuesFieldUpdates).size);
        this.values = (PagedGrowableWriter)this.values.grow(this.size + ((NumericDocValuesFieldUpdates)docValuesFieldUpdates).size);
        for (int i2 = 0; i2 < ((NumericDocValuesFieldUpdates)docValuesFieldUpdates).size; ++i2) {
            int n2 = (int)((NumericDocValuesFieldUpdates)docValuesFieldUpdates).docs.get(i2);
            this.docs.set(this.size, n2);
            this.values.set(this.size, ((NumericDocValuesFieldUpdates)docValuesFieldUpdates).values.get(i2));
            ++this.size;
        }
    }

    public boolean any() {
        return this.size > 0;
    }

    public long ramBytesPerDoc() {
        long l2 = (long)Math.ceil((double)this.bitsPerValue / 8.0);
        int n2 = NumericDocValuesFieldUpdates.estimateCapacity(this.size);
        return l2 + (long)Math.ceil((double)this.values.ramBytesUsed() / (double)n2);
    }

    static final class Iterator
    extends DocValuesFieldUpdates.a {
        private final int size;
        private final PagedGrowableWriter values;
        private final PagedMutable docs;
        private long idx = 0L;
        private int doc = -1;
        private Long value = null;

        Iterator(int n2, PagedGrowableWriter pagedGrowableWriter, PagedMutable pagedMutable) {
            this.size = n2;
            this.values = pagedGrowableWriter;
            this.docs = pagedMutable;
        }

        @Override
        final Long value() {
            return this.value;
        }

        @Override
        final int nextDoc() {
            if (this.idx >= (long)this.size) {
                this.value = null;
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = (int)this.docs.get(this.idx);
            ++this.idx;
            while (this.idx < (long)this.size && this.docs.get(this.idx) == (long)this.doc) {
                ++this.idx;
            }
            this.value = this.values.get(this.idx - 1L);
            return this.doc;
        }

        @Override
        final int doc() {
            return this.doc;
        }

        @Override
        final void reset() {
            this.doc = -1;
            this.value = null;
            this.idx = 0L;
        }
    }
}

