/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.codecs.g;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.packed.PackedLongValues;

class NormValuesWriter {
    private PackedLongValues.Builder pending = PackedLongValues.deltaPackedBuilder(0.0f);
    private final Counter iwBytesUsed;
    private long bytesUsed = this.pending.ramBytesUsed();
    private final FieldInfo fieldInfo;

    public NormValuesWriter(FieldInfo fieldInfo, Counter counter) {
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = counter;
        counter.addAndGet(this.bytesUsed);
    }

    public void addValue(int n2, long l2) {
        for (int i2 = (int)this.pending.size(); i2 < n2; ++i2) {
            this.pending.add(0L);
        }
        this.pending.add(l2);
        this.updateBytesUsed();
    }

    private void updateBytesUsed() {
        long l2 = this.pending.ramBytesUsed();
        this.iwBytesUsed.addAndGet(l2 - this.bytesUsed);
        this.bytesUsed = l2;
    }

    public void finish(int n2) {
    }

    public void flush(SegmentWriteState segmentWriteState, g g2) throws IOException {
        final int n2 = segmentWriteState.segmentInfo.maxDoc();
        final PackedLongValues packedLongValues = this.pending.build();
        g2.addNormsField(this.fieldInfo, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                return new NumericIterator(n2, packedLongValues);
            }
        });
    }

    private static class NumericIterator
    implements Iterator<Number> {
        final PackedLongValues.Iterator iter;
        final int size;
        final int maxDoc;
        int upto;

        NumericIterator(int n2, PackedLongValues packedLongValues) {
            this.maxDoc = n2;
            this.iter = packedLongValues.iterator();
            this.size = (int)packedLongValues.size();
        }

        @Override
        public boolean hasNext() {
            return this.upto < this.maxDoc;
        }

        @Override
        public Number next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Long l2 = this.upto < this.size ? Long.valueOf(this.iter.next()) : Long.valueOf(0L);
            ++this.upto;
            return l2;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

