/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.index.MultiPostingsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.PriorityQueue;

public final class MultiTermsEnum
extends TermsEnum {
    private static final Comparator<TermsEnumWithSlice> INDEX_COMPARATOR = new Comparator<TermsEnumWithSlice>(){};
    private final TermMergeQueue queue;
    private final TermsEnumWithSlice[] subs;
    private final TermsEnumWithSlice[] currentSubs;
    private final TermsEnumWithSlice[] top;
    private final MultiPostingsEnum.EnumWithSlice[] subDocs;
    private BytesRef lastSeek;
    private boolean lastSeekExact;
    private final BytesRefBuilder lastSeekScratch = new BytesRefBuilder();
    private int numTop;
    private int numSubs;
    private BytesRef current;

    public final int getMatchCount() {
        return this.numTop;
    }

    public final TermsEnumWithSlice[] getMatchArray() {
        return this.top;
    }

    public MultiTermsEnum(ReaderSlice[] readerSliceArray) {
        this.queue = new TermMergeQueue(readerSliceArray.length);
        this.top = new TermsEnumWithSlice[readerSliceArray.length];
        this.subs = new TermsEnumWithSlice[readerSliceArray.length];
        this.subDocs = new MultiPostingsEnum.EnumWithSlice[readerSliceArray.length];
        for (int i2 = 0; i2 < readerSliceArray.length; ++i2) {
            this.subs[i2] = new TermsEnumWithSlice(i2, readerSliceArray[i2]);
            this.subDocs[i2] = new MultiPostingsEnum.EnumWithSlice();
            this.subDocs[i2].slice = readerSliceArray[i2];
        }
        this.currentSubs = new TermsEnumWithSlice[readerSliceArray.length];
    }

    @Override
    public final BytesRef term() {
        return this.current;
    }

    public final TermsEnum reset(TermsEnumIndex[] termsEnumIndexArray) throws IOException {
        assert (termsEnumIndexArray.length <= this.top.length);
        this.numSubs = 0;
        this.numTop = 0;
        this.queue.clear();
        for (int i2 = 0; i2 < termsEnumIndexArray.length; ++i2) {
            TermsEnumIndex termsEnumIndex = termsEnumIndexArray[i2];
            assert (termsEnumIndex != null);
            BytesRef bytesRef = termsEnumIndex.termsEnum.next();
            if (bytesRef == null) continue;
            TermsEnumWithSlice termsEnumWithSlice = this.subs[termsEnumIndex.subIndex];
            termsEnumWithSlice.reset(termsEnumIndex.termsEnum, bytesRef);
            this.queue.add(termsEnumWithSlice);
            this.currentSubs[this.numSubs++] = termsEnumWithSlice;
        }
        if (this.queue.size() == 0) {
            return TermsEnum.EMPTY;
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final boolean seekExact(BytesRef var1_1) throws IOException {
        this.queue.clear();
        this.numTop = 0;
        var2_2 = false;
        if (this.lastSeek != null && this.lastSeek.compareTo(var1_1) <= 0) {
            var2_2 = true;
        }
        this.lastSeek = null;
        this.lastSeekExact = true;
        for (var3_3 = 0; var3_3 < this.numSubs; ++var3_3) {
            if (!var2_2) ** GOTO lbl-1000
            var4_5 = this.currentSubs[var3_3].current;
            if (var4_5 == null) ** GOTO lbl-1000
            var4_4 = var1_1.compareTo(var4_5);
            if (var4_4 == 0) {
                var4_4 = 1;
            } else if (var4_4 < 0) lbl-1000:
            // 2 sources

            {
                var4_4 = 0;
            } else lbl-1000:
            // 2 sources

            {
                var4_4 = this.currentSubs[var3_3].terms.seekExact(var1_1);
            }
            if (var4_4 == 0) continue;
            this.top[this.numTop++] = this.currentSubs[var3_3];
            this.current = this.currentSubs[var3_3].current = this.currentSubs[var3_3].terms.term();
            if (!MultiTermsEnum.$assertionsDisabled && !var1_1.equals(this.currentSubs[var3_3].current)) {
                throw new AssertionError();
            }
        }
        return this.numTop > 0;
    }

    @Override
    public final TermsEnum.SeekStatus seekCeil(BytesRef bytesRef) throws IOException {
        this.queue.clear();
        this.numTop = 0;
        this.lastSeekExact = false;
        boolean bl = false;
        if (this.lastSeek != null && this.lastSeek.compareTo(bytesRef) <= 0) {
            bl = true;
        }
        this.lastSeekScratch.copyBytes(bytesRef);
        this.lastSeek = this.lastSeekScratch.get();
        for (int i2 = 0; i2 < this.numSubs; ++i2) {
            int n2;
            Object object;
            object = bl ? ((object = this.currentSubs[i2].current) != null ? ((n2 = bytesRef.compareTo((BytesRef)object)) == 0 ? TermsEnum.SeekStatus.FOUND : (n2 < 0 ? TermsEnum.SeekStatus.NOT_FOUND : this.currentSubs[i2].terms.seekCeil(bytesRef))) : TermsEnum.SeekStatus.END) : this.currentSubs[i2].terms.seekCeil(bytesRef);
            if (object == TermsEnum.SeekStatus.FOUND) {
                this.top[this.numTop++] = this.currentSubs[i2];
                this.current = this.currentSubs[i2].current = this.currentSubs[i2].terms.term();
                this.queue.add(this.currentSubs[i2]);
                continue;
            }
            if (object == TermsEnum.SeekStatus.NOT_FOUND) {
                this.currentSubs[i2].current = this.currentSubs[i2].terms.term();
                assert (this.currentSubs[i2].current != null);
                this.queue.add(this.currentSubs[i2]);
                continue;
            }
            assert (object == TermsEnum.SeekStatus.END);
            this.currentSubs[i2].current = null;
        }
        if (this.numTop > 0) {
            return TermsEnum.SeekStatus.FOUND;
        }
        if (this.queue.size() > 0) {
            this.pullTop();
            return TermsEnum.SeekStatus.NOT_FOUND;
        }
        return TermsEnum.SeekStatus.END;
    }

    @Override
    public final void seekExact(long l2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final long ord() {
        throw new UnsupportedOperationException();
    }

    private void pullTop() {
        assert (this.numTop == 0);
        this.numTop = this.queue.fillTop(this.top);
        this.current = this.top[0].current;
    }

    private void pushTop() throws IOException {
        for (int i2 = 0; i2 < this.numTop; ++i2) {
            TermsEnumWithSlice termsEnumWithSlice = (TermsEnumWithSlice)this.queue.top();
            termsEnumWithSlice.current = termsEnumWithSlice.terms.next();
            if (termsEnumWithSlice.current == null) {
                this.queue.pop();
                continue;
            }
            this.queue.updateTop();
        }
        this.numTop = 0;
    }

    @Override
    public final BytesRef next() throws IOException {
        if (this.lastSeekExact) {
            TermsEnum.SeekStatus seekStatus = this.seekCeil(this.current);
            assert (seekStatus == TermsEnum.SeekStatus.FOUND);
            this.lastSeekExact = false;
        }
        this.lastSeek = null;
        this.pushTop();
        if (this.queue.size() > 0) {
            this.pullTop();
        } else {
            this.current = null;
        }
        return this.current;
    }

    @Override
    public final int docFreq() throws IOException {
        int n2 = 0;
        for (int i2 = 0; i2 < this.numTop; ++i2) {
            n2 += this.top[i2].terms.docFreq();
        }
        return n2;
    }

    @Override
    public final long totalTermFreq() throws IOException {
        long l2 = 0L;
        for (int i2 = 0; i2 < this.numTop; ++i2) {
            long l3 = this.top[i2].terms.totalTermFreq();
            if (l3 == -1L) {
                return l3;
            }
            l2 += l3;
        }
        return l2;
    }

    @Override
    public final PostingsEnum postings(PostingsEnum postingsEnum, int n2) throws IOException {
        if (postingsEnum != null && postingsEnum instanceof MultiPostingsEnum) {
            if (!((MultiPostingsEnum)(postingsEnum = (MultiPostingsEnum)postingsEnum)).canReuse(this)) {
                postingsEnum = new MultiPostingsEnum(this, this.subs.length);
            }
        } else {
            postingsEnum = new MultiPostingsEnum(this, this.subs.length);
        }
        int n3 = 0;
        ArrayUtil.timSort(this.top, 0, this.numTop, INDEX_COMPARATOR);
        for (int i2 = 0; i2 < this.numTop; ++i2) {
            TermsEnumWithSlice termsEnumWithSlice = this.top[i2];
            assert (termsEnumWithSlice.index < ((MultiPostingsEnum)postingsEnum).subPostingsEnums.length) : termsEnumWithSlice.index + " vs " + ((MultiPostingsEnum)postingsEnum).subPostingsEnums.length + "; " + this.subs.length;
            PostingsEnum postingsEnum2 = termsEnumWithSlice.terms.postings(((MultiPostingsEnum)postingsEnum).subPostingsEnums[termsEnumWithSlice.index], n2);
            assert (postingsEnum2 != null);
            ((MultiPostingsEnum)postingsEnum).subPostingsEnums[termsEnumWithSlice.index] = postingsEnum2;
            this.subDocs[n3].postingsEnum = postingsEnum2;
            this.subDocs[n3].slice = termsEnumWithSlice.subSlice;
            ++n3;
        }
        return ((MultiPostingsEnum)postingsEnum).reset(this.subDocs, n3);
    }

    public final String toString() {
        return "MultiTermsEnum(" + Arrays.toString(this.subs) + ")";
    }

    private static final class TermMergeQueue
    extends PriorityQueue<TermsEnumWithSlice> {
        final int[] stack;

        TermMergeQueue(int n2) {
            super(n2);
            this.stack = new int[n2];
        }

        @Override
        protected final boolean lessThan(TermsEnumWithSlice termsEnumWithSlice, TermsEnumWithSlice termsEnumWithSlice2) {
            return termsEnumWithSlice.current.compareTo(termsEnumWithSlice2.current) < 0;
        }

        final int fillTop(TermsEnumWithSlice[] termsEnumWithSliceArray) {
            int n2 = this.size();
            if (n2 == 0) {
                return 0;
            }
            termsEnumWithSliceArray[0] = (TermsEnumWithSlice)this.top();
            int n3 = 1;
            this.stack[0] = 1;
            int n4 = 1;
            while (n4 != 0) {
                int n5;
                int n6 = n5 = this.stack[--n4] << 1;
                n5 = Math.min(n2, n5 + 1);
                while (n6 <= n5) {
                    TermsEnumWithSlice termsEnumWithSlice = this.get(n6);
                    if (termsEnumWithSlice.current.equals(termsEnumWithSliceArray[0].current)) {
                        termsEnumWithSliceArray[n3++] = termsEnumWithSlice;
                        this.stack[n4++] = n6;
                    }
                    ++n6;
                }
            }
            return n3;
        }

        private TermsEnumWithSlice get(int n2) {
            return (TermsEnumWithSlice)this.getHeapArray()[n2];
        }
    }

    static final class TermsEnumWithSlice {
        private final ReaderSlice subSlice;
        TermsEnum terms;
        public BytesRef current;
        final int index;

        public TermsEnumWithSlice(int n2, ReaderSlice readerSlice) {
            this.subSlice = readerSlice;
            this.index = n2;
            assert (readerSlice.length >= 0) : "length=" + readerSlice.length;
        }

        public final void reset(TermsEnum termsEnum, BytesRef bytesRef) {
            this.terms = termsEnum;
            this.current = bytesRef;
        }

        public final String toString() {
            return this.subSlice.toString() + ":" + this.terms;
        }
    }

    static class TermsEnumIndex {
        public static final TermsEnumIndex[] EMPTY_ARRAY = new TermsEnumIndex[0];
        final int subIndex;
        final TermsEnum termsEnum;

        public TermsEnumIndex(TermsEnum termsEnum, int n2) {
            this.termsEnum = termsEnum;
            this.subIndex = n2;
        }
    }
}

