/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.MultiTermsEnum;
import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;

public final class MultiTerms
extends Terms {
    private final Terms[] subs;
    private final ReaderSlice[] subSlices;
    private final boolean hasFreqs;
    private final boolean hasOffsets;
    private final boolean hasPositions;
    private final boolean hasPayloads;

    public MultiTerms(Terms[] termsArray, ReaderSlice[] readerSliceArray) throws IOException {
        this.subs = termsArray;
        this.subSlices = readerSliceArray;
        assert (termsArray.length > 0) : "inefficient: don't use MultiTerms over one sub";
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = false;
        for (int i2 = 0; i2 < termsArray.length; ++i2) {
            bl &= termsArray[i2].hasFreqs();
            bl2 &= termsArray[i2].hasOffsets();
            bl3 &= termsArray[i2].hasPositions();
            bl4 |= termsArray[i2].hasPayloads();
        }
        this.hasFreqs = bl;
        this.hasOffsets = bl2;
        this.hasPositions = bl3;
        this.hasPayloads = this.hasPositions && bl4;
    }

    @Override
    public final TermsEnum intersect(CompiledAutomaton compiledAutomaton, BytesRef bytesRef) throws IOException {
        ArrayList<MultiTermsEnum.TermsEnumIndex> arrayList = new ArrayList<MultiTermsEnum.TermsEnumIndex>();
        for (int i2 = 0; i2 < this.subs.length; ++i2) {
            TermsEnum termsEnum = this.subs[i2].intersect(compiledAutomaton, bytesRef);
            if (termsEnum == null) continue;
            arrayList.add(new MultiTermsEnum.TermsEnumIndex(termsEnum, i2));
        }
        if (arrayList.size() > 0) {
            return new MultiTermsEnum(this.subSlices).reset(arrayList.toArray(MultiTermsEnum.TermsEnumIndex.EMPTY_ARRAY));
        }
        return TermsEnum.EMPTY;
    }

    @Override
    public final TermsEnum iterator() throws IOException {
        ArrayList<MultiTermsEnum.TermsEnumIndex> arrayList = new ArrayList<MultiTermsEnum.TermsEnumIndex>();
        for (int i2 = 0; i2 < this.subs.length; ++i2) {
            TermsEnum termsEnum = this.subs[i2].iterator();
            if (termsEnum == null) continue;
            arrayList.add(new MultiTermsEnum.TermsEnumIndex(termsEnum, i2));
        }
        if (arrayList.size() > 0) {
            return new MultiTermsEnum(this.subSlices).reset(arrayList.toArray(MultiTermsEnum.TermsEnumIndex.EMPTY_ARRAY));
        }
        return TermsEnum.EMPTY;
    }

    @Override
    public final long size() {
        return -1L;
    }

    @Override
    public final long getSumTotalTermFreq() throws IOException {
        long l2 = 0L;
        Terms[] termsArray = this.subs;
        int n2 = this.subs.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l3 = termsArray[i2].getSumTotalTermFreq();
            if (l3 == -1L) {
                return -1L;
            }
            l2 += l3;
        }
        return l2;
    }

    @Override
    public final long getSumDocFreq() throws IOException {
        long l2 = 0L;
        Terms[] termsArray = this.subs;
        int n2 = this.subs.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l3 = termsArray[i2].getSumDocFreq();
            if (l3 == -1L) {
                return -1L;
            }
            l2 += l3;
        }
        return l2;
    }

    @Override
    public final int getDocCount() throws IOException {
        int n2 = 0;
        Terms[] termsArray = this.subs;
        int n3 = this.subs.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = termsArray[i2].getDocCount();
            if (n4 == -1) {
                return -1;
            }
            n2 += n4;
        }
        return n2;
    }

    @Override
    public final boolean hasFreqs() {
        return this.hasFreqs;
    }

    @Override
    public final boolean hasOffsets() {
        return this.hasOffsets;
    }

    @Override
    public final boolean hasPositions() {
        return this.hasPositions;
    }

    @Override
    public final boolean hasPayloads() {
        return this.hasPayloads;
    }
}

