/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.MergedIterator;

public final class MultiFields
extends Fields {
    private final Fields[] subs;
    private final ReaderSlice[] subSlices;
    private final Map<String, Terms> terms = new ConcurrentHashMap<String, Terms>();

    public static Fields getFields(IndexReader iterator) throws IOException {
        iterator = ((IndexReader)((Object)iterator)).leaves();
        switch (iterator.size()) {
            case 1: {
                return ((LeafReaderContext)iterator.get(0)).reader().fields();
            }
        }
        ArrayList<Fields> arrayList = new ArrayList<Fields>();
        ArrayList<ReaderSlice> arrayList2 = new ArrayList<ReaderSlice>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            LeafReaderContext leafReaderContext = (LeafReaderContext)iterator.next();
            LeafReader leafReader = leafReaderContext.reader();
            Fields fields = leafReader.fields();
            arrayList.add(fields);
            arrayList2.add(new ReaderSlice(leafReaderContext.docBase, leafReader.maxDoc(), arrayList.size() - 1));
        }
        if (arrayList.size() == 1) {
            return (Fields)arrayList.get(0);
        }
        return new MultiFields(arrayList.toArray(Fields.EMPTY_ARRAY), arrayList2.toArray(ReaderSlice.EMPTY_ARRAY));
    }

    public static Terms getTerms(IndexReader indexReader, String string) throws IOException {
        return MultiFields.getFields(indexReader).terms(string);
    }

    public MultiFields(Fields[] fieldsArray, ReaderSlice[] readerSliceArray) {
        this.subs = fieldsArray;
        this.subSlices = readerSliceArray;
    }

    @Override
    public final Iterator<String> iterator() {
        Iterator[] iteratorArray = new Iterator[this.subs.length];
        for (int i2 = 0; i2 < this.subs.length; ++i2) {
            iteratorArray[i2] = this.subs[i2].iterator();
        }
        return new MergedIterator<String>(iteratorArray);
    }

    @Override
    public final Terms terms(String string) throws IOException {
        Object object = this.terms.get(string);
        if (object != null) {
            return object;
        }
        object = new ArrayList();
        ArrayList<ReaderSlice> arrayList = new ArrayList<ReaderSlice>();
        for (int i2 = 0; i2 < this.subs.length; ++i2) {
            Terms terms = this.subs[i2].terms(string);
            if (terms == null) continue;
            object.add(terms);
            arrayList.add(this.subSlices[i2]);
        }
        if (object.size() == 0) {
            object = null;
        } else {
            object = new MultiTerms(object.toArray(Terms.EMPTY_ARRAY), arrayList.toArray(ReaderSlice.EMPTY_ARRAY));
            this.terms.put(string, (Terms)object);
        }
        return object;
    }

    @Override
    public final int size() {
        return -1;
    }
}

