/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.DocumentsWriterPerThreadPool;
import org.apache.lucene.index.FlushPolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.index.f;
import org.apache.lucene.index.g;
import org.apache.lucene.index.h;
import org.apache.lucene.index.l;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.similarities.a;
import org.apache.lucene.util.InfoStream;

public class LiveIndexWriterConfig {
    private final Analyzer analyzer;
    private volatile int maxBufferedDocs;
    private volatile double ramBufferSizeMB;
    private volatile int maxBufferedDeleteTerms;
    private volatile IndexWriter.b mergedSegmentWarmer;
    protected volatile h delPolicy;
    protected volatile g commit;
    protected volatile IndexWriterConfig.OpenMode openMode;
    protected volatile a similarity;
    protected volatile MergeScheduler mergeScheduler;
    @Deprecated
    protected volatile long writeLockTimeout;
    protected volatile DocumentsWriterPerThread.a indexingChain;
    protected volatile Codec codec;
    protected volatile InfoStream infoStream;
    protected volatile MergePolicy mergePolicy;
    protected volatile DocumentsWriterPerThreadPool indexerThreadPool;
    protected volatile boolean readerPooling;
    protected volatile FlushPolicy flushPolicy;
    protected volatile int perThreadHardLimitMB;
    protected volatile boolean useCompoundFile = true;
    protected boolean commitOnClose = true;

    LiveIndexWriterConfig(Analyzer analyzer) {
        this.analyzer = analyzer;
        this.ramBufferSizeMB = 16.0;
        this.maxBufferedDocs = -1;
        this.maxBufferedDeleteTerms = -1;
        this.mergedSegmentWarmer = null;
        this.delPolicy = new l();
        this.commit = null;
        this.useCompoundFile = true;
        this.openMode = IndexWriterConfig.OpenMode.CREATE_OR_APPEND;
        this.similarity = IndexSearcher.getDefaultSimilarity();
        this.mergeScheduler = new ConcurrentMergeScheduler();
        this.writeLockTimeout = 0L;
        this.indexingChain = DocumentsWriterPerThread.defaultIndexingChain;
        this.codec = Codec.getDefault();
        if (this.codec == null) {
            throw new NullPointerException();
        }
        this.infoStream = InfoStream.getDefault();
        this.mergePolicy = new TieredMergePolicy();
        this.flushPolicy = new f();
        this.readerPooling = false;
        this.indexerThreadPool = new DocumentsWriterPerThreadPool();
        this.perThreadHardLimitMB = 1945;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public int getMaxBufferedDeleteTerms() {
        return this.maxBufferedDeleteTerms;
    }

    public double getRAMBufferSizeMB() {
        return this.ramBufferSizeMB;
    }

    public int getMaxBufferedDocs() {
        return this.maxBufferedDocs;
    }

    public IndexWriter.b getMergedSegmentWarmer() {
        return this.mergedSegmentWarmer;
    }

    public IndexWriterConfig.OpenMode getOpenMode() {
        return this.openMode;
    }

    public h getIndexDeletionPolicy() {
        return this.delPolicy;
    }

    public g getIndexCommit() {
        return this.commit;
    }

    public a getSimilarity() {
        return this.similarity;
    }

    public MergeScheduler getMergeScheduler() {
        return this.mergeScheduler;
    }

    @Deprecated
    public long getWriteLockTimeout() {
        return this.writeLockTimeout;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public MergePolicy getMergePolicy() {
        return this.mergePolicy;
    }

    DocumentsWriterPerThreadPool getIndexerThreadPool() {
        return this.indexerThreadPool;
    }

    public boolean getReaderPooling() {
        return this.readerPooling;
    }

    DocumentsWriterPerThread.a getIndexingChain() {
        return this.indexingChain;
    }

    public int getRAMPerThreadHardLimitMB() {
        return this.perThreadHardLimitMB;
    }

    FlushPolicy getFlushPolicy() {
        return this.flushPolicy;
    }

    public InfoStream getInfoStream() {
        return this.infoStream;
    }

    public boolean getUseCompoundFile() {
        return this.useCompoundFile;
    }

    public boolean getCommitOnClose() {
        return this.commitOnClose;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("analyzer=").append(this.analyzer == null ? "null" : this.analyzer.getClass().getName()).append("\n");
        stringBuilder.append("ramBufferSizeMB=").append(this.getRAMBufferSizeMB()).append("\n");
        stringBuilder.append("maxBufferedDocs=").append(this.getMaxBufferedDocs()).append("\n");
        stringBuilder.append("maxBufferedDeleteTerms=").append(this.getMaxBufferedDeleteTerms()).append("\n");
        stringBuilder.append("mergedSegmentWarmer=").append(this.getMergedSegmentWarmer()).append("\n");
        stringBuilder.append("delPolicy=").append(this.getIndexDeletionPolicy().getClass().getName()).append("\n");
        g g2 = this.getIndexCommit();
        stringBuilder.append("commit=").append(g2 == null ? "null" : g2).append("\n");
        stringBuilder.append("openMode=").append((Object)this.getOpenMode()).append("\n");
        stringBuilder.append("similarity=").append(this.getSimilarity().getClass().getName()).append("\n");
        stringBuilder.append("mergeScheduler=").append(this.getMergeScheduler()).append("\n");
        stringBuilder.append("default WRITE_LOCK_TIMEOUT=0\n");
        stringBuilder.append("writeLockTimeout=").append(this.getWriteLockTimeout()).append("\n");
        stringBuilder.append("codec=").append(this.getCodec()).append("\n");
        stringBuilder.append("infoStream=").append(this.getInfoStream().getClass().getName()).append("\n");
        stringBuilder.append("mergePolicy=").append(this.getMergePolicy()).append("\n");
        stringBuilder.append("indexerThreadPool=").append(this.getIndexerThreadPool()).append("\n");
        stringBuilder.append("readerPooling=").append(this.getReaderPooling()).append("\n");
        stringBuilder.append("perThreadHardLimitMB=").append(this.getRAMPerThreadHardLimitMB()).append("\n");
        stringBuilder.append("useCompoundFile=").append(this.getUseCompoundFile()).append("\n");
        stringBuilder.append("commitOnClose=").append(this.getCommitOnClose()).append("\n");
        return stringBuilder.toString();
    }
}

