/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.CompositeReaderContext;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;

public final class LeafReaderContext
extends IndexReaderContext {
    public final int ord;
    public final int docBase;
    private final LeafReader reader;
    private final List<LeafReaderContext> leaves;

    LeafReaderContext(CompositeReaderContext compositeReaderContext, LeafReader leafReader, int n2, int n3, int n4, int n5) {
        super(compositeReaderContext, n2, n3);
        this.ord = n4;
        this.docBase = n5;
        this.reader = leafReader;
        this.leaves = this.isTopLevel ? Collections.singletonList(this) : null;
    }

    LeafReaderContext(LeafReader leafReader) {
        this(null, leafReader, 0, 0, 0, 0);
    }

    @Override
    public final List<LeafReaderContext> leaves() {
        if (!this.isTopLevel) {
            throw new UnsupportedOperationException("This is not a top-level context.");
        }
        assert (this.leaves != null);
        return this.leaves;
    }

    @Override
    public final LeafReader reader() {
        return this.reader;
    }

    public final String toString() {
        return "LeafReaderContext(" + this.reader + " docBase=" + this.docBase + " ord=" + this.ord + ")";
    }
}

