/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.AbortingException;
import org.apache.lucene.index.BufferedUpdatesStream;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FrozenBufferedUpdates;
import org.apache.lucene.index.IndexFileDeleter;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeRateLimiter;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.ReadersAndUpdates;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.StandardDirectoryReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.g;
import org.apache.lucene.index.i;
import org.apache.lucene.index.j;
import org.apache.lucene.portmobile.file.NoSuchFileException;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockValidatingDirectoryWrapper;
import org.apache.lucene.store.RateLimitedIndexOutput;
import org.apache.lucene.store.SleepingLockWrapper;
import org.apache.lucene.store.TrackingDirectoryWrapper;
import org.apache.lucene.store.c;
import org.apache.lucene.store.e;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.Version;

public class IndexWriter
implements Closeable,
org.apache.lucene.util.a {
    private static int actualMaxDocs = 0x7FFFFF7F;
    boolean enableTestPoints = false;
    volatile Throwable tragedy;
    private final c directoryOrig;
    private final c directory;
    private final c mergeDirectory;
    private final Analyzer analyzer;
    private final AtomicLong changeCount = new AtomicLong();
    private volatile long lastCommitChangeCount;
    private List<SegmentCommitInfo> rollbackSegments;
    volatile SegmentInfos pendingCommit;
    volatile long pendingCommitChangeCount;
    private Collection<String> filesToCommit;
    final SegmentInfos segmentInfos;
    final FieldInfos.FieldNumbers globalFieldNumberMap;
    private final DocumentsWriter docWriter;
    private final Queue<a> eventQueue;
    final IndexFileDeleter deleter;
    private Map<SegmentCommitInfo, Boolean> segmentsToMerge = new HashMap<SegmentCommitInfo, Boolean>();
    private int mergeMaxNumSegments;
    private e writeLock;
    private volatile boolean closed;
    private volatile boolean closing;
    private HashSet<SegmentCommitInfo> mergingSegments = new HashSet();
    private final MergeScheduler mergeScheduler;
    private LinkedList<MergePolicy.OneMerge> pendingMerges = new LinkedList();
    private Set<MergePolicy.OneMerge> runningMerges = new HashSet<MergePolicy.OneMerge>();
    private List<MergePolicy.OneMerge> mergeExceptions = new ArrayList<MergePolicy.OneMerge>();
    private long mergeGen;
    private boolean stopMerges;
    private boolean didMessageState;
    final AtomicInteger flushCount = new AtomicInteger();
    final AtomicInteger flushDeletesCount = new AtomicInteger();
    final ReaderPool readerPool = new ReaderPool();
    final BufferedUpdatesStream bufferedUpdatesStream;
    private volatile boolean poolReaders;
    private final LiveIndexWriterConfig config;
    private long startCommitTime;
    final AtomicLong pendingNumDocs = new AtomicLong();
    final CloseableThreadLocal<MergeRateLimiter> rateLimiters = new CloseableThreadLocal();
    final Codec codec;
    final InfoStream infoStream;
    private final Object commitLock = new Object();
    private final Object fullFlushLock = new Object();
    private boolean keepFullyDeletedSegments;

    static int getActualMaxDocs() {
        return actualMaxDocs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectoryReader getReader(boolean bl) throws IOException {
        this.ensureOpen();
        long l2 = System.currentTimeMillis();
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "flush at getReader");
        }
        this.poolReaders = true;
        DirectoryReader directoryReader = null;
        this.doBeforeFlush();
        try {
            try {
                boolean bl2;
                Object object = this.fullFlushLock;
                synchronized (object) {
                    try {
                        bl2 = this.docWriter.flushAllThreads();
                        if (!bl2) {
                            this.flushCount.incrementAndGet();
                        }
                        IndexWriter indexWriter = this;
                        synchronized (indexWriter) {
                            bl2 |= this.maybeApplyDeletes(bl);
                            directoryReader = StandardDirectoryReader.open(this, this.segmentInfos, bl);
                            if (this.infoStream.isEnabled("IW")) {
                                this.infoStream.message("IW", "return reader version=" + directoryReader.getVersion() + " reader=" + directoryReader);
                            }
                        }
                        this.docWriter.finishFullFlush(this, true);
                    }
                    catch (Throwable throwable) {
                        this.docWriter.finishFullFlush(this, false);
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "hit exception during NRT reader");
                        }
                        throw throwable;
                    }
                    this.processEvents(false, true);
                    this.doAfterFlush();
                }
                if (bl2) {
                    this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.FULL_FLUSH, -1);
                }
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "getReader took " + (System.currentTimeMillis() - l2) + " msec");
                }
            }
            catch (OutOfMemoryError | AbortingException throwable) {
                this.tragicEvent(throwable, "getReader");
                IOUtils.closeWhileHandlingException(directoryReader);
                return null;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(directoryReader);
            throw throwable;
        }
        return directoryReader;
    }

    @Override
    public final long ramBytesUsed() {
        this.ensureOpen();
        return this.docWriter.ramBytesUsed();
    }

    @Override
    public Collection<org.apache.lucene.util.a> getChildResources() {
        return Collections.emptyList();
    }

    public int numDeletedDocs(SegmentCommitInfo object) {
        this.ensureOpen(false);
        int n2 = ((SegmentCommitInfo)object).getDelCount();
        object = this.readerPool.get((SegmentCommitInfo)object, false);
        if (object != null) {
            n2 += ((ReadersAndUpdates)object).getPendingDeleteCount();
        }
        return n2;
    }

    protected final void ensureOpen(boolean bl) throws org.apache.lucene.store.a {
        if (this.closed || bl && this.closing) {
            throw new org.apache.lucene.store.a("this IndexWriter is closed", this.tragedy);
        }
    }

    protected final void ensureOpen() throws org.apache.lucene.store.a {
        this.ensureOpen(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexWriter(c object, IndexWriterConfig object2) throws IOException {
        ((IndexWriterConfig)object2).setIndexWriter(this);
        this.config = object2;
        this.infoStream = this.config.getInfoStream();
        long l2 = this.config.getWriteLockTimeout();
        object2 = l2 == 0L ? object : new SleepingLockWrapper((c)object, l2);
        this.writeLock = ((c)object2).obtainLock("write.lock");
        try {
            this.directoryOrig = object;
            this.directory = new LockValidatingDirectoryWrapper((c)object, this.writeLock);
            this.mergeDirectory = this.addMergeRateLimiters(this.directory);
            this.analyzer = this.config.getAnalyzer();
            this.mergeScheduler = this.config.getMergeScheduler();
            this.mergeScheduler.setInfoStream(this.infoStream);
            this.codec = this.config.getCodec();
            this.bufferedUpdatesStream = new BufferedUpdatesStream(this.infoStream);
            this.poolReaders = this.config.getReaderPooling();
            object = this.config.getOpenMode();
            boolean bl = object == IndexWriterConfig.OpenMode.CREATE ? true : object != IndexWriterConfig.OpenMode.APPEND && !DirectoryReader.indexExists(this.directory);
            boolean bl2 = true;
            Object[] objectArray = this.directory.listAll();
            g g2 = this.config.getIndexCommit();
            StandardDirectoryReader standardDirectoryReader = g2 == null ? null : g2.getReader();
            if (bl) {
                if (this.config.getIndexCommit() != null) {
                    if (object == IndexWriterConfig.OpenMode.CREATE) {
                        throw new IllegalArgumentException("cannot use IndexWriterConfig.setIndexCommit() with OpenMode.CREATE");
                    }
                    throw new IllegalArgumentException("cannot use IndexWriterConfig.setIndexCommit() when index has no commit");
                }
                try {
                    object = SegmentInfos.readLatestCommit(this.directory);
                    ((SegmentInfos)object).clear();
                }
                catch (IOException iOException) {
                    bl2 = false;
                    object = new SegmentInfos();
                }
                this.segmentInfos = object;
                this.rollbackSegments = this.segmentInfos.createBackupSegmentInfos();
                this.changed();
            } else if (standardDirectoryReader != null) {
                if (standardDirectoryReader.directory() != g2.getDirectory()) {
                    throw new IllegalArgumentException("IndexCommit's reader must have the same directory as the IndexCommit");
                }
                if (standardDirectoryReader.directory() != this.directoryOrig) {
                    throw new IllegalArgumentException("IndexCommit's reader must have the same directory passed to IndexWriter");
                }
                if (standardDirectoryReader.segmentInfos.getLastGeneration() == 0L) {
                    throw new IllegalArgumentException("index must already have an initial commit to open from reader");
                }
                this.segmentInfos = standardDirectoryReader.segmentInfos.clone();
                try {
                    object = SegmentInfos.readCommit(this.directoryOrig, this.segmentInfos.getSegmentsFileName());
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("the provided reader is stale: its prior commit file \"" + this.segmentInfos.getSegmentsFileName() + "\" is missing from index");
                }
                if (standardDirectoryReader.writer != null) {
                    assert (standardDirectoryReader.writer.closed);
                    this.segmentInfos.updateGenerationVersionAndCounter(standardDirectoryReader.writer.segmentInfos);
                    ((SegmentInfos)object).updateGenerationVersionAndCounter(standardDirectoryReader.writer.segmentInfos);
                }
                this.rollbackSegments = ((SegmentInfos)object).createBackupSegmentInfos();
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "init from reader " + standardDirectoryReader);
                    this.messageState();
                }
            } else {
                object = SegmentInfos.getLastCommitSegmentsFileName((String[])objectArray);
                if (object == null) {
                    throw new i("no segments* file found in " + this.directory + ": files: " + Arrays.toString(objectArray));
                }
                this.segmentInfos = SegmentInfos.readCommit(this.directoryOrig, (String)object);
                if (g2 != null) {
                    if (g2.getDirectory() != this.directoryOrig) {
                        throw new IllegalArgumentException("IndexCommit's directory doesn't match my directory, expected=" + this.directoryOrig + ", got=" + g2.getDirectory());
                    }
                    SegmentInfos segmentInfos = SegmentInfos.readCommit(this.directoryOrig, g2.getSegmentsFileName());
                    this.segmentInfos.replace(segmentInfos);
                    this.changed();
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "init: loaded commit \"" + g2.getSegmentsFileName() + "\"");
                    }
                }
                this.rollbackSegments = this.segmentInfos.createBackupSegmentInfos();
            }
            this.pendingNumDocs.set(this.segmentInfos.totalMaxDoc());
            this.globalFieldNumberMap = this.getFieldNumberMap();
            this.config.getFlushPolicy().init(this.config);
            this.docWriter = new DocumentsWriter(this, this.config, this.directoryOrig, this.directory);
            this.eventQueue = this.docWriter.eventQueue();
            object = this;
            synchronized (object) {
                this.deleter = new IndexFileDeleter((String[])objectArray, this.directoryOrig, this.directory, this.config.getIndexDeletionPolicy(), this.segmentInfos, this.infoStream, this, bl2, standardDirectoryReader != null);
                assert (bl || this.filesExist(this.segmentInfos));
            }
            if (this.deleter.startingCommitDeleted) {
                this.changed();
            }
            if (standardDirectoryReader != null) {
                object = standardDirectoryReader.leaves();
                assert (this.segmentInfos.size() == object.size());
                for (int i2 = 0; i2 < object.size(); ++i2) {
                    SegmentReader segmentReader = (SegmentReader)((LeafReaderContext)object.get(i2)).reader();
                    segmentReader = new SegmentReader(this.segmentInfos.info(i2), segmentReader, segmentReader.getLiveDocs(), segmentReader.numDocs());
                    this.readerPool.readerMap.put(segmentReader.getSegmentInfo(), new ReadersAndUpdates(this, segmentReader));
                }
                this.segmentInfos.changed();
                this.changed();
            }
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "init: create=" + bl);
                this.messageState();
            }
            return;
        }
        catch (Throwable throwable) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "init: hit exception on init; releasing write lock");
            }
            IOUtils.closeWhileHandlingException(this.writeLock);
            this.writeLock = null;
            throw throwable;
        }
    }

    static FieldInfos readFieldInfos(SegmentCommitInfo object) throws IOException {
        Object object2 = ((SegmentCommitInfo)object).info.getCodec();
        org.apache.lucene.codecs.c c2 = ((Codec)object2).fieldInfosFormat();
        if (((SegmentCommitInfo)object).hasFieldUpdates()) {
            object2 = Long.toString(((SegmentCommitInfo)object).getFieldInfosGen(), 36);
            return c2.read(((SegmentCommitInfo)object).info.dir, ((SegmentCommitInfo)object).info, (String)object2, IOContext.READONCE);
        }
        if (((SegmentCommitInfo)object).info.getUseCompoundFile()) {
            block11: {
                object2 = ((Codec)object2).compoundFormat().getCompoundReader(((SegmentCommitInfo)object).info.dir, ((SegmentCommitInfo)object).info, IOContext.DEFAULT);
                Throwable throwable = null;
                try {
                    object = c2.read((c)object2, ((SegmentCommitInfo)object).info, "", IOContext.READONCE);
                    if (object2 == null) break block11;
                }
                catch (Throwable throwable2) {
                    try {
                        object = throwable2;
                        throwable = throwable2;
                        throw object;
                    }
                    catch (Throwable throwable3) {
                        if (object2 != null) {
                            if (throwable != null) {
                                try {
                                    ((c)object2).close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                ((c)object2).close();
                            }
                        }
                        throw throwable3;
                    }
                }
                ((c)object2).close();
            }
            return object;
        }
        return c2.read(((SegmentCommitInfo)object).info.dir, ((SegmentCommitInfo)object).info, "", IOContext.READONCE);
    }

    private FieldInfos.FieldNumbers getFieldNumberMap() throws IOException {
        FieldInfos.FieldNumbers fieldNumbers = new FieldInfos.FieldNumbers();
        Iterator<SegmentCommitInfo> iterator = this.segmentInfos.iterator();
        while (iterator.hasNext()) {
            for (FieldInfo fieldInfo : IndexWriter.readFieldInfos(iterator.next())) {
                fieldNumbers.addOrGet(fieldInfo.name, fieldInfo.number, fieldInfo.getDocValuesType());
            }
        }
        return fieldNumbers;
    }

    private void messageState() {
        if (this.infoStream.isEnabled("IW") && !this.didMessageState) {
            this.didMessageState = true;
            this.infoStream.message("IW", "\ndir=" + this.directoryOrig + "\nindex=" + this.segString() + "\nversion=" + Version.LATEST.toString() + "\n" + this.config.toString());
        }
    }

    private void shutdown() throws IOException {
        if (this.pendingCommit != null) {
            throw new IllegalStateException("cannot close: prepareCommit was already called with no corresponding call to commit");
        }
        if (this.shouldClose(true)) {
            try {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "now flush at close");
                }
                this.flush(true, true);
                this.waitForMerges();
                this.commitInternal(this.config.getMergePolicy());
                this.rollbackInternal();
                return;
            }
            catch (Throwable throwable) {
                try {
                    this.rollbackInternal();
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.config.getCommitOnClose()) {
            this.shutdown();
            return;
        }
        this.rollback();
    }

    private synchronized boolean shouldClose(boolean bl) {
        while (!this.closed) {
            if (!this.closing) {
                this.closing = true;
                return true;
            }
            if (!bl) {
                return false;
            }
            this.doWait();
        }
        return false;
    }

    public c getDirectory() {
        return this.directoryOrig;
    }

    public void addDocument(Iterable<? extends j> iterable) throws IOException {
        this.updateDocument(null, iterable);
    }

    public void deleteDocuments(Term ... termArray) throws IOException {
        this.ensureOpen();
        try {
            if (this.docWriter.deleteTerms(termArray)) {
                this.processEvents(true, false);
            }
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.tragicEvent(outOfMemoryError, "deleteDocuments(Term..)");
            return;
        }
    }

    public void deleteDocuments(Query ... queryArray) throws IOException {
        this.ensureOpen();
        Query[] queryArray2 = queryArray;
        int n2 = queryArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (queryArray2[i2].getClass() != org.apache.lucene.search.i.class) continue;
            this.deleteAll();
            return;
        }
        try {
            if (this.docWriter.deleteQueries(queryArray)) {
                this.processEvents(true, false);
            }
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.tragicEvent(outOfMemoryError, "deleteDocuments(Query..)");
            return;
        }
    }

    public void updateDocument(Term term, Iterable<? extends j> iterable) throws IOException {
        this.ensureOpen();
        try {
            try {
                if (this.docWriter.updateDocument(iterable, this.analyzer, term)) {
                    this.processEvents(true, false);
                }
                return;
            }
            catch (Throwable throwable) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "hit exception updating document");
                }
                throw throwable;
            }
        }
        catch (OutOfMemoryError | AbortingException throwable) {
            this.tragicEvent(throwable, "updateDocument");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String newSegmentName() {
        SegmentInfos segmentInfos = this.segmentInfos;
        synchronized (segmentInfos) {
            this.changeCount.incrementAndGet();
            this.segmentInfos.changed();
            return "_" + Integer.toString(this.segmentInfos.counter++, 36);
        }
    }

    private final void maybeMerge(MergePolicy mergePolicy, MergeTrigger mergeTrigger, int n2) throws IOException {
        this.ensureOpen(false);
        boolean bl = this.updatePendingMerges(mergePolicy, mergeTrigger, n2);
        this.mergeScheduler.merge(this, mergeTrigger, bl);
    }

    private synchronized boolean updatePendingMerges(MergePolicy mergePolicy, MergeTrigger object, int n2) throws IOException {
        boolean bl;
        int n3;
        int n4;
        this.messageState();
        assert (n2 == -1 || n2 > 0);
        assert (object != null);
        if (this.stopMerges) {
            return false;
        }
        if (this.tragedy != null) {
            return false;
        }
        if (n2 != -1) {
            assert (object == MergeTrigger.EXPLICIT || object == MergeTrigger.MERGE_FINISHED) : "Expected EXPLICT or MERGE_FINISHED as trigger even with maxNumSegments set but was: " + ((Enum)object).name();
            object = mergePolicy.findForcedMerges(this.segmentInfos, n2, Collections.unmodifiableMap(this.segmentsToMerge), this);
            if (object != null) {
                n4 = ((MergePolicy.MergeSpecification)object).merges.size();
                for (n3 = 0; n3 < n4; ++n3) {
                    ((MergePolicy.MergeSpecification)object).merges.get((int)n3).maxNumSegments = n2;
                }
            }
        } else {
            object = mergePolicy.findMerges((MergeTrigger)((Object)object), this.segmentInfos, this);
        }
        if (bl = object != null) {
            n4 = ((MergePolicy.MergeSpecification)object).merges.size();
            for (n3 = 0; n3 < n4; ++n3) {
                this.registerMerge(((MergePolicy.MergeSpecification)object).merges.get(n3));
            }
        }
        return bl;
    }

    public synchronized Collection<SegmentCommitInfo> getMergingSegments() {
        return this.mergingSegments;
    }

    public synchronized MergePolicy.OneMerge getNextMerge() {
        if (this.pendingMerges.size() == 0) {
            return null;
        }
        MergePolicy.OneMerge oneMerge = this.pendingMerges.removeFirst();
        this.runningMerges.add(oneMerge);
        return oneMerge;
    }

    public synchronized boolean hasPendingMerges() {
        return this.pendingMerges.size() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IOException {
        Object object = this.commitLock;
        synchronized (object) {
            if (this.shouldClose(true)) {
                this.rollbackInternal();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackInternal() throws IOException {
        IndexWriter indexWriter;
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "rollback");
        }
        try {
            this.abortMerges();
            this.rateLimiters.close();
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "rollback: done finish merges");
            }
            this.mergeScheduler.close();
            this.bufferedUpdatesStream.clear();
            this.docWriter.close();
            this.docWriter.abort(this);
            indexWriter = this;
            synchronized (indexWriter) {
                if (this.pendingCommit != null) {
                    this.pendingCommit.rollbackCommit(this.directory);
                    try {
                        this.deleter.decRef(this.pendingCommit);
                    }
                    finally {
                        this.pendingCommit = null;
                        this.notifyAll();
                    }
                }
                this.readerPool.dropAll(false);
                this.segmentInfos.rollbackSegmentInfos(this.rollbackSegments);
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "rollback: infos=" + this.segString(this.segmentInfos));
                }
                this.testPoint("rollback before checkpoint");
                if (this.tragedy == null) {
                    this.deleter.checkpoint(this.segmentInfos, false);
                    this.deleter.refresh();
                    this.deleter.close();
                }
                this.lastCommitChangeCount = this.changeCount.get();
                this.closed = true;
                IOUtils.close(this.writeLock);
                this.writeLock = null;
            }
            indexWriter = this;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            try {
                this.tragicEvent(outOfMemoryError, "rollbackInternal");
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException(this.mergeScheduler);
                IndexWriter indexWriter2 = this;
                synchronized (indexWriter2) {
                    if (this.pendingCommit != null) {
                        try {
                            this.pendingCommit.rollbackCommit(this.directory);
                            this.deleter.decRef(this.pendingCommit);
                        }
                        catch (Throwable throwable2) {}
                        this.pendingCommit = null;
                    }
                    IOUtils.closeWhileHandlingException(this.readerPool, this.deleter, this.writeLock);
                    this.writeLock = null;
                    this.closed = true;
                    this.closing = false;
                    this.notifyAll();
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(this.mergeScheduler);
            IndexWriter indexWriter3 = this;
            synchronized (indexWriter3) {
                if (this.pendingCommit != null) {
                    try {
                        this.pendingCommit.rollbackCommit(this.directory);
                        this.deleter.decRef(this.pendingCommit);
                    }
                    catch (Throwable throwable) {}
                    this.pendingCommit = null;
                }
                IOUtils.closeWhileHandlingException(this.readerPool, this.deleter, this.writeLock);
                this.writeLock = null;
                this.closed = true;
                this.closing = false;
                this.notifyAll();
                return;
            }
        }
        synchronized (indexWriter) {
            this.closed = true;
            this.closing = false;
            this.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() throws IOException {
        this.ensureOpen();
        try {
            Object object = this.fullFlushLock;
            synchronized (object) {
                long l2 = this.docWriter.lockAndAbortAll(this);
                this.pendingNumDocs.addAndGet(-l2);
                this.processEvents(false, true);
                IndexWriter indexWriter = this;
                synchronized (indexWriter) {
                    try {
                        this.abortMerges();
                        this.stopMerges = false;
                        this.pendingNumDocs.addAndGet(-this.segmentInfos.totalMaxDoc());
                        this.segmentInfos.clear();
                        this.deleter.checkpoint(this.segmentInfos, false);
                        this.readerPool.dropAll(false);
                        this.changeCount.incrementAndGet();
                        this.segmentInfos.changed();
                        this.globalFieldNumberMap.clear();
                        this.docWriter.unlockAllAfterAbortAll(this);
                    }
                    catch (Throwable throwable) {
                        this.docWriter.unlockAllAfterAbortAll(this);
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "hit exception during deleteAll");
                        }
                        throw throwable;
                    }
                }
                return;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.tragicEvent(outOfMemoryError, "deleteAll");
            return;
        }
    }

    private synchronized void abortMerges() {
        this.stopMerges = true;
        for (MergePolicy.OneMerge oneMerge : this.pendingMerges) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "now abort pending merge " + this.segString(oneMerge.segments));
            }
            oneMerge.rateLimiter.setAbort();
            this.mergeFinish(oneMerge);
        }
        this.pendingMerges.clear();
        for (MergePolicy.OneMerge oneMerge : this.runningMerges) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "now abort running merge " + this.segString(oneMerge.segments));
            }
            oneMerge.rateLimiter.setAbort();
        }
        while (this.runningMerges.size() != 0) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "now wait for " + this.runningMerges.size() + " running merge/s to abort");
            }
            this.doWait();
        }
        this.notifyAll();
        assert (0 == this.mergingSegments.size());
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "all running merges have aborted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForMerges() throws IOException {
        this.mergeScheduler.merge(this, MergeTrigger.CLOSING, false);
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            this.ensureOpen(false);
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "waitForMerges");
            }
            while (this.pendingMerges.size() > 0 || this.runningMerges.size() > 0) {
                this.doWait();
            }
            assert (0 == this.mergingSegments.size());
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "waitForMerges done");
            }
            return;
        }
    }

    synchronized void checkpoint() throws IOException {
        this.changed();
        this.deleter.checkpoint(this.segmentInfos, false);
    }

    synchronized void checkpointNoSIS() throws IOException {
        this.changeCount.incrementAndGet();
        this.deleter.checkpoint(this.segmentInfos, false);
    }

    synchronized void changed() {
        this.changeCount.incrementAndGet();
        this.segmentInfos.changed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void publishFrozenUpdates(FrozenBufferedUpdates frozenBufferedUpdates) {
        assert (frozenBufferedUpdates != null && frozenBufferedUpdates.any());
        BufferedUpdatesStream bufferedUpdatesStream = this.bufferedUpdatesStream;
        synchronized (bufferedUpdatesStream) {
            this.bufferedUpdatesStream.push(frozenBufferedUpdates);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publishFlushedSegment(SegmentCommitInfo segmentCommitInfo, FrozenBufferedUpdates frozenBufferedUpdates, FrozenBufferedUpdates frozenBufferedUpdates2) throws IOException {
        try {
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                this.ensureOpen(false);
                BufferedUpdatesStream bufferedUpdatesStream = this.bufferedUpdatesStream;
                synchronized (bufferedUpdatesStream) {
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "publishFlushedSegment");
                    }
                    if (frozenBufferedUpdates2 != null && frozenBufferedUpdates2.any()) {
                        this.bufferedUpdatesStream.push(frozenBufferedUpdates2);
                    }
                    long l2 = frozenBufferedUpdates != null && frozenBufferedUpdates.any() ? this.bufferedUpdatesStream.push(frozenBufferedUpdates) : this.bufferedUpdatesStream.getNextGen();
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "publish sets newSegment delGen=" + l2 + " seg=" + this.segString(segmentCommitInfo));
                    }
                    segmentCommitInfo.setBufferedDeletesGen(l2);
                    this.segmentInfos.add(segmentCommitInfo);
                    this.checkpoint();
                }
            }
            return;
        }
        finally {
            this.flushCount.incrementAndGet();
            this.doAfterFlush();
        }
    }

    protected void doAfterFlush() throws IOException {
    }

    protected void doBeforeFlush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareCommitInternal(MergePolicy mergePolicy) throws IOException {
        this.startCommitTime = System.nanoTime();
        Object object = this.commitLock;
        synchronized (object) {
            this.ensureOpen(false);
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "prepareCommit: flush");
                this.infoStream.message("IW", "  index before flush " + this.segString());
            }
            if (this.tragedy != null) {
                throw new IllegalStateException("this writer hit an unrecoverable error; cannot commit", this.tragedy);
            }
            if (this.pendingCommit != null) {
                throw new IllegalStateException("prepareCommit was already called with no corresponding call to commit");
            }
            this.doBeforeFlush();
            this.testPoint("startDoFlush");
            Object object2 = null;
            boolean bl = false;
            try {
                Object object3 = this.fullFlushLock;
                synchronized (object3) {
                    boolean bl2 = false;
                    try {
                        bl = this.docWriter.flushAllThreads();
                        if (!bl) {
                            this.flushCount.incrementAndGet();
                        }
                        this.processEvents(false, true);
                        bl2 = true;
                        IndexWriter indexWriter = this;
                        synchronized (indexWriter) {
                            this.maybeApplyDeletes(true);
                            this.readerPool.commit(this.segmentInfos);
                            if (this.changeCount.get() != this.lastCommitChangeCount) {
                                this.changeCount.incrementAndGet();
                                this.segmentInfos.changed();
                            }
                            object2 = this.segmentInfos.clone();
                            this.pendingCommitChangeCount = this.changeCount.get();
                            this.filesToCommit = ((SegmentInfos)object2).files(false);
                            this.deleter.incRef(this.filesToCommit);
                        }
                        this.docWriter.finishFullFlush(this, true);
                    }
                    catch (Throwable throwable) {
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "hit exception during prepareCommit");
                        }
                        this.docWriter.finishFullFlush(this, bl2);
                        this.doAfterFlush();
                        throw throwable;
                    }
                    this.doAfterFlush();
                }
            }
            catch (OutOfMemoryError | AbortingException throwable) {
                this.tragicEvent(throwable, "prepareCommit");
            }
            try {
                if (bl) {
                    this.maybeMerge(mergePolicy, MergeTrigger.FULL_FLUSH, -1);
                }
                this.startCommit((SegmentInfos)object2);
            }
            catch (Throwable throwable) {
                object2 = this;
                synchronized (object2) {
                    if (this.filesToCommit != null) {
                        this.deleter.decRefWhileHandlingException(this.filesToCommit);
                        this.filesToCommit = null;
                    }
                }
                throw throwable;
            }
            return;
        }
    }

    public final void commit() throws IOException {
        this.ensureOpen();
        this.commitInternal(this.config.getMergePolicy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void commitInternal(MergePolicy mergePolicy) throws IOException {
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "commit: start");
        }
        Object object = this.commitLock;
        synchronized (object) {
            this.ensureOpen(false);
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "commit: enter lock");
            }
            if (this.pendingCommit == null) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "commit: now prepare");
                }
                this.prepareCommitInternal(mergePolicy);
            } else if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "commit: already prepared");
            }
            this.finishCommit();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void finishCommit() throws IOException {
        boolean bl = false;
        try {
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                this.ensureOpen(false);
                if (this.tragedy != null) {
                    throw new IllegalStateException("this writer hit an unrecoverable error; cannot complete commit", this.tragedy);
                }
                if (this.pendingCommit != null) {
                    try {
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "commit: pendingCommit != null");
                        }
                        String string = this.pendingCommit.finishCommit(this.directory);
                        bl = true;
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "commit: done writing segments file \"" + string + "\"");
                        }
                        this.deleter.checkpoint(this.pendingCommit, true);
                        this.segmentInfos.updateGeneration(this.pendingCommit);
                        this.lastCommitChangeCount = this.pendingCommitChangeCount;
                        this.rollbackSegments = this.pendingCommit.createBackupSegmentInfos();
                        this.notifyAll();
                    }
                    catch (Throwable throwable) {
                        this.notifyAll();
                        try {
                            if (!bl) {
                                this.deleter.decRefWhileHandlingException(this.filesToCommit);
                            }
                        }
                        finally {
                            this.pendingCommit = null;
                            this.filesToCommit = null;
                        }
                        throw throwable;
                    }
                    try {
                        this.deleter.decRef(this.filesToCommit);
                    }
                    finally {
                        this.pendingCommit = null;
                        this.filesToCommit = null;
                    }
                }
                assert (this.filesToCommit == null);
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "commit: pendingCommit == null; skip");
                }
            }
        }
        catch (Throwable throwable) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "hit exception during finishCommit: " + throwable.getMessage());
            }
            if (bl) {
                this.tragicEvent(throwable, "finishCommit");
            }
            IOUtils.reThrow(throwable);
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", String.format(Locale.ROOT, "commit: took %.1f msec", (double)(System.nanoTime() - this.startCommitTime) / 1000000.0));
            this.infoStream.message("IW", "commit: done");
        }
    }

    boolean holdsFullFlushLock() {
        return Thread.holdsLock(this.fullFlushLock);
    }

    protected final void flush(boolean bl, boolean bl2) throws IOException {
        this.ensureOpen(false);
        if (this.doFlush(bl2) && bl) {
            this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.FULL_FLUSH, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFlush(boolean bl) throws IOException {
        if (this.tragedy != null) {
            throw new IllegalStateException("this writer hit an unrecoverable error; cannot flush", this.tragedy);
        }
        this.doBeforeFlush();
        this.testPoint("startDoFlush");
        boolean bl2 = false;
        try {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "  start flush: applyAllDeletes=" + bl);
                this.infoStream.message("IW", "  index before flush " + this.segString());
            }
            Object object = this.fullFlushLock;
            synchronized (object) {
                try {
                    boolean bl3 = this.docWriter.flushAllThreads();
                    if (!bl3) {
                        this.flushCount.incrementAndGet();
                    }
                    this.docWriter.finishFullFlush(this, true);
                }
                catch (Throwable throwable) {
                    this.docWriter.finishFullFlush(this, false);
                    this.processEvents(false, true);
                    throw throwable;
                }
                this.processEvents(false, true);
            }
            object = this;
            synchronized (object) {
                try {
                    this.doAfterFlush();
                    bl2 = true;
                    return bl3 |= this.maybeApplyDeletes(bl);
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (OutOfMemoryError | AbortingException throwable2) {
                        this.tragicEvent(throwable2, "doFlush");
                        return false;
                    }
                }
            }
        }
        finally {
            if (!bl2 && this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "hit exception during flush");
            }
        }
    }

    final synchronized boolean maybeApplyDeletes(boolean bl) throws IOException {
        if (bl) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "apply all deletes during flush");
            }
            return this.applyAllDeletesAndUpdates();
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "don't apply deletes now delTermCount=" + this.bufferedUpdatesStream.numTerms() + " bytesUsed=" + this.bufferedUpdatesStream.ramBytesUsed());
        }
        return false;
    }

    final synchronized boolean applyAllDeletesAndUpdates() throws IOException {
        this.flushDeletesCount.incrementAndGet();
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "now apply all deletes for all segments maxDoc=" + (this.docWriter.getNumDocs() + this.segmentInfos.totalMaxDoc()));
        }
        BufferedUpdatesStream.ApplyDeletesResult applyDeletesResult = this.bufferedUpdatesStream.applyDeletesAndUpdates(this.readerPool, this.segmentInfos.asList());
        if (applyDeletesResult.anyDeletes) {
            this.checkpoint();
        }
        if (!this.keepFullyDeletedSegments && applyDeletesResult.allDeleted != null) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "drop 100% deleted segments: " + this.segString(applyDeletesResult.allDeleted));
            }
            for (SegmentCommitInfo segmentCommitInfo : applyDeletesResult.allDeleted) {
                if (this.mergingSegments.contains(segmentCommitInfo)) continue;
                this.segmentInfos.remove(segmentCommitInfo);
                this.pendingNumDocs.addAndGet(-segmentCommitInfo.info.maxDoc());
                this.readerPool.drop(segmentCommitInfo);
            }
            this.checkpoint();
        }
        this.bufferedUpdatesStream.prune(this.segmentInfos);
        return applyDeletesResult.anyDeletes;
    }

    private synchronized void ensureValidMerge(MergePolicy.OneMerge object) {
        for (SegmentCommitInfo segmentCommitInfo : ((MergePolicy.OneMerge)object).segments) {
            if (this.segmentInfos.contains(segmentCommitInfo)) continue;
            throw new MergePolicy.MergeException("MergePolicy selected a segment (" + segmentCommitInfo.info.name + ") that is not in the current index " + this.segString(), this.directoryOrig);
        }
    }

    private void skipDeletedDoc(DocValuesFieldUpdates.a[] aArray, int n2) {
        for (DocValuesFieldUpdates.a a2 : aArray) {
            if (a2.doc() == n2) {
                a2.nextDoc();
            }
            assert (a2.doc() > n2) : "updateDoc=" + a2.doc() + " deletedDoc=" + n2;
        }
    }

    private void maybeApplyMergedDVUpdates(MergePolicy.OneMerge oneMerge, MergeState mergeState, int n2, MergedDeletesAndUpdates mergedDeletesAndUpdates, String[] stringArray, DocValuesFieldUpdates[] docValuesFieldUpdatesArray, DocValuesFieldUpdates.a[] aArray, int n3) throws IOException {
        int n4 = -1;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            DocValuesFieldUpdates.a a2 = aArray[i2];
            if (a2.doc() == n3) {
                if (mergedDeletesAndUpdates.mergedDeletesAndUpdates == null) {
                    mergedDeletesAndUpdates.init(this.readerPool, oneMerge, mergeState, false);
                }
                if (n4 == -1) {
                    n4 = mergedDeletesAndUpdates.docMap.map(n2);
                }
                docValuesFieldUpdatesArray[i2].add(n4, a2.value());
                a2.nextDoc();
                continue;
            }
            assert (a2.doc() > n3) : "field=" + stringArray[i2] + " updateDoc=" + a2.doc() + " curDoc=" + n3;
        }
    }

    private synchronized ReadersAndUpdates commitMergedDeletesAndUpdates(MergePolicy.OneMerge oneMerge, MergeState mergeState) throws IOException {
        this.testPoint("startCommitMergeDeletes");
        List<SegmentCommitInfo> list = oneMerge.segments;
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "commitMergeDeletes " + this.segString(oneMerge.segments));
        }
        int n2 = 0;
        long l2 = Long.MAX_VALUE;
        MergedDeletesAndUpdates mergedDeletesAndUpdates = new MergedDeletesAndUpdates();
        DocValuesFieldUpdates.Container container = new DocValuesFieldUpdates.Container();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            int n3;
            DocValuesFieldUpdates[] docValuesFieldUpdatesArray;
            DocValuesFieldUpdates.a[] aArray;
            String[] stringArray;
            SegmentCommitInfo segmentCommitInfo = list.get(i2);
            l2 = Math.min(segmentCommitInfo.getBufferedDeletesGen(), l2);
            int n4 = segmentCommitInfo.info.maxDoc();
            Bits bits = oneMerge.readers.get(i2).getLiveDocs();
            ReadersAndUpdates readersAndUpdates = this.readerPool.get(segmentCommitInfo, false);
            assert (readersAndUpdates != null) : "seg=" + segmentCommitInfo.info.name;
            Bits bits2 = readersAndUpdates.getLiveDocs();
            Map<String, DocValuesFieldUpdates> map = readersAndUpdates.getMergingFieldUpdates();
            if (map.isEmpty()) {
                stringArray = null;
                aArray = null;
                docValuesFieldUpdatesArray = null;
            } else {
                stringArray = new String[map.size()];
                docValuesFieldUpdatesArray = new DocValuesFieldUpdates[map.size()];
                aArray = new DocValuesFieldUpdates.a[map.size()];
                n3 = 0;
                for (Map.Entry entry : map.entrySet()) {
                    String string = (String)entry.getKey();
                    DocValuesFieldUpdates object = (DocValuesFieldUpdates)entry.getValue();
                    stringArray[n3] = string;
                    docValuesFieldUpdatesArray[n3] = container.getUpdates(string, object.type);
                    if (docValuesFieldUpdatesArray[n3] == null) {
                        docValuesFieldUpdatesArray[n3] = container.newUpdates(string, object.type, mergeState.segmentInfo.maxDoc());
                    }
                    aArray[n3] = object.iterator();
                    aArray[n3].nextDoc();
                    ++n3;
                }
            }
            if (bits != null) {
                assert (bits2 != null);
                assert (bits.length() == n4);
                assert (bits2.length() == n4);
                if (bits2 != bits) {
                    for (n3 = 0; n3 < n4; ++n3) {
                        if (!bits.get(n3)) {
                            assert (!bits2.get(n3));
                            continue;
                        }
                        if (!bits2.get(n3)) {
                            if (mergedDeletesAndUpdates.mergedDeletesAndUpdates == null || !mergedDeletesAndUpdates.initializedWritableLiveDocs) {
                                mergedDeletesAndUpdates.init(this.readerPool, oneMerge, mergeState, true);
                            }
                            mergedDeletesAndUpdates.mergedDeletesAndUpdates.delete(mergedDeletesAndUpdates.docMap.map(n2));
                            if (stringArray != null) {
                                this.skipDeletedDoc(aArray, n3);
                            }
                        } else if (stringArray != null) {
                            this.maybeApplyMergedDVUpdates(oneMerge, mergeState, n2, mergedDeletesAndUpdates, stringArray, docValuesFieldUpdatesArray, aArray, n3);
                        }
                        ++n2;
                    }
                    continue;
                }
                if (stringArray != null) {
                    for (n3 = 0; n3 < n4; ++n3) {
                        if (bits.get(n3)) {
                            this.maybeApplyMergedDVUpdates(oneMerge, mergeState, n2, mergedDeletesAndUpdates, stringArray, docValuesFieldUpdatesArray, aArray, n3);
                            ++n2;
                            continue;
                        }
                        this.skipDeletedDoc(aArray, n3);
                    }
                    continue;
                }
                n2 += segmentCommitInfo.info.maxDoc() - segmentCommitInfo.getDelCount() - readersAndUpdates.getPendingDeleteCount();
                continue;
            }
            if (bits2 != null) {
                assert (bits2.length() == n4);
                for (n3 = 0; n3 < n4; ++n3) {
                    if (!bits2.get(n3)) {
                        if (mergedDeletesAndUpdates.mergedDeletesAndUpdates == null || !mergedDeletesAndUpdates.initializedWritableLiveDocs) {
                            mergedDeletesAndUpdates.init(this.readerPool, oneMerge, mergeState, true);
                        }
                        mergedDeletesAndUpdates.mergedDeletesAndUpdates.delete(mergedDeletesAndUpdates.docMap.map(n2));
                        if (stringArray != null) {
                            this.skipDeletedDoc(aArray, n3);
                        }
                    } else if (stringArray != null) {
                        this.maybeApplyMergedDVUpdates(oneMerge, mergeState, n2, mergedDeletesAndUpdates, stringArray, docValuesFieldUpdatesArray, aArray, n3);
                    }
                    ++n2;
                }
                continue;
            }
            if (stringArray != null) {
                for (n3 = 0; n3 < n4; ++n3) {
                    this.maybeApplyMergedDVUpdates(oneMerge, mergeState, n2, mergedDeletesAndUpdates, stringArray, docValuesFieldUpdatesArray, aArray, n3);
                    ++n2;
                }
                continue;
            }
            n2 += segmentCommitInfo.info.maxDoc();
        }
        assert (n2 == oneMerge.info.info.maxDoc());
        if (container.any()) {
            try {
                mergedDeletesAndUpdates.mergedDeletesAndUpdates.writeFieldUpdates(this.directory, container);
            }
            catch (Throwable throwable) {
                mergedDeletesAndUpdates.mergedDeletesAndUpdates.dropChanges();
                this.readerPool.drop(oneMerge.info);
                throw throwable;
            }
        }
        if (this.infoStream.isEnabled("IW")) {
            if (mergedDeletesAndUpdates.mergedDeletesAndUpdates == null) {
                this.infoStream.message("IW", "no new deletes or field updates since merge started");
            } else {
                String string = mergedDeletesAndUpdates.mergedDeletesAndUpdates.getPendingDeleteCount() + " new deletes";
                if (container.any()) {
                    string = string + " and " + container.size() + " new field updates";
                }
                string = string + " since merge started";
                this.infoStream.message("IW", string);
            }
        }
        oneMerge.info.setBufferedDeletesGen(l2);
        return mergedDeletesAndUpdates.mergedDeletesAndUpdates;
    }

    private synchronized boolean commitMerge(MergePolicy.OneMerge oneMerge, MergeState mergeState) throws IOException {
        boolean bl;
        this.testPoint("startCommitMerge");
        if (this.tragedy != null) {
            throw new IllegalStateException("this writer hit an unrecoverable error; cannot complete merge", this.tragedy);
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "commitMerge: " + this.segString(oneMerge.segments) + " index=" + this.segString());
        }
        assert (oneMerge.registerDone);
        if (oneMerge.rateLimiter.getAbort()) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "commitMerge: skip: it was aborted");
            }
            this.readerPool.drop(oneMerge.info);
            this.deleteNewFiles(oneMerge.info.files());
            return false;
        }
        MergeState mergeState2 = mergeState = oneMerge.info.info.maxDoc() == 0 ? null : this.commitMergedDeletesAndUpdates(oneMerge, mergeState);
        assert (!this.segmentInfos.contains(oneMerge.info));
        boolean bl2 = bl = oneMerge.segments.size() == 0 || oneMerge.info.info.maxDoc() == 0 || mergeState != null && ((ReadersAndUpdates)((Object)mergeState)).getPendingDeleteCount() == oneMerge.info.info.maxDoc();
        if (this.infoStream.isEnabled("IW") && bl) {
            this.infoStream.message("IW", "merged segment " + oneMerge.info + " is 100% deleted" + (this.keepFullyDeletedSegments ? "" : "; skipping insert"));
        }
        boolean bl3 = bl = bl && !this.keepFullyDeletedSegments;
        assert (oneMerge.segments.size() > 0 || bl);
        assert (oneMerge.info.info.maxDoc() != 0 || this.keepFullyDeletedSegments || bl);
        if (mergeState != null) {
            try {
                if (bl) {
                    ((ReadersAndUpdates)((Object)mergeState)).dropChanges();
                }
                this.readerPool.release((ReadersAndUpdates)((Object)mergeState), false);
            }
            catch (Throwable throwable) {
                ((ReadersAndUpdates)((Object)mergeState)).dropChanges();
                this.readerPool.drop(oneMerge.info);
                throw throwable;
            }
        }
        this.segmentInfos.applyMergeChanges(oneMerge, bl);
        int n2 = oneMerge.totalMaxDoc - oneMerge.info.info.maxDoc();
        assert (n2 >= 0);
        this.pendingNumDocs.addAndGet(-n2);
        if (bl) {
            assert (!this.segmentInfos.contains(oneMerge.info));
            this.readerPool.drop(oneMerge.info);
            this.deleteNewFiles(oneMerge.info.files());
        }
        try {
            this.closeMergeReaders(oneMerge, false);
        }
        catch (Throwable throwable) {
            try {
                this.checkpoint();
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        this.checkpoint();
        this.deleter.deletePendingFiles();
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "after commitMerge: " + this.segString());
        }
        if (oneMerge.maxNumSegments != -1 && !bl && !this.segmentsToMerge.containsKey(oneMerge.info)) {
            this.segmentsToMerge.put(oneMerge.info, Boolean.FALSE);
        }
        return true;
    }

    private final void handleMergeException(Throwable throwable, MergePolicy.OneMerge oneMerge) throws IOException {
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "handleMergeException: merge=" + this.segString(oneMerge.segments) + " exc=" + throwable);
        }
        oneMerge.setException(throwable);
        this.addMergeException(oneMerge);
        if (throwable instanceof MergePolicy.a) {
            if (oneMerge.isExternal) {
                throw (MergePolicy.a)throwable;
            }
        } else {
            IOUtils.reThrow(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(MergePolicy.OneMerge oneMerge) throws IOException {
        boolean bl = false;
        this.rateLimiters.set(oneMerge.rateLimiter);
        long l2 = System.currentTimeMillis();
        MergePolicy mergePolicy = this.config.getMergePolicy();
        try {
            try {
                try {
                    this.mergeInit(oneMerge);
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "now merge\n  merge=" + this.segString(oneMerge.segments) + "\n  index=" + this.segString());
                    }
                    this.mergeMiddle(oneMerge, mergePolicy);
                    this.mergeSuccess(oneMerge);
                    bl = true;
                }
                catch (Throwable throwable) {
                    this.handleMergeException(throwable, oneMerge);
                }
            }
            finally {
                IndexWriter indexWriter = this;
                synchronized (indexWriter) {
                    this.mergeFinish(oneMerge);
                    if (!bl) {
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "hit exception during merge");
                        }
                        if (oneMerge.info != null && !this.segmentInfos.contains(oneMerge.info)) {
                            this.deleter.refresh(oneMerge.info.info.name);
                        }
                    } else if (!(oneMerge.rateLimiter.getAbort() || oneMerge.maxNumSegments == -1 && (this.closed || this.closing))) {
                        this.updatePendingMerges(mergePolicy, MergeTrigger.MERGE_FINISHED, oneMerge.maxNumSegments);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            this.tragicEvent(throwable, "merge");
        }
        if (oneMerge.info != null && !oneMerge.rateLimiter.getAbort() && this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "merge time " + (System.currentTimeMillis() - l2) + " msec for " + oneMerge.info.info.maxDoc() + " docs");
        }
    }

    void mergeSuccess(MergePolicy.OneMerge oneMerge) {
    }

    final synchronized boolean registerMerge(MergePolicy.OneMerge oneMerge) throws IOException {
        if (oneMerge.registerDone) {
            return true;
        }
        assert (oneMerge.segments.size() > 0);
        if (this.stopMerges) {
            oneMerge.rateLimiter.setAbort();
            throw new MergePolicy.a("merge is aborted: " + this.segString(oneMerge.segments));
        }
        int n2 = 0;
        for (SegmentCommitInfo object : oneMerge.segments) {
            if (this.mergingSegments.contains(object)) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "reject merge " + this.segString(oneMerge.segments) + ": segment " + this.segString(object) + " is already marked for merge");
                }
                return false;
            }
            if (!this.segmentInfos.contains(object)) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "reject merge " + this.segString(oneMerge.segments) + ": segment " + this.segString(object) + " does not exist in live infos");
                }
                return false;
            }
            if (object.info.dir != this.directoryOrig) {
                n2 = 1;
            }
            if (!this.segmentsToMerge.containsKey(object)) continue;
            oneMerge.maxNumSegments = this.mergeMaxNumSegments;
        }
        this.ensureValidMerge(oneMerge);
        this.pendingMerges.add(oneMerge);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "add merge to pendingMerges: " + this.segString(oneMerge.segments) + " [total " + this.pendingMerges.size() + " pending]");
        }
        oneMerge.mergeGen = this.mergeGen;
        oneMerge.isExternal = n2;
        if (this.infoStream.isEnabled("IW")) {
            Iterator<SegmentCommitInfo> iterator = new StringBuilder("registerMerge merging= [");
            for (SegmentCommitInfo segmentCommitInfo : this.mergingSegments) {
                ((StringBuilder)((Object)iterator)).append(segmentCommitInfo.info.name).append(", ");
            }
            ((StringBuilder)((Object)iterator)).append("]");
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", ((StringBuilder)((Object)iterator)).toString());
            }
        }
        for (SegmentCommitInfo segmentCommitInfo : oneMerge.segments) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "registerMerge info=" + this.segString(segmentCommitInfo));
            }
            this.mergingSegments.add(segmentCommitInfo);
        }
        assert (oneMerge.estimatedMergeBytes == 0L);
        assert (oneMerge.totalMergeBytes == 0L);
        for (SegmentCommitInfo segmentCommitInfo : oneMerge.segments) {
            if (segmentCommitInfo.info.maxDoc() <= 0) continue;
            n2 = this.numDeletedDocs(segmentCommitInfo);
            assert (n2 <= segmentCommitInfo.info.maxDoc());
            double d2 = (double)n2 / (double)segmentCommitInfo.info.maxDoc();
            oneMerge.estimatedMergeBytes = (long)((double)oneMerge.estimatedMergeBytes + (double)segmentCommitInfo.sizeInBytes() * (1.0 - d2));
            oneMerge.totalMergeBytes += segmentCommitInfo.sizeInBytes();
        }
        oneMerge.registerDone = true;
        return true;
    }

    final synchronized void mergeInit(MergePolicy.OneMerge oneMerge) throws IOException {
        try {
            this._mergeInit(oneMerge);
            return;
        }
        catch (Throwable throwable) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "hit exception in mergeInit");
            }
            this.mergeFinish(oneMerge);
            throw throwable;
        }
    }

    private synchronized void _mergeInit(MergePolicy.OneMerge oneMerge) throws IOException {
        this.testPoint("startMergeInit");
        assert (oneMerge.registerDone);
        assert (oneMerge.maxNumSegments == -1 || oneMerge.maxNumSegments > 0);
        if (this.tragedy != null) {
            throw new IllegalStateException("this writer hit an unrecoverable error; cannot merge", this.tragedy);
        }
        if (oneMerge.info != null) {
            return;
        }
        if (oneMerge.rateLimiter.getAbort()) {
            return;
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "now apply deletes for " + oneMerge.segments.size() + " merging segments");
        }
        Object object2 = this.bufferedUpdatesStream.applyDeletesAndUpdates(this.readerPool, oneMerge.segments);
        if (((BufferedUpdatesStream.ApplyDeletesResult)object2).anyDeletes) {
            this.checkpoint();
        }
        if (!this.keepFullyDeletedSegments && ((BufferedUpdatesStream.ApplyDeletesResult)object2).allDeleted != null) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "drop 100% deleted segments: " + ((BufferedUpdatesStream.ApplyDeletesResult)object2).allDeleted);
            }
            for (SegmentCommitInfo object3 : ((BufferedUpdatesStream.ApplyDeletesResult)object2).allDeleted) {
                this.segmentInfos.remove(object3);
                this.pendingNumDocs.addAndGet(-object3.info.maxDoc());
                if (oneMerge.segments.contains(object3)) {
                    this.mergingSegments.remove(object3);
                    oneMerge.segments.remove(object3);
                }
                this.readerPool.drop(object3);
            }
            this.checkpoint();
        }
        object2 = this.newSegmentName();
        SegmentInfo segmentInfo = new SegmentInfo(this.directoryOrig, Version.LATEST, (String)object2, -1, false, this.codec, Collections.emptyMap(), StringHelper.randomId(), (Map<String, String>)new HashMap<String, String>());
        object2 = new HashMap<String, String>();
        object2.put("mergeMaxNumSegments", "" + oneMerge.maxNumSegments);
        object2.put("mergeFactor", Integer.toString(oneMerge.segments.size()));
        IndexWriter.setDiagnostics(segmentInfo, "merge", (Map<String, String>)object2);
        oneMerge.setMergeInfo(new SegmentCommitInfo(segmentInfo, 0, -1L, -1L, -1L));
        this.bufferedUpdatesStream.prune(this.segmentInfos);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "merge seg=" + oneMerge.info.info.name + " " + this.segString(oneMerge.segments));
        }
    }

    static void setDiagnostics(SegmentInfo segmentInfo, String string) {
        IndexWriter.setDiagnostics(segmentInfo, string, null);
    }

    private static void setDiagnostics(SegmentInfo segmentInfo, String string, Map<String, String> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("source", string);
        hashMap.put("lucene.version", Version.LATEST.toString());
        hashMap.put("os", Constants.OS_NAME);
        hashMap.put("os.arch", Constants.OS_ARCH);
        hashMap.put("os.version", Constants.OS_VERSION);
        hashMap.put("java.version", Constants.JAVA_VERSION);
        hashMap.put("java.vendor", Constants.JAVA_VENDOR);
        hashMap.put("java.runtime.version", System.getProperty("java.runtime.version", "undefined"));
        hashMap.put("java.vm.version", System.getProperty("java.vm.version", "undefined"));
        hashMap.put("timestamp", Long.toString(new Date().getTime()));
        if (map != null) {
            hashMap.putAll(map);
        }
        segmentInfo.setDiagnostics(hashMap);
    }

    final synchronized void mergeFinish(MergePolicy.OneMerge oneMerge) {
        this.notifyAll();
        if (oneMerge.registerDone) {
            for (SegmentCommitInfo segmentCommitInfo : oneMerge.segments) {
                this.mergingSegments.remove(segmentCommitInfo);
            }
            oneMerge.registerDone = false;
        }
        this.runningMerges.remove(oneMerge);
    }

    private final synchronized void closeMergeReaders(MergePolicy.OneMerge oneMerge, boolean bl) throws IOException {
        Throwable throwable;
        block11: {
            int n2 = oneMerge.readers.size();
            throwable = null;
            boolean bl2 = !bl;
            for (int i2 = 0; i2 < n2; ++i2) {
                block10: {
                    SegmentReader segmentReader = oneMerge.readers.get(i2);
                    if (segmentReader == null) continue;
                    try {
                        ReadersAndUpdates readersAndUpdates = this.readerPool.get(segmentReader.getSegmentInfo(), false);
                        assert (readersAndUpdates != null);
                        if (bl2) {
                            readersAndUpdates.dropChanges();
                        } else {
                            readersAndUpdates.dropMergingUpdates();
                        }
                        readersAndUpdates.release(segmentReader);
                        this.readerPool.release(readersAndUpdates);
                        if (bl2) {
                            this.readerPool.drop(readersAndUpdates.info);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable != null) break block10;
                        throwable = throwable2;
                    }
                }
                oneMerge.readers.set(i2, null);
            }
            try {
                oneMerge.mergeFinished();
            }
            catch (Throwable throwable3) {
                if (throwable != null) break block11;
                throwable = throwable3;
            }
        }
        if (!bl) {
            IOUtils.reThrow(throwable);
        }
    }

    /*
     * Exception decompiling
     */
    private int mergeMiddle(MergePolicy.OneMerge var1_1, MergePolicy var2_2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    synchronized void addMergeException(MergePolicy.OneMerge oneMerge) {
        assert (oneMerge.getException() != null);
        if (!this.mergeExceptions.contains(oneMerge) && this.mergeGen == oneMerge.mergeGen) {
            this.mergeExceptions.add(oneMerge);
        }
    }

    synchronized String segString() {
        return this.segString(this.segmentInfos);
    }

    synchronized String segString(Iterable<SegmentCommitInfo> object) {
        StringBuilder stringBuilder = new StringBuilder();
        object = object.iterator();
        while (object.hasNext()) {
            SegmentCommitInfo segmentCommitInfo = (SegmentCommitInfo)object.next();
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.segString(segmentCommitInfo));
        }
        return stringBuilder.toString();
    }

    synchronized String segString(SegmentCommitInfo segmentCommitInfo) {
        return segmentCommitInfo.toString(this.numDeletedDocs(segmentCommitInfo) - segmentCommitInfo.getDelCount());
    }

    private synchronized void doWait() {
        try {
            this.wait(1000L);
            return;
        }
        catch (InterruptedException interruptedException) {
            throw new org.apache.lucene.util.j(interruptedException);
        }
    }

    boolean getKeepFullyDeletedSegments() {
        return this.keepFullyDeletedSegments;
    }

    private boolean filesExist(SegmentInfos object) throws IOException {
        for (String string : ((SegmentInfos)object).files(false)) {
            assert (IndexWriter.slowFileExists(this.directory, string)) : "file " + string + " does not exist; files=" + Arrays.toString(this.directory.listAll());
            assert (this.deleter.exists(string)) : "IndexFileDeleter doesn't know about file " + string;
        }
        return true;
    }

    synchronized SegmentInfos toLiveInfos(SegmentInfos object) {
        SegmentInfos segmentInfos = new SegmentInfos();
        HashMap<SegmentCommitInfo, SegmentCommitInfo> hashMap = new HashMap<SegmentCommitInfo, SegmentCommitInfo>();
        for (Object object2 : this.segmentInfos) {
            hashMap.put((SegmentCommitInfo)object2, (SegmentCommitInfo)object2);
        }
        Iterator<SegmentCommitInfo> iterator = ((SegmentInfos)object).iterator();
        while (iterator.hasNext()) {
            Object object2;
            object2 = iterator.next();
            object = (SegmentCommitInfo)hashMap.get(object2);
            if (object != null) {
                object2 = object;
            }
            segmentInfos.add((SegmentCommitInfo)object2);
        }
        return segmentInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCommit(SegmentInfos segmentInfos) throws IOException {
        this.testPoint("startStartCommit");
        assert (this.pendingCommit == null);
        if (this.tragedy != null) {
            throw new IllegalStateException("this writer hit an unrecoverable error; cannot commit", this.tragedy);
        }
        try {
            Object object;
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "startCommit(): start");
            }
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                if (this.lastCommitChangeCount > this.changeCount.get()) {
                    throw new IllegalStateException("lastCommitChangeCount=" + this.lastCommitChangeCount + ",changeCount=" + this.changeCount);
                }
                if (this.pendingCommitChangeCount == this.lastCommitChangeCount) {
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "  skip startCommit(): no changes pending");
                    }
                    try {
                        this.deleter.decRef(this.filesToCommit);
                    }
                    finally {
                        this.filesToCommit = null;
                    }
                    return;
                }
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "startCommit index=" + this.segString(this.toLiveInfos(segmentInfos)) + " changeCount=" + this.changeCount);
                }
                assert (this.filesExist(segmentInfos));
            }
            this.testPoint("midStartCommit");
            boolean bl = false;
            try {
                this.testPoint("midStartCommit2");
                object = this;
                synchronized (object) {
                    assert (this.pendingCommit == null);
                    assert (this.segmentInfos.getGeneration() == segmentInfos.getGeneration());
                    segmentInfos.prepareCommit(this.directory);
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "startCommit: wrote pending segments file \"" + IndexFileNames.fileNameFromGeneration("pending_segments", "", segmentInfos.getGeneration()) + "\"");
                    }
                    bl = true;
                    this.pendingCommit = segmentInfos;
                }
                try {
                    object = segmentInfos.files(false);
                    this.directory.sync((Collection<String>)object);
                }
                catch (Throwable throwable) {
                    bl = false;
                    this.pendingCommit = null;
                    segmentInfos.rollbackCommit(this.directory);
                    throw throwable;
                }
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "done all syncs: " + object);
                }
                this.testPoint("midStartCommitSuccess");
                object = this;
            }
            catch (Throwable throwable) {
                IndexWriter indexWriter2 = this;
                synchronized (indexWriter2) {
                    this.segmentInfos.updateGeneration(segmentInfos);
                    if (!bl) {
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "hit exception committing segments file");
                        }
                        this.deleter.decRefWhileHandlingException(this.filesToCommit);
                        this.filesToCommit = null;
                    }
                }
                throw throwable;
            }
            synchronized (object) {
                this.segmentInfos.updateGeneration(segmentInfos);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.tragicEvent(outOfMemoryError, "startCommit");
        }
        this.testPoint("finishStartCommit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tragicEvent(Throwable throwable, String object) throws IOException {
        if (throwable instanceof AbortingException) {
            throwable = throwable.getCause();
        }
        assert (!(throwable instanceof MergePolicy.a));
        assert (!Thread.holdsLock(this));
        assert (throwable != null);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "hit tragic " + throwable.getClass().getSimpleName() + " inside " + (String)object);
        }
        object = this;
        synchronized (object) {
            if (this.tragedy != null) {
                IOUtils.reThrow(throwable);
            }
            this.tragedy = throwable;
        }
        if (this.shouldClose(false)) {
            this.rollbackInternal();
        }
        IOUtils.reThrow(throwable);
    }

    private final void testPoint(String string) {
        if (this.enableTestPoints) {
            assert (this.infoStream.isEnabled("TP"));
            this.infoStream.message("TP", string);
        }
    }

    synchronized boolean nrtIsCurrent(SegmentInfos segmentInfos) {
        boolean bl;
        this.ensureOpen();
        boolean bl2 = bl = segmentInfos.version == this.segmentInfos.version && !this.docWriter.anyChanges() && !this.bufferedUpdatesStream.any();
        if (this.infoStream.isEnabled("IW") && !bl) {
            this.infoStream.message("IW", "nrtIsCurrent: infoVersion matches: " + (segmentInfos.version == this.segmentInfos.version) + "; DW changes: " + this.docWriter.anyChanges() + "; BD changes: " + this.bufferedUpdatesStream.any());
        }
        return bl;
    }

    synchronized boolean isClosed() {
        return this.closed;
    }

    final void createCompoundFile(InfoStream infoStream, TrackingDirectoryWrapper trackingDirectoryWrapper, SegmentInfo segmentInfo, IOContext iOContext) throws IOException {
        if (!trackingDirectoryWrapper.getCreatedFiles().isEmpty()) {
            throw new IllegalStateException("pass a clean trackingdir for CFS creation");
        }
        if (infoStream.isEnabled("IW")) {
            infoStream.message("IW", "create compound file");
        }
        try {
            segmentInfo.getCodec().compoundFormat().write(trackingDirectoryWrapper, segmentInfo, iOContext);
        }
        catch (Throwable throwable) {
            this.deleteNewFiles(trackingDirectoryWrapper.getCreatedFiles());
            throw throwable;
        }
        segmentInfo.setFiles(new HashSet<String>(trackingDirectoryWrapper.getCreatedFiles()));
    }

    final synchronized void deleteNewFiles(Collection<String> collection) throws IOException {
        this.deleter.deleteNewFiles(collection);
    }

    final synchronized void flushFailed(SegmentInfo segmentInfo) throws IOException {
        this.deleter.refresh(segmentInfo.name);
    }

    final int purge(boolean bl) throws IOException {
        return this.docWriter.purgeBuffer(this, bl);
    }

    final void applyDeletesAndPurge(boolean bl) throws IOException {
        try {
            this.purge(bl);
            return;
        }
        finally {
            if (this.applyAllDeletesAndUpdates()) {
                this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.SEGMENT_FLUSH, -1);
            }
            this.flushCount.incrementAndGet();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void doAfterSegmentFlushed(boolean bl, boolean bl2) throws IOException {
        try {
            this.purge(bl2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.SEGMENT_FLUSH, -1);
            throw throwable;
        }
        this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.SEGMENT_FLUSH, -1);
    }

    synchronized void incRefDeleter(SegmentInfos segmentInfos) throws IOException {
        this.ensureOpen();
        this.deleter.incRef(segmentInfos, false);
    }

    synchronized void decRefDeleter(SegmentInfos segmentInfos) throws IOException {
        this.ensureOpen();
        this.deleter.decRef(segmentInfos);
    }

    private boolean processEvents(boolean bl, boolean bl2) throws IOException {
        return this.processEvents(this.eventQueue, bl, bl2);
    }

    private boolean processEvents(Queue<a> queue, boolean bl, boolean bl2) throws IOException {
        boolean bl3 = false;
        if (this.tragedy == null) {
            a a2;
            while ((a2 = queue.poll()) != null) {
                bl3 = true;
                a2.process(this, bl, bl2);
            }
        }
        return bl3;
    }

    static boolean slowFileExists(c c2, String string) throws IOException {
        try {
            c2.openInput(string, IOContext.DEFAULT).close();
            return true;
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            return false;
        }
    }

    private c addMergeRateLimiters(c c2) {
        return new FilterDirectory(c2){

            @Override
            public IndexOutput createOutput(String string, IOContext iOContext) throws IOException {
                this.ensureOpen();
                IndexWriter.this.ensureOpen(false);
                assert (iOContext.context == IOContext.Context.MERGE) : "got context=" + (Object)((Object)iOContext.context);
                MergeRateLimiter mergeRateLimiter = IndexWriter.this.rateLimiters.get();
                assert (mergeRateLimiter != null);
                return new RateLimitedIndexOutput(mergeRateLimiter, this.in.createOutput(string, iOContext));
            }
        };
    }

    static interface a {
        public void process(IndexWriter var1, boolean var2, boolean var3) throws IOException;
    }

    public static abstract class b {
    }

    private static class MergedDeletesAndUpdates {
        ReadersAndUpdates mergedDeletesAndUpdates = null;
        MergePolicy.DocMap docMap = null;
        boolean initializedWritableLiveDocs = false;

        MergedDeletesAndUpdates() {
        }

        final void init(ReaderPool readerPool, MergePolicy.OneMerge oneMerge, MergeState mergeState, boolean bl) throws IOException {
            if (this.mergedDeletesAndUpdates == null) {
                this.mergedDeletesAndUpdates = readerPool.get(oneMerge.info, true);
                this.docMap = oneMerge.getDocMap(mergeState);
                assert (this.docMap.isConsistent(oneMerge.info.info.maxDoc()));
            }
            if (bl && !this.initializedWritableLiveDocs) {
                this.mergedDeletesAndUpdates.initWritableLiveDocs();
                this.initializedWritableLiveDocs = true;
            }
        }
    }

    class ReaderPool
    implements Closeable {
        private final Map<SegmentCommitInfo, ReadersAndUpdates> readerMap = new HashMap<SegmentCommitInfo, ReadersAndUpdates>();

        ReaderPool() {
        }

        public synchronized boolean infoIsLive(SegmentCommitInfo segmentCommitInfo) {
            int n2 = IndexWriter.this.segmentInfos.indexOf(segmentCommitInfo);
            assert (n2 != -1) : "info=" + segmentCommitInfo + " isn't live";
            assert (IndexWriter.this.segmentInfos.info(n2) == segmentCommitInfo) : "info=" + segmentCommitInfo + " doesn't match live info in segmentInfos";
            return true;
        }

        public synchronized void drop(SegmentCommitInfo segmentCommitInfo) throws IOException {
            ReadersAndUpdates readersAndUpdates = this.readerMap.get(segmentCommitInfo);
            if (readersAndUpdates != null) {
                assert (segmentCommitInfo == readersAndUpdates.info);
                this.readerMap.remove(segmentCommitInfo);
                readersAndUpdates.dropReaders();
            }
        }

        public synchronized void release(ReadersAndUpdates readersAndUpdates) throws IOException {
            this.release(readersAndUpdates, true);
        }

        public synchronized void release(ReadersAndUpdates readersAndUpdates, boolean bl) throws IOException {
            readersAndUpdates.decRef();
            assert (readersAndUpdates.refCount() > 0);
            if (!IndexWriter.this.poolReaders && readersAndUpdates.refCount() == 1) {
                if (readersAndUpdates.writeLiveDocs(IndexWriter.this.directory)) {
                    assert (!bl || this.infoIsLive(readersAndUpdates.info));
                    IndexWriter.this.checkpointNoSIS();
                }
                readersAndUpdates.dropReaders();
                this.readerMap.remove(readersAndUpdates.info);
            }
        }

        @Override
        public void close() throws IOException {
            this.dropAll(false);
        }

        synchronized void dropAll(boolean bl) throws IOException {
            Throwable throwable = null;
            Iterator<Map.Entry<SegmentCommitInfo, ReadersAndUpdates>> iterator = this.readerMap.entrySet().iterator();
            while (iterator.hasNext()) {
                ReadersAndUpdates readersAndUpdates;
                block10: {
                    readersAndUpdates = iterator.next().getValue();
                    try {
                        if (bl && readersAndUpdates.writeLiveDocs(IndexWriter.this.directory)) {
                            assert (this.infoIsLive(readersAndUpdates.info));
                            IndexWriter.this.checkpointNoSIS();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (bl) {
                            IOUtils.reThrow(throwable2);
                        }
                        if (throwable != null) break block10;
                        throwable = throwable2;
                    }
                }
                iterator.remove();
                try {
                    readersAndUpdates.dropReaders();
                }
                catch (Throwable throwable3) {
                    if (bl) {
                        IOUtils.reThrow(throwable3);
                        continue;
                    }
                    if (throwable != null) continue;
                    throwable = throwable3;
                }
            }
            assert (this.readerMap.size() == 0);
            IOUtils.reThrow(throwable);
        }

        public synchronized void commit(SegmentInfos object) throws IOException {
            object = ((SegmentInfos)object).iterator();
            while (object.hasNext()) {
                SegmentCommitInfo segmentCommitInfo = (SegmentCommitInfo)object.next();
                ReadersAndUpdates readersAndUpdates = this.readerMap.get(segmentCommitInfo);
                if (readersAndUpdates == null) continue;
                assert (readersAndUpdates.info == segmentCommitInfo);
                if (!readersAndUpdates.writeLiveDocs(IndexWriter.this.directory)) continue;
                assert (this.infoIsLive(segmentCommitInfo));
                IndexWriter.this.checkpointNoSIS();
            }
        }

        public synchronized ReadersAndUpdates get(SegmentCommitInfo segmentCommitInfo, boolean bl) {
            IndexWriter.this.ensureOpen(false);
            assert (segmentCommitInfo.info.dir == IndexWriter.this.directoryOrig) : "info.dir=" + segmentCommitInfo.info.dir + " vs " + IndexWriter.access$200(IndexWriter.this);
            ReadersAndUpdates readersAndUpdates = this.readerMap.get(segmentCommitInfo);
            if (readersAndUpdates == null) {
                if (!bl) {
                    return null;
                }
                readersAndUpdates = new ReadersAndUpdates(IndexWriter.this, segmentCommitInfo);
                this.readerMap.put(segmentCommitInfo, readersAndUpdates);
            } else assert (readersAndUpdates.info == segmentCommitInfo) : "rld.info=" + readersAndUpdates.info + " info=" + segmentCommitInfo + " isLive?=" + this.infoIsLive(readersAndUpdates.info) + " vs " + this.infoIsLive(segmentCommitInfo);
            if (bl) {
                readersAndUpdates.incRef();
            }
            assert (this.noDups());
            return readersAndUpdates;
        }

        private boolean noDups() {
            HashSet<String> hashSet = new HashSet<String>();
            for (SegmentCommitInfo segmentCommitInfo : this.readerMap.keySet()) {
                assert (!hashSet.contains(segmentCommitInfo.info.name));
                hashSet.add(segmentCommitInfo.info.name);
            }
            return true;
        }
    }
}

