/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DocumentStoredFieldVisitor;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.a;
import org.apache.lucene.util.IOUtils;

public abstract class IndexReader
implements Closeable {
    private boolean closed = false;
    private boolean closedByChild = false;
    private final AtomicInteger refCount = new AtomicInteger(1);
    private final Set<Object> readerClosedListeners = Collections.synchronizedSet(new LinkedHashSet());
    private final Set<IndexReader> parentReaders = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));

    IndexReader() {
        if (!(this instanceof CompositeReader) && !(this instanceof LeafReader)) {
            throw new Error("IndexReader should never be directly extended, subclass LeafReader or CompositeReader instead.");
        }
    }

    public final void registerParentReader(IndexReader indexReader) {
        this.ensureOpen();
        this.parentReaders.add(indexReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyReaderClosedListeners(Throwable throwable) {
        Set<Object> set = this.readerClosedListeners;
        synchronized (set) {
            Iterator<Object> iterator = this.readerClosedListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next();
            }
            IOUtils.reThrowUnchecked(throwable);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportCloseToParentReaders() {
        Set<IndexReader> set = this.parentReaders;
        synchronized (set) {
            for (IndexReader indexReader : this.parentReaders) {
                var2_2.next().closedByChild = true;
                indexReader.refCount.addAndGet(0);
                indexReader.reportCloseToParentReaders();
            }
            return;
        }
    }

    public final int getRefCount() {
        return this.refCount.get();
    }

    public final void incRef() {
        if (!this.tryIncRef()) {
            this.ensureOpen();
        }
    }

    public final boolean tryIncRef() {
        int n2;
        while ((n2 = this.refCount.get()) > 0) {
            if (!this.refCount.compareAndSet(n2, n2 + 1)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void decRef() throws IOException {
        if (this.refCount.get() <= 0) {
            throw new a("this IndexReader is closed");
        }
        int n2 = this.refCount.decrementAndGet();
        if (n2 != 0) {
            if (n2 >= 0) return;
            throw new IllegalStateException("too many decRef calls: refCount is " + n2 + " after decrement");
        }
        this.closed = true;
        try {
            this.doClose();
        }
        catch (Throwable throwable) {
            try {
                this.reportCloseToParentReaders();
                return;
            }
            finally {
                this.notifyReaderClosedListeners(throwable);
            }
        }
        catch (Throwable throwable) {
            try {
                this.reportCloseToParentReaders();
                throw throwable;
            }
            finally {
                this.notifyReaderClosedListeners(null);
            }
        }
        try {
            this.reportCloseToParentReaders();
            return;
        }
        finally {
            this.notifyReaderClosedListeners(null);
        }
    }

    protected final void ensureOpen() throws a {
        if (this.refCount.get() <= 0) {
            throw new a("this IndexReader is closed");
        }
        if (this.closedByChild) {
            throw new a("this IndexReader cannot be used anymore as one of its child readers was closed");
        }
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    public abstract int numDocs();

    public abstract int maxDoc();

    public final int numDeletedDocs() {
        return this.maxDoc() - this.numDocs();
    }

    public abstract void document(int var1, StoredFieldVisitor var2) throws IOException;

    public final Document document(int n2) throws IOException {
        DocumentStoredFieldVisitor documentStoredFieldVisitor = new DocumentStoredFieldVisitor();
        this.document(n2, documentStoredFieldVisitor);
        return documentStoredFieldVisitor.getDocument();
    }

    public boolean hasDeletions() {
        return this.numDeletedDocs() > 0;
    }

    @Override
    public final synchronized void close() throws IOException {
        if (!this.closed) {
            this.decRef();
            this.closed = true;
        }
    }

    protected abstract void doClose() throws IOException;

    public abstract IndexReaderContext getContext();

    public final List<LeafReaderContext> leaves() {
        return this.getContext().leaves();
    }

    public abstract int docFreq(Term var1) throws IOException;
}

