/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.g;
import org.apache.lucene.index.h;
import org.apache.lucene.portmobile.file.NoSuchFileException;
import org.apache.lucene.portmobile.util.Objects;
import org.apache.lucene.store.a;
import org.apache.lucene.store.c;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;

final class IndexFileDeleter
implements Closeable {
    private final Set<String> deletable = new HashSet<String>();
    private Map<String, RefCount> refCounts = new HashMap<String, RefCount>();
    private List<CommitPoint> commits = new ArrayList<CommitPoint>();
    private final List<String> lastFiles = new ArrayList<String>();
    private List<CommitPoint> commitsToDelete = new ArrayList<CommitPoint>();
    private final InfoStream infoStream;
    private final c directoryOrig;
    private final c directory;
    private final h policy;
    final boolean startingCommitDeleted;
    private SegmentInfos lastSegmentInfos;
    public static boolean VERBOSE_REF_COUNTS = false;
    private final IndexWriter writer;

    private boolean locked() {
        return this.writer == null || Thread.holdsLock(this.writer);
    }

    /*
     * WARNING - void declaration
     */
    public IndexFileDeleter(String[] object5, c c2, c object2, h h2, SegmentInfos segmentInfos, InfoStream infoStream, IndexWriter object3, boolean bl, boolean bl2) throws IOException {
        void var9_14;
        void var8_13;
        Iterator<Map.Entry<String, RefCount>> iterator;
        CommitPoint commitPoint;
        void var2_7;
        void var4_9;
        void var5_10;
        void var6_11;
        String string;
        Objects.requireNonNull(string);
        this.infoStream = var6_11;
        this.writer = string;
        string = var5_10.getSegmentsFileName();
        if (var6_11.isEnabled("IFD")) {
            var6_11.message("IFD", "init: current segments file is \"" + string + "\"; deletionPolicy=" + var4_9);
        }
        this.policy = var4_9;
        this.directoryOrig = var2_7;
        this.directory = commitPoint;
        var5_10.getGeneration();
        commitPoint = null;
        if (string != null) {
            iterator = IndexFileNames.CODEC_FILE_PATTERN.matcher("");
            for (Object object : object5) {
                ((Matcher)((Object)iterator)).reset((CharSequence)object);
                if (((String)object).endsWith("write.lock") || !((Matcher)((Object)iterator)).matches() && !((String)object).startsWith("segments") && !((String)object).startsWith("pending_segments")) continue;
                this.getRefCount((String)object);
                if (!((String)object).startsWith("segments") || ((String)object).equals("segments.gen")) continue;
                if (var6_11.isEnabled("IFD")) {
                    var6_11.message("IFD", "init: load commit \"" + (String)object + "\"");
                }
                object = SegmentInfos.readCommit((c)var2_7, (String)object);
                CommitPoint commitPoint2 = new CommitPoint(this.commitsToDelete, (c)var2_7, (SegmentInfos)object);
                if (((SegmentInfos)object).getGeneration() == var5_10.getGeneration()) {
                    commitPoint = commitPoint2;
                }
                this.commits.add(commitPoint2);
                this.incRef((SegmentInfos)object, true);
                if (this.lastSegmentInfos != null && ((SegmentInfos)object).getGeneration() <= this.lastSegmentInfos.getGeneration()) continue;
                this.lastSegmentInfos = object;
            }
        }
        if (commitPoint == null && string != null && var8_13 != false) {
            try {
                iterator = SegmentInfos.readCommit((c)var2_7, string);
            }
            catch (IOException iOException) {
                throw new CorruptIndexException("unable to read current segments_N file", string, (Throwable)iOException);
            }
            if (var6_11.isEnabled("IFD")) {
                var6_11.message("IFD", "forced open of current segments file " + var5_10.getSegmentsFileName());
            }
            commitPoint = new CommitPoint((Collection<CommitPoint>)this.commitsToDelete, (c)var2_7, (SegmentInfos)((Object)iterator));
            this.commits.add(commitPoint);
            this.incRef((SegmentInfos)((Object)iterator), true);
        }
        if (var9_14 != false) {
            this.checkpoint((SegmentInfos)var5_10, false);
        }
        CollectionUtil.a(this.commits);
        IndexFileDeleter.inflateGens((SegmentInfos)var5_10, this.refCounts.keySet(), (InfoStream)var6_11);
        for (Map.Entry<String, RefCount> entry : this.refCounts.entrySet()) {
            RefCount refCount = entry.getValue();
            String string2 = entry.getKey();
            if (refCount.count != 0) continue;
            if (string2.startsWith("segments") && !string2.equals("segments.gen")) {
                throw new IllegalStateException("file \"" + string2 + "\" has refCount=0, which should never happen on init");
            }
            if (var6_11.isEnabled("IFD")) {
                var6_11.message("IFD", "init: removing unreferenced file \"" + string2 + "\"");
            }
            this.deleteFile(string2);
        }
        var4_9.a(this.commits);
        this.checkpoint((SegmentInfos)var5_10, false);
        this.startingCommitDeleted = commitPoint == null ? false : commitPoint.isDeleted();
        this.deleteCommits();
    }

    static void inflateGens(SegmentInfos segmentInfos, Collection<String> iterator, InfoStream infoStream) {
        Object object;
        long l2 = Long.MIN_VALUE;
        int n2 = Integer.MIN_VALUE;
        HashMap<Object, Long> hashMap = new HashMap<Object, Long>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object2 = (String)iterator.next();
            if (((String)object2).equals("segments.gen") || ((String)object2).equals("write.lock")) continue;
            if (((String)object2).startsWith("segments")) {
                try {
                    l2 = Math.max(SegmentInfos.generationFromSegmentsFileName((String)object2), l2);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (((String)object2).startsWith("pending_segments")) {
                try {
                    l2 = Math.max(SegmentInfos.generationFromSegmentsFileName(((String)object2).substring(8)), l2);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            object = IndexFileNames.parseSegmentName((String)object2);
            assert (((String)object).startsWith("_")) : "wtf? file=" + (String)object2;
            n2 = Math.max(n2, Integer.parseInt(((String)object).substring(1), 36));
            Long l3 = (Long)hashMap.get(object);
            if (l3 == null) {
                l3 = 0L;
            }
            try {
                l3 = Math.max(l3, IndexFileNames.parseGeneration((String)object2));
            }
            catch (NumberFormatException numberFormatException) {}
            hashMap.put(object, l3);
        }
        segmentInfos.setNextWriteGeneration(Math.max(segmentInfos.getGeneration(), l2));
        if (segmentInfos.counter < n2 + 1) {
            if (infoStream.isEnabled("IFD")) {
                infoStream.message("IFD", "init: inflate infos.counter to " + (n2 + 1) + " vs current=" + segmentInfos.counter);
            }
            segmentInfos.counter = n2 + 1;
        }
        for (Object object2 : segmentInfos) {
            object = (Long)hashMap.get(((SegmentCommitInfo)object2).info.name);
            assert (object != null);
            long l4 = (Long)object;
            if (((SegmentCommitInfo)object2).getNextWriteDelGen() < l4 + 1L) {
                if (infoStream.isEnabled("IFD")) {
                    infoStream.message("IFD", "init: seg=" + ((SegmentCommitInfo)object2).info.name + " set nextWriteDelGen=" + (l4 + 1L) + " vs current=" + ((SegmentCommitInfo)object2).getNextWriteDelGen());
                }
                ((SegmentCommitInfo)object2).setNextWriteDelGen(l4 + 1L);
            }
            if (((SegmentCommitInfo)object2).getNextWriteFieldInfosGen() < l4 + 1L) {
                if (infoStream.isEnabled("IFD")) {
                    infoStream.message("IFD", "init: seg=" + ((SegmentCommitInfo)object2).info.name + " set nextWriteFieldInfosGen=" + (l4 + 1L) + " vs current=" + ((SegmentCommitInfo)object2).getNextWriteFieldInfosGen());
                }
                ((SegmentCommitInfo)object2).setNextWriteFieldInfosGen(l4 + 1L);
            }
            if (((SegmentCommitInfo)object2).getNextWriteDocValuesGen() >= l4 + 1L) continue;
            if (infoStream.isEnabled("IFD")) {
                infoStream.message("IFD", "init: seg=" + ((SegmentCommitInfo)object2).info.name + " set nextWriteDocValuesGen=" + (l4 + 1L) + " vs current=" + ((SegmentCommitInfo)object2).getNextWriteDocValuesGen());
            }
            ((SegmentCommitInfo)object2).setNextWriteDocValuesGen(l4 + 1L);
        }
    }

    final void ensureOpen() throws a {
        this.writer.ensureOpen(false);
        if (this.writer.tragedy != null) {
            throw new a("refusing to delete any files: this IndexWriter hit an unrecoverable exception", this.writer.tragedy);
        }
    }

    private void deleteCommits() {
        int n2 = this.commitsToDelete.size();
        if (n2 > 0) {
            int n3;
            Throwable throwable = null;
            for (n3 = 0; n3 < n2; ++n3) {
                CommitPoint commitPoint = this.commitsToDelete.get(n3);
                if (this.infoStream.isEnabled("IFD")) {
                    this.infoStream.message("IFD", "deleteCommits: now decRef commit \"" + commitPoint.getSegmentsFileName() + "\"");
                }
                try {
                    this.decRef(commitPoint.files);
                    continue;
                }
                catch (Throwable throwable2) {
                    if (throwable != null) continue;
                    throwable = throwable2;
                }
            }
            this.commitsToDelete.clear();
            IOUtils.reThrowUnchecked(throwable);
            n2 = this.commits.size();
            int n4 = 0;
            for (n3 = 0; n3 < n2; ++n3) {
                if (this.commits.get((int)n3).deleted) continue;
                if (n4 != n3) {
                    this.commits.set(n4, this.commits.get(n3));
                }
                ++n4;
            }
            while (n2 > n4) {
                this.commits.remove(n2 - 1);
                --n2;
            }
        }
    }

    final void refresh(String string) throws IOException {
        String string2;
        String string3;
        assert (this.locked());
        String[] stringArray = this.directory.listAll();
        if (string != null) {
            string3 = string + ".";
            string2 = string + "_";
        } else {
            string3 = null;
            string2 = null;
        }
        Matcher matcher = IndexFileNames.CODEC_FILE_PATTERN.matcher("");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string4 = stringArray[i2];
            matcher.reset(string4);
            if (string != null && !string4.startsWith(string3) && !string4.startsWith(string2) || string4.endsWith("write.lock") || this.refCounts.containsKey(string4) || !matcher.matches() && !string4.startsWith("segments") && (string != null || !string4.startsWith("pending_segments"))) continue;
            if (this.infoStream.isEnabled("IFD")) {
                this.infoStream.message("IFD", "refresh [prefix=" + string + "]: removing newly created unreferenced file \"" + string4 + "\"");
            }
            this.deletable.add(string4);
        }
        this.deletePendingFiles();
    }

    final void refresh() throws IOException {
        assert (this.locked());
        this.deletable.clear();
        this.refresh(null);
    }

    @Override
    public final void close() {
        assert (this.locked());
        if (!this.lastFiles.isEmpty()) {
            try {
                this.decRef(this.lastFiles);
            }
            finally {
                this.lastFiles.clear();
            }
        }
        this.deletePendingFiles();
    }

    public final void deletePendingFiles() {
        assert (this.locked());
        ArrayList<String> arrayList = new ArrayList<String>(this.deletable);
        for (String string : arrayList) {
            RefCount refCount = this.refCounts.get(string);
            if (refCount != null && refCount.count > 0) {
                throw new IllegalStateException("file \"" + string + "\" is in pending delete set but has non-zero refCount=" + refCount.count);
            }
            if (!string.startsWith("segments") || this.deleteFile(string)) continue;
            if (this.infoStream.isEnabled("IFD")) {
                this.infoStream.message("IFD", "failed to remove commit point \"" + string + "\"; skipping deletion of all other pending files");
            }
            return;
        }
        for (String string : arrayList) {
            if (string.startsWith("segments")) continue;
            this.deleteFile(string);
        }
    }

    public final void checkpoint(SegmentInfos segmentInfos, boolean bl) throws IOException {
        assert (this.locked());
        assert (Thread.holdsLock(this.writer));
        long l2 = 0L;
        if (this.infoStream.isEnabled("IFD")) {
            l2 = System.nanoTime();
            this.infoStream.message("IFD", "now checkpoint \"" + this.writer.segString(this.writer.toLiveInfos(segmentInfos)) + "\" [" + segmentInfos.size() + " segments ; isCommit = " + bl + "]");
        }
        this.incRef(segmentInfos, bl);
        if (bl) {
            this.commits.add(new CommitPoint(this.commitsToDelete, this.directoryOrig, segmentInfos));
            this.policy.b(this.commits);
            this.deleteCommits();
        } else {
            try {
                this.decRef(this.lastFiles);
            }
            finally {
                this.lastFiles.clear();
            }
            this.lastFiles.addAll(segmentInfos.files(false));
        }
        if (this.infoStream.isEnabled("IFD")) {
            long l3 = System.nanoTime();
            this.infoStream.message("IFD", (l3 - l2) / 1000000L + " msec to checkpoint");
        }
    }

    final void incRef(SegmentInfos object, boolean bl) throws IOException {
        assert (this.locked());
        for (String string : ((SegmentInfos)object).files(bl)) {
            this.incRef(string);
        }
    }

    final void incRef(Collection<String> object) {
        assert (this.locked());
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            this.incRef(string);
        }
    }

    final void incRef(String string) {
        assert (this.locked());
        RefCount refCount = this.getRefCount(string);
        if (this.infoStream.isEnabled("IFD") && VERBOSE_REF_COUNTS) {
            this.infoStream.message("IFD", "  IncRef \"" + string + "\": pre-incr count is " + refCount.count);
        }
        refCount.IncRef();
    }

    final void decRef(Collection<String> object) {
        Throwable throwable;
        block6: {
            assert (this.locked());
            throwable = null;
            object = object.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                try {
                    this.decRef(string);
                }
                catch (Throwable throwable2) {
                    if (throwable != null) continue;
                    throwable = throwable2;
                }
            }
            try {
                this.deletePendingFiles();
            }
            catch (Throwable throwable3) {
                if (throwable != null) break block6;
                throwable = throwable3;
            }
        }
        IOUtils.reThrowUnchecked(throwable);
    }

    final void decRefWhileHandlingException(Collection<String> object) {
        assert (this.locked());
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            try {
                this.decRef(string);
            }
            catch (Throwable throwable) {}
        }
        try {
            this.deletePendingFiles();
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private void decRef(String string) {
        assert (this.locked());
        RefCount refCount = this.getRefCount(string);
        if (this.infoStream.isEnabled("IFD") && VERBOSE_REF_COUNTS) {
            this.infoStream.message("IFD", "  DecRef \"" + string + "\": pre-decr count is " + refCount.count);
        }
        if (0 == refCount.DecRef()) {
            try {
                this.deletable.add(string);
                return;
            }
            finally {
                this.refCounts.remove(string);
            }
        }
    }

    final void decRef(SegmentInfos segmentInfos) throws IOException {
        assert (this.locked());
        this.decRef(segmentInfos.files(false));
    }

    public final boolean exists(String string) {
        assert (this.locked());
        if (!this.refCounts.containsKey(string)) {
            return false;
        }
        return this.getRefCount((String)string).count > 0;
    }

    private RefCount getRefCount(String string) {
        RefCount refCount;
        assert (this.locked());
        if (!this.refCounts.containsKey(string)) {
            refCount = new RefCount(string);
            assert (this.deletable == null || !this.deletable.contains(string)) : "file \"" + string + "\" cannot be incRef'd: it's already pending delete";
            this.refCounts.put(string, refCount);
        } else {
            refCount = this.refCounts.get(string);
        }
        return refCount;
    }

    final void deleteNewFiles(Collection<String> object) throws IOException {
        assert (this.locked());
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (this.refCounts.containsKey(string) && this.refCounts.get((Object)string).count != 0) continue;
            if (this.infoStream.isEnabled("IFD")) {
                this.infoStream.message("IFD", "will delete new file \"" + string + "\"");
            }
            this.deletable.add(string);
        }
        this.deletePendingFiles();
    }

    private boolean deleteFile(String string) {
        assert (this.locked());
        this.ensureOpen();
        try {
            if (this.infoStream.isEnabled("IFD")) {
                this.infoStream.message("IFD", "delete \"" + string + "\"");
            }
            this.directory.deleteFile(string);
            this.deletable.remove(string);
            return true;
        }
        catch (IOException iOException) {
            assert (!(iOException instanceof NoSuchFileException)) : "hit unexpected NoSuchFileException: file=" + string;
            assert (!(iOException instanceof FileNotFoundException)) : "hit unexpected FileNotFoundException: file=" + string;
            if (this.infoStream.isEnabled("IFD")) {
                this.infoStream.message("IFD", "unable to remove file \"" + string + "\": " + iOException.toString() + "; Will re-try later.");
            }
            this.deletable.add(string);
            return false;
        }
    }

    private static final class CommitPoint
    extends g {
        Collection<String> files;
        String segmentsFileName;
        boolean deleted;
        c directoryOrig;
        Collection<CommitPoint> commitsToDelete;
        long generation;
        final Map<String, String> userData;
        private final int segmentCount;

        public CommitPoint(Collection<CommitPoint> collection, c c2, SegmentInfos segmentInfos) throws IOException {
            this.directoryOrig = c2;
            this.commitsToDelete = collection;
            this.userData = segmentInfos.getUserData();
            this.segmentsFileName = segmentInfos.getSegmentsFileName();
            this.generation = segmentInfos.getGeneration();
            this.files = Collections.unmodifiableCollection(segmentInfos.files(true));
            this.segmentCount = segmentInfos.size();
        }

        public final String toString() {
            return "IndexFileDeleter.CommitPoint(" + this.segmentsFileName + ")";
        }

        @Override
        public final String getSegmentsFileName() {
            return this.segmentsFileName;
        }

        @Override
        public final c getDirectory() {
            return this.directoryOrig;
        }

        @Override
        public final long getGeneration() {
            return this.generation;
        }

        @Override
        public final void delete() {
            if (!this.deleted) {
                this.deleted = true;
                this.commitsToDelete.add(this);
            }
        }

        public final boolean isDeleted() {
            return this.deleted;
        }
    }

    private static final class RefCount {
        final String fileName;
        boolean initDone;
        int count;

        RefCount(String string) {
            this.fileName = string;
        }

        public final int IncRef() {
            if (!this.initDone) {
                this.initDone = true;
            } else assert (this.count > 0) : Thread.currentThread().getName() + ": RefCount is 0 pre-increment for file \"" + this.fileName + "\"";
            return ++this.count;
        }

        public final int DecRef() {
            assert (this.count > 0) : Thread.currentThread().getName() + ": RefCount is 0 pre-decrement for file \"" + this.fileName + "\"";
            return --this.count;
        }
    }
}

