/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.codecs.d;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FreqProxFields;
import org.apache.lucene.index.FreqProxTermsWriterPerField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.TermsHash;
import org.apache.lucene.index.TermsHashPerField;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.IOUtils;

final class FreqProxTermsWriter
extends TermsHash {
    public FreqProxTermsWriter(DocumentsWriterPerThread documentsWriterPerThread, TermsHash termsHash) {
        super(documentsWriterPerThread, true, termsHash);
    }

    private void applyDeletes(SegmentWriteState segmentWriteState, Fields fields) throws IOException {
        if (segmentWriteState.segUpdates != null && segmentWriteState.segUpdates.terms.size() > 0) {
            Map<Term, Integer> map = segmentWriteState.segUpdates.terms;
            Object object = new ArrayList<Term>(map.keySet());
            Collections.sort(object);
            String string = null;
            TermsEnum termsEnum = null;
            PostingsEnum postingsEnum = null;
            object = object.iterator();
            while (object.hasNext()) {
                int n2;
                Term term = (Term)object.next();
                if (!term.field().equals(string)) {
                    string = term.field();
                    Terms terms = fields.terms(string);
                    termsEnum = terms != null ? terms.iterator() : null;
                }
                if (termsEnum == null || !termsEnum.seekExact(term.bytes())) continue;
                postingsEnum = termsEnum.postings(postingsEnum, 0);
                int n3 = map.get(term);
                assert (n3 < Integer.MAX_VALUE);
                while ((n2 = postingsEnum.nextDoc()) < n3) {
                    if (segmentWriteState.liveDocs == null) {
                        segmentWriteState.liveDocs = segmentWriteState.segmentInfo.getCodec().liveDocsFormat().newLiveDocs(segmentWriteState.segmentInfo.maxDoc());
                    }
                    if (!segmentWriteState.liveDocs.get(n2)) continue;
                    ++segmentWriteState.delCountOnFlush;
                    segmentWriteState.liveDocs.clear(n2);
                }
            }
        }
    }

    @Override
    public final void flush(Map<String, TermsHashPerField> iterable, SegmentWriteState segmentWriteState) throws IOException {
        Object object;
        super.flush((Map<String, TermsHashPerField>)((Object)iterable), segmentWriteState);
        ArrayList<FreqProxTermsWriterPerField> arrayList = new ArrayList<FreqProxTermsWriterPerField>();
        iterable = iterable.values().iterator();
        while (iterable.hasNext()) {
            object = (FreqProxTermsWriterPerField)((TermsHashPerField)iterable.next());
            if (((FreqProxTermsWriterPerField)object).bytesHash.size() <= 0) continue;
            ((TermsHashPerField)object).sortPostings();
            assert (((FreqProxTermsWriterPerField)object).fieldInfo.getIndexOptions() != IndexOptions.NONE);
            arrayList.add((FreqProxTermsWriterPerField)object);
        }
        iterable = arrayList;
        if (iterable.size() > 1) {
            CollectionUtil.a(iterable, ArrayUtil.naturalComparator());
        }
        iterable = new FreqProxFields(arrayList);
        this.applyDeletes(segmentWriteState, (Fields)iterable);
        object = segmentWriteState.segmentInfo.getCodec().postingsFormat().fieldsConsumer(segmentWriteState);
        try {
            ((d)object).write((Fields)iterable);
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(new Closeable[]{object});
            throw throwable;
        }
        IOUtils.close(new Closeable[]{object});
    }

    @Override
    public final TermsHashPerField addField(FieldInvertState fieldInvertState, FieldInfo fieldInfo) {
        return new FreqProxTermsWriterPerField(fieldInvertState, this, fieldInfo, this.nextTermsHash.addField(fieldInvertState, fieldInfo));
    }
}

