/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.ByteSliceReader;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FreqProxTermsWriterPerField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.q;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;

class FreqProxFields
extends Fields {
    final Map<String, FreqProxTermsWriterPerField> fields = new LinkedHashMap<String, FreqProxTermsWriterPerField>();

    public FreqProxFields(List<FreqProxTermsWriterPerField> object) {
        object = object.iterator();
        while (object.hasNext()) {
            FreqProxTermsWriterPerField freqProxTermsWriterPerField = (FreqProxTermsWriterPerField)object.next();
            this.fields.put(freqProxTermsWriterPerField.fieldInfo.name, freqProxTermsWriterPerField);
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this.fields.keySet().iterator();
    }

    @Override
    public Terms terms(String object) throws IOException {
        if ((object = this.fields.get(object)) == null) {
            return null;
        }
        return new FreqProxTerms((FreqProxTermsWriterPerField)object);
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    private static class FreqProxPostingsEnum
    extends PostingsEnum {
        final FreqProxTermsWriterPerField terms;
        final FreqProxTermsWriterPerField.FreqProxPostingsArray postingsArray;
        final ByteSliceReader reader = new ByteSliceReader();
        final ByteSliceReader posReader = new ByteSliceReader();
        final boolean readOffsets;
        int docID = -1;
        int freq;
        int pos;
        int startOffset;
        int endOffset;
        int posLeft;
        int termID;
        boolean ended;
        boolean hasPayload;
        BytesRefBuilder payload = new BytesRefBuilder();

        public FreqProxPostingsEnum(FreqProxTermsWriterPerField freqProxTermsWriterPerField, FreqProxTermsWriterPerField.FreqProxPostingsArray freqProxPostingsArray) {
            this.terms = freqProxTermsWriterPerField;
            this.postingsArray = freqProxPostingsArray;
            this.readOffsets = freqProxTermsWriterPerField.hasOffsets;
            assert (freqProxTermsWriterPerField.hasProx);
            assert (freqProxTermsWriterPerField.hasFreq);
        }

        public void reset(int n2) {
            this.termID = n2;
            this.terms.initReader(this.reader, n2, 0);
            this.terms.initReader(this.posReader, n2, 1);
            this.ended = false;
            this.docID = -1;
            this.posLeft = 0;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int freq() {
            return this.freq;
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.docID == -1) {
                this.docID = 0;
            }
            while (this.posLeft != 0) {
                this.nextPosition();
            }
            if (this.reader.eof()) {
                if (this.ended) {
                    return Integer.MAX_VALUE;
                }
                this.ended = true;
                this.docID = this.postingsArray.lastDocIDs[this.termID];
                this.freq = this.postingsArray.termFreqs[this.termID];
            } else {
                int n2 = this.reader.readVInt();
                this.docID += n2 >>> 1;
                this.freq = (n2 & 1) != 0 ? 1 : this.reader.readVInt();
                assert (this.docID != this.postingsArray.lastDocIDs[this.termID]);
            }
            this.posLeft = this.freq;
            this.pos = 0;
            this.startOffset = 0;
            return this.docID;
        }

        @Override
        public int advance(int n2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long cost() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int nextPosition() throws IOException {
            assert (this.posLeft > 0);
            --this.posLeft;
            int n2 = this.posReader.readVInt();
            this.pos += n2 >>> 1;
            if ((n2 & 1) != 0) {
                this.hasPayload = true;
                this.payload.setLength(this.posReader.readVInt());
                this.payload.grow(this.payload.length());
                this.posReader.readBytes(this.payload.bytes(), 0, this.payload.length());
            } else {
                this.hasPayload = false;
            }
            if (this.readOffsets) {
                this.startOffset += this.posReader.readVInt();
                this.endOffset = this.startOffset + this.posReader.readVInt();
            }
            return this.pos;
        }

        @Override
        public int startOffset() {
            if (!this.readOffsets) {
                throw new IllegalStateException("offsets were not indexed");
            }
            return this.startOffset;
        }

        @Override
        public int endOffset() {
            if (!this.readOffsets) {
                throw new IllegalStateException("offsets were not indexed");
            }
            return this.endOffset;
        }

        @Override
        public BytesRef getPayload() {
            if (this.hasPayload) {
                return this.payload.get();
            }
            return null;
        }
    }

    private static class FreqProxDocsEnum
    extends PostingsEnum {
        final FreqProxTermsWriterPerField terms;
        final FreqProxTermsWriterPerField.FreqProxPostingsArray postingsArray;
        final ByteSliceReader reader = new ByteSliceReader();
        final boolean readTermFreq;
        int docID = -1;
        int freq;
        boolean ended;
        int termID;

        public FreqProxDocsEnum(FreqProxTermsWriterPerField freqProxTermsWriterPerField, FreqProxTermsWriterPerField.FreqProxPostingsArray freqProxPostingsArray) {
            this.terms = freqProxTermsWriterPerField;
            this.postingsArray = freqProxPostingsArray;
            this.readTermFreq = freqProxTermsWriterPerField.hasFreq;
        }

        public void reset(int n2) {
            this.termID = n2;
            this.terms.initReader(this.reader, n2, 0);
            this.ended = false;
            this.docID = -1;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int freq() {
            if (!this.readTermFreq) {
                throw new IllegalStateException("freq was not indexed");
            }
            return this.freq;
        }

        @Override
        public int nextPosition() throws IOException {
            return -1;
        }

        @Override
        public int startOffset() throws IOException {
            return -1;
        }

        @Override
        public int endOffset() throws IOException {
            return -1;
        }

        @Override
        public BytesRef getPayload() throws IOException {
            return null;
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.docID == -1) {
                this.docID = 0;
            }
            if (this.reader.eof()) {
                if (this.ended) {
                    return Integer.MAX_VALUE;
                }
                this.ended = true;
                this.docID = this.postingsArray.lastDocIDs[this.termID];
                if (this.readTermFreq) {
                    this.freq = this.postingsArray.termFreqs[this.termID];
                }
            } else {
                int n2 = this.reader.readVInt();
                if (!this.readTermFreq) {
                    this.docID += n2;
                } else {
                    this.docID += n2 >>> 1;
                    this.freq = (n2 & 1) != 0 ? 1 : this.reader.readVInt();
                }
                assert (this.docID != this.postingsArray.lastDocIDs[this.termID]);
            }
            return this.docID;
        }

        @Override
        public int advance(int n2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long cost() {
            throw new UnsupportedOperationException();
        }
    }

    private static class FreqProxTermsEnum
    extends TermsEnum {
        final FreqProxTermsWriterPerField terms;
        final int[] sortedTermIDs;
        final FreqProxTermsWriterPerField.FreqProxPostingsArray postingsArray;
        final BytesRef scratch = new BytesRef();
        final int numTerms;
        int ord;

        public FreqProxTermsEnum(FreqProxTermsWriterPerField freqProxTermsWriterPerField) {
            this.terms = freqProxTermsWriterPerField;
            this.numTerms = freqProxTermsWriterPerField.bytesHash.size();
            this.sortedTermIDs = freqProxTermsWriterPerField.sortedTermIDs;
            assert (this.sortedTermIDs != null);
            this.postingsArray = (FreqProxTermsWriterPerField.FreqProxPostingsArray)freqProxTermsWriterPerField.postingsArray;
        }

        public void reset() {
            this.ord = -1;
        }

        @Override
        public TermsEnum.SeekStatus seekCeil(BytesRef bytesRef) {
            int n2;
            int n3 = 0;
            int n4 = this.numTerms - 1;
            while (n4 >= n3) {
                n2 = n3 + n4 >>> 1;
                int n5 = this.postingsArray.textStarts[this.sortedTermIDs[n2]];
                this.terms.bytePool.setBytesRef(this.scratch, n5);
                n5 = this.scratch.compareTo(bytesRef);
                if (n5 < 0) {
                    n3 = n2 + 1;
                    continue;
                }
                if (n5 > 0) {
                    n4 = n2 - 1;
                    continue;
                }
                this.ord = n2;
                assert (this.term().compareTo(bytesRef) == 0);
                return TermsEnum.SeekStatus.FOUND;
            }
            this.ord = n3;
            if (this.ord >= this.numTerms) {
                return TermsEnum.SeekStatus.END;
            }
            n2 = this.postingsArray.textStarts[this.sortedTermIDs[this.ord]];
            this.terms.bytePool.setBytesRef(this.scratch, n2);
            assert (this.term().compareTo(bytesRef) > 0);
            return TermsEnum.SeekStatus.NOT_FOUND;
        }

        @Override
        public void seekExact(long l2) {
            this.ord = (int)l2;
            int n2 = this.postingsArray.textStarts[this.sortedTermIDs[this.ord]];
            this.terms.bytePool.setBytesRef(this.scratch, n2);
        }

        @Override
        public BytesRef next() {
            ++this.ord;
            if (this.ord >= this.numTerms) {
                return null;
            }
            int n2 = this.postingsArray.textStarts[this.sortedTermIDs[this.ord]];
            this.terms.bytePool.setBytesRef(this.scratch, n2);
            return this.scratch;
        }

        @Override
        public BytesRef term() {
            return this.scratch;
        }

        @Override
        public long ord() {
            return this.ord;
        }

        @Override
        public int docFreq() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long totalTermFreq() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PostingsEnum postings(PostingsEnum postingsEnum, int n2) {
            if (PostingsEnum.featureRequested(n2, (short)24)) {
                if (!this.terms.hasProx) {
                    throw new IllegalArgumentException("did not index positions");
                }
                if (!this.terms.hasOffsets && PostingsEnum.featureRequested(n2, (short)56)) {
                    throw new IllegalArgumentException("did not index offsets");
                }
                if (postingsEnum instanceof FreqProxPostingsEnum) {
                    postingsEnum = (FreqProxPostingsEnum)postingsEnum;
                    if (((FreqProxPostingsEnum)postingsEnum).postingsArray != this.postingsArray) {
                        postingsEnum = new FreqProxPostingsEnum(this.terms, this.postingsArray);
                    }
                } else {
                    postingsEnum = new FreqProxPostingsEnum(this.terms, this.postingsArray);
                }
                ((FreqProxPostingsEnum)postingsEnum).reset(this.sortedTermIDs[this.ord]);
                return postingsEnum;
            }
            if (!this.terms.hasFreq && PostingsEnum.featureRequested(n2, (short)8)) {
                throw new IllegalArgumentException("did not index freq");
            }
            if (postingsEnum instanceof FreqProxDocsEnum) {
                postingsEnum = (FreqProxDocsEnum)postingsEnum;
                if (((FreqProxDocsEnum)postingsEnum).postingsArray != this.postingsArray) {
                    postingsEnum = new FreqProxDocsEnum(this.terms, this.postingsArray);
                }
            } else {
                postingsEnum = new FreqProxDocsEnum(this.terms, this.postingsArray);
            }
            ((FreqProxDocsEnum)postingsEnum).reset(this.sortedTermIDs[this.ord]);
            return postingsEnum;
        }

        @Override
        public q termState() throws IOException {
            return new q(){

                @Override
                public void copyFrom(q q2) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static class FreqProxTerms
    extends Terms {
        final FreqProxTermsWriterPerField terms;

        public FreqProxTerms(FreqProxTermsWriterPerField freqProxTermsWriterPerField) {
            this.terms = freqProxTermsWriterPerField;
        }

        @Override
        public TermsEnum iterator() {
            FreqProxTermsEnum freqProxTermsEnum = new FreqProxTermsEnum(this.terms);
            freqProxTermsEnum.reset();
            return freqProxTermsEnum;
        }

        @Override
        public long size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getSumTotalTermFreq() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getSumDocFreq() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getDocCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasFreqs() {
            return this.terms.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
        }

        @Override
        public boolean hasOffsets() {
            return this.terms.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        }

        @Override
        public boolean hasPositions() {
            return this.terms.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        }

        @Override
        public boolean hasPayloads() {
            return this.terms.sawPayloads;
        }
    }
}

