/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.DocumentsWriterFlushControl;
import org.apache.lucene.index.DocumentsWriterPerThreadPool;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.util.InfoStream;

abstract class FlushPolicy {
    protected LiveIndexWriterConfig indexWriterConfig;
    protected InfoStream infoStream;

    FlushPolicy() {
    }

    public abstract void onDelete(DocumentsWriterFlushControl var1, DocumentsWriterPerThreadPool.ThreadState var2);

    public void onUpdate(DocumentsWriterFlushControl documentsWriterFlushControl, DocumentsWriterPerThreadPool.ThreadState threadState) {
        this.onInsert(documentsWriterFlushControl, threadState);
        this.onDelete(documentsWriterFlushControl, threadState);
    }

    public abstract void onInsert(DocumentsWriterFlushControl var1, DocumentsWriterPerThreadPool.ThreadState var2);

    protected synchronized void init(LiveIndexWriterConfig liveIndexWriterConfig) {
        this.indexWriterConfig = liveIndexWriterConfig;
        this.infoStream = liveIndexWriterConfig.getInfoStream();
    }

    protected DocumentsWriterPerThreadPool.ThreadState findLargestNonPendingWriter(DocumentsWriterFlushControl object, DocumentsWriterPerThreadPool.ThreadState threadState) {
        assert (threadState.dwpt.getNumDocsInRAM() > 0);
        long l2 = threadState.bytesUsed;
        DocumentsWriterPerThreadPool.ThreadState threadState2 = threadState;
        assert (!threadState.flushPending) : "DWPT should have flushed";
        object = ((DocumentsWriterFlushControl)object).allActiveThreadStates();
        int n2 = 0;
        while (object.hasNext()) {
            long l3;
            DocumentsWriterPerThreadPool.ThreadState threadState3 = (DocumentsWriterPerThreadPool.ThreadState)object.next();
            if (threadState3.flushPending || (l3 = threadState3.bytesUsed) <= 0L || threadState3.dwpt.getNumDocsInRAM() <= 0) continue;
            if (this.infoStream.isEnabled("FP")) {
                this.infoStream.message("FP", "thread state has " + l3 + " bytes; docInRAM=" + threadState3.dwpt.getNumDocsInRAM());
            }
            ++n2;
            if (l3 <= l2) continue;
            l2 = l3;
            threadState2 = threadState3;
        }
        if (this.infoStream.isEnabled("FP")) {
            this.infoStream.message("FP", n2 + " in-use non-flushing threads states");
        }
        assert (this.assertMessage("set largest ram consuming thread pending on lower watermark"));
        return threadState2;
    }

    private boolean assertMessage(String string) {
        if (this.infoStream.isEnabled("FP")) {
            this.infoStream.message("FP", string);
        }
        return true;
    }
}

