/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.q;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;

public abstract class FilteredTermsEnum
extends TermsEnum {
    private BytesRef initialSeekTerm;
    private boolean doSeek;
    protected BytesRef actualTerm;
    protected final TermsEnum tenum;

    protected abstract AcceptStatus accept(BytesRef var1) throws IOException;

    public FilteredTermsEnum(TermsEnum termsEnum) {
        this(termsEnum, true);
    }

    public FilteredTermsEnum(TermsEnum termsEnum, boolean bl) {
        assert (termsEnum != null);
        this.tenum = termsEnum;
        this.doSeek = bl;
    }

    protected final void setInitialSeekTerm(BytesRef bytesRef) {
        this.initialSeekTerm = bytesRef;
    }

    protected BytesRef nextSeekTerm(BytesRef bytesRef) throws IOException {
        bytesRef = this.initialSeekTerm;
        this.initialSeekTerm = null;
        return bytesRef;
    }

    @Override
    public AttributeSource attributes() {
        return this.tenum.attributes();
    }

    @Override
    public BytesRef term() throws IOException {
        return this.tenum.term();
    }

    @Override
    public int docFreq() throws IOException {
        return this.tenum.docFreq();
    }

    @Override
    public long totalTermFreq() throws IOException {
        return this.tenum.totalTermFreq();
    }

    @Override
    public boolean seekExact(BytesRef bytesRef) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support seeking");
    }

    @Override
    public TermsEnum.SeekStatus seekCeil(BytesRef bytesRef) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support seeking");
    }

    @Override
    public void seekExact(long l2) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support seeking");
    }

    @Override
    public long ord() throws IOException {
        return this.tenum.ord();
    }

    @Override
    public PostingsEnum postings(PostingsEnum postingsEnum, int n2) throws IOException {
        return this.tenum.postings(postingsEnum, n2);
    }

    @Override
    public void seekExact(BytesRef bytesRef, q q2) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support seeking");
    }

    @Override
    public q termState() throws IOException {
        assert (this.tenum != null);
        return this.tenum.termState();
    }

    @Override
    public BytesRef next() throws IOException {
        block6: while (true) {
            if (this.doSeek) {
                this.doSeek = false;
                BytesRef bytesRef = this.nextSeekTerm(this.actualTerm);
                assert (this.actualTerm == null || bytesRef == null || bytesRef.compareTo(this.actualTerm) > 0) : "curTerm=" + this.actualTerm + " seekTerm=" + bytesRef;
                if (bytesRef == null || this.tenum.seekCeil(bytesRef) == TermsEnum.SeekStatus.END) {
                    return null;
                }
                this.actualTerm = this.tenum.term();
            } else {
                this.actualTerm = this.tenum.next();
                if (this.actualTerm == null) {
                    return null;
                }
            }
            switch (this.accept(this.actualTerm)) {
                case YES_AND_SEEK: {
                    this.doSeek = true;
                }
                case YES: {
                    return this.actualTerm;
                }
                case NO_AND_SEEK: {
                    this.doSeek = true;
                    continue block6;
                }
                case END: {
                    return null;
                }
            }
        }
    }

    protected static enum AcceptStatus {
        YES,
        YES_AND_SEEK,
        NO,
        NO_AND_SEEK,
        END;

    }
}

