/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.util.ArrayUtil;

public class FieldInfos
implements Iterable<FieldInfo> {
    private final boolean hasFreq;
    private final boolean hasProx;
    private final boolean hasPayloads;
    private final boolean hasOffsets;
    private final boolean hasVectors;
    private final boolean hasNorms;
    private final boolean hasDocValues;
    private final FieldInfo[] byNumberTable;
    private final SortedMap<Integer, FieldInfo> byNumberMap;
    private final HashMap<String, FieldInfo> byName = new HashMap();
    private final Collection<FieldInfo> values;

    public FieldInfos(FieldInfo[] fieldInfoArray) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        TreeMap<Integer, FieldInfo> treeMap = new TreeMap<Integer, FieldInfo>();
        for (FieldInfo fieldInfo : fieldInfoArray) {
            if (fieldInfo.number < 0) {
                throw new IllegalArgumentException("illegal field number: " + fieldInfo.number + " for field " + fieldInfo.name);
            }
            FieldInfo fieldInfo2 = treeMap.put(fieldInfo.number, fieldInfo);
            if (fieldInfo2 != null) {
                throw new IllegalArgumentException("duplicate field numbers: " + fieldInfo2.name + " and " + fieldInfo.name + " have: " + fieldInfo.number);
            }
            fieldInfo2 = this.byName.put(fieldInfo.name, fieldInfo);
            if (fieldInfo2 != null) {
                throw new IllegalArgumentException("duplicate field names: " + fieldInfo2.number + " and " + fieldInfo.number + " have: " + fieldInfo.name);
            }
            bl |= fieldInfo.hasVectors();
            bl2 |= fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
            bl5 |= fieldInfo.getIndexOptions() != IndexOptions.DOCS;
            bl4 |= fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            bl6 |= fieldInfo.hasNorms();
            bl7 |= fieldInfo.getDocValuesType() != DocValuesType.NONE;
            bl3 |= fieldInfo.hasPayloads();
        }
        this.hasVectors = bl;
        this.hasProx = bl2;
        this.hasPayloads = bl3;
        this.hasOffsets = bl4;
        this.hasFreq = bl5;
        this.hasNorms = bl6;
        this.hasDocValues = bl7;
        this.values = Collections.unmodifiableCollection(treeMap.values());
        fieldInfoArray = treeMap.isEmpty() ? null : (FieldInfo[])Collections.max(treeMap.keySet());
        if (fieldInfoArray != null && fieldInfoArray.intValue() < ArrayUtil.MAX_ARRAY_LENGTH && (long)fieldInfoArray.intValue() < 16L * (long)treeMap.size()) {
            this.byNumberMap = null;
            this.byNumberTable = new FieldInfo[fieldInfoArray.intValue() + 1];
            for (Map.Entry<Integer, FieldInfo> entry : treeMap.entrySet()) {
                this.byNumberTable[entry.getKey().intValue()] = entry.getValue();
            }
            return;
        }
        this.byNumberMap = treeMap;
        this.byNumberTable = null;
    }

    public boolean hasFreq() {
        return this.hasFreq;
    }

    public boolean hasProx() {
        return this.hasProx;
    }

    public boolean hasPayloads() {
        return this.hasPayloads;
    }

    public boolean hasOffsets() {
        return this.hasOffsets;
    }

    public boolean hasVectors() {
        return this.hasVectors;
    }

    public boolean hasNorms() {
        return this.hasNorms;
    }

    public boolean hasDocValues() {
        return this.hasDocValues;
    }

    public int size() {
        return this.byName.size();
    }

    @Override
    public Iterator<FieldInfo> iterator() {
        return this.values.iterator();
    }

    public FieldInfo fieldInfo(String string) {
        return this.byName.get(string);
    }

    public FieldInfo fieldInfo(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal field number: " + n2);
        }
        if (this.byNumberTable != null) {
            if (n2 >= this.byNumberTable.length) {
                return null;
            }
            return this.byNumberTable[n2];
        }
        return (FieldInfo)this.byNumberMap.get(n2);
    }

    static final class Builder {
        private final HashMap<String, FieldInfo> byName = new HashMap();
        final FieldNumbers globalFieldNumbers;

        Builder() {
            this(new FieldNumbers());
        }

        Builder(FieldNumbers fieldNumbers) {
            assert (fieldNumbers != null);
            this.globalFieldNumbers = fieldNumbers;
        }

        public final FieldInfo getOrAdd(String string) {
            FieldInfo fieldInfo = this.fieldInfo(string);
            if (fieldInfo == null) {
                int n2 = this.globalFieldNumbers.addOrGet(string, -1, DocValuesType.NONE);
                fieldInfo = new FieldInfo(string, n2, false, false, false, IndexOptions.NONE, DocValuesType.NONE, -1L, new HashMap<String, String>());
                assert (!this.byName.containsKey(fieldInfo.name));
                this.globalFieldNumbers.verifyConsistent(fieldInfo.number, fieldInfo.name, DocValuesType.NONE);
                this.byName.put(fieldInfo.name, fieldInfo);
            }
            return fieldInfo;
        }

        private FieldInfo addOrUpdateInternal(String string, int n2, boolean bl, boolean bl2, boolean bl3, IndexOptions indexOptions, DocValuesType docValuesType) {
            if (docValuesType == null) {
                throw new NullPointerException("DocValuesType cannot be null");
            }
            FieldInfo fieldInfo = this.fieldInfo(string);
            if (fieldInfo == null) {
                n2 = this.globalFieldNumbers.addOrGet(string, n2, docValuesType);
                fieldInfo = new FieldInfo(string, n2, bl, bl2, bl3, indexOptions, docValuesType, -1L, new HashMap<String, String>());
                assert (!this.byName.containsKey(fieldInfo.name));
                this.globalFieldNumbers.verifyConsistent(fieldInfo.number, fieldInfo.name, fieldInfo.getDocValuesType());
                this.byName.put(fieldInfo.name, fieldInfo);
            } else {
                fieldInfo.update(bl, bl2, bl3, indexOptions);
                if (docValuesType != DocValuesType.NONE) {
                    if (fieldInfo.getDocValuesType() == DocValuesType.NONE) {
                        this.globalFieldNumbers.setDocValuesType(fieldInfo.number, string, docValuesType);
                    }
                    fieldInfo.setDocValuesType(docValuesType);
                }
            }
            return fieldInfo;
        }

        public final FieldInfo add(FieldInfo fieldInfo) {
            return this.addOrUpdateInternal(fieldInfo.name, fieldInfo.number, fieldInfo.hasVectors(), fieldInfo.omitsNorms(), fieldInfo.hasPayloads(), fieldInfo.getIndexOptions(), fieldInfo.getDocValuesType());
        }

        public final FieldInfo fieldInfo(String string) {
            return this.byName.get(string);
        }

        final FieldInfos finish() {
            return new FieldInfos(this.byName.values().toArray(new FieldInfo[this.byName.size()]));
        }
    }

    static final class FieldNumbers {
        private final Map<Integer, String> numberToName;
        private final Map<String, Integer> nameToNumber = new HashMap<String, Integer>();
        private final Map<String, DocValuesType> docValuesType;
        private int lowestUnassignedFieldNumber = -1;

        FieldNumbers() {
            this.numberToName = new HashMap<Integer, String>();
            this.docValuesType = new HashMap<String, DocValuesType>();
        }

        final synchronized int addOrGet(String string, int n2, DocValuesType object) {
            Object object2;
            if (object != DocValuesType.NONE) {
                object2 = this.docValuesType.get(string);
                if (object2 == null) {
                    this.docValuesType.put(string, (DocValuesType)((Object)object));
                } else if (object2 != DocValuesType.NONE && object2 != object) {
                    throw new IllegalArgumentException("cannot change DocValues type from " + (Object)object2 + " to " + (Object)object + " for field \"" + string + "\"");
                }
            }
            if ((object2 = this.nameToNumber.get(string)) == null) {
                object = n2;
                if (n2 != -1 && !this.numberToName.containsKey(object)) {
                    object2 = object;
                } else {
                    while (this.numberToName.containsKey(++this.lowestUnassignedFieldNumber)) {
                    }
                    object2 = this.lowestUnassignedFieldNumber;
                }
                assert ((Integer)object2 >= 0);
                this.numberToName.put((Integer)object2, string);
                this.nameToNumber.put(string, (Integer)object2);
            }
            return (Integer)object2;
        }

        final synchronized void verifyConsistent(Integer object, String string, DocValuesType docValuesType) {
            if (!string.equals(this.numberToName.get(object))) {
                throw new IllegalArgumentException("field number " + object + " is already mapped to field name \"" + this.numberToName.get(object) + "\", not \"" + string + "\"");
            }
            if (!object.equals(this.nameToNumber.get(string))) {
                throw new IllegalArgumentException("field name \"" + string + "\" is already mapped to field number \"" + this.nameToNumber.get(string) + "\", not \"" + object + "\"");
            }
            object = this.docValuesType.get(string);
            if (docValuesType != DocValuesType.NONE && object != null && object != DocValuesType.NONE && docValuesType != object) {
                throw new IllegalArgumentException("cannot change DocValues type from " + object + " to " + (Object)((Object)docValuesType) + " for field \"" + string + "\"");
            }
        }

        final synchronized void clear() {
            this.numberToName.clear();
            this.nameToNumber.clear();
            this.docValuesType.clear();
        }

        final synchronized void setDocValuesType(int n2, String string, DocValuesType docValuesType) {
            this.verifyConsistent(n2, string, docValuesType);
            this.docValuesType.put(string, docValuesType);
        }
    }
}

