/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.Map;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.portmobile.util.Objects;

public final class FieldInfo {
    public final String name;
    public final int number;
    private DocValuesType docValuesType = DocValuesType.NONE;
    private boolean storeTermVector;
    private boolean omitNorms;
    private IndexOptions indexOptions = IndexOptions.NONE;
    private boolean storePayloads;
    private final Map<String, String> attributes;
    private long dvGen;

    public FieldInfo(String string, int n2, boolean bl, boolean bl2, boolean bl3, IndexOptions indexOptions, DocValuesType docValuesType, long l2, Map<String, String> map) {
        this.name = Objects.requireNonNull(string);
        this.number = n2;
        this.docValuesType = Objects.requireNonNull(docValuesType, "DocValuesType cannot be null (field: \"" + string + "\")");
        this.indexOptions = Objects.requireNonNull(indexOptions, "IndexOptions cannot be null (field: \"" + string + "\")");
        if (indexOptions != IndexOptions.NONE) {
            this.storeTermVector = bl;
            this.storePayloads = bl3;
            this.omitNorms = bl2;
        } else {
            this.storeTermVector = false;
            this.storePayloads = false;
            this.omitNorms = false;
        }
        this.dvGen = l2;
        this.attributes = Objects.requireNonNull(map);
        assert (this.checkConsistency());
    }

    public final boolean checkConsistency() {
        if (this.indexOptions != IndexOptions.NONE) {
            if (this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0 && this.storePayloads) {
                throw new IllegalStateException("indexed field '" + this.name + "' cannot have payloads without positions");
            }
        } else {
            if (this.storeTermVector) {
                throw new IllegalStateException("non-indexed field '" + this.name + "' cannot store term vectors");
            }
            if (this.storePayloads) {
                throw new IllegalStateException("non-indexed field '" + this.name + "' cannot store payloads");
            }
            if (this.omitNorms) {
                throw new IllegalStateException("non-indexed field '" + this.name + "' cannot omit norms");
            }
        }
        if (this.dvGen != -1L && this.docValuesType == DocValuesType.NONE) {
            throw new IllegalStateException("field '" + this.name + "' cannot have a docvalues update generation without having docvalues");
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    final void update(boolean var1_1, boolean var2_2, boolean var3_3, IndexOptions var4_4) {
        block8: {
            block9: {
                if (var4_4 == null) {
                    throw new NullPointerException("IndexOptions cannot be null (field: \"" + this.name + "\")");
                }
                if (this.indexOptions == var4_4) break block8;
                if (this.indexOptions != IndexOptions.NONE) break block9;
                v0 = this;
                ** GOTO lbl-1000
            }
            if (var4_4 != IndexOptions.NONE) {
                v0 = this;
                ** if (this.indexOptions.compareTo(var4_4) >= 0) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    v1 = this.indexOptions;
                    ** GOTO lbl15
                }
            }
            break block8;
lbl-1000:
            // 2 sources

            {
                v1 = v0.indexOptions = var4_4;
            }
        }
        if (this.indexOptions != IndexOptions.NONE) {
            this.storeTermVector |= var1_1;
            this.storePayloads |= var3_3;
            if (var4_4 != IndexOptions.NONE && this.omitNorms != var2_2) {
                this.omitNorms = true;
            }
        }
        if (this.indexOptions == IndexOptions.NONE || this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
            this.storePayloads = false;
        }
        if (!FieldInfo.$assertionsDisabled && !this.checkConsistency()) {
            throw new AssertionError();
        }
    }

    final void setDocValuesType(DocValuesType docValuesType) {
        if (docValuesType == null) {
            throw new NullPointerException("DocValuesType cannot be null (field: \"" + this.name + "\")");
        }
        if (this.docValuesType != DocValuesType.NONE && docValuesType != DocValuesType.NONE && this.docValuesType != docValuesType) {
            throw new IllegalArgumentException("cannot change DocValues type from " + (Object)((Object)this.docValuesType) + " to " + (Object)((Object)docValuesType) + " for field \"" + this.name + "\"");
        }
        this.docValuesType = docValuesType;
        assert (this.checkConsistency());
    }

    public final IndexOptions getIndexOptions() {
        return this.indexOptions;
    }

    /*
     * Unable to fully structure code
     */
    public final void setIndexOptions(IndexOptions var1_1) {
        block4: {
            block5: {
                if (this.indexOptions == var1_1) break block4;
                if (this.indexOptions != IndexOptions.NONE) break block5;
                v0 = this;
                ** GOTO lbl-1000
            }
            if (var1_1 != IndexOptions.NONE) {
                v0 = this;
                ** if (this.indexOptions.compareTo(var1_1) >= 0) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    v1 = this.indexOptions;
                    ** GOTO lbl13
                }
            }
            break block4;
lbl-1000:
            // 2 sources

            {
                v1 = v0.indexOptions = var1_1;
            }
        }
        if (this.indexOptions == IndexOptions.NONE || this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
            this.storePayloads = false;
        }
    }

    public final DocValuesType getDocValuesType() {
        return this.docValuesType;
    }

    final void setDocValuesGen(long l2) {
        this.dvGen = l2;
        assert (this.checkConsistency());
    }

    public final long getDocValuesGen() {
        return this.dvGen;
    }

    final void setStoreTermVectors() {
        this.storeTermVector = true;
        assert (this.checkConsistency());
    }

    final void setStorePayloads() {
        if (this.indexOptions != IndexOptions.NONE && this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0) {
            this.storePayloads = true;
        }
        assert (this.checkConsistency());
    }

    public final boolean omitsNorms() {
        return this.omitNorms;
    }

    public final void setOmitsNorms() {
        if (this.indexOptions == IndexOptions.NONE) {
            throw new IllegalStateException("cannot omit norms: this field is not indexed");
        }
        this.omitNorms = true;
    }

    public final boolean hasNorms() {
        return this.indexOptions != IndexOptions.NONE && !this.omitNorms;
    }

    public final boolean hasPayloads() {
        return this.storePayloads;
    }

    public final boolean hasVectors() {
        return this.storeTermVector;
    }

    public final String getAttribute(String string) {
        return this.attributes.get(string);
    }

    public final String putAttribute(String string, String string2) {
        return this.attributes.put(string, string2);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }
}

