/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.util.j;

final class DocumentsWriterPerThreadPool {
    private final List<ThreadState> threadStates = new ArrayList<ThreadState>();
    private final List<ThreadState> freeList = new ArrayList<ThreadState>();
    private boolean aborted;

    DocumentsWriterPerThreadPool() {
    }

    final synchronized int getActiveThreadStateCount() {
        return this.threadStates.size();
    }

    final synchronized void setAbort() {
        this.aborted = true;
    }

    final synchronized void clearAbort() {
        this.aborted = false;
        this.notifyAll();
    }

    private synchronized ThreadState newThreadState() {
        while (this.aborted) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new j(interruptedException);
            }
        }
        ThreadState threadState = new ThreadState(null);
        threadState.lock();
        this.threadStates.add(threadState);
        return threadState;
    }

    final DocumentsWriterPerThread reset(ThreadState threadState) {
        assert (threadState.isHeldByCurrentThread());
        DocumentsWriterPerThread documentsWriterPerThread = threadState.dwpt;
        threadState.reset();
        return documentsWriterPerThread;
    }

    final void recycle(DocumentsWriterPerThread documentsWriterPerThread) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ThreadState getAndLock(Thread object, DocumentsWriter object2) {
        object2 = this;
        synchronized (object2) {
            if (this.freeList.isEmpty()) {
                return this.newThreadState();
            }
            object = this.freeList.remove(this.freeList.size() - 1);
            if (((ThreadState)object).dwpt == null) {
                for (int i2 = 0; i2 < this.freeList.size(); ++i2) {
                    ThreadState threadState = this.freeList.get(i2);
                    if (threadState.dwpt == null) continue;
                    this.freeList.set(i2, (ThreadState)object);
                    object = threadState;
                    break;
                }
            }
        }
        ((ReentrantLock)object).lock();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void release(ThreadState threadState) {
        threadState.unlock();
        DocumentsWriterPerThreadPool documentsWriterPerThreadPool = this;
        synchronized (documentsWriterPerThreadPool) {
            this.freeList.add(threadState);
            this.notifyAll();
            return;
        }
    }

    final synchronized ThreadState getThreadState(int n2) {
        return this.threadStates.get(n2);
    }

    final synchronized int getMaxThreadStates() {
        return this.threadStates.size();
    }

    static final class ThreadState
    extends ReentrantLock {
        DocumentsWriterPerThread dwpt;
        volatile boolean flushPending = false;
        long bytesUsed = 0L;

        ThreadState(DocumentsWriterPerThread documentsWriterPerThread) {
            this.dwpt = documentsWriterPerThread;
        }

        private void reset() {
            assert (this.isHeldByCurrentThread());
            this.dwpt = null;
            this.bytesUsed = 0L;
            this.flushPending = false;
        }

        final boolean isInitialized() {
            assert (this.isHeldByCurrentThread());
            return this.dwpt != null;
        }
    }
}

