/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.AbortingException;
import org.apache.lucene.index.BufferedUpdates;
import org.apache.lucene.index.DefaultIndexingChain;
import org.apache.lucene.index.DocumentsWriterDeleteQueue;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FrozenBufferedUpdates;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.b;
import org.apache.lucene.index.j;
import org.apache.lucene.portmobile.annotations.Weak;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.TrackingDirectoryWrapper;
import org.apache.lucene.store.c;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.IntBlockPool;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.Version;
import org.apache.lucene.util.i;

class DocumentsWriterPerThread {
    static final a defaultIndexingChain = new a(){

        @Override
        final b a(DocumentsWriterPerThread documentsWriterPerThread) throws IOException {
            return new DefaultIndexingChain(documentsWriterPerThread);
        }
    };
    final Codec codec;
    final TrackingDirectoryWrapper directory;
    final c directoryOrig;
    final DocState docState;
    final b consumer;
    final Counter bytesUsed;
    final BufferedUpdates pendingUpdates;
    private final SegmentInfo segmentInfo;
    boolean aborted = false;
    private final FieldInfos.Builder fieldInfos;
    private final InfoStream infoStream;
    private int numDocsInRAM;
    final DocumentsWriterDeleteQueue deleteQueue;
    private final DocumentsWriterDeleteQueue.DeleteSlice deleteSlice;
    private final NumberFormat nf = NumberFormat.getInstance(Locale.ROOT);
    final ByteBlockPool.Allocator byteBlockAllocator;
    final IntBlockPool.Allocator intBlockAllocator;
    private final AtomicLong pendingNumDocs;
    private final LiveIndexWriterConfig indexWriterConfig;
    private final boolean enableTestPoints;
    @Weak
    private final IndexWriter indexWriter;
    private final Set<String> filesToDelete = new HashSet<String>();

    void abort() {
        this.aborted = true;
        try {
            if (this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "now abort");
            }
            try {
                this.consumer.abort();
            }
            catch (Throwable throwable) {}
            this.pendingUpdates.clear();
            if (this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "done abort");
                return;
            }
        }
        catch (Throwable throwable) {
            if (this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "done abort");
            }
            throw throwable;
        }
    }

    public DocumentsWriterPerThread(IndexWriter indexWriter, String string, c c2, c c3, LiveIndexWriterConfig liveIndexWriterConfig, InfoStream infoStream, DocumentsWriterDeleteQueue documentsWriterDeleteQueue, FieldInfos.Builder builder, AtomicLong atomicLong, boolean bl) throws IOException {
        this.indexWriter = indexWriter;
        this.directoryOrig = c2;
        this.directory = new TrackingDirectoryWrapper(c3);
        this.fieldInfos = builder;
        this.indexWriterConfig = liveIndexWriterConfig;
        this.infoStream = infoStream;
        this.codec = liveIndexWriterConfig.getCodec();
        this.docState = new DocState(this, infoStream);
        this.docState.similarity = liveIndexWriterConfig.getSimilarity();
        this.pendingNumDocs = atomicLong;
        this.bytesUsed = Counter.newCounter();
        this.byteBlockAllocator = new ByteBlockPool.DirectTrackingAllocator(this.bytesUsed);
        this.pendingUpdates = new BufferedUpdates();
        this.intBlockAllocator = new IntBlockAllocator(this.bytesUsed);
        this.deleteQueue = documentsWriterDeleteQueue;
        assert (this.numDocsInRAM == 0) : "num docs " + this.numDocsInRAM;
        this.pendingUpdates.clear();
        this.deleteSlice = documentsWriterDeleteQueue.newSlice();
        this.segmentInfo = new SegmentInfo(c2, Version.LATEST, string, -1, false, this.codec, Collections.emptyMap(), StringHelper.randomId(), new HashMap<String, String>());
        assert (this.numDocsInRAM == 0);
        this.consumer = liveIndexWriterConfig.getIndexingChain().a(this);
        this.enableTestPoints = bl;
    }

    public FieldInfos.Builder getFieldInfosBuilder() {
        return this.fieldInfos;
    }

    final void testPoint(String string) {
        if (this.enableTestPoints) {
            assert (this.infoStream.isEnabled("TP"));
            this.infoStream.message("TP", string);
        }
    }

    private void reserveOneDoc() {
        if (this.pendingNumDocs.incrementAndGet() > (long)IndexWriter.getActualMaxDocs()) {
            this.pendingNumDocs.decrementAndGet();
            throw new IllegalArgumentException("number of documents in the index cannot exceed " + IndexWriter.getActualMaxDocs());
        }
    }

    public void updateDocument(Iterable<? extends j> iterable, Analyzer analyzer, Term term) throws IOException, AbortingException {
        this.testPoint("DocumentsWriterPerThread addDocument start");
        assert (this.deleteQueue != null);
        this.reserveOneDoc();
        this.docState.doc = iterable;
        this.docState.analyzer = analyzer;
        this.docState.docID = this.numDocsInRAM++;
        try {
            try {
                this.consumer.processDocument();
            }
            finally {
                this.docState.clear();
            }
        }
        catch (Throwable throwable) {
            this.deleteDocID(this.docState.docID);
            throw throwable;
        }
        this.finishDocument(term);
    }

    private void finishDocument(Term term) {
        boolean bl;
        boolean bl2 = bl = this.numDocsInRAM != 0;
        if (term != null) {
            this.deleteQueue.add(term, this.deleteSlice);
            assert (this.deleteSlice.isTailItem(term)) : "expected the delete term as the tail item";
        } else {
            bl &= this.deleteQueue.updateSlice(this.deleteSlice);
        }
        if (bl) {
            this.deleteSlice.apply(this.pendingUpdates, this.numDocsInRAM);
        } else {
            this.deleteSlice.reset();
        }
        ++this.numDocsInRAM;
    }

    void deleteDocID(int n2) {
        this.pendingUpdates.addDocID(n2);
    }

    public int getNumDocsInRAM() {
        return this.numDocsInRAM;
    }

    FrozenBufferedUpdates prepareFlush() {
        assert (this.numDocsInRAM > 0);
        FrozenBufferedUpdates frozenBufferedUpdates = this.deleteQueue.freezeGlobalBuffer(this.deleteSlice);
        if (this.deleteSlice != null) {
            this.deleteSlice.apply(this.pendingUpdates, this.numDocsInRAM);
            assert (this.deleteSlice.isEmpty());
            this.deleteSlice.reset();
        }
        return frozenBufferedUpdates;
    }

    FlushedSegment flush() throws IOException, AbortingException {
        Object object;
        assert (this.numDocsInRAM > 0);
        assert (this.deleteSlice.isEmpty()) : "all deletes must be applied in prepareFlush";
        this.segmentInfo.setMaxDoc(this.numDocsInRAM);
        SegmentWriteState segmentWriteState = new SegmentWriteState(this.infoStream, this.directory, this.segmentInfo, this.fieldInfos.finish(), this.pendingUpdates, new IOContext(new FlushInfo(this.numDocsInRAM, this.bytesUsed())));
        double d2 = (double)this.bytesUsed() / 1024.0 / 1024.0;
        if (this.pendingUpdates.docIDs.size() > 0) {
            segmentWriteState.liveDocs = this.codec.liveDocsFormat().newLiveDocs(this.numDocsInRAM);
            object = this.pendingUpdates.docIDs.iterator();
            while (object.hasNext()) {
                int n2 = object.next();
                segmentWriteState.liveDocs.clear(n2);
            }
            segmentWriteState.delCountOnFlush = this.pendingUpdates.docIDs.size();
            this.pendingUpdates.bytesUsed.addAndGet(-this.pendingUpdates.docIDs.size() * BufferedUpdates.BYTES_PER_DEL_DOCID);
            this.pendingUpdates.docIDs.clear();
        }
        if (this.aborted) {
            if (this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "flush: skip because aborting is set");
            }
            return null;
        }
        if (this.infoStream.isEnabled("DWPT")) {
            this.infoStream.message("DWPT", "flush postings as segment " + segmentWriteState.segmentInfo.name + " numDocs=" + this.numDocsInRAM);
        }
        try {
            BufferedUpdates bufferedUpdates;
            this.consumer.flush(segmentWriteState);
            this.pendingUpdates.terms.clear();
            this.segmentInfo.setFiles(new HashSet<String>(this.directory.getCreatedFiles()));
            object = new SegmentCommitInfo(this.segmentInfo, 0, -1L, -1L, -1L);
            if (this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "new segment has " + (segmentWriteState.liveDocs == null ? 0 : segmentWriteState.delCountOnFlush) + " deleted docs");
                this.infoStream.message("DWPT", "new segment has " + (segmentWriteState.fieldInfos.hasVectors() ? "vectors" : "no vectors") + "; " + (segmentWriteState.fieldInfos.hasNorms() ? "norms" : "no norms") + "; " + (segmentWriteState.fieldInfos.hasDocValues() ? "docValues" : "no docValues") + "; " + (segmentWriteState.fieldInfos.hasProx() ? "prox" : "no prox") + "; " + (segmentWriteState.fieldInfos.hasFreq() ? "freqs" : "no freqs"));
                this.infoStream.message("DWPT", "flushedFiles=" + ((SegmentCommitInfo)object).files());
                this.infoStream.message("DWPT", "flushed codec=" + this.codec);
            }
            if (this.pendingUpdates.queries.isEmpty() && this.pendingUpdates.numericUpdates.isEmpty() && this.pendingUpdates.binaryUpdates.isEmpty()) {
                this.pendingUpdates.clear();
                bufferedUpdates = null;
            } else {
                bufferedUpdates = this.pendingUpdates;
            }
            if (this.infoStream.isEnabled("DWPT")) {
                double d3 = (double)((SegmentCommitInfo)object).sizeInBytes() / 1024.0 / 1024.0;
                this.infoStream.message("DWPT", "flushed: segment=" + this.segmentInfo.name + " ramUsed=" + this.nf.format(d2) + " MB newFlushedSize=" + this.nf.format(d3) + " MB docs/MB=" + this.nf.format((double)segmentWriteState.segmentInfo.maxDoc() / d3));
            }
            assert (this.segmentInfo != null);
            FlushedSegment flushedSegment = new FlushedSegment((SegmentCommitInfo)object, segmentWriteState.fieldInfos, bufferedUpdates, segmentWriteState.liveDocs, segmentWriteState.delCountOnFlush);
            this.sealFlushedSegment(flushedSegment);
            return flushedSegment;
        }
        catch (Throwable throwable) {
            this.abort();
            throw AbortingException.wrap(throwable);
        }
    }

    public Set<String> pendingFilesToDelete() {
        return this.filesToDelete;
    }

    void sealFlushedSegment(FlushedSegment flushedSegment) throws IOException {
        assert (flushedSegment != null);
        SegmentCommitInfo segmentCommitInfo = flushedSegment.segmentInfo;
        IndexWriter.setDiagnostics(segmentCommitInfo.info, "flush");
        IOContext iOContext = new IOContext(new FlushInfo(segmentCommitInfo.info.maxDoc(), segmentCommitInfo.sizeInBytes()));
        try {
            if (this.indexWriterConfig.getUseCompoundFile()) {
                Set<String> set = segmentCommitInfo.info.files();
                this.indexWriter.createCompoundFile(this.infoStream, new TrackingDirectoryWrapper(this.directory), segmentCommitInfo.info, iOContext);
                this.filesToDelete.addAll(set);
                segmentCommitInfo.info.setUseCompoundFile(true);
            }
            this.codec.segmentInfoFormat().write(this.directory, segmentCommitInfo.info, iOContext);
            if (flushedSegment.liveDocs != null) {
                int n2 = flushedSegment.delCount;
                assert (n2 > 0);
                if (this.infoStream.isEnabled("DWPT")) {
                    this.infoStream.message("DWPT", "flush: write " + n2 + " deletes gen=" + flushedSegment.segmentInfo.getDelGen());
                }
                SegmentCommitInfo segmentCommitInfo2 = flushedSegment.segmentInfo;
                segmentCommitInfo2.info.getCodec().liveDocsFormat().writeLiveDocs(flushedSegment.liveDocs, this.directory, segmentCommitInfo2, n2, iOContext);
                segmentCommitInfo.setDelCount(n2);
                segmentCommitInfo.advanceDelGen();
            }
            return;
        }
        catch (Throwable throwable) {
            if (this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "hit exception creating compound file for newly flushed segment " + segmentCommitInfo.info.name);
            }
            throw throwable;
        }
    }

    SegmentInfo getSegmentInfo() {
        return this.segmentInfo;
    }

    long bytesUsed() {
        return this.bytesUsed.get() + this.pendingUpdates.bytesUsed.get();
    }

    public String toString() {
        return "DocumentsWriterPerThread [pendingDeletes=" + this.pendingUpdates + ", segment=" + (this.segmentInfo != null ? this.segmentInfo.name : "null") + ", aborted=" + this.aborted + ", numDocsInRAM=" + this.numDocsInRAM + ", deleteQueue=" + this.deleteQueue + "]";
    }

    private static class IntBlockAllocator
    extends IntBlockPool.Allocator {
        private final Counter bytesUsed;

        public IntBlockAllocator(Counter counter) {
            super(8192);
            this.bytesUsed = counter;
        }

        @Override
        public int[] getIntBlock() {
            int[] nArray = new int[8192];
            this.bytesUsed.addAndGet(32768L);
            return nArray;
        }

        @Override
        public void recycleIntBlocks(int[][] nArray, int n2, int n3) {
            this.bytesUsed.addAndGet(-(n3 << 15));
        }
    }

    static class FlushedSegment {
        final SegmentCommitInfo segmentInfo;
        final FieldInfos fieldInfos;
        final FrozenBufferedUpdates segmentUpdates;
        final i liveDocs;
        final int delCount;

        private FlushedSegment(SegmentCommitInfo segmentCommitInfo, FieldInfos fieldInfos, BufferedUpdates bufferedUpdates, i i2, int n2) {
            this.segmentInfo = segmentCommitInfo;
            this.fieldInfos = fieldInfos;
            this.segmentUpdates = bufferedUpdates != null && bufferedUpdates.any() ? new FrozenBufferedUpdates(bufferedUpdates, true) : null;
            this.liveDocs = i2;
            this.delCount = n2;
        }
    }

    static class DocState {
        final DocumentsWriterPerThread docWriter;
        Analyzer analyzer;
        InfoStream infoStream;
        org.apache.lucene.search.similarities.a similarity;
        int docID;
        Iterable<? extends j> doc;

        DocState(DocumentsWriterPerThread documentsWriterPerThread, InfoStream infoStream) {
            this.docWriter = documentsWriterPerThread;
            this.infoStream = infoStream;
        }

        public void clear() {
            this.doc = null;
            this.analyzer = null;
        }
    }

    static abstract class a {
        a() {
        }

        abstract b a(DocumentsWriterPerThread var1) throws IOException;
    }
}

