/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.index.DocumentsWriterDeleteQueue;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.FrozenBufferedUpdates;
import org.apache.lucene.index.IndexWriter;

class DocumentsWriterFlushQueue {
    private final Queue<FlushTicket> queue = new LinkedList<FlushTicket>();
    private final AtomicInteger ticketCount = new AtomicInteger();
    private final ReentrantLock purgeLock = new ReentrantLock();

    DocumentsWriterFlushQueue() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDeletes(DocumentsWriterDeleteQueue documentsWriterDeleteQueue) throws IOException {
        DocumentsWriterFlushQueue documentsWriterFlushQueue = this;
        synchronized (documentsWriterFlushQueue) {
            this.incTickets();
            try {
                this.queue.add(new GlobalDeletesTicket(documentsWriterDeleteQueue.freezeGlobalBuffer(null)));
            }
            catch (Throwable throwable) {
                this.decTickets();
                throw throwable;
            }
            return;
        }
    }

    private void incTickets() {
        int n2 = this.ticketCount.incrementAndGet();
        assert (n2 > 0);
    }

    private void decTickets() {
        int n2 = this.ticketCount.decrementAndGet();
        assert (n2 >= 0);
    }

    synchronized SegmentFlushTicket addFlushTicket(DocumentsWriterPerThread object) {
        this.incTickets();
        try {
            object = new SegmentFlushTicket(((DocumentsWriterPerThread)object).prepareFlush());
            this.queue.add((FlushTicket)object);
            return object;
        }
        catch (Throwable throwable) {
            this.decTickets();
            throw throwable;
        }
    }

    synchronized void addSegment(SegmentFlushTicket segmentFlushTicket, DocumentsWriterPerThread.FlushedSegment flushedSegment) {
        segmentFlushTicket.setSegment(flushedSegment);
    }

    synchronized void markTicketFailed(SegmentFlushTicket segmentFlushTicket) {
        segmentFlushTicket.setFailed();
    }

    boolean hasTickets() {
        assert (this.ticketCount.get() >= 0) : "ticketCount should be >= 0 but was: " + this.ticketCount.get();
        return this.ticketCount.get() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int innerPurge(IndexWriter indexWriter) throws IOException {
        assert (this.purgeLock.isHeldByCurrentThread());
        int n2 = 0;
        while (true) {
            boolean bl;
            FlushTicket flushTicket;
            DocumentsWriterFlushQueue documentsWriterFlushQueue = this;
            synchronized (documentsWriterFlushQueue) {
                flushTicket = this.queue.peek();
                bl = flushTicket != null && flushTicket.canPublish();
            }
            if (!bl) return n2;
            ++n2;
            try {
                flushTicket.publish(indexWriter);
                continue;
            }
            finally {
                documentsWriterFlushQueue = this;
                synchronized (documentsWriterFlushQueue) {
                    FlushTicket flushTicket2 = this.queue.poll();
                    this.ticketCount.decrementAndGet();
                    assert (flushTicket2 == flushTicket);
                }
                continue;
            }
            break;
        }
    }

    int forcePurge(IndexWriter indexWriter) throws IOException {
        assert (!Thread.holdsLock(this));
        assert (!Thread.holdsLock(indexWriter));
        this.purgeLock.lock();
        try {
            int n2 = this.innerPurge(indexWriter);
            return n2;
        }
        finally {
            this.purgeLock.unlock();
        }
    }

    int tryPurge(IndexWriter indexWriter) throws IOException {
        assert (!Thread.holdsLock(this));
        assert (!Thread.holdsLock(indexWriter));
        if (this.purgeLock.tryLock()) {
            try {
                int n2 = this.innerPurge(indexWriter);
                return n2;
            }
            finally {
                this.purgeLock.unlock();
            }
        }
        return 0;
    }

    public int getTicketCount() {
        return this.ticketCount.get();
    }

    static final class SegmentFlushTicket
    extends FlushTicket {
        private DocumentsWriterPerThread.FlushedSegment segment;
        private boolean failed = false;

        protected SegmentFlushTicket(FrozenBufferedUpdates frozenBufferedUpdates) {
            super(frozenBufferedUpdates);
        }

        @Override
        protected final void publish(IndexWriter indexWriter) throws IOException {
            assert (!this.published) : "ticket was already publised - can not publish twice";
            this.published = true;
            this.finishFlush(indexWriter, this.segment, this.frozenUpdates);
        }

        protected final void setSegment(DocumentsWriterPerThread.FlushedSegment flushedSegment) {
            assert (!this.failed);
            this.segment = flushedSegment;
        }

        protected final void setFailed() {
            assert (this.segment == null);
            this.failed = true;
        }

        @Override
        protected final boolean canPublish() {
            return this.segment != null || this.failed;
        }
    }

    static final class GlobalDeletesTicket
    extends FlushTicket {
        protected GlobalDeletesTicket(FrozenBufferedUpdates frozenBufferedUpdates) {
            super(frozenBufferedUpdates);
        }

        @Override
        protected final void publish(IndexWriter indexWriter) throws IOException {
            assert (!this.published) : "ticket was already publised - can not publish twice";
            this.published = true;
            this.finishFlush(indexWriter, null, this.frozenUpdates);
        }

        @Override
        protected final boolean canPublish() {
            return true;
        }
    }

    static abstract class FlushTicket {
        protected FrozenBufferedUpdates frozenUpdates;
        protected boolean published = false;

        protected FlushTicket(FrozenBufferedUpdates frozenBufferedUpdates) {
            assert (frozenBufferedUpdates != null);
            this.frozenUpdates = frozenBufferedUpdates;
        }

        protected abstract void publish(IndexWriter var1) throws IOException;

        protected abstract boolean canPublish();

        protected final void publishFlushedSegment(IndexWriter indexWriter, DocumentsWriterPerThread.FlushedSegment flushedSegment, FrozenBufferedUpdates frozenBufferedUpdates) throws IOException {
            assert (flushedSegment != null);
            assert (flushedSegment.segmentInfo != null);
            FrozenBufferedUpdates frozenBufferedUpdates2 = flushedSegment.segmentUpdates;
            if (indexWriter.infoStream.isEnabled("DW")) {
                indexWriter.infoStream.message("DW", "publishFlushedSegment seg-private updates=" + frozenBufferedUpdates2);
            }
            if (frozenBufferedUpdates2 != null && indexWriter.infoStream.isEnabled("DW")) {
                indexWriter.infoStream.message("DW", "flush: push buffered seg private updates: " + frozenBufferedUpdates2);
            }
            indexWriter.publishFlushedSegment(flushedSegment.segmentInfo, frozenBufferedUpdates2, frozenBufferedUpdates);
        }

        protected final void finishFlush(IndexWriter indexWriter, DocumentsWriterPerThread.FlushedSegment flushedSegment, FrozenBufferedUpdates frozenBufferedUpdates) throws IOException {
            if (flushedSegment == null) {
                assert (frozenBufferedUpdates != null);
                if (frozenBufferedUpdates != null && frozenBufferedUpdates.any()) {
                    indexWriter.publishFrozenUpdates(frozenBufferedUpdates);
                    if (indexWriter.infoStream.isEnabled("DW")) {
                        indexWriter.infoStream.message("DW", "flush: push buffered updates: " + frozenBufferedUpdates);
                        return;
                    }
                }
            } else {
                this.publishFlushedSegment(indexWriter, flushedSegment, frozenBufferedUpdates);
            }
        }
    }
}

