/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.index.BufferedUpdatesStream;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.DocumentsWriterDeleteQueue;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.DocumentsWriterPerThreadPool;
import org.apache.lucene.index.DocumentsWriterStallControl;
import org.apache.lucene.index.FlushPolicy;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.portmobile.annotations.Weak;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.a;
import org.apache.lucene.util.j;

final class DocumentsWriterFlushControl
implements a {
    private final long hardMaxBytesPerDWPT;
    private long activeBytes = 0L;
    private long flushBytes = 0L;
    private volatile int numPending = 0;
    private int numDocsSinceStalled = 0;
    final AtomicBoolean flushDeletes = new AtomicBoolean(false);
    private boolean fullFlush = false;
    private final Queue<DocumentsWriterPerThread> flushQueue = new LinkedList<DocumentsWriterPerThread>();
    private final Queue<BlockedFlush> blockedFlushes = new LinkedList<BlockedFlush>();
    private final IdentityHashMap<DocumentsWriterPerThread, Long> flushingWriters = new IdentityHashMap();
    double maxConfiguredRamBuffer = 0.0;
    long peakActiveBytes = 0L;
    long peakFlushBytes = 0L;
    long peakNetBytes = 0L;
    long peakDelta = 0L;
    boolean flushByRAMWasDisabled;
    final DocumentsWriterStallControl stallControl;
    private final DocumentsWriterPerThreadPool perThreadPool;
    private final FlushPolicy flushPolicy;
    private boolean closed = false;
    @Weak
    private final DocumentsWriter documentsWriter;
    private final LiveIndexWriterConfig config;
    private final BufferedUpdatesStream bufferedUpdatesStream;
    private final InfoStream infoStream;
    private final List<DocumentsWriterPerThread> fullFlushBuffer = new ArrayList<DocumentsWriterPerThread>();

    DocumentsWriterFlushControl(DocumentsWriter documentsWriter, LiveIndexWriterConfig liveIndexWriterConfig, BufferedUpdatesStream bufferedUpdatesStream) {
        this.infoStream = liveIndexWriterConfig.getInfoStream();
        this.stallControl = new DocumentsWriterStallControl(liveIndexWriterConfig);
        this.perThreadPool = documentsWriter.perThreadPool;
        this.flushPolicy = documentsWriter.flushPolicy;
        this.config = liveIndexWriterConfig;
        this.hardMaxBytesPerDWPT = liveIndexWriterConfig.getRAMPerThreadHardLimitMB() << 10 << 10;
        this.documentsWriter = documentsWriter;
        this.bufferedUpdatesStream = bufferedUpdatesStream;
    }

    public final synchronized long activeBytes() {
        return this.activeBytes;
    }

    public final synchronized long flushBytes() {
        return this.flushBytes;
    }

    public final synchronized long netBytes() {
        return this.flushBytes + this.activeBytes;
    }

    private long stallLimitBytes() {
        double d2 = this.config.getRAMBufferSizeMB();
        if (d2 != -1.0) {
            return (long)(2.0 * (d2 * 1024.0 * 1024.0));
        }
        return Long.MAX_VALUE;
    }

    private boolean assertMemory() {
        double d2 = this.config.getRAMBufferSizeMB();
        if (d2 != -1.0 && !this.flushByRAMWasDisabled) {
            this.maxConfiguredRamBuffer = Math.max(d2, this.maxConfiguredRamBuffer);
            long l2 = this.flushBytes + this.activeBytes;
            long l3 = (long)(this.maxConfiguredRamBuffer * 1024.0 * 1024.0);
            long l4 = 2L * l3 + (long)(this.numPending + this.numFlushingDWPT() + this.numBlockedFlushes()) * this.peakDelta + (long)this.numDocsSinceStalled * this.peakDelta;
            if (this.peakDelta < l3 >> 1) assert (l2 <= l4) : "actual mem: " + l2 + " byte, expected mem: " + l4 + " byte, flush mem: " + this.flushBytes + ", active mem: " + this.activeBytes + ", pending DWPT: " + this.numPending + ", flushing DWPT: " + this.numFlushingDWPT() + ", blocked DWPT: " + this.numBlockedFlushes() + ", peakDelta mem: " + this.peakDelta + " bytes, ramBufferBytes=" + l3 + ", maxConfiguredRamBuffer=" + this.maxConfiguredRamBuffer;
        } else {
            this.flushByRAMWasDisabled = true;
        }
        return true;
    }

    private void commitPerThreadBytes(DocumentsWriterPerThreadPool.ThreadState threadState) {
        long l2 = threadState.dwpt.bytesUsed() - threadState.bytesUsed;
        threadState.bytesUsed += l2;
        if (threadState.flushPending) {
            this.flushBytes += l2;
        } else {
            this.activeBytes += l2;
        }
        assert (this.updatePeaks(l2));
    }

    private boolean updatePeaks(long l2) {
        this.peakActiveBytes = Math.max(this.peakActiveBytes, this.activeBytes);
        this.peakFlushBytes = Math.max(this.peakFlushBytes, this.flushBytes);
        this.peakNetBytes = Math.max(this.peakNetBytes, this.netBytes());
        this.peakDelta = Math.max(this.peakDelta, l2);
        return true;
    }

    final synchronized DocumentsWriterPerThread doAfterDocument(DocumentsWriterPerThreadPool.ThreadState object, boolean bl) {
        try {
            this.commitPerThreadBytes((DocumentsWriterPerThreadPool.ThreadState)object);
            if (!((DocumentsWriterPerThreadPool.ThreadState)object).flushPending) {
                if (bl) {
                    this.flushPolicy.onUpdate(this, (DocumentsWriterPerThreadPool.ThreadState)object);
                } else {
                    this.flushPolicy.onInsert(this, (DocumentsWriterPerThreadPool.ThreadState)object);
                }
                if (!((DocumentsWriterPerThreadPool.ThreadState)object).flushPending && ((DocumentsWriterPerThreadPool.ThreadState)object).bytesUsed > this.hardMaxBytesPerDWPT) {
                    this.setFlushPending((DocumentsWriterPerThreadPool.ThreadState)object);
                }
            }
            if (this.fullFlush) {
                if (((DocumentsWriterPerThreadPool.ThreadState)object).flushPending) {
                    this.checkoutAndBlock((DocumentsWriterPerThreadPool.ThreadState)object);
                    object = this.nextPendingFlush();
                } else {
                    object = null;
                }
            } else {
                object = this.tryCheckoutForFlush((DocumentsWriterPerThreadPool.ThreadState)object);
            }
            return object;
        }
        finally {
            bl = this.updateStallState();
            assert (this.assertNumDocsSinceStalled(bl) && this.assertMemory());
        }
    }

    private boolean assertNumDocsSinceStalled(boolean bl) {
        this.numDocsSinceStalled = bl ? ++this.numDocsSinceStalled : 0;
        return true;
    }

    final synchronized void doAfterFlush(DocumentsWriterPerThread documentsWriterPerThread) {
        block9: {
            assert (this.flushingWriters.containsKey(documentsWriterPerThread));
            try {
                Long l2 = this.flushingWriters.remove(documentsWriterPerThread);
                this.flushBytes -= l2.longValue();
                this.perThreadPool.recycle(documentsWriterPerThread);
                if ($assertionsDisabled || this.assertMemory()) break block9;
                throw new AssertionError();
            }
            catch (Throwable throwable) {
                try {
                    this.updateStallState();
                }
                finally {
                    this.notifyAll();
                }
                throw throwable;
            }
        }
        try {
            this.updateStallState();
            return;
        }
        finally {
            this.notifyAll();
        }
    }

    private boolean updateStallState() {
        assert (Thread.holdsLock(this));
        long l2 = this.stallLimitBytes();
        boolean bl = this.activeBytes + this.flushBytes > l2 && this.activeBytes < l2 && !this.closed;
        this.stallControl.updateStalled(bl);
        return bl;
    }

    public final synchronized void waitForFlush() {
        while (this.flushingWriters.size() != 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new j(interruptedException);
            }
        }
    }

    public final synchronized void setFlushPending(DocumentsWriterPerThreadPool.ThreadState threadState) {
        assert (!threadState.flushPending);
        if (threadState.dwpt.getNumDocsInRAM() > 0) {
            threadState.flushPending = true;
            long l2 = threadState.bytesUsed;
            this.flushBytes += l2;
            this.activeBytes -= l2;
            ++this.numPending;
            assert (this.assertMemory());
        }
    }

    final synchronized void doOnAbort(DocumentsWriterPerThreadPool.ThreadState threadState) {
        try {
            if (threadState.flushPending) {
                this.flushBytes -= threadState.bytesUsed;
            } else {
                this.activeBytes -= threadState.bytesUsed;
            }
            assert (this.assertMemory());
            this.perThreadPool.reset(threadState);
            return;
        }
        finally {
            this.updateStallState();
        }
    }

    final synchronized DocumentsWriterPerThread tryCheckoutForFlush(DocumentsWriterPerThreadPool.ThreadState threadState) {
        if (threadState.flushPending) {
            return this.internalTryCheckOutForFlush(threadState);
        }
        return null;
    }

    private void checkoutAndBlock(DocumentsWriterPerThreadPool.ThreadState threadState) {
        threadState.lock();
        try {
            assert (threadState.flushPending) : "can not block non-pending threadstate";
            assert (this.fullFlush) : "can not block if fullFlush == false";
            long l2 = threadState.bytesUsed;
            DocumentsWriterPerThread documentsWriterPerThread = this.perThreadPool.reset(threadState);
            --this.numPending;
            this.blockedFlushes.add(new BlockedFlush(documentsWriterPerThread, l2));
            return;
        }
        finally {
            threadState.unlock();
        }
    }

    private DocumentsWriterPerThread internalTryCheckOutForFlush(DocumentsWriterPerThreadPool.ThreadState threadState) {
        assert (Thread.holdsLock(this));
        assert (threadState.flushPending);
        try {
            if (threadState.tryLock()) {
                try {
                    if (threadState.isInitialized()) {
                        assert (threadState.isHeldByCurrentThread());
                        long l2 = threadState.bytesUsed;
                        DocumentsWriterPerThread documentsWriterPerThread = this.perThreadPool.reset(threadState);
                        assert (!this.flushingWriters.containsKey(documentsWriterPerThread)) : "DWPT is already flushing";
                        this.flushingWriters.put(documentsWriterPerThread, l2);
                        --this.numPending;
                        return documentsWriterPerThread;
                    }
                }
                finally {
                    threadState.unlock();
                }
            }
            return null;
        }
        finally {
            this.updateStallState();
        }
    }

    public final String toString() {
        return "DocumentsWriterFlushControl [activeBytes=" + this.activeBytes + ", flushBytes=" + this.flushBytes + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final DocumentsWriterPerThread nextPendingFlush() {
        int n2;
        int n3;
        DocumentsWriterFlushControl documentsWriterFlushControl = this;
        synchronized (documentsWriterFlushControl) {
            DocumentsWriterPerThread documentsWriterPerThread = this.flushQueue.poll();
            if (documentsWriterPerThread != null) {
                this.updateStallState();
                return documentsWriterPerThread;
            }
            n3 = this.fullFlush;
            n2 = this.numPending;
        }
        if (n2 > 0 && n3 == 0) {
            int n4 = this.perThreadPool.getActiveThreadStateCount();
            for (n3 = 0; n3 < n4 && n2 > 0; ++n3) {
                Object object = this.perThreadPool.getThreadState(n3);
                if (!((DocumentsWriterPerThreadPool.ThreadState)object).flushPending || (object = this.tryCheckoutForFlush((DocumentsWriterPerThreadPool.ThreadState)object)) == null) continue;
                return object;
            }
        }
        return null;
    }

    final synchronized void setClosed() {
        this.closed = true;
    }

    public final Iterator<DocumentsWriterPerThreadPool.ThreadState> allActiveThreadStates() {
        return this.getPerThreadsIterator(this.perThreadPool.getActiveThreadStateCount());
    }

    private Iterator<DocumentsWriterPerThreadPool.ThreadState> getPerThreadsIterator(final int n2) {
        return new Iterator<DocumentsWriterPerThreadPool.ThreadState>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < n2;
            }

            @Override
            public DocumentsWriterPerThreadPool.ThreadState next() {
                return DocumentsWriterFlushControl.this.perThreadPool.getThreadState(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove() not supported.");
            }
        };
    }

    final synchronized void doOnDelete() {
        this.flushPolicy.onDelete(this, null);
    }

    public final int getNumGlobalTermDeletes() {
        return this.documentsWriter.deleteQueue.numGlobalTermDeletes() + this.bufferedUpdatesStream.numTerms();
    }

    public final long getDeleteBytesUsed() {
        return this.documentsWriter.deleteQueue.ramBytesUsed() + this.bufferedUpdatesStream.ramBytesUsed();
    }

    @Override
    public final long ramBytesUsed() {
        return this.getDeleteBytesUsed() + this.netBytes();
    }

    @Override
    public final Collection<a> getChildResources() {
        return Collections.emptyList();
    }

    final synchronized int numFlushingDWPT() {
        return this.flushingWriters.size();
    }

    public final boolean getAndResetApplyAllDeletes() {
        return this.flushDeletes.getAndSet(false);
    }

    public final void setApplyAllDeletes() {
        this.flushDeletes.set(true);
    }

    final DocumentsWriterPerThreadPool.ThreadState obtainAndLock() {
        DocumentsWriterPerThreadPool.ThreadState threadState = this.perThreadPool.getAndLock(Thread.currentThread(), this.documentsWriter);
        boolean bl = false;
        try {
            if (threadState.isInitialized() && threadState.dwpt.deleteQueue != this.documentsWriter.deleteQueue) {
                this.addFlushableState(threadState);
            }
            bl = true;
            DocumentsWriterPerThreadPool.ThreadState threadState2 = threadState;
            return threadState2;
        }
        catch (Throwable throwable) {
            if (!bl) {
                this.perThreadPool.release(threadState);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void markForFullFlush() {
        DocumentsWriterDeleteQueue documentsWriterDeleteQueue;
        DocumentsWriterFlushControl documentsWriterFlushControl = this;
        synchronized (documentsWriterFlushControl) {
            DocumentsWriterDeleteQueue documentsWriterDeleteQueue2;
            assert (!this.fullFlush) : "called DWFC#markForFullFlush() while full flush is still running";
            assert (this.fullFlushBuffer.isEmpty()) : "full flush buffer should be empty: " + this.fullFlushBuffer;
            this.fullFlush = true;
            documentsWriterDeleteQueue = this.documentsWriter.deleteQueue;
            this.documentsWriter.deleteQueue = documentsWriterDeleteQueue2 = new DocumentsWriterDeleteQueue(documentsWriterDeleteQueue.generation + 1L);
        }
        int n2 = this.perThreadPool.getActiveThreadStateCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            DocumentsWriterPerThreadPool.ThreadState threadState = this.perThreadPool.getThreadState(i2);
            threadState.lock();
            try {
                if (!threadState.isInitialized()) continue;
                assert (threadState.dwpt.deleteQueue == documentsWriterDeleteQueue || threadState.dwpt.deleteQueue == this.documentsWriter.deleteQueue) : " flushingQueue: " + documentsWriterDeleteQueue + " currentqueue: " + this.documentsWriter.deleteQueue + " perThread queue: " + threadState.dwpt.deleteQueue + " numDocsInRam: " + threadState.dwpt.getNumDocsInRAM();
                if (threadState.dwpt.deleteQueue != documentsWriterDeleteQueue) continue;
                this.addFlushableState(threadState);
                continue;
            }
            finally {
                threadState.unlock();
            }
        }
        DocumentsWriterFlushControl documentsWriterFlushControl2 = this;
        synchronized (documentsWriterFlushControl2) {
            this.pruneBlockedQueue(documentsWriterDeleteQueue);
            assert (this.assertBlockedFlushes(this.documentsWriter.deleteQueue));
            this.flushQueue.addAll(this.fullFlushBuffer);
            this.fullFlushBuffer.clear();
            this.updateStallState();
        }
        assert (this.assertActiveDeleteQueue(this.documentsWriter.deleteQueue));
    }

    private boolean assertActiveDeleteQueue(DocumentsWriterDeleteQueue documentsWriterDeleteQueue) {
        int n2 = this.perThreadPool.getActiveThreadStateCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            DocumentsWriterPerThreadPool.ThreadState threadState = this.perThreadPool.getThreadState(i2);
            threadState.lock();
            try {
                if ($assertionsDisabled || !threadState.isInitialized() || threadState.dwpt.deleteQueue == documentsWriterDeleteQueue) continue;
                throw new AssertionError((Object)("isInitialized: " + threadState.isInitialized() + " numDocs: " + (threadState.isInitialized() ? threadState.dwpt.getNumDocsInRAM() : 0)));
            }
            finally {
                threadState.unlock();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addFlushableState(DocumentsWriterPerThreadPool.ThreadState object) {
        if (this.infoStream.isEnabled("DWFC")) {
            this.infoStream.message("DWFC", "addFlushableState " + ((DocumentsWriterPerThreadPool.ThreadState)object).dwpt);
        }
        DocumentsWriterPerThread documentsWriterPerThread = ((DocumentsWriterPerThreadPool.ThreadState)object).dwpt;
        assert (((ReentrantLock)object).isHeldByCurrentThread());
        assert (((DocumentsWriterPerThreadPool.ThreadState)object).isInitialized());
        assert (this.fullFlush);
        assert (documentsWriterPerThread.deleteQueue != this.documentsWriter.deleteQueue);
        if (documentsWriterPerThread.getNumDocsInRAM() > 0) {
            DocumentsWriterFlushControl documentsWriterFlushControl = this;
            synchronized (documentsWriterFlushControl) {
                if (!((DocumentsWriterPerThreadPool.ThreadState)object).flushPending) {
                    this.setFlushPending((DocumentsWriterPerThreadPool.ThreadState)object);
                }
                object = this.internalTryCheckOutForFlush((DocumentsWriterPerThreadPool.ThreadState)object);
                assert (object != null) : "DWPT must never be null here since we hold the lock and it holds documents";
                assert (documentsWriterPerThread == object) : "flushControl returned different DWPT";
                this.fullFlushBuffer.add((DocumentsWriterPerThread)object);
                return;
            }
        }
        this.perThreadPool.reset((DocumentsWriterPerThreadPool.ThreadState)object);
    }

    private void pruneBlockedQueue(DocumentsWriterDeleteQueue documentsWriterDeleteQueue) {
        Iterator iterator = this.blockedFlushes.iterator();
        while (iterator.hasNext()) {
            BlockedFlush blockedFlush = (BlockedFlush)iterator.next();
            if (blockedFlush.dwpt.deleteQueue != documentsWriterDeleteQueue) continue;
            iterator.remove();
            assert (!this.flushingWriters.containsKey(blockedFlush.dwpt)) : "DWPT is already flushing";
            this.flushingWriters.put(blockedFlush.dwpt, blockedFlush.bytes);
            this.flushQueue.add(blockedFlush.dwpt);
        }
    }

    final synchronized void finishFullFlush() {
        assert (this.fullFlush);
        assert (this.flushQueue.isEmpty());
        assert (this.flushingWriters.isEmpty());
        try {
            if (!this.blockedFlushes.isEmpty()) {
                assert (this.assertBlockedFlushes(this.documentsWriter.deleteQueue));
                this.pruneBlockedQueue(this.documentsWriter.deleteQueue);
                assert (this.blockedFlushes.isEmpty());
            }
            return;
        }
        finally {
            this.fullFlush = false;
            this.updateStallState();
        }
    }

    final boolean assertBlockedFlushes(DocumentsWriterDeleteQueue documentsWriterDeleteQueue) {
        for (BlockedFlush blockedFlush : this.blockedFlushes) {
            assert (blockedFlush.dwpt.deleteQueue == documentsWriterDeleteQueue);
        }
        return true;
    }

    final synchronized void abortFullFlushes() {
        try {
            this.abortPendingFlushes();
            return;
        }
        finally {
            this.fullFlush = false;
        }
    }

    final synchronized void abortPendingFlushes() {
        try {
            for (DocumentsWriterPerThread object : this.flushQueue) {
                try {
                    this.documentsWriter.subtractFlushedNumDocs(object.getNumDocsInRAM());
                    object.abort();
                }
                catch (Throwable throwable) {
                }
                finally {
                    this.doAfterFlush(object);
                }
            }
            for (BlockedFlush blockedFlush : this.blockedFlushes) {
                try {
                    this.flushingWriters.put(blockedFlush.dwpt, blockedFlush.bytes);
                    this.documentsWriter.subtractFlushedNumDocs(blockedFlush.dwpt.getNumDocsInRAM());
                    blockedFlush.dwpt.abort();
                }
                catch (Throwable throwable) {
                }
                finally {
                    this.doAfterFlush(blockedFlush.dwpt);
                }
            }
            return;
        }
        finally {
            this.flushQueue.clear();
            this.blockedFlushes.clear();
            this.updateStallState();
        }
    }

    final synchronized boolean isFullFlush() {
        return this.fullFlush;
    }

    final synchronized int numQueuedFlushes() {
        return this.flushQueue.size();
    }

    final synchronized int numBlockedFlushes() {
        return this.blockedFlushes.size();
    }

    final void waitIfStalled() {
        if (this.infoStream.isEnabled("DWFC")) {
            this.infoStream.message("DWFC", "waitIfStalled: numFlushesPending: " + this.flushQueue.size() + " netBytes: " + this.netBytes() + " flushBytes: " + this.flushBytes() + " fullFlush: " + this.fullFlush);
        }
        this.stallControl.waitIfStalled();
    }

    final boolean anyStalledThreads() {
        return this.stallControl.anyStalledThreads();
    }

    private static class BlockedFlush {
        final DocumentsWriterPerThread dwpt;
        final long bytes;

        BlockedFlush(DocumentsWriterPerThread documentsWriterPerThread, long l2) {
            this.dwpt = documentsWriterPerThread;
            this.bytes = l2;
        }
    }
}

