/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.AbortingException;
import org.apache.lucene.index.DocumentsWriterDeleteQueue;
import org.apache.lucene.index.DocumentsWriterFlushControl;
import org.apache.lucene.index.DocumentsWriterFlushQueue;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.DocumentsWriterPerThreadPool;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FlushPolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.j;
import org.apache.lucene.portmobile.annotations.Weak;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.c;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.a;

final class DocumentsWriter
implements Closeable,
a {
    private final c directoryOrig;
    private final c directory;
    private volatile boolean closed;
    private final InfoStream infoStream;
    private final LiveIndexWriterConfig config;
    private final AtomicInteger numDocsInRAM = new AtomicInteger(0);
    volatile DocumentsWriterDeleteQueue deleteQueue = new DocumentsWriterDeleteQueue();
    private final DocumentsWriterFlushQueue ticketQueue = new DocumentsWriterFlushQueue();
    private volatile boolean pendingChangesInCurrentFullFlush;
    final DocumentsWriterPerThreadPool perThreadPool;
    final FlushPolicy flushPolicy;
    final DocumentsWriterFlushControl flushControl;
    @Weak
    private final IndexWriter writer;
    private final Queue<IndexWriter.a> events;
    private volatile DocumentsWriterDeleteQueue currentFullFlushDelQueue = null;

    DocumentsWriter(IndexWriter indexWriter, LiveIndexWriterConfig liveIndexWriterConfig, c c2, c c3) {
        this.directoryOrig = c2;
        this.directory = c3;
        this.config = liveIndexWriterConfig;
        this.infoStream = liveIndexWriterConfig.getInfoStream();
        this.perThreadPool = liveIndexWriterConfig.getIndexerThreadPool();
        this.flushPolicy = liveIndexWriterConfig.getFlushPolicy();
        this.writer = indexWriter;
        this.events = new ConcurrentLinkedQueue<IndexWriter.a>();
        this.flushControl = new DocumentsWriterFlushControl(this, liveIndexWriterConfig, indexWriter.bufferedUpdatesStream);
    }

    final synchronized boolean deleteQueries(Query ... queryArray) throws IOException {
        DocumentsWriterDeleteQueue documentsWriterDeleteQueue = this.deleteQueue;
        documentsWriterDeleteQueue.addDelete(queryArray);
        this.flushControl.doOnDelete();
        return this.applyAllDeletes(documentsWriterDeleteQueue);
    }

    final synchronized boolean deleteTerms(Term ... termArray) throws IOException {
        DocumentsWriterDeleteQueue documentsWriterDeleteQueue = this.deleteQueue;
        documentsWriterDeleteQueue.addDelete(termArray);
        this.flushControl.doOnDelete();
        return this.applyAllDeletes(documentsWriterDeleteQueue);
    }

    private boolean applyAllDeletes(DocumentsWriterDeleteQueue documentsWriterDeleteQueue) throws IOException {
        if (this.flushControl.getAndResetApplyAllDeletes()) {
            if (documentsWriterDeleteQueue != null && !this.flushControl.isFullFlush()) {
                this.ticketQueue.addDeletes(documentsWriterDeleteQueue);
            }
            this.putEvent(ApplyDeletesEvent.INSTANCE);
            return true;
        }
        return false;
    }

    final int purgeBuffer(IndexWriter indexWriter, boolean bl) throws IOException {
        if (bl) {
            return this.ticketQueue.forcePurge(indexWriter);
        }
        return this.ticketQueue.tryPurge(indexWriter);
    }

    final int getNumDocs() {
        return this.numDocsInRAM.get();
    }

    private void ensureOpen() throws org.apache.lucene.store.a {
        if (this.closed) {
            throw new org.apache.lucene.store.a("this IndexWriter is closed");
        }
    }

    final synchronized void abort(IndexWriter indexWriter) {
        assert (!Thread.holdsLock(indexWriter)) : "IndexWriter lock should never be hold when aborting";
        try {
            this.deleteQueue.clear();
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", "abort");
            }
            int n2 = this.perThreadPool.getActiveThreadStateCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                DocumentsWriterPerThreadPool.ThreadState threadState = this.perThreadPool.getThreadState(i2);
                threadState.lock();
                try {
                    this.abortThreadState(threadState);
                    continue;
                }
                finally {
                    threadState.unlock();
                }
            }
            this.flushControl.abortPendingFlushes();
            this.flushControl.waitForFlush();
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", "done abort success=true");
                return;
            }
        }
        catch (Throwable throwable) {
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", "done abort success=false");
            }
            throw throwable;
        }
    }

    final synchronized long lockAndAbortAll(IndexWriter indexWriter) {
        assert (indexWriter.holdsFullFlushLock());
        if (this.infoStream.isEnabled("DW")) {
            this.infoStream.message("DW", "lockAndAbortAll");
        }
        long l2 = 0L;
        boolean bl = false;
        try {
            this.deleteQueue.clear();
            int n2 = this.perThreadPool.getMaxThreadStates();
            this.perThreadPool.setAbort();
            for (int i2 = 0; i2 < n2; ++i2) {
                DocumentsWriterPerThreadPool.ThreadState threadState = this.perThreadPool.getThreadState(i2);
                threadState.lock();
                l2 += (long)this.abortThreadState(threadState);
            }
            this.deleteQueue.clear();
            this.flushControl.abortPendingFlushes();
            this.flushControl.waitForFlush();
            bl = true;
            long l3 = l2;
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", "finished lockAndAbortAll success=true");
            }
            return l3;
        }
        catch (Throwable throwable) {
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", "finished lockAndAbortAll success=" + bl);
            }
            if (!bl) {
                this.unlockAllAfterAbortAll(indexWriter);
            }
            throw throwable;
        }
    }

    private int abortThreadState(DocumentsWriterPerThreadPool.ThreadState threadState) {
        assert (threadState.isHeldByCurrentThread());
        if (threadState.isInitialized()) {
            try {
                int n2 = threadState.dwpt.getNumDocsInRAM();
                this.subtractFlushedNumDocs(n2);
                threadState.dwpt.abort();
                return n2;
            }
            finally {
                this.flushControl.doOnAbort(threadState);
            }
        }
        this.flushControl.doOnAbort(threadState);
        return 0;
    }

    final synchronized void unlockAllAfterAbortAll(IndexWriter indexWriter) {
        assert (indexWriter.holdsFullFlushLock());
        if (this.infoStream.isEnabled("DW")) {
            this.infoStream.message("DW", "unlockAll");
        }
        int n2 = this.perThreadPool.getMaxThreadStates();
        this.perThreadPool.clearAbort();
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                DocumentsWriterPerThreadPool.ThreadState threadState = this.perThreadPool.getThreadState(i2);
                if (!threadState.isHeldByCurrentThread()) continue;
                threadState.unlock();
                continue;
            }
            catch (Throwable throwable) {
                if (!this.infoStream.isEnabled("DW")) continue;
                this.infoStream.message("DW", "unlockAll: could not unlock state: " + i2 + " msg:" + throwable.getMessage());
            }
        }
    }

    final boolean anyChanges() {
        boolean bl;
        boolean bl2 = bl = this.numDocsInRAM.get() != 0 || this.anyDeletions() || this.ticketQueue.hasTickets() || this.pendingChangesInCurrentFullFlush;
        if (this.infoStream.isEnabled("DW") && bl) {
            this.infoStream.message("DW", "anyChanges? numDocsInRam=" + this.numDocsInRAM.get() + " deletes=" + this.anyDeletions() + " hasTickets:" + this.ticketQueue.hasTickets() + " pendingChangesInFullFlush: " + this.pendingChangesInCurrentFullFlush);
        }
        return bl;
    }

    public final boolean anyDeletions() {
        return this.deleteQueue.anyChanges();
    }

    @Override
    public final void close() {
        this.closed = true;
        this.flushControl.setClosed();
    }

    private boolean preUpdate() throws IOException, AbortingException {
        this.ensureOpen();
        boolean bl = false;
        if (this.flushControl.anyStalledThreads() || this.flushControl.numQueuedFlushes() > 0) {
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", "DocumentsWriter has queued dwpt; will hijack this thread to flush pending segment(s)");
            }
            while (true) {
                DocumentsWriterPerThread documentsWriterPerThread;
                if ((documentsWriterPerThread = this.flushControl.nextPendingFlush()) != null) {
                    bl |= this.doFlush(documentsWriterPerThread);
                    continue;
                }
                if (this.infoStream.isEnabled("DW") && this.flushControl.anyStalledThreads()) {
                    this.infoStream.message("DW", "WARNING DocumentsWriter has stalled threads; waiting");
                }
                this.flushControl.waitIfStalled();
                if (this.flushControl.numQueuedFlushes() == 0) break;
            }
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", "continue indexing after helping out flushing DocumentsWriter is healthy");
            }
        }
        return bl;
    }

    private boolean postUpdate(DocumentsWriterPerThread documentsWriterPerThread, boolean bl) throws IOException, AbortingException {
        bl |= this.applyAllDeletes(this.deleteQueue);
        if (documentsWriterPerThread != null) {
            bl |= this.doFlush(documentsWriterPerThread);
        } else {
            documentsWriterPerThread = this.flushControl.nextPendingFlush();
            if (documentsWriterPerThread != null) {
                bl |= this.doFlush(documentsWriterPerThread);
            }
        }
        return bl;
    }

    private void ensureInitialized(DocumentsWriterPerThreadPool.ThreadState threadState) throws IOException {
        if (threadState.dwpt == null) {
            FieldInfos.Builder builder = new FieldInfos.Builder(this.writer.globalFieldNumberMap);
            threadState.dwpt = new DocumentsWriterPerThread(this.writer, this.writer.newSegmentName(), this.directoryOrig, this.directory, this.config, this.infoStream, this.deleteQueue, builder, this.writer.pendingNumDocs, this.writer.enableTestPoints);
        }
    }

    final boolean updateDocument(Iterable<? extends j> iterable, Analyzer analyzer, Term term) throws IOException, AbortingException {
        DocumentsWriterPerThread documentsWriterPerThread;
        boolean bl = this.preUpdate();
        DocumentsWriterPerThreadPool.ThreadState threadState = this.flushControl.obtainAndLock();
        try {
            this.ensureOpen();
            this.ensureInitialized(threadState);
            assert (threadState.isInitialized());
            DocumentsWriterPerThread documentsWriterPerThread2 = threadState.dwpt;
            int n2 = documentsWriterPerThread2.getNumDocsInRAM();
            try {
                documentsWriterPerThread2.updateDocument(iterable, analyzer, term);
            }
            catch (AbortingException abortingException) {
                this.flushControl.doOnAbort(threadState);
                documentsWriterPerThread2.abort();
                throw abortingException;
            }
            finally {
                this.numDocsInRAM.addAndGet(documentsWriterPerThread2.getNumDocsInRAM() - n2);
            }
            boolean bl2 = term != null;
            documentsWriterPerThread = this.flushControl.doAfterDocument(threadState, bl2);
        }
        finally {
            this.perThreadPool.release(threadState);
        }
        return this.postUpdate(documentsWriterPerThread, bl);
    }

    private boolean doFlush(DocumentsWriterPerThread documentsWriterPerThread) throws IOException, AbortingException {
        double d2;
        boolean bl = false;
        while (documentsWriterPerThread != null) {
            bl = true;
            DocumentsWriterFlushQueue.SegmentFlushTicket segmentFlushTicket = null;
            try {
                assert (this.currentFullFlushDelQueue == null || documentsWriterPerThread.deleteQueue == this.currentFullFlushDelQueue) : "expected: " + this.currentFullFlushDelQueue + "but was: " + documentsWriterPerThread.deleteQueue + " " + this.flushControl.isFullFlush();
                try {
                    segmentFlushTicket = this.ticketQueue.addFlushTicket(documentsWriterPerThread);
                    int n2 = documentsWriterPerThread.getNumDocsInRAM();
                    try {
                        DocumentsWriterPerThread.FlushedSegment flushedSegment = documentsWriterPerThread.flush();
                        this.ticketQueue.addSegment(segmentFlushTicket, flushedSegment);
                        this.subtractFlushedNumDocs(n2);
                        if (!documentsWriterPerThread.pendingFilesToDelete().isEmpty()) {
                            this.putEvent(new DeleteNewFilesEvent(documentsWriterPerThread.pendingFilesToDelete()));
                            bl = true;
                        }
                    }
                    catch (Throwable throwable) {
                        this.subtractFlushedNumDocs(n2);
                        if (!documentsWriterPerThread.pendingFilesToDelete().isEmpty()) {
                            this.putEvent(new DeleteNewFilesEvent(documentsWriterPerThread.pendingFilesToDelete()));
                        }
                        this.putEvent(new FlushFailedEvent(documentsWriterPerThread.getSegmentInfo()));
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    if (segmentFlushTicket != null) {
                        this.ticketQueue.markTicketFailed(segmentFlushTicket);
                    }
                    throw throwable;
                }
                if (this.ticketQueue.getTicketCount() >= this.perThreadPool.getActiveThreadStateCount()) {
                    this.putEvent(ForcedPurgeEvent.INSTANCE);
                    break;
                }
            }
            finally {
                this.flushControl.doAfterFlush(documentsWriterPerThread);
            }
            documentsWriterPerThread = this.flushControl.nextPendingFlush();
        }
        if (bl) {
            this.putEvent(MergePendingEvent.INSTANCE);
        }
        if ((d2 = this.config.getRAMBufferSizeMB()) != -1.0 && (double)this.flushControl.getDeleteBytesUsed() > d2 * 1048576.0 / 2.0) {
            bl = true;
            if (!this.applyAllDeletes(this.deleteQueue)) {
                if (this.infoStream.isEnabled("DW")) {
                    this.infoStream.message("DW", String.format(Locale.ROOT, "force apply deletes bytesUsed=%.1f MB vs ramBuffer=%.1f MB", (double)this.flushControl.getDeleteBytesUsed() / 1048576.0, d2));
                }
                this.putEvent(ApplyDeletesEvent.INSTANCE);
            }
        }
        return bl;
    }

    final void subtractFlushedNumDocs(int n2) {
        int n3 = this.numDocsInRAM.get();
        while (!this.numDocsInRAM.compareAndSet(n3, n3 - n2)) {
            n3 = this.numDocsInRAM.get();
        }
        assert (this.numDocsInRAM.get() >= 0);
    }

    private synchronized boolean setFlushingDeleteQueue(DocumentsWriterDeleteQueue documentsWriterDeleteQueue) {
        this.currentFullFlushDelQueue = documentsWriterDeleteQueue;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean flushAllThreads() throws IOException, AbortingException {
        DocumentsWriterDeleteQueue documentsWriterDeleteQueue;
        if (this.infoStream.isEnabled("DW")) {
            this.infoStream.message("DW", "startFullFlush");
        }
        DocumentsWriter documentsWriter = this;
        synchronized (documentsWriter) {
            this.pendingChangesInCurrentFullFlush = this.anyChanges();
            documentsWriterDeleteQueue = this.deleteQueue;
            this.flushControl.markForFullFlush();
            assert (this.setFlushingDeleteQueue(documentsWriterDeleteQueue));
        }
        assert (this.currentFullFlushDelQueue != null);
        assert (this.currentFullFlushDelQueue != this.deleteQueue);
        boolean bl = false;
        try {
            DocumentsWriterPerThread documentsWriterPerThread;
            while ((documentsWriterPerThread = this.flushControl.nextPendingFlush()) != null) {
                bl |= this.doFlush(documentsWriterPerThread);
            }
            this.flushControl.waitForFlush();
            if (!bl && documentsWriterDeleteQueue.anyChanges()) {
                if (this.infoStream.isEnabled("DW")) {
                    this.infoStream.message("DW", Thread.currentThread().getName() + ": flush naked frozen global deletes");
                }
                this.ticketQueue.addDeletes(documentsWriterDeleteQueue);
            }
            this.ticketQueue.forcePurge(this.writer);
            assert (!documentsWriterDeleteQueue.anyChanges() && !this.ticketQueue.hasTickets());
        }
        finally {
            assert (documentsWriterDeleteQueue == this.currentFullFlushDelQueue);
        }
        return bl;
    }

    final void finishFullFlush(IndexWriter indexWriter, boolean bl) {
        assert (indexWriter.holdsFullFlushLock());
        try {
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", Thread.currentThread().getName() + " finishFullFlush success=" + bl);
            }
            assert (this.setFlushingDeleteQueue(null));
            if (bl) {
                this.flushControl.finishFullFlush();
            } else {
                this.flushControl.abortFullFlushes();
            }
            return;
        }
        finally {
            this.pendingChangesInCurrentFullFlush = false;
        }
    }

    private void putEvent(IndexWriter.a a2) {
        this.events.add(a2);
    }

    @Override
    public final long ramBytesUsed() {
        return this.flushControl.ramBytesUsed();
    }

    @Override
    public final Collection<a> getChildResources() {
        return Collections.emptyList();
    }

    public final Queue<IndexWriter.a> eventQueue() {
        return this.events;
    }

    static class DeleteNewFilesEvent
    implements IndexWriter.a {
        private final Collection<String> files;

        public DeleteNewFilesEvent(Collection<String> collection) {
            this.files = collection;
        }

        @Override
        public void process(IndexWriter indexWriter, boolean bl, boolean bl2) throws IOException {
            indexWriter.deleteNewFiles(this.files);
        }
    }

    static class FlushFailedEvent
    implements IndexWriter.a {
        private final SegmentInfo info;

        public FlushFailedEvent(SegmentInfo segmentInfo) {
            this.info = segmentInfo;
        }

        @Override
        public void process(IndexWriter indexWriter, boolean bl, boolean bl2) throws IOException {
            indexWriter.flushFailed(this.info);
        }
    }

    static final class ForcedPurgeEvent
    implements IndexWriter.a {
        static final IndexWriter.a INSTANCE = new ForcedPurgeEvent();
        private int instCount = 0;

        private ForcedPurgeEvent() {
            assert (this.instCount == 0);
            ++this.instCount;
        }

        @Override
        public final void process(IndexWriter indexWriter, boolean bl, boolean bl2) throws IOException {
            indexWriter.purge(true);
        }
    }

    static final class MergePendingEvent
    implements IndexWriter.a {
        static final IndexWriter.a INSTANCE = new MergePendingEvent();
        private int instCount = 0;

        private MergePendingEvent() {
            assert (this.instCount == 0);
            ++this.instCount;
        }

        @Override
        public final void process(IndexWriter indexWriter, boolean bl, boolean bl2) throws IOException {
            indexWriter.doAfterSegmentFlushed(bl, bl2);
        }
    }

    static final class ApplyDeletesEvent
    implements IndexWriter.a {
        static final IndexWriter.a INSTANCE = new ApplyDeletesEvent();
        private int instCount = 0;

        private ApplyDeletesEvent() {
            assert (this.instCount == 0);
            ++this.instCount;
        }

        @Override
        public final void process(IndexWriter indexWriter, boolean bl, boolean bl2) throws IOException {
            indexWriter.applyDeletesAndPurge(true);
        }
    }
}

