/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;

abstract class DocValuesUpdate {
    private static final int RAW_SIZE_IN_BYTES = 8 * RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + 32;
    final DocValuesType type;
    final Term term;
    final String field;
    final Object value;
    int docIDUpto = -1;

    protected DocValuesUpdate(DocValuesType docValuesType, Term term, String string, Object object) {
        this.type = docValuesType;
        this.term = term;
        this.field = string;
        this.value = object;
    }

    abstract long valueSizeInBytes();

    final int sizeInBytes() {
        return (int)((long)(RAW_SIZE_IN_BYTES + (this.term.field.length() << 1) + this.term.bytes.bytes.length + (this.field.length() << 1)) + this.valueSizeInBytes());
    }

    public String toString() {
        return "term=" + this.term + ",field=" + this.field + ",value=" + this.value;
    }

    static final class a
    extends DocValuesUpdate {
        a(Term term, String string, Long l2) {
            super(DocValuesType.NUMERIC, term, string, l2);
        }

        @Override
        final long valueSizeInBytes() {
            return 8L;
        }
    }

    static final class BinaryDocValuesUpdate
    extends DocValuesUpdate {
        private static final long RAW_VALUE_SIZE_IN_BYTES = RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + 8 + RamUsageEstimator.NUM_BYTES_OBJECT_REF;

        BinaryDocValuesUpdate(Term term, String string, BytesRef bytesRef) {
            super(DocValuesType.BINARY, term, string, bytesRef);
        }

        @Override
        final long valueSizeInBytes() {
            return RAW_VALUE_SIZE_IN_BYTES + (long)((BytesRef)this.value).bytes.length;
        }
    }
}

