/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;

public final class CompositeReaderContext
extends IndexReaderContext {
    private final List<IndexReaderContext> children;
    private final List<LeafReaderContext> leaves;
    private final CompositeReader reader;

    static CompositeReaderContext create(CompositeReader compositeReader) {
        return new Builder(compositeReader).build();
    }

    CompositeReaderContext(CompositeReaderContext compositeReaderContext, CompositeReader compositeReader, int n2, int n3, List<IndexReaderContext> list) {
        this(compositeReaderContext, compositeReader, n2, n3, list, null);
    }

    CompositeReaderContext(CompositeReader compositeReader, List<IndexReaderContext> list, List<LeafReaderContext> list2) {
        this(null, compositeReader, 0, 0, list, list2);
    }

    private CompositeReaderContext(CompositeReaderContext compositeReaderContext, CompositeReader compositeReader, int n2, int n3, List<IndexReaderContext> list, List<LeafReaderContext> list2) {
        super(compositeReaderContext, n2, n3);
        this.children = Collections.unmodifiableList(list);
        this.leaves = list2 == null ? null : Collections.unmodifiableList(list2);
        this.reader = compositeReader;
    }

    @Override
    public final List<LeafReaderContext> leaves() throws UnsupportedOperationException {
        if (!this.isTopLevel) {
            throw new UnsupportedOperationException("This is not a top-level context.");
        }
        assert (this.leaves != null);
        return this.leaves;
    }

    @Override
    public final CompositeReader reader() {
        return this.reader;
    }

    private static final class Builder {
        private final CompositeReader reader;
        private final List<LeafReaderContext> leaves = new ArrayList<LeafReaderContext>();
        private int leafDocBase = 0;

        public Builder(CompositeReader compositeReader) {
            this.reader = compositeReader;
        }

        public final CompositeReaderContext build() {
            return (CompositeReaderContext)this.build(null, this.reader, 0, 0);
        }

        private IndexReaderContext build(CompositeReaderContext compositeReaderContext, IndexReader object, int n2, int n3) {
            if (object instanceof LeafReader) {
                LeafReader leafReader = (LeafReader)object;
                LeafReaderContext leafReaderContext = new LeafReaderContext(compositeReaderContext, leafReader, n2, n3, this.leaves.size(), this.leafDocBase);
                this.leaves.add(leafReaderContext);
                this.leafDocBase += ((IndexReader)object).maxDoc();
                return leafReaderContext;
            }
            CompositeReader compositeReader = (CompositeReader)object;
            List<? extends IndexReader> list = compositeReader.getSequentialSubReaders();
            object = Arrays.asList(new IndexReaderContext[list.size()]);
            compositeReaderContext = compositeReaderContext == null ? new CompositeReaderContext(compositeReader, (List<IndexReaderContext>)object, this.leaves) : new CompositeReaderContext(compositeReaderContext, compositeReader, n2, n3, (List<IndexReaderContext>)object);
            n2 = 0;
            int n4 = list.size();
            for (n3 = 0; n3 < n4; ++n3) {
                IndexReader indexReader = list.get(n3);
                object.set(n3, this.build(compositeReaderContext, indexReader, n3, n2));
                n2 += indexReader.maxDoc();
            }
            assert (n2 == compositeReader.maxDoc());
            return compositeReaderContext;
        }
    }
}

