/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.e;
import org.apache.lucene.codecs.i;
import org.apache.lucene.codecs.n;
import org.apache.lucene.codecs.p;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.a;
import org.apache.lucene.index.m;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.b;

public abstract class CodecReader
extends LeafReader
implements org.apache.lucene.util.a {
    final CloseableThreadLocal<Map<String, Object>> docValuesLocal = new CloseableThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };
    final CloseableThreadLocal<Map<String, Bits>> docsWithFieldLocal = new CloseableThreadLocal<Map<String, Bits>>(){

        @Override
        protected Map<String, Bits> initialValue() {
            return new HashMap<String, Bits>();
        }
    };
    final CloseableThreadLocal<Map<String, m>> normsLocal = new CloseableThreadLocal<Map<String, m>>(){

        @Override
        protected Map<String, m> initialValue() {
            return new HashMap<String, m>();
        }
    };

    protected CodecReader() {
    }

    public abstract n getFieldsReader();

    public abstract p getTermVectorsReader();

    public abstract i getNormsReader();

    public abstract org.apache.lucene.codecs.b getDocValuesReader();

    public abstract e getPostingsReader();

    @Override
    public final void document(int n2, StoredFieldVisitor storedFieldVisitor) throws IOException {
        this.checkBounds(n2);
        this.getFieldsReader().visitDocument(n2, storedFieldVisitor);
    }

    private void checkBounds(int n2) {
        if (n2 < 0 || n2 >= this.maxDoc()) {
            throw new IndexOutOfBoundsException("docID must be >= 0 and < maxDoc=" + this.maxDoc() + " (got docID=" + n2 + ")");
        }
    }

    @Override
    public final Fields fields() {
        return this.getPostingsReader();
    }

    private FieldInfo getDVField(String object, DocValuesType docValuesType) {
        object = this.getFieldInfos().fieldInfo((String)object);
        if (object == null) {
            return null;
        }
        if (((FieldInfo)object).getDocValuesType() == DocValuesType.NONE) {
            return null;
        }
        if (((FieldInfo)object).getDocValuesType() != docValuesType) {
            return null;
        }
        return object;
    }

    @Override
    public final m getNumericDocValues(String string) throws IOException {
        this.ensureOpen();
        Map<String, Object> map = this.docValuesLocal.get();
        Object object = map.get(string);
        if (object != null && object instanceof m) {
            return (m)object;
        }
        object = this.getDVField(string, DocValuesType.NUMERIC);
        if (object == null) {
            return null;
        }
        object = this.getDocValuesReader().getNumeric((FieldInfo)object);
        map.put(string, object);
        return object;
    }

    @Override
    public final Bits getDocsWithField(String string) throws IOException {
        this.ensureOpen();
        Map<String, Bits> map = this.docsWithFieldLocal.get();
        Object object = map.get(string);
        if (object != null) {
            return object;
        }
        object = this.getFieldInfos().fieldInfo(string);
        if (object == null) {
            return null;
        }
        if (((FieldInfo)object).getDocValuesType() == DocValuesType.NONE) {
            return null;
        }
        object = this.getDocValuesReader().getDocsWithField((FieldInfo)object);
        map.put(string, (Bits)object);
        return object;
    }

    @Override
    public final a getBinaryDocValues(String string) throws IOException {
        this.ensureOpen();
        FieldInfo fieldInfo = this.getDVField(string, DocValuesType.BINARY);
        if (fieldInfo == null) {
            return null;
        }
        Map<String, Object> map = this.docValuesLocal.get();
        a a2 = (a)map.get(string);
        if (a2 == null) {
            a2 = this.getDocValuesReader().getBinary(fieldInfo);
            map.put(string, a2);
        }
        return a2;
    }

    @Override
    public final SortedDocValues getSortedDocValues(String string) throws IOException {
        this.ensureOpen();
        Map<String, Object> map = this.docValuesLocal.get();
        Object object = map.get(string);
        if (object != null && object instanceof SortedDocValues) {
            return (SortedDocValues)object;
        }
        object = this.getDVField(string, DocValuesType.SORTED);
        if (object == null) {
            return null;
        }
        object = this.getDocValuesReader().getSorted((FieldInfo)object);
        map.put(string, object);
        return object;
    }

    @Override
    public final m getNormValues(String string) throws IOException {
        this.ensureOpen();
        Map<String, m> map = this.normsLocal.get();
        Object object = map.get(string);
        if (object != null) {
            return object;
        }
        object = this.getFieldInfos().fieldInfo(string);
        if (object == null || !((FieldInfo)object).hasNorms()) {
            return null;
        }
        object = this.getNormsReader().getNorms((FieldInfo)object);
        map.put(string, (m)object);
        return object;
    }

    @Override
    protected void doClose() throws IOException {
        IOUtils.close(this.docValuesLocal, this.docsWithFieldLocal, this.normsLocal);
    }

    @Override
    public long ramBytesUsed() {
        this.ensureOpen();
        long l2 = this.getPostingsReader().ramBytesUsed();
        if (this.getNormsReader() != null) {
            l2 += this.getNormsReader().ramBytesUsed();
        }
        if (this.getDocValuesReader() != null) {
            l2 += this.getDocValuesReader().ramBytesUsed();
        }
        if (this.getFieldsReader() != null) {
            l2 += this.getFieldsReader().ramBytesUsed();
        }
        if (this.getTermVectorsReader() != null) {
            l2 += this.getTermVectorsReader().ramBytesUsed();
        }
        return l2;
    }

    @Override
    public Collection<org.apache.lucene.util.a> getChildResources() {
        this.ensureOpen();
        ArrayList<org.apache.lucene.util.a> arrayList = new ArrayList<org.apache.lucene.util.a>();
        arrayList.add(b.a("postings", this.getPostingsReader()));
        if (this.getNormsReader() != null) {
            arrayList.add(b.a("norms", this.getNormsReader()));
        }
        if (this.getDocValuesReader() != null) {
            arrayList.add(b.a("docvalues", this.getDocValuesReader()));
        }
        if (this.getFieldsReader() != null) {
            arrayList.add(b.a("stored fields", this.getFieldsReader()));
        }
        if (this.getTermVectorsReader() != null) {
            arrayList.add(b.a("term vectors", this.getTermVectorsReader()));
        }
        return Collections.unmodifiableList(arrayList);
    }
}

