/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.ByteBlockPool;

final class ByteSliceReader
extends DataInput {
    ByteBlockPool pool;
    int bufferUpto;
    byte[] buffer;
    public int upto;
    int limit;
    int level;
    public int bufferOffset;
    public int endIndex;

    ByteSliceReader() {
    }

    public final void init(ByteBlockPool byteBlockPool, int n2, int n3) {
        assert (n3 - n2 >= 0);
        assert (n2 >= 0);
        assert (n3 >= 0);
        this.pool = byteBlockPool;
        this.endIndex = n3;
        this.level = 0;
        this.bufferUpto = n2 / 32768;
        this.bufferOffset = this.bufferUpto << 15;
        this.buffer = byteBlockPool.buffers[this.bufferUpto];
        this.upto = n2 & Short.MAX_VALUE;
        int n4 = ByteBlockPool.LEVEL_SIZE_ARRAY[0];
        if (n2 + n4 >= n3) {
            this.limit = n3 & Short.MAX_VALUE;
            return;
        }
        this.limit = this.upto + n4 - 4;
    }

    public final boolean eof() {
        assert (this.upto + this.bufferOffset <= this.endIndex);
        return this.upto + this.bufferOffset == this.endIndex;
    }

    @Override
    public final byte readByte() {
        assert (!this.eof());
        assert (this.upto <= this.limit);
        if (this.upto == this.limit) {
            this.nextSlice();
        }
        return this.buffer[this.upto++];
    }

    public final void nextSlice() {
        int n2 = ((this.buffer[this.limit] & 0xFF) << 24) + ((this.buffer[1 + this.limit] & 0xFF) << 16) + ((this.buffer[2 + this.limit] & 0xFF) << 8) + (this.buffer[3 + this.limit] & 0xFF);
        this.level = ByteBlockPool.NEXT_LEVEL_ARRAY[this.level];
        int n3 = ByteBlockPool.LEVEL_SIZE_ARRAY[this.level];
        this.bufferUpto = n2 / 32768;
        this.bufferOffset = this.bufferUpto << 15;
        this.buffer = this.pool.buffers[this.bufferUpto];
        this.upto = n2 & Short.MAX_VALUE;
        if (n2 + n3 >= this.endIndex) {
            assert (this.endIndex - n2 > 0);
            this.limit = this.endIndex - this.bufferOffset;
            return;
        }
        this.limit = this.upto + n3 - 4;
    }

    @Override
    public final void readBytes(byte[] byArray, int n2, int n3) {
        while (n3 > 0) {
            int n4 = this.limit - this.upto;
            if (n4 < n3) {
                System.arraycopy(this.buffer, this.upto, byArray, n2, n4);
                n2 += n4;
                n3 -= n4;
                this.nextSlice();
                continue;
            }
            System.arraycopy(this.buffer, this.upto, byArray, n2, n3);
            this.upto += n3;
            return;
        }
    }
}

