/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.CoalescedUpdates;
import org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.lucene.index.DocValuesUpdate;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FrozenBufferedUpdates;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.ReadersAndUpdates;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.e;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.PriorityQueue;

class BufferedUpdatesStream
implements org.apache.lucene.util.a {
    private final List<FrozenBufferedUpdates> updates = new ArrayList<FrozenBufferedUpdates>();
    private long nextGen = 1L;
    private BytesRef lastDeleteTerm;
    private final InfoStream infoStream;
    private final AtomicLong bytesUsed = new AtomicLong();
    private final AtomicInteger numTerms = new AtomicInteger();
    private static final Comparator<SegmentCommitInfo> sortSegInfoByDelGen = new Comparator<SegmentCommitInfo>(){

        @Override
        public final /* synthetic */ int compare(Object object, Object object2) {
            object2 = (SegmentCommitInfo)object2;
            return Long.compare(((SegmentCommitInfo)object).getBufferedDeletesGen(), ((SegmentCommitInfo)object2).getBufferedDeletesGen());
        }
    };

    public BufferedUpdatesStream(InfoStream infoStream) {
        this.infoStream = infoStream;
    }

    public synchronized long push(FrozenBufferedUpdates frozenBufferedUpdates) {
        frozenBufferedUpdates.setDelGen(this.nextGen++);
        assert (frozenBufferedUpdates.any());
        assert (this.checkDeleteStats());
        assert (frozenBufferedUpdates.delGen() < this.nextGen);
        assert (this.updates.isEmpty() || this.updates.get(this.updates.size() - 1).delGen() < frozenBufferedUpdates.delGen()) : "Delete packets must be in order";
        this.updates.add(frozenBufferedUpdates);
        this.numTerms.addAndGet(frozenBufferedUpdates.numTermDeletes);
        this.bytesUsed.addAndGet(frozenBufferedUpdates.bytesUsed);
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", "push deletes " + frozenBufferedUpdates + " segmentPrivate?=" + frozenBufferedUpdates.isSegmentPrivate + " delGen=" + frozenBufferedUpdates.delGen() + " packetCount=" + this.updates.size() + " totBytesUsed=" + this.bytesUsed.get());
        }
        assert (this.checkDeleteStats());
        return frozenBufferedUpdates.delGen();
    }

    public synchronized void clear() {
        this.updates.clear();
        this.nextGen = 1L;
        this.numTerms.set(0);
        this.bytesUsed.set(0L);
    }

    public boolean any() {
        return this.bytesUsed.get() != 0L;
    }

    public int numTerms() {
        return this.numTerms.get();
    }

    @Override
    public long ramBytesUsed() {
        return this.bytesUsed.get();
    }

    @Override
    public Collection<org.apache.lucene.util.a> getChildResources() {
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized ApplyDeletesResult applyDeletesAndUpdates(IndexWriter.ReaderPool readerPool, List<SegmentCommitInfo> list) throws IOException {
        ApplyDeletesResult applyDeletesResult;
        long l2;
        long l3;
        long l4;
        long l5;
        block26: {
            l5 = System.currentTimeMillis();
            l4 = this.nextGen++;
            if (list.size() == 0) {
                return new ApplyDeletesResult(false, l4, null);
            }
            SegmentState[] segmentStateArray = null;
            l3 = 0L;
            l2 = 0L;
            applyDeletesResult = null;
            try {
                if (this.infoStream.isEnabled("BD")) {
                    this.infoStream.message("BD", String.format(Locale.ROOT, "applyDeletes: open segment readers took %d msec", System.currentTimeMillis() - l5));
                }
                assert (this.checkDeleteStats());
                if (!this.any()) {
                    if (!this.infoStream.isEnabled("BD")) return new ApplyDeletesResult(false, l4, null);
                    this.infoStream.message("BD", "applyDeletes: no segments; skipping");
                    return new ApplyDeletesResult(false, l4, null);
                }
                if (this.infoStream.isEnabled("BD")) {
                    this.infoStream.message("BD", "applyDeletes: infos=" + list + " packetCount=" + this.updates.size());
                }
                list = this.sortByDelGen(list);
                CoalescedUpdates coalescedUpdates = null;
                int n2 = list.size() - 1;
                int n3 = this.updates.size() - 1;
                while (n2 >= 0) {
                    DocValuesFieldUpdates.Container container;
                    int n4;
                    FrozenBufferedUpdates frozenBufferedUpdates = n3 >= 0 ? this.updates.get(n3) : null;
                    SegmentCommitInfo segmentCommitInfo = list.get(n2);
                    long l6 = segmentCommitInfo.getBufferedDeletesGen();
                    if (frozenBufferedUpdates != null && l6 < frozenBufferedUpdates.delGen()) {
                        if (!frozenBufferedUpdates.isSegmentPrivate && frozenBufferedUpdates.any()) {
                            if (coalescedUpdates == null) {
                                coalescedUpdates = new CoalescedUpdates();
                            }
                            coalescedUpdates.update(frozenBufferedUpdates);
                        }
                        --n3;
                        continue;
                    }
                    if (frozenBufferedUpdates != null && l6 == frozenBufferedUpdates.delGen()) {
                        assert (frozenBufferedUpdates.isSegmentPrivate) : "Packet and Segments deletegen can only match on a segment private del packet gen=" + l6;
                        if (segmentStateArray == null) {
                            segmentStateArray = this.openSegmentStates(readerPool, list);
                        }
                        SegmentState segmentState = segmentStateArray[n2];
                        assert (readerPool.infoIsLive(segmentCommitInfo));
                        n4 = 0;
                        container = new DocValuesFieldUpdates.Container();
                        if (coalescedUpdates != null) {
                            n4 = (int)(0L + BufferedUpdatesStream.applyQueryDeletes(coalescedUpdates.queriesIterable(), segmentState));
                            this.applyDocValuesUpdates(coalescedUpdates.numericDVUpdates, segmentState, container);
                            this.applyDocValuesUpdates(coalescedUpdates.binaryDVUpdates, segmentState, container);
                        }
                        n4 = (int)((long)n4 + BufferedUpdatesStream.applyQueryDeletes(frozenBufferedUpdates.queriesIterable(), segmentState));
                        this.applyDocValuesUpdates(Arrays.asList(frozenBufferedUpdates.numericDVUpdates), segmentState, container);
                        this.applyDocValuesUpdates(Arrays.asList(frozenBufferedUpdates.binaryDVUpdates), segmentState, container);
                        if (container.any()) {
                            segmentState.rld.writeFieldUpdates(segmentCommitInfo.info.dir, container);
                        }
                        l3 += (long)n4;
                        --n3;
                    } else if (coalescedUpdates != null) {
                        if (segmentStateArray == null) {
                            segmentStateArray = this.openSegmentStates(readerPool, list);
                        }
                        SegmentState segmentState = segmentStateArray[n2];
                        assert (readerPool.infoIsLive(segmentCommitInfo));
                        n4 = (int)(0L + BufferedUpdatesStream.applyQueryDeletes(coalescedUpdates.queriesIterable(), segmentState));
                        container = new DocValuesFieldUpdates.Container();
                        this.applyDocValuesUpdates(coalescedUpdates.numericDVUpdates, segmentState, container);
                        this.applyDocValuesUpdates(coalescedUpdates.binaryDVUpdates, segmentState, container);
                        if (container.any()) {
                            segmentState.rld.writeFieldUpdates(segmentCommitInfo.info.dir, container);
                        }
                        l3 += (long)n4;
                    }
                    --n2;
                }
                if (coalescedUpdates != null && coalescedUpdates.totalTermCount != 0L) {
                    if (segmentStateArray == null) {
                        segmentStateArray = this.openSegmentStates(readerPool, list);
                    }
                    l2 = 0L + this.applyTermDeletes(coalescedUpdates, segmentStateArray);
                }
                assert (this.checkDeleteStats());
                if (segmentStateArray == null) break block26;
            }
            catch (Throwable throwable) {
                if (segmentStateArray == null) throw throwable;
                this.closeSegmentStates(readerPool, segmentStateArray, false, l4);
                throw throwable;
            }
            applyDeletesResult = this.closeSegmentStates(readerPool, segmentStateArray, true, l4);
        }
        if (applyDeletesResult == null) {
            applyDeletesResult = new ApplyDeletesResult(false, l4, null);
        }
        if (!this.infoStream.isEnabled("BD")) return applyDeletesResult;
        this.infoStream.message("BD", String.format(Locale.ROOT, "applyDeletes took %d msec for %d segments, %d newly deleted docs (query deletes), %d visited terms, allDeleted=%s", System.currentTimeMillis() - l5, list.size(), l3, l2, applyDeletesResult.allDeleted));
        return applyDeletesResult;
    }

    private List<SegmentCommitInfo> sortByDelGen(List<SegmentCommitInfo> list) {
        list = new ArrayList<SegmentCommitInfo>(list);
        Collections.sort(list, sortSegInfoByDelGen);
        return list;
    }

    synchronized long getNextGen() {
        return this.nextGen++;
    }

    public synchronized void prune(SegmentInfos segmentInfos) {
        assert (this.checkDeleteStats());
        long l2 = Long.MAX_VALUE;
        Iterator<SegmentCommitInfo> iterator = segmentInfos.iterator();
        while (iterator.hasNext()) {
            l2 = Math.min(iterator.next().getBufferedDeletesGen(), l2);
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", "prune sis=" + segmentInfos + " minGen=" + l2 + " packetCount=" + this.updates.size());
        }
        int n2 = this.updates.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.updates.get(i2).delGen() < l2) continue;
            this.prune(i2);
            assert (this.checkDeleteStats());
            return;
        }
        this.prune(n2);
        assert (!this.any());
        assert (this.checkDeleteStats());
    }

    private synchronized void prune(int n2) {
        if (n2 > 0) {
            if (this.infoStream.isEnabled("BD")) {
                this.infoStream.message("BD", "pruneDeletes: prune " + n2 + " packets; " + (this.updates.size() - n2) + " packets remain");
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                FrozenBufferedUpdates frozenBufferedUpdates = this.updates.get(i2);
                this.numTerms.addAndGet(-frozenBufferedUpdates.numTermDeletes);
                assert (this.numTerms.get() >= 0);
                this.bytesUsed.addAndGet(-frozenBufferedUpdates.bytesUsed);
                assert (this.bytesUsed.get() >= 0L);
            }
            this.updates.subList(0, n2).clear();
        }
    }

    private SegmentState[] openSegmentStates(IndexWriter.ReaderPool readerPool, List<SegmentCommitInfo> list) throws IOException {
        int n2 = list.size();
        SegmentState[] segmentStateArray = new SegmentState[n2];
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                segmentStateArray[i2] = new SegmentState(readerPool, list.get(i2));
            }
        }
        catch (Throwable throwable) {
            for (int i3 = 0; i3 < n2; ++i3) {
                if (segmentStateArray[i3] == null) continue;
                try {
                    segmentStateArray[i3].finish(readerPool);
                    continue;
                }
                catch (Throwable throwable2) {}
            }
            throw throwable;
        }
        return segmentStateArray;
    }

    private ApplyDeletesResult closeSegmentStates(IndexWriter.ReaderPool readerPool, SegmentState[] segmentStateArray, boolean bl, long l2) throws IOException {
        int n2 = segmentStateArray.length;
        ArrayList<SegmentCommitInfo> arrayList = null;
        long l3 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            SegmentState segmentState = segmentStateArray[i2];
            if (bl) {
                l3 += (long)(segmentState.rld.getPendingDeleteCount() - segmentState.startDelCount);
                segmentState.reader.getSegmentInfo().setBufferedDeletesGen(l2);
                int n3 = segmentState.rld.info.getDelCount() + segmentState.rld.getPendingDeleteCount();
                assert (n3 <= segmentState.rld.info.info.maxDoc());
                if (n3 == segmentState.rld.info.info.maxDoc()) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<SegmentCommitInfo>();
                    }
                    arrayList.add(segmentState.reader.getSegmentInfo());
                }
            }
            try {
                segmentStateArray[i2].finish(readerPool);
                continue;
            }
            catch (Throwable throwable) {}
        }
        if (bl) {
            IOUtils.reThrow(null);
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", "applyDeletes: " + l3 + " new deleted documents");
        }
        return new ApplyDeletesResult(l3 > 0L, l2, arrayList);
    }

    private synchronized long applyTermDeletes(CoalescedUpdates coalescedUpdates, SegmentState[] segmentStateArray) throws IOException {
        BytesRef bytesRef;
        long l2 = System.nanoTime();
        int n2 = segmentStateArray.length;
        long l3 = 0L;
        long l4 = 0L;
        e e2 = coalescedUpdates.termIterator();
        String string = null;
        a a2 = null;
        block0: while ((bytesRef = e2.next()) != null) {
            Object object;
            if (e2.field() != string) {
                string = e2.field();
                a2 = new a(n2);
                for (int i2 = 0; i2 < n2; ++i2) {
                    SegmentState segmentState = segmentStateArray[i2];
                    object = segmentState.reader.fields().terms(string);
                    if (object == null) continue;
                    ((Terms)object).size();
                    segmentState.termsEnum = ((Terms)object).iterator();
                    segmentState.term = segmentState.termsEnum.next();
                    if (segmentState.term == null) continue;
                    a2.add(segmentState);
                }
                assert (this.checkDeleteTerm(null));
            }
            assert (this.checkDeleteTerm(bytesRef));
            ++l3;
            long l5 = e2.delGen();
            while (a2.size() != 0) {
                SegmentState segmentState = (SegmentState)a2.top();
                ++l4;
                int n3 = bytesRef.compareTo(segmentState.term);
                if (n3 < 0) continue block0;
                if (n3 != 0 && (object = segmentState.termsEnum.seekCeil(bytesRef)) != TermsEnum.SeekStatus.FOUND) {
                    if (object == TermsEnum.SeekStatus.NOT_FOUND) {
                        segmentState.term = segmentState.termsEnum.term();
                        a2.updateTop();
                        continue;
                    }
                    a2.pop();
                    continue;
                }
                assert (segmentState.delGen != l5);
                if (segmentState.delGen < l5) {
                    object = segmentState.rld.getLiveDocs();
                    segmentState.postingsEnum = segmentState.termsEnum.postings(segmentState.postingsEnum, 0);
                    assert (segmentState.postingsEnum != null);
                    while ((n3 = segmentState.postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                        if (object != null && !object.get(n3)) continue;
                        if (!segmentState.any) {
                            segmentState.rld.initWritableLiveDocs();
                            segmentState.any = true;
                        }
                        segmentState.rld.delete(n3);
                    }
                }
                segmentState.term = segmentState.termsEnum.next();
                if (segmentState.term == null) {
                    a2.pop();
                    continue;
                }
                a2.updateTop();
            }
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", String.format(Locale.ROOT, "applyTermDeletes took %.1f msec for %d segments and %d packets; %d del terms visited; %d seg terms visited", (double)(System.nanoTime() - l2) / 1000000.0, n2, coalescedUpdates.terms.size(), l3, l4));
        }
        return l3;
    }

    private synchronized void applyDocValuesUpdates(Iterable<? extends DocValuesUpdate> object, SegmentState segmentState, DocValuesFieldUpdates.Container container) throws IOException {
        Fields fields = segmentState.reader.fields();
        String string = null;
        TermsEnum termsEnum = null;
        PostingsEnum postingsEnum = null;
        object = object.iterator();
        while (object.hasNext()) {
            int n2;
            Object object2;
            DocValuesUpdate docValuesUpdate = (DocValuesUpdate)object.next();
            Object object3 = docValuesUpdate.term;
            int n3 = docValuesUpdate.docIDUpto;
            if (!((Term)object3).field().equals(string)) {
                string = ((Term)object3).field();
                object2 = fields.terms(string);
                termsEnum = object2 != null ? ((Terms)object2).iterator() : null;
            }
            if (termsEnum == null || !termsEnum.seekExact(((Term)object3).bytes())) continue;
            object2 = segmentState.rld.getLiveDocs();
            postingsEnum = termsEnum.postings(postingsEnum, 0);
            object3 = container.getUpdates(docValuesUpdate.field, docValuesUpdate.type);
            if (object3 == null) {
                object3 = container.newUpdates(docValuesUpdate.field, docValuesUpdate.type, segmentState.reader.maxDoc());
            }
            while ((n2 = postingsEnum.nextDoc()) != Integer.MAX_VALUE && n2 < n3) {
                if (object2 != null && !object2.get(n2)) continue;
                ((DocValuesFieldUpdates)object3).add(n2, docValuesUpdate.value);
            }
        }
    }

    private static long applyQueryDeletes(Iterable<QueryAndLimit> object, SegmentState segmentState) throws IOException {
        long l2 = 0L;
        LeafReaderContext leafReaderContext = segmentState.reader.getContext();
        object = object.iterator();
        while (object.hasNext()) {
            int n2;
            QueryAndLimit queryAndLimit = (QueryAndLimit)object.next();
            Object object2 = queryAndLimit.query;
            int n3 = queryAndLimit.limit;
            Object object3 = new IndexSearcher(leafReaderContext.reader());
            ((IndexSearcher)object3).setQueryCache(null);
            if ((object2 = ((IndexSearcher)object3).createNormalizedWeight((Query)object2, false).scorer(leafReaderContext)) == null) continue;
            object3 = leafReaderContext.reader().getLiveDocs();
            while ((n2 = ((DocIdSetIterator)object2).nextDoc()) < n3) {
                if (object3 != null && !object3.get(n2)) continue;
                if (!segmentState.any) {
                    segmentState.rld.initWritableLiveDocs();
                    segmentState.any = true;
                }
                if (!segmentState.rld.delete(n2)) continue;
                ++l2;
            }
        }
        return l2;
    }

    private boolean checkDeleteTerm(BytesRef bytesRef) {
        if (bytesRef != null) assert (this.lastDeleteTerm == null || bytesRef.compareTo(this.lastDeleteTerm) >= 0) : "lastTerm=" + this.lastDeleteTerm + " vs term=" + bytesRef;
        this.lastDeleteTerm = bytesRef == null ? null : BytesRef.deepCopyOf(bytesRef);
        return true;
    }

    private boolean checkDeleteStats() {
        int n2 = 0;
        long l2 = 0L;
        for (FrozenBufferedUpdates frozenBufferedUpdates : this.updates) {
            n2 += frozenBufferedUpdates.numTermDeletes;
            l2 += (long)frozenBufferedUpdates.bytesUsed;
        }
        assert (n2 == this.numTerms.get()) : "numTerms2=" + n2 + " vs " + this.numTerms.get();
        assert (l2 == this.bytesUsed.get()) : "bytesUsed2=" + l2 + " vs " + this.bytesUsed;
        return true;
    }

    public static class QueryAndLimit {
        public final Query query;
        public final int limit;

        public QueryAndLimit(Query query, int n2) {
            this.query = query;
            this.limit = n2;
        }
    }

    static final class a
    extends PriorityQueue<SegmentState> {
        public a(int n2) {
            super(n2);
        }

        @Override
        protected final /* synthetic */ boolean lessThan(Object object, Object object2) {
            object2 = (SegmentState)object2;
            return ((SegmentState)object).term.compareTo(((SegmentState)object2).term) < 0;
        }
    }

    static class SegmentState {
        final long delGen;
        final ReadersAndUpdates rld;
        final SegmentReader reader;
        final int startDelCount;
        TermsEnum termsEnum;
        PostingsEnum postingsEnum;
        BytesRef term;
        boolean any;

        public SegmentState(IndexWriter.ReaderPool readerPool, SegmentCommitInfo segmentCommitInfo) throws IOException {
            this.rld = readerPool.get(segmentCommitInfo, true);
            this.startDelCount = this.rld.getPendingDeleteCount();
            this.reader = this.rld.getReader(IOContext.READ);
            this.delGen = segmentCommitInfo.getBufferedDeletesGen();
        }

        public void finish(IndexWriter.ReaderPool readerPool) throws IOException {
            try {
                this.rld.release(this.reader);
                return;
            }
            finally {
                readerPool.release(this.rld);
            }
        }
    }

    public static class ApplyDeletesResult {
        public final boolean anyDeletes;
        public final long gen;
        public final List<SegmentCommitInfo> allDeleted;

        ApplyDeletesResult(boolean bl, long l2, List<SegmentCommitInfo> list) {
            this.anyDeletes = bl;
            this.gen = l2;
            this.allDeleted = list;
        }
    }
}

