/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.DocValuesUpdate;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.RamUsageEstimator;

class BufferedUpdates {
    static final int BYTES_PER_DEL_TERM = 9 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + 7 * RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 40;
    static final int BYTES_PER_DEL_DOCID = 2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 4;
    static final int BYTES_PER_DEL_QUERY = 5 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + 2 * RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8 + 24;
    static final int BYTES_PER_NUMERIC_FIELD_ENTRY = 7 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + 3 * RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + 20 + 4;
    static final int BYTES_PER_NUMERIC_UPDATE_ENTRY = 7 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 4;
    static final int BYTES_PER_BINARY_FIELD_ENTRY = 7 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + 3 * RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + 20 + 4;
    static final int BYTES_PER_BINARY_UPDATE_ENTRY = 7 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 4;
    final AtomicInteger numTermDeletes = new AtomicInteger();
    final AtomicInteger numNumericUpdates = new AtomicInteger();
    final AtomicInteger numBinaryUpdates = new AtomicInteger();
    final Map<Term, Integer> terms = new HashMap<Term, Integer>();
    final Map<Query, Integer> queries = new HashMap<Query, Integer>();
    final List<Integer> docIDs = new ArrayList<Integer>();
    final Map<String, LinkedHashMap<Term, DocValuesUpdate.a>> numericUpdates = new HashMap<String, LinkedHashMap<Term, DocValuesUpdate.a>>();
    final Map<String, LinkedHashMap<Term, DocValuesUpdate.BinaryDocValuesUpdate>> binaryUpdates = new HashMap<String, LinkedHashMap<Term, DocValuesUpdate.BinaryDocValuesUpdate>>();
    public static final Integer MAX_INT = Integer.MAX_VALUE;
    final AtomicLong bytesUsed = new AtomicLong();
    long gen;

    public String toString() {
        String string = "gen=" + this.gen;
        if (this.numTermDeletes.get() != 0) {
            string = string + " " + this.numTermDeletes.get() + " deleted terms (unique count=" + this.terms.size() + ")";
        }
        if (this.queries.size() != 0) {
            string = string + " " + this.queries.size() + " deleted queries";
        }
        if (this.docIDs.size() != 0) {
            string = string + " " + this.docIDs.size() + " deleted docIDs";
        }
        if (this.numNumericUpdates.get() != 0) {
            string = string + " " + this.numNumericUpdates.get() + " numeric updates (unique count=" + this.numericUpdates.size() + ")";
        }
        if (this.numBinaryUpdates.get() != 0) {
            string = string + " " + this.numBinaryUpdates.get() + " binary updates (unique count=" + this.binaryUpdates.size() + ")";
        }
        if (this.bytesUsed.get() != 0L) {
            string = string + " bytesUsed=" + this.bytesUsed.get();
        }
        return string;
    }

    public void addQuery(Query query, int n2) {
        if (this.queries.put(query, n2) == null) {
            this.bytesUsed.addAndGet(BYTES_PER_DEL_QUERY);
        }
    }

    public void addDocID(int n2) {
        this.docIDs.add(n2);
        this.bytesUsed.addAndGet(BYTES_PER_DEL_DOCID);
    }

    public void addTerm(Term term, int n2) {
        Integer n3 = this.terms.get(term);
        if (n3 != null && n2 < n3) {
            return;
        }
        this.terms.put(term, n2);
        this.numTermDeletes.incrementAndGet();
        if (n3 == null) {
            this.bytesUsed.addAndGet(BYTES_PER_DEL_TERM + term.bytes.length + 2 * term.field().length());
        }
    }

    void clear() {
        this.terms.clear();
        this.queries.clear();
        this.docIDs.clear();
        this.numericUpdates.clear();
        this.binaryUpdates.clear();
        this.numTermDeletes.set(0);
        this.numNumericUpdates.set(0);
        this.numBinaryUpdates.set(0);
        this.bytesUsed.set(0L);
    }

    boolean any() {
        return this.terms.size() > 0 || this.docIDs.size() > 0 || this.queries.size() > 0 || this.numericUpdates.size() > 0 || this.binaryUpdates.size() > 0;
    }
}

