/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.c;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedLongValues;

class BinaryDocValuesWriter
extends c {
    private static final int MAX_LENGTH = ArrayUtil.MAX_ARRAY_LENGTH;
    private final PagedBytes bytes;
    private final DataOutput bytesOut;
    private final Counter iwBytesUsed;
    private final PackedLongValues.Builder lengths;
    private FixedBitSet docsWithField;
    private final FieldInfo fieldInfo;
    private int addedValues;
    private long bytesUsed;

    public BinaryDocValuesWriter(FieldInfo fieldInfo, Counter counter) {
        this.fieldInfo = fieldInfo;
        this.bytes = new PagedBytes(15);
        this.bytesOut = this.bytes.getDataOutput();
        this.lengths = PackedLongValues.deltaPackedBuilder(0.0f);
        this.iwBytesUsed = counter;
        this.docsWithField = new FixedBitSet(64);
        this.bytesUsed = this.docsWithFieldBytesUsed();
        counter.addAndGet(this.bytesUsed);
    }

    public void addValue(int n2, BytesRef bytesRef) {
        if (n2 < this.addedValues) {
            throw new IllegalArgumentException("DocValuesField \"" + this.fieldInfo.name + "\" appears more than once in this document (only one value is allowed per field)");
        }
        if (bytesRef == null) {
            throw new IllegalArgumentException("field=\"" + this.fieldInfo.name + "\": null value not allowed");
        }
        if (bytesRef.length > MAX_LENGTH) {
            throw new IllegalArgumentException("DocValuesField \"" + this.fieldInfo.name + "\" is too large, must be <= " + MAX_LENGTH);
        }
        while (this.addedValues < n2) {
            ++this.addedValues;
            this.lengths.add(0L);
        }
        ++this.addedValues;
        this.lengths.add(bytesRef.length);
        try {
            this.bytesOut.writeBytes(bytesRef.bytes, bytesRef.offset, bytesRef.length);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.docsWithField = FixedBitSet.ensureCapacity(this.docsWithField, n2);
        this.docsWithField.set(n2);
        this.updateBytesUsed();
    }

    private long docsWithFieldBytesUsed() {
        return RamUsageEstimator.sizeOf(this.docsWithField.getBits()) + 64L;
    }

    private void updateBytesUsed() {
        long l2 = this.lengths.ramBytesUsed() + this.bytes.ramBytesUsed() + this.docsWithFieldBytesUsed();
        this.iwBytesUsed.addAndGet(l2 - this.bytesUsed);
        this.bytesUsed = l2;
    }

    @Override
    public void finish(int n2) {
    }

    @Override
    public void flush(SegmentWriteState segmentWriteState, DocValuesConsumer docValuesConsumer) throws IOException {
        final int n2 = segmentWriteState.segmentInfo.maxDoc();
        this.bytes.freeze(false);
        final PackedLongValues packedLongValues = this.lengths.build();
        docValuesConsumer.addBinaryField(this.fieldInfo, new Iterable<BytesRef>(){

            @Override
            public Iterator<BytesRef> iterator() {
                return new BytesIterator(n2, packedLongValues);
            }
        });
    }

    static /* synthetic */ PagedBytes access$000(BinaryDocValuesWriter binaryDocValuesWriter) {
        return binaryDocValuesWriter.bytes;
    }

    static /* synthetic */ PackedLongValues.Builder access$100(BinaryDocValuesWriter binaryDocValuesWriter) {
        return binaryDocValuesWriter.lengths;
    }

    private class BytesIterator
    implements Iterator<BytesRef> {
        final BytesRefBuilder value = new BytesRefBuilder();
        final PackedLongValues.Iterator lengthsIterator;
        final DataInput bytesIterator = BinaryDocValuesWriter.access$000(BinaryDocValuesWriter.this).getDataInput();
        final int size = (int)BinaryDocValuesWriter.access$100(BinaryDocValuesWriter.this).size();
        final int maxDoc;
        int upto;

        BytesIterator(int n2, PackedLongValues packedLongValues) {
            this.maxDoc = n2;
            this.lengthsIterator = packedLongValues.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.upto < this.maxDoc;
        }

        @Override
        public BytesRef next() {
            BytesRef bytesRef;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.upto < this.size) {
                int n2 = (int)this.lengthsIterator.next();
                this.value.grow(n2);
                this.value.setLength(n2);
                try {
                    this.bytesIterator.readBytes(this.value.bytes(), 0, this.value.length());
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                bytesRef = BinaryDocValuesWriter.this.docsWithField.get(this.upto) ? this.value.get() : null;
            } else {
                bytesRef = null;
            }
            ++this.upto;
            return bytesRef;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

