/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.f;
import org.apache.lucene.util.packed.PackedInts;
import org.apache.lucene.util.packed.PagedGrowableWriter;
import org.apache.lucene.util.packed.PagedMutable;

class BinaryDocValuesFieldUpdates
extends DocValuesFieldUpdates {
    private PagedMutable docs;
    private PagedGrowableWriter offsets;
    private PagedGrowableWriter lengths;
    private BytesRefBuilder values;
    private int size;
    private final int bitsPerValue;

    public BinaryDocValuesFieldUpdates(String string, int n2) {
        super(string, DocValuesType.BINARY);
        this.bitsPerValue = PackedInts.bitsRequired(n2 - 1);
        this.docs = new PagedMutable(1L, 1024, this.bitsPerValue, 0.0f);
        this.offsets = new PagedGrowableWriter(1L, 1024, 1, 0.5f);
        this.lengths = new PagedGrowableWriter(1L, 1024, 1, 0.5f);
        this.values = new BytesRefBuilder();
        this.size = 0;
    }

    @Override
    public void add(int n2, Object object) {
        if (this.size == Integer.MAX_VALUE) {
            throw new IllegalStateException("cannot support more than Integer.MAX_VALUE doc/value entries");
        }
        object = (BytesRef)object;
        if (this.docs.size() == (long)this.size) {
            this.docs = (PagedMutable)this.docs.grow(this.size + 1);
            this.offsets = (PagedGrowableWriter)this.offsets.grow(this.size + 1);
            this.lengths = (PagedGrowableWriter)this.lengths.grow(this.size + 1);
        }
        this.docs.set(this.size, n2);
        this.offsets.set(this.size, this.values.length());
        this.lengths.set(this.size, ((BytesRef)object).length);
        this.values.append((BytesRef)object);
        ++this.size;
    }

    @Override
    public Iterator iterator() {
        final PagedMutable pagedMutable = this.docs;
        final PagedGrowableWriter pagedGrowableWriter = this.offsets;
        final PagedGrowableWriter pagedGrowableWriter2 = this.lengths;
        BytesRef bytesRef = this.values.get();
        new f(){

            @Override
            protected void swap(int n2, int n3) {
                long l2 = pagedMutable.get(n3);
                pagedMutable.set(n3, pagedMutable.get(n2));
                pagedMutable.set(n2, l2);
                long l3 = pagedGrowableWriter.get(n3);
                pagedGrowableWriter.set(n3, pagedGrowableWriter.get(n2));
                pagedGrowableWriter.set(n2, l3);
                long l4 = pagedGrowableWriter2.get(n3);
                pagedGrowableWriter2.set(n3, pagedGrowableWriter2.get(n2));
                pagedGrowableWriter2.set(n2, l4);
            }

            @Override
            protected int compare(int n2, int n3) {
                if ((n2 = (int)pagedMutable.get(n2)) < (n3 = (int)pagedMutable.get(n3))) {
                    return -1;
                }
                if (n2 == n3) {
                    return 0;
                }
                return 1;
            }
        }.sort(0, this.size);
        return new Iterator(this.size, pagedGrowableWriter, pagedGrowableWriter2, pagedMutable, bytesRef);
    }

    @Override
    public void merge(DocValuesFieldUpdates docValuesFieldUpdates) {
        docValuesFieldUpdates = (BinaryDocValuesFieldUpdates)docValuesFieldUpdates;
        int n2 = this.size + ((BinaryDocValuesFieldUpdates)docValuesFieldUpdates).size;
        if (n2 > Integer.MAX_VALUE) {
            throw new IllegalStateException("cannot support more than Integer.MAX_VALUE doc/value entries; size=" + this.size + " other.size=" + ((BinaryDocValuesFieldUpdates)docValuesFieldUpdates).size);
        }
        this.docs = (PagedMutable)this.docs.grow(n2);
        this.offsets = (PagedGrowableWriter)this.offsets.grow(n2);
        this.lengths = (PagedGrowableWriter)this.lengths.grow(n2);
        for (n2 = 0; n2 < ((BinaryDocValuesFieldUpdates)docValuesFieldUpdates).size; ++n2) {
            int n3 = (int)((BinaryDocValuesFieldUpdates)docValuesFieldUpdates).docs.get(n2);
            this.docs.set(this.size, n3);
            this.offsets.set(this.size, (long)this.values.length() + ((BinaryDocValuesFieldUpdates)docValuesFieldUpdates).offsets.get(n2));
            this.lengths.set(this.size, ((BinaryDocValuesFieldUpdates)docValuesFieldUpdates).lengths.get(n2));
            ++this.size;
        }
        this.values.append(((BinaryDocValuesFieldUpdates)docValuesFieldUpdates).values);
    }

    public boolean any() {
        return this.size > 0;
    }

    public long ramBytesPerDoc() {
        long l2 = (long)Math.ceil((double)this.bitsPerValue / 8.0);
        int n2 = BinaryDocValuesFieldUpdates.estimateCapacity(this.size);
        return l2 + (long)Math.ceil((double)this.offsets.ramBytesUsed() / (double)n2) + (long)Math.ceil((double)this.lengths.ramBytesUsed() / (double)n2) + (long)Math.ceil((double)this.values.length() / (double)this.size);
    }

    static final class Iterator
    extends DocValuesFieldUpdates.a {
        private final PagedGrowableWriter offsets;
        private final int size;
        private final PagedGrowableWriter lengths;
        private final PagedMutable docs;
        private long idx = 0L;
        private int doc = -1;
        private final BytesRef value;
        private int offset;
        private int length;

        Iterator(int n2, PagedGrowableWriter pagedGrowableWriter, PagedGrowableWriter pagedGrowableWriter2, PagedMutable pagedMutable, BytesRef bytesRef) {
            this.offsets = pagedGrowableWriter;
            this.size = n2;
            this.lengths = pagedGrowableWriter2;
            this.docs = pagedMutable;
            this.value = bytesRef.clone();
        }

        @Override
        final BytesRef value() {
            this.value.offset = this.offset;
            this.value.length = this.length;
            return this.value;
        }

        @Override
        final int nextDoc() {
            if (this.idx >= (long)this.size) {
                this.offset = -1;
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = (int)this.docs.get(this.idx);
            ++this.idx;
            while (this.idx < (long)this.size && this.docs.get(this.idx) == (long)this.doc) {
                ++this.idx;
            }
            long l2 = this.idx - 1L;
            this.offset = (int)this.offsets.get(l2);
            this.length = (int)this.lengths.get(l2);
            return this.doc;
        }

        @Override
        final int doc() {
            return this.doc;
        }

        @Override
        final void reset() {
            this.doc = -1;
            this.offset = -1;
            this.idx = 0L;
        }
    }
}

