/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.automaton.Transition;
import org.apache.lucene.util.automaton.a;

public class AutomatonTermsEnum
extends FilteredTermsEnum {
    private final a runAutomaton;
    private final BytesRef commonSuffixRef;
    private final boolean finite;
    private final Automaton automaton;
    private final long[] visited;
    private long curGen;
    private final BytesRefBuilder seekBytesRef = new BytesRefBuilder();
    private boolean linear = false;
    private final BytesRef linearUpperBound = new BytesRef(10);
    private Transition transition = new Transition();
    private final IntsRefBuilder savedStates = new IntsRefBuilder();

    public AutomatonTermsEnum(TermsEnum termsEnum, CompiledAutomaton compiledAutomaton) {
        super(termsEnum);
        this.finite = compiledAutomaton.finite;
        this.runAutomaton = compiledAutomaton.runAutomaton;
        assert (this.runAutomaton != null);
        this.commonSuffixRef = compiledAutomaton.commonSuffixRef;
        this.automaton = compiledAutomaton.automaton;
        this.visited = new long[this.runAutomaton.getSize()];
    }

    @Override
    protected FilteredTermsEnum.AcceptStatus accept(BytesRef bytesRef) {
        if (this.commonSuffixRef == null || StringHelper.endsWith(bytesRef, this.commonSuffixRef)) {
            if (this.runAutomaton.a(bytesRef.bytes, bytesRef.offset, bytesRef.length)) {
                if (this.linear) {
                    return FilteredTermsEnum.AcceptStatus.YES;
                }
                return FilteredTermsEnum.AcceptStatus.YES_AND_SEEK;
            }
            if (this.linear && bytesRef.compareTo(this.linearUpperBound) < 0) {
                return FilteredTermsEnum.AcceptStatus.NO;
            }
            return FilteredTermsEnum.AcceptStatus.NO_AND_SEEK;
        }
        if (this.linear && bytesRef.compareTo(this.linearUpperBound) < 0) {
            return FilteredTermsEnum.AcceptStatus.NO;
        }
        return FilteredTermsEnum.AcceptStatus.NO_AND_SEEK;
    }

    @Override
    protected BytesRef nextSeekTerm(BytesRef bytesRef) throws IOException {
        if (bytesRef == null) {
            assert (this.seekBytesRef.length() == 0);
            if (this.runAutomaton.isAccept(this.runAutomaton.getInitialState())) {
                return this.seekBytesRef.get();
            }
        } else {
            this.seekBytesRef.copyBytes(bytesRef);
        }
        if (this.nextString()) {
            return this.seekBytesRef.get();
        }
        return null;
    }

    private void setLinear(int n2) {
        int n3;
        assert (!this.linear);
        int n4 = this.runAutomaton.getInitialState();
        assert (n4 == 0);
        int n5 = 255;
        for (n3 = 0; n3 < n2; ++n3) {
            n4 = this.runAutomaton.step(n4, this.seekBytesRef.byteAt(n3) & 0xFF);
            assert (n4 >= 0) : "state=" + n4;
        }
        n3 = this.automaton.getNumTransitions(n4);
        this.automaton.initTransition(n4, this.transition);
        for (n4 = 0; n4 < n3; ++n4) {
            this.automaton.getNextTransition(this.transition);
            if (this.transition.min > (this.seekBytesRef.byteAt(n2) & 0xFF) || (this.seekBytesRef.byteAt(n2) & 0xFF) > this.transition.max) continue;
            n5 = this.transition.max;
            break;
        }
        if (n5 != 255) {
            ++n5;
        }
        if (this.linearUpperBound.bytes.length < (n4 = n2 + 1)) {
            this.linearUpperBound.bytes = new byte[n4];
        }
        System.arraycopy(this.seekBytesRef.bytes(), 0, this.linearUpperBound.bytes, 0, n2);
        this.linearUpperBound.bytes[n2] = (byte)n5;
        this.linearUpperBound.length = n4;
        this.linear = true;
    }

    private boolean nextString() {
        int n2 = 0;
        this.savedStates.grow(this.seekBytesRef.length() + 1);
        this.savedStates.setIntAt(0, this.runAutomaton.getInitialState());
        while (true) {
            int n3;
            ++this.curGen;
            this.linear = false;
            int n4 = this.savedStates.intAt(n2);
            while (n2 < this.seekBytesRef.length()) {
                this.visited[n4] = this.curGen;
                n3 = this.runAutomaton.step(n4, this.seekBytesRef.byteAt(n2) & 0xFF);
                if (n3 == -1) break;
                this.savedStates.setIntAt(n2 + 1, n3);
                if (!this.finite && !this.linear && this.visited[n3] == this.curGen) {
                    this.setLinear(n2);
                }
                n4 = n3;
                ++n2;
            }
            if (this.nextString(n4, n2)) {
                return true;
            }
            if ((n2 = this.backtrack(n2)) < 0) {
                return false;
            }
            n3 = this.runAutomaton.step(this.savedStates.intAt(n2), this.seekBytesRef.byteAt(n2) & 0xFF);
            if (n3 >= 0 && this.runAutomaton.isAccept(n3)) {
                return true;
            }
            if (this.finite) continue;
            n2 = 0;
        }
    }

    private boolean nextString(int n2, int n3) {
        int n4 = 0;
        if (n3 < this.seekBytesRef.length()) {
            int n5 = this.seekBytesRef.byteAt(n3) & 0xFF;
            n4 = n5;
            ++n4;
            if (n5 == 255) {
                return false;
            }
        }
        this.seekBytesRef.setLength(n3);
        this.visited[n2] = this.curGen;
        n3 = this.automaton.getNumTransitions(n2);
        this.automaton.initTransition(n2, this.transition);
        for (n2 = 0; n2 < n3; ++n2) {
            this.automaton.getNextTransition(this.transition);
            if (this.transition.max < n4) continue;
            n2 = Math.max(n4, this.transition.min);
            this.seekBytesRef.grow(this.seekBytesRef.length() + 1);
            this.seekBytesRef.append((byte)n2);
            n2 = this.transition.dest;
            while (this.visited[n2] != this.curGen && !this.runAutomaton.isAccept(n2)) {
                this.visited[n2] = this.curGen;
                this.automaton.initTransition(n2, this.transition);
                this.automaton.getNextTransition(this.transition);
                n2 = this.transition.dest;
                this.seekBytesRef.grow(this.seekBytesRef.length() + 1);
                this.seekBytesRef.append((byte)this.transition.min);
                if (this.finite || this.linear || this.visited[n2] != this.curGen) continue;
                this.setLinear(this.seekBytesRef.length() - 1);
            }
            return true;
        }
        return false;
    }

    private int backtrack(int n2) {
        while (n2-- > 0) {
            int n3 = this.seekBytesRef.byteAt(n2) & 0xFF;
            int n4 = n3;
            ++n4;
            if (n3 == 255) continue;
            this.seekBytesRef.setByteAt(n2, (byte)n4);
            this.seekBytesRef.setLength(n2 + 1);
            return n2;
        }
        return -1;
    }
}

