/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.perfield;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.d;
import org.apache.lucene.codecs.e;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.a;
import org.apache.lucene.util.b;

public abstract class PerFieldPostingsFormat
extends PostingsFormat {
    public static final String PER_FIELD_NAME = "PerField40";
    public static final String PER_FIELD_FORMAT_KEY = PerFieldPostingsFormat.class.getSimpleName() + ".format";
    public static final String PER_FIELD_SUFFIX_KEY = PerFieldPostingsFormat.class.getSimpleName() + ".suffix";

    public PerFieldPostingsFormat() {
        super(PER_FIELD_NAME);
    }

    static String getSuffix(String string, String string2) {
        return string + "_" + string2;
    }

    static String getFullSegmentSuffix(String string, String string2, String string3) {
        if (string2.length() == 0) {
            return string3;
        }
        throw new IllegalStateException("cannot embed PerFieldPostingsFormat inside itself (field \"" + string + "\" returned PerFieldPostingsFormat)");
    }

    @Override
    public final d fieldsConsumer(SegmentWriteState segmentWriteState) throws IOException {
        return new FieldsWriter(segmentWriteState);
    }

    @Override
    public final e fieldsProducer(SegmentReadState segmentReadState) throws IOException {
        return new FieldsReader(segmentReadState);
    }

    public abstract PostingsFormat getPostingsFormatForField(String var1);

    private static class FieldsReader
    extends e {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(FieldsReader.class);
        private final Map<String, e> fields = new TreeMap<String, e>();
        private final Map<String, e> formats = new HashMap<String, e>();
        private final String segment;

        FieldsReader(FieldsReader fieldsReader) throws IOException {
            e e2;
            IdentityHashMap<e, e> identityHashMap = new IdentityHashMap<e, e>();
            for (Map.Entry<String, e> entry : fieldsReader.formats.entrySet()) {
                e2 = entry.getValue().getMergeInstance();
                this.formats.put(entry.getKey(), e2);
                identityHashMap.put(entry.getValue(), e2);
            }
            for (Map.Entry<String, e> entry : fieldsReader.fields.entrySet()) {
                e2 = (e)identityHashMap.get(entry.getValue());
                assert (e2 != null);
                this.fields.put(entry.getKey(), e2);
            }
            this.segment = fieldsReader.segment;
        }

        public FieldsReader(SegmentReadState segmentReadState) throws IOException {
            try {
                for (Object object : segmentReadState.fieldInfos) {
                    if (((FieldInfo)object).getIndexOptions() == IndexOptions.NONE) continue;
                    String string = ((FieldInfo)object).name;
                    String string2 = ((FieldInfo)object).getAttribute(PER_FIELD_FORMAT_KEY);
                    if (string2 == null) continue;
                    if ((object = ((FieldInfo)object).getAttribute(PER_FIELD_SUFFIX_KEY)) == null) {
                        throw new IllegalStateException("missing attribute: " + PER_FIELD_SUFFIX_KEY + " for field: " + string);
                    }
                    PostingsFormat postingsFormat = PostingsFormat.forName(string2);
                    if (!this.formats.containsKey(object = PerFieldPostingsFormat.getSuffix(string2, (String)object))) {
                        this.formats.put((String)object, postingsFormat.fieldsProducer(new SegmentReadState(segmentReadState, (String)object)));
                    }
                    this.fields.put(string, this.formats.get(object));
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException(this.formats.values());
                throw throwable;
            }
            this.segment = segmentReadState.segmentInfo.name;
        }

        @Override
        public Iterator<String> iterator() {
            return Collections.unmodifiableSet(this.fields.keySet()).iterator();
        }

        @Override
        public Terms terms(String string) throws IOException {
            e e2 = this.fields.get(string);
            if (e2 == null) {
                return null;
            }
            return e2.terms(string);
        }

        @Override
        public int size() {
            return this.fields.size();
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.formats.values());
        }

        @Override
        public long ramBytesUsed() {
            long l2 = BASE_RAM_BYTES_USED + ((long)this.fields.size() << 1) * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + ((long)this.formats.size() << 1) * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
            for (Map.Entry<String, e> entry : this.formats.entrySet()) {
                l2 += entry.getValue().ramBytesUsed();
            }
            return l2;
        }

        @Override
        public Collection<a> getChildResources() {
            return b.a("format", this.formats);
        }

        @Override
        public void checkIntegrity() throws IOException {
            Iterator<e> iterator = this.formats.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().checkIntegrity();
            }
        }

        @Override
        public e getMergeInstance() throws IOException {
            return new FieldsReader(this);
        }

        public String toString() {
            return "PerFieldPostings(segment=" + this.segment + " formats=" + this.formats.size() + ")";
        }
    }

    private class FieldsWriter
    extends d {
        final SegmentWriteState writeState;
        final List<Closeable> toClose = new ArrayList<Closeable>();

        public FieldsWriter(SegmentWriteState segmentWriteState) {
            this.writeState = segmentWriteState;
        }

        @Override
        public void write(Fields fields) throws IOException {
            Object object;
            Object object2;
            Object object3;
            PostingsFormat postingsFormat;
            HashMap<PostingsFormat, Object> hashMap = new HashMap<PostingsFormat, Object>();
            HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
            for (Object object4 : fields) {
                FieldInfo object5 = this.writeState.fieldInfos.fieldInfo((String)object4);
                postingsFormat = PerFieldPostingsFormat.this.getPostingsFormatForField((String)object4);
                if (postingsFormat == null) {
                    throw new IllegalStateException("invalid null PostingsFormat for field=\"" + (String)object4 + "\"");
                }
                object3 = postingsFormat.getName();
                object2 = (FieldsGroup)hashMap.get(postingsFormat);
                if (object2 == null) {
                    object = (Integer)hashMap2.get(object3);
                    object = object == null ? Integer.valueOf(0) : Integer.valueOf((Integer)object + 1);
                    hashMap2.put(object3, object);
                    String string = PerFieldPostingsFormat.getFullSegmentSuffix((String)object4, this.writeState.segmentSuffix, PerFieldPostingsFormat.getSuffix((String)object3, Integer.toString((Integer)object)));
                    object2 = new FieldsGroup();
                    new FieldsGroup().state = new SegmentWriteState(this.writeState, string);
                    ((FieldsGroup)object2).suffix = (Integer)object;
                    hashMap.put(postingsFormat, object2);
                } else if (!hashMap2.containsKey(object3)) {
                    throw new IllegalStateException("no suffix for format name: " + (String)object3 + ", expected: " + ((FieldsGroup)object2).suffix);
                }
                ((FieldsGroup)object2).fields.add((String)object4);
                object = object5.putAttribute(PER_FIELD_FORMAT_KEY, (String)object3);
                if (object != null) {
                    throw new IllegalStateException("found existing value for " + PER_FIELD_FORMAT_KEY + ", field=" + object5.name + ", old=" + (String)object + ", new=" + (String)object3);
                }
                object = object5.putAttribute(PER_FIELD_SUFFIX_KEY, Integer.toString(((FieldsGroup)object2).suffix));
                if (object == null) continue;
                throw new IllegalStateException("found existing value for " + PER_FIELD_SUFFIX_KEY + ", field=" + object5.name + ", old=" + (String)object + ", new=" + ((FieldsGroup)object2).suffix);
            }
            try {
                for (Map.Entry entry : hashMap.entrySet()) {
                    postingsFormat = (PostingsFormat)entry.getKey();
                    object3 = (FieldsGroup)entry.getValue();
                    object2 = new FilterLeafReader.FilterFields(fields, (FieldsGroup)object3){
                        final /* synthetic */ FieldsGroup val$group;
                        {
                            this.val$group = fieldsGroup;
                            super(fields);
                        }

                        @Override
                        public Iterator<String> iterator() {
                            return this.val$group.fields.iterator();
                        }
                    };
                    object = postingsFormat.fieldsConsumer(((FieldsGroup)object3).state);
                    this.toClose.add((Closeable)object);
                    ((d)object).write((Fields)object2);
                }
                return;
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException(this.toClose);
                throw throwable;
            }
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.toClose);
        }
    }

    static class FieldsGroup {
        final Set<String> fields = new TreeSet<String>();
        int suffix;
        SegmentWriteState state;

        FieldsGroup() {
        }
    }
}

