/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.perfield;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.b;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.m;
import org.apache.lucene.index.p;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.a;

public abstract class PerFieldDocValuesFormat
extends DocValuesFormat {
    public static final String PER_FIELD_NAME = "PerFieldDV40";
    public static final String PER_FIELD_FORMAT_KEY = PerFieldDocValuesFormat.class.getSimpleName() + ".format";
    public static final String PER_FIELD_SUFFIX_KEY = PerFieldDocValuesFormat.class.getSimpleName() + ".suffix";

    public PerFieldDocValuesFormat() {
        super(PER_FIELD_NAME);
    }

    @Override
    public final DocValuesConsumer fieldsConsumer(SegmentWriteState segmentWriteState) throws IOException {
        return new FieldsWriter(segmentWriteState);
    }

    static String getSuffix(String string, String string2) {
        return string + "_" + string2;
    }

    static String getFullSegmentSuffix(String string, String string2) {
        if (string.length() == 0) {
            return string2;
        }
        return string + "_" + string2;
    }

    @Override
    public final b fieldsProducer(SegmentReadState segmentReadState) throws IOException {
        return new FieldsReader(segmentReadState);
    }

    public abstract DocValuesFormat getDocValuesFormatForField(String var1);

    private class FieldsReader
    extends b {
        private final Map<String, b> fields = new TreeMap<String, b>();
        private final Map<String, b> formats = new HashMap<String, b>();

        FieldsReader(FieldsReader fieldsReader) throws IOException {
            b b2;
            PerFieldDocValuesFormat.this = new IdentityHashMap();
            for (Map.Entry<String, b> entry : fieldsReader.formats.entrySet()) {
                b2 = entry.getValue().getMergeInstance();
                this.formats.put(entry.getKey(), b2);
                PerFieldDocValuesFormat.this.put(entry.getValue(), b2);
            }
            for (Map.Entry<String, b> entry : fieldsReader.fields.entrySet()) {
                b2 = (b)PerFieldDocValuesFormat.this.get(entry.getValue());
                assert (b2 != null);
                this.fields.put(entry.getKey(), b2);
            }
        }

        public FieldsReader(SegmentReadState segmentReadState) throws IOException {
            try {
                for (Object object2 : segmentReadState.fieldInfos) {
                    if (((FieldInfo)object2).getDocValuesType() == DocValuesType.NONE) continue;
                    String string = ((FieldInfo)object2).name;
                    String string2 = ((FieldInfo)object2).getAttribute(PER_FIELD_FORMAT_KEY);
                    if (string2 == null) continue;
                    if ((object2 = ((FieldInfo)object2).getAttribute(PER_FIELD_SUFFIX_KEY)) == null) {
                        throw new IllegalStateException("missing attribute: " + PER_FIELD_SUFFIX_KEY + " for field: " + string);
                    }
                    DocValuesFormat docValuesFormat = DocValuesFormat.forName(string2);
                    if (!this.formats.containsKey(object2 = PerFieldDocValuesFormat.getFullSegmentSuffix(segmentReadState.segmentSuffix, PerFieldDocValuesFormat.getSuffix(string2, (String)object2)))) {
                        this.formats.put((String)object2, docValuesFormat.fieldsProducer(new SegmentReadState(segmentReadState, (String)object2)));
                    }
                    this.fields.put(string, this.formats.get(object2));
                }
                return;
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException(this.formats.values());
                throw throwable;
            }
        }

        @Override
        public m getNumeric(FieldInfo fieldInfo) throws IOException {
            b b2 = this.fields.get(fieldInfo.name);
            if (b2 == null) {
                return null;
            }
            return b2.getNumeric(fieldInfo);
        }

        @Override
        public org.apache.lucene.index.a getBinary(FieldInfo fieldInfo) throws IOException {
            b b2 = this.fields.get(fieldInfo.name);
            if (b2 == null) {
                return null;
            }
            return b2.getBinary(fieldInfo);
        }

        @Override
        public SortedDocValues getSorted(FieldInfo fieldInfo) throws IOException {
            b b2 = this.fields.get(fieldInfo.name);
            if (b2 == null) {
                return null;
            }
            return b2.getSorted(fieldInfo);
        }

        @Override
        public p getSortedNumeric(FieldInfo fieldInfo) throws IOException {
            b b2 = this.fields.get(fieldInfo.name);
            if (b2 == null) {
                return null;
            }
            return b2.getSortedNumeric(fieldInfo);
        }

        @Override
        public SortedSetDocValues getSortedSet(FieldInfo fieldInfo) throws IOException {
            b b2 = this.fields.get(fieldInfo.name);
            if (b2 == null) {
                return null;
            }
            return b2.getSortedSet(fieldInfo);
        }

        @Override
        public Bits getDocsWithField(FieldInfo fieldInfo) throws IOException {
            b b2 = this.fields.get(fieldInfo.name);
            if (b2 == null) {
                return null;
            }
            return b2.getDocsWithField(fieldInfo);
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.formats.values());
        }

        @Override
        public long ramBytesUsed() {
            long l2 = 0L;
            for (Map.Entry<String, b> entry : this.formats.entrySet()) {
                l2 += (long)(entry.getKey().length() << 1) + entry.getValue().ramBytesUsed();
            }
            return l2;
        }

        @Override
        public Collection<a> getChildResources() {
            return org.apache.lucene.util.b.a("format", this.formats);
        }

        @Override
        public void checkIntegrity() throws IOException {
            Iterator<b> iterator = this.formats.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().checkIntegrity();
            }
        }

        @Override
        public b getMergeInstance() throws IOException {
            return new FieldsReader(this);
        }

        public String toString() {
            return "PerFieldDocValues(formats=" + this.formats.size() + ")";
        }
    }

    private class FieldsWriter
    extends DocValuesConsumer {
        private final Map<DocValuesFormat, ConsumerAndSuffix> formats = new HashMap<DocValuesFormat, ConsumerAndSuffix>();
        private final Map<String, Integer> suffixes = new HashMap<String, Integer>();
        private final SegmentWriteState segmentWriteState;

        public FieldsWriter(SegmentWriteState segmentWriteState) {
            this.segmentWriteState = segmentWriteState;
        }

        @Override
        public void addNumericField(FieldInfo fieldInfo, Iterable<Number> iterable) throws IOException {
            this.getInstance(fieldInfo).addNumericField(fieldInfo, iterable);
        }

        @Override
        public void addBinaryField(FieldInfo fieldInfo, Iterable<BytesRef> iterable) throws IOException {
            this.getInstance(fieldInfo).addBinaryField(fieldInfo, iterable);
        }

        @Override
        public void addSortedField(FieldInfo fieldInfo, Iterable<BytesRef> iterable, Iterable<Number> iterable2) throws IOException {
            this.getInstance(fieldInfo).addSortedField(fieldInfo, iterable, iterable2);
        }

        @Override
        public void addSortedNumericField(FieldInfo fieldInfo, Iterable<Number> iterable, Iterable<Number> iterable2) throws IOException {
            this.getInstance(fieldInfo).addSortedNumericField(fieldInfo, iterable, iterable2);
        }

        @Override
        public void addSortedSetField(FieldInfo fieldInfo, Iterable<BytesRef> iterable, Iterable<Number> iterable2, Iterable<Number> iterable3) throws IOException {
            this.getInstance(fieldInfo).addSortedSetField(fieldInfo, iterable, iterable2, iterable3);
        }

        private DocValuesConsumer getInstance(FieldInfo fieldInfo) throws IOException {
            String string;
            DocValuesFormat docValuesFormat = null;
            if (fieldInfo.getDocValuesGen() != -1L && (string = fieldInfo.getAttribute(PER_FIELD_FORMAT_KEY)) != null) {
                docValuesFormat = DocValuesFormat.forName(string);
            }
            if (docValuesFormat == null) {
                docValuesFormat = PerFieldDocValuesFormat.this.getDocValuesFormatForField(fieldInfo.name);
            }
            if (docValuesFormat == null) {
                throw new IllegalStateException("invalid null DocValuesFormat for field=\"" + fieldInfo.name + "\"");
            }
            string = docValuesFormat.getName();
            String string2 = fieldInfo.putAttribute(PER_FIELD_FORMAT_KEY, string);
            if (fieldInfo.getDocValuesGen() == -1L && string2 != null) {
                throw new IllegalStateException("found existing value for " + PER_FIELD_FORMAT_KEY + ", field=" + fieldInfo.name + ", old=" + string2 + ", new=" + string);
            }
            Integer n2 = null;
            ConsumerAndSuffix consumerAndSuffix = this.formats.get(docValuesFormat);
            if (consumerAndSuffix == null) {
                if (fieldInfo.getDocValuesGen() != -1L && (string2 = fieldInfo.getAttribute(PER_FIELD_SUFFIX_KEY)) != null) {
                    n2 = Integer.valueOf(string2);
                }
                if (n2 == null) {
                    n2 = this.suffixes.get(string);
                    n2 = n2 == null ? Integer.valueOf(0) : Integer.valueOf(n2 + 1);
                }
                this.suffixes.put(string, n2);
                string2 = PerFieldDocValuesFormat.getFullSegmentSuffix(this.segmentWriteState.segmentSuffix, PerFieldDocValuesFormat.getSuffix(string, Integer.toString(n2)));
                consumerAndSuffix = new ConsumerAndSuffix();
                new ConsumerAndSuffix().consumer = docValuesFormat.fieldsConsumer(new SegmentWriteState(this.segmentWriteState, string2));
                consumerAndSuffix.suffix = n2;
                this.formats.put(docValuesFormat, consumerAndSuffix);
            } else {
                assert (this.suffixes.containsKey(string));
                n2 = consumerAndSuffix.suffix;
            }
            string2 = fieldInfo.putAttribute(PER_FIELD_SUFFIX_KEY, Integer.toString(n2));
            if (fieldInfo.getDocValuesGen() == -1L && string2 != null) {
                throw new IllegalStateException("found existing value for " + PER_FIELD_SUFFIX_KEY + ", field=" + fieldInfo.name + ", old=" + string2 + ", new=" + n2);
            }
            return consumerAndSuffix.consumer;
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.formats.values());
        }
    }

    static class ConsumerAndSuffix
    implements Closeable {
        DocValuesConsumer consumer;
        int suffix;

        ConsumerAndSuffix() {
        }

        @Override
        public void close() throws IOException {
            this.consumer.close();
        }
    }
}

