/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene53;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.i;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.m;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.b;
import org.apache.lucene.store.h;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.a;

class Lucene53NormsProducer
extends i {
    private final Map<Integer, NormsEntry> norms;
    private final IndexInput data;
    private final int maxDoc;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Lucene53NormsProducer(SegmentReadState segmentReadState, String string, String string2, String object, String object2) throws IOException {
        int n2;
        block14: {
            this.norms = new HashMap<Integer, NormsEntry>();
            this.maxDoc = segmentReadState.segmentInfo.maxDoc();
            object2 = IndexFileNames.segmentFileName(segmentReadState.segmentInfo.name, segmentReadState.segmentSuffix, (String)object2);
            n2 = -1;
            object2 = segmentReadState.directory.openChecksumInput((String)object2, segmentReadState.context);
            Throwable throwable = null;
            try {
                block13: {
                    try {
                        n2 = CodecUtil.checkIndexHeader((DataInput)object2, (String)object, 0, 0, segmentReadState.segmentInfo.getId(), segmentReadState.segmentSuffix);
                        this.readFields((IndexInput)object2, segmentReadState.fieldInfos);
                    }
                    catch (Throwable throwable2) {
                        CodecUtil.checkFooter((b)object2, throwable2);
                        break block13;
                    }
                    catch (Throwable throwable3) {
                        CodecUtil.checkFooter((b)object2, null);
                        throw throwable3;
                    }
                    CodecUtil.checkFooter((b)object2, null);
                }
                if (object2 == null) break block14;
            }
            catch (Throwable throwable4) {
                try {
                    object = throwable4;
                    throwable = throwable4;
                    throw object;
                }
                catch (Throwable throwable5) {
                    if (object2 == null) throw throwable5;
                    if (throwable == null) {
                        ((IndexInput)object2).close();
                        throw throwable5;
                    }
                    try {
                        ((IndexInput)object2).close();
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                        throw throwable5;
                    }
                }
            }
            ((IndexInput)object2).close();
        }
        object2 = IndexFileNames.segmentFileName(segmentReadState.segmentInfo.name, segmentReadState.segmentSuffix, string2);
        this.data = segmentReadState.directory.openInput((String)object2, segmentReadState.context);
        try {
            int n3 = CodecUtil.checkIndexHeader(this.data, string, 0, 0, segmentReadState.segmentInfo.getId(), segmentReadState.segmentSuffix);
            if (n2 != n3) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + n2 + ",data=" + n3, this.data);
            }
            CodecUtil.retrieveChecksum(this.data);
            return;
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(this.data);
            throw throwable;
        }
    }

    private void readFields(IndexInput indexInput, FieldInfos fieldInfos) throws IOException {
        int n2 = indexInput.readVInt();
        while (n2 != -1) {
            FieldInfo fieldInfo = fieldInfos.fieldInfo(n2);
            if (fieldInfo == null) {
                throw new CorruptIndexException("Invalid field number: " + n2, indexInput);
            }
            if (!fieldInfo.hasNorms()) {
                throw new CorruptIndexException("Invalid field: " + fieldInfo.name, indexInput);
            }
            NormsEntry normsEntry = new NormsEntry();
            new NormsEntry().bytesPerValue = indexInput.readByte();
            switch (normsEntry.bytesPerValue) {
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    break;
                }
                default: {
                    throw new CorruptIndexException("Invalid bytesPerValue: " + normsEntry.bytesPerValue + ", field: " + fieldInfo.name, indexInput);
                }
            }
            normsEntry.offset = indexInput.readLong();
            this.norms.put(fieldInfo.number, normsEntry);
            n2 = indexInput.readVInt();
        }
    }

    @Override
    public m getNorms(FieldInfo object) throws IOException {
        object = this.norms.get(((FieldInfo)object).number);
        if (((NormsEntry)object).bytesPerValue == 0) {
            final long l2 = ((NormsEntry)object).offset;
            return new m(){

                @Override
                public long get(int n2) {
                    return l2;
                }
            };
        }
        IndexInput indexInput = this.data;
        synchronized (indexInput) {
            switch (((NormsEntry)object).bytesPerValue) {
                case 1: {
                    final h h2 = this.data.randomAccessSlice(((NormsEntry)object).offset, this.maxDoc);
                    return new m(){

                        @Override
                        public long get(int n2) {
                            try {
                                return h2.readByte(n2);
                            }
                            catch (IOException iOException) {
                                throw new RuntimeException(iOException);
                            }
                        }
                    };
                }
                case 2: {
                    final h h3 = this.data.randomAccessSlice(((NormsEntry)object).offset, (long)this.maxDoc << 1);
                    return new m(){

                        @Override
                        public long get(int n2) {
                            try {
                                return h3.readShort((long)n2 << 1);
                            }
                            catch (IOException iOException) {
                                throw new RuntimeException(iOException);
                            }
                        }
                    };
                }
                case 4: {
                    final h h4 = this.data.randomAccessSlice(((NormsEntry)object).offset, (long)this.maxDoc << 2);
                    return new m(){

                        @Override
                        public long get(int n2) {
                            try {
                                return h4.readInt((long)n2 << 2);
                            }
                            catch (IOException iOException) {
                                throw new RuntimeException(iOException);
                            }
                        }
                    };
                }
                case 8: {
                    final h h5 = this.data.randomAccessSlice(((NormsEntry)object).offset, (long)this.maxDoc << 3);
                    return new m(){

                        @Override
                        public long get(int n2) {
                            try {
                                return h5.readLong((long)n2 << 3);
                            }
                            catch (IOException iOException) {
                                throw new RuntimeException(iOException);
                            }
                        }
                    };
                }
            }
            throw new AssertionError();
        }
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    @Override
    public long ramBytesUsed() {
        return 64L * (long)this.norms.size();
    }

    @Override
    public Collection<a> getChildResources() {
        return Collections.emptyList();
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.data);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.norms.size() + ")";
    }

    static class NormsEntry {
        byte bytesPerValue;
        long offset;

        NormsEntry() {
        }
    }
}

