/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.codecs.MultiLevelSkipListReader;
import org.apache.lucene.store.IndexInput;

final class Lucene50SkipReader
extends MultiLevelSkipListReader {
    private long[] docPointer;
    private long[] posPointer;
    private long[] payPointer;
    private int[] posBufferUpto;
    private int[] payloadByteUpto;
    private long lastPosPointer;
    private long lastPayPointer;
    private int lastPayloadByteUpto;
    private long lastDocPointer;
    private int lastPosBufferUpto;

    public Lucene50SkipReader(IndexInput indexInput, int n2, boolean bl, boolean bl2, boolean bl3) {
        super(indexInput, n2, 128, 8);
        this.docPointer = new long[n2];
        if (bl) {
            this.posPointer = new long[n2];
            this.posBufferUpto = new int[n2];
            this.payloadByteUpto = (int[])(bl3 ? new int[n2] : null);
            if (bl2 || bl3) {
                this.payPointer = new long[n2];
                return;
            }
            this.payPointer = null;
            return;
        }
        this.posPointer = null;
    }

    protected final int trim(int n2) {
        if (n2 % 128 == 0) {
            return n2 - 1;
        }
        return n2;
    }

    public final void init(long l2, long l3, long l4, long l5, int n2) throws IOException {
        super.init(l2, this.trim(n2));
        this.lastDocPointer = l3;
        this.lastPosPointer = l4;
        this.lastPayPointer = l5;
        Arrays.fill(this.docPointer, l3);
        if (this.posPointer != null) {
            Arrays.fill(this.posPointer, l4);
            if (this.payPointer != null) {
                Arrays.fill(this.payPointer, l5);
                return;
            }
        } else assert (l4 == 0L);
    }

    public final long getDocPointer() {
        return this.lastDocPointer;
    }

    public final long getPosPointer() {
        return this.lastPosPointer;
    }

    public final int getPosBufferUpto() {
        return this.lastPosBufferUpto;
    }

    public final long getPayPointer() {
        return this.lastPayPointer;
    }

    public final int getPayloadByteUpto() {
        return this.lastPayloadByteUpto;
    }

    public final int getNextSkipDoc() {
        return this.skipDoc[0];
    }

    @Override
    protected final void seekChild(int n2) throws IOException {
        super.seekChild(n2);
        this.docPointer[n2] = this.lastDocPointer;
        if (this.posPointer != null) {
            this.posPointer[n2] = this.lastPosPointer;
            this.posBufferUpto[n2] = this.lastPosBufferUpto;
            if (this.payloadByteUpto != null) {
                this.payloadByteUpto[n2] = this.lastPayloadByteUpto;
            }
            if (this.payPointer != null) {
                this.payPointer[n2] = this.lastPayPointer;
            }
        }
    }

    @Override
    protected final void setLastSkipData(int n2) {
        super.setLastSkipData(n2);
        this.lastDocPointer = this.docPointer[n2];
        if (this.posPointer != null) {
            this.lastPosPointer = this.posPointer[n2];
            this.lastPosBufferUpto = this.posBufferUpto[n2];
            if (this.payPointer != null) {
                this.lastPayPointer = this.payPointer[n2];
            }
            if (this.payloadByteUpto != null) {
                this.lastPayloadByteUpto = this.payloadByteUpto[n2];
            }
        }
    }

    @Override
    protected final int readSkipData(int n2, IndexInput indexInput) throws IOException {
        int n3 = indexInput.readVInt();
        int n4 = n2;
        this.docPointer[n4] = this.docPointer[n4] + indexInput.readVLong();
        if (this.posPointer != null) {
            int n5 = n2;
            this.posPointer[n5] = this.posPointer[n5] + indexInput.readVLong();
            this.posBufferUpto[n2] = indexInput.readVInt();
            if (this.payloadByteUpto != null) {
                this.payloadByteUpto[n2] = indexInput.readVInt();
            }
            if (this.payPointer != null) {
                int n6 = n2;
                this.payPointer[n6] = this.payPointer[n6] + indexInput.readVLong();
            }
        }
        return n3;
    }
}

