/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.l;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.b;
import org.apache.lucene.store.c;
import org.apache.lucene.util.Version;

public class Lucene50SegmentInfoFormat
extends l {
    public static final String SI_EXTENSION = "si";
    static final String CODEC_NAME = "Lucene50SegmentInfo";
    static final int VERSION_START = 0;
    static final int VERSION_SAFE_MAPS = 1;
    static final int VERSION_CURRENT = 1;

    @Override
    public SegmentInfo read(c object, String string, byte[] byArray, IOContext object2) throws IOException {
        Map<String, String> map;
        block15: {
            Object object3 = IndexFileNames.segmentFileName(string, "", SI_EXTENSION);
            object2 = ((c)object).openChecksumInput((String)object3, (IOContext)object2);
            object3 = null;
            try {
                Object object4 = null;
                try {
                    Map<String, String> map2;
                    Set<String> set;
                    boolean bl;
                    int n2 = CodecUtil.checkIndexHeader((DataInput)object2, CODEC_NAME, 0, 1, byArray, "");
                    Version version = Version.fromBits(((DataInput)object2).readInt(), ((DataInput)object2).readInt(), ((DataInput)object2).readInt());
                    int n3 = ((DataInput)object2).readInt();
                    if (n3 < 0) {
                        throw new CorruptIndexException("invalid docCount: " + n3, (DataInput)object2);
                    }
                    boolean bl2 = bl = ((DataInput)object2).readByte() == 1;
                    if (n2 > 0) {
                        map = ((DataInput)object2).readMapOfStrings();
                        set = ((DataInput)object2).readSetOfStrings();
                        map2 = ((DataInput)object2).readMapOfStrings();
                    } else {
                        map = Collections.unmodifiableMap(((DataInput)object2).readStringStringMap());
                        set = Collections.unmodifiableSet(((DataInput)object2).readStringSet());
                        map2 = Collections.unmodifiableMap(((DataInput)object2).readStringStringMap());
                    }
                    object4 = new SegmentInfo((c)object, version, string, n3, bl, null, map, byArray, map2);
                    ((SegmentInfo)object4).setFiles(set);
                }
                catch (Throwable throwable) {
                    CodecUtil.checkFooter((b)object2, throwable);
                }
                catch (Throwable throwable) {
                    CodecUtil.checkFooter((b)object2, null);
                    throw throwable;
                }
                CodecUtil.checkFooter((b)object2, null);
                map = object4;
                if (object2 == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    object = throwable;
                    object3 = throwable;
                    throw object;
                }
                catch (Throwable throwable2) {
                    if (object2 != null) {
                        if (object3 != null) {
                            try {
                                ((IndexInput)object2).close();
                            }
                            catch (Throwable throwable3) {
                                ((Throwable)object3).addSuppressed(throwable3);
                            }
                        } else {
                            ((IndexInput)object2).close();
                        }
                    }
                    throw throwable2;
                }
            }
            ((IndexInput)object2).close();
        }
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(c closeable, SegmentInfo segmentInfo, IOContext object) throws IOException {
        Set<String> set = IndexFileNames.segmentFileName(segmentInfo.name, "", SI_EXTENSION);
        closeable = ((c)closeable).createOutput((String)((Object)set), (IOContext)object);
        object = null;
        try {
            segmentInfo.addFile((String)((Object)set));
            CodecUtil.writeIndexHeader((DataOutput)((Object)closeable), CODEC_NAME, 1, segmentInfo.getId(), "");
            set = segmentInfo.getVersion();
            if (((Version)((Object)set)).major < 5) {
                throw new IllegalArgumentException("invalid major version: should be >= 5 but got: " + ((Version)((Object)set)).major + " segment=" + segmentInfo);
            }
            ((DataOutput)((Object)closeable)).writeInt(((Version)((Object)set)).major);
            ((DataOutput)((Object)closeable)).writeInt(((Version)((Object)set)).minor);
            ((DataOutput)((Object)closeable)).writeInt(((Version)((Object)set)).bugfix);
            assert (((Version)((Object)set)).prerelease == 0);
            ((DataOutput)((Object)closeable)).writeInt(segmentInfo.maxDoc());
            ((DataOutput)((Object)closeable)).writeByte((byte)(segmentInfo.getUseCompoundFile() ? 1 : -1));
            ((DataOutput)((Object)closeable)).writeMapOfStrings(segmentInfo.getDiagnostics());
            set = segmentInfo.files();
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                if (IndexFileNames.parseSegmentName(iterator.next()).equals(segmentInfo.name)) continue;
                throw new IllegalArgumentException("invalid files: expected segment=" + segmentInfo.name + ", got=" + set);
            }
            ((DataOutput)((Object)closeable)).writeSetOfStrings(set);
            ((DataOutput)((Object)closeable)).writeMapOfStrings(segmentInfo.getAttributes());
            CodecUtil.writeFooter((IndexOutput)closeable);
            if (closeable == null) return;
        }
        catch (Throwable throwable) {
            try {
                set = throwable;
                object = throwable;
                throw set;
            }
            catch (Throwable throwable2) {
                if (closeable == null) throw throwable2;
                if (object != null) {
                    try {
                        ((IndexOutput)closeable).close();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        ((Throwable)object).addSuppressed(throwable3);
                    }
                    throw throwable2;
                } else {
                    ((IndexOutput)closeable).close();
                }
                throw throwable2;
            }
        }
        ((IndexOutput)closeable).close();
        return;
    }
}

