/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.PushPostingsWriterBase;
import org.apache.lucene.codecs.lucene50.ForUtil;
import org.apache.lucene.codecs.lucene50.Lucene50PostingsFormat;
import org.apache.lucene.codecs.lucene50.Lucene50SkipWriter;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

public final class Lucene50PostingsWriter
extends PushPostingsWriterBase {
    IndexOutput docOut;
    IndexOutput posOut;
    IndexOutput payOut;
    static final Lucene50PostingsFormat.IntBlockTermState emptyState = new Lucene50PostingsFormat.IntBlockTermState();
    Lucene50PostingsFormat.IntBlockTermState lastState;
    private long docStartFP;
    private long posStartFP;
    private long payStartFP;
    final int[] docDeltaBuffer;
    final int[] freqBuffer;
    private int docBufferUpto;
    final int[] posDeltaBuffer;
    final int[] payloadLengthBuffer;
    final int[] offsetStartDeltaBuffer;
    final int[] offsetLengthBuffer;
    private int posBufferUpto;
    private byte[] payloadBytes;
    private int payloadByteUpto;
    private int lastBlockDocID;
    private long lastBlockPosFP;
    private long lastBlockPayFP;
    private int lastBlockPosBufferUpto;
    private int lastBlockPayloadByteUpto;
    private int lastDocID;
    private int lastPosition;
    private int lastStartOffset;
    private int docCount;
    final byte[] encoded;
    private final ForUtil forUtil;
    private final Lucene50SkipWriter skipWriter;

    public Lucene50PostingsWriter(SegmentWriteState segmentWriteState) throws IOException {
        Object object = IndexFileNames.segmentFileName(segmentWriteState.segmentInfo.name, segmentWriteState.segmentSuffix, "doc");
        this.docOut = segmentWriteState.directory.createOutput((String)object, segmentWriteState.context);
        object = null;
        IndexOutput indexOutput = null;
        try {
            CodecUtil.writeIndexHeader(this.docOut, "Lucene50PostingsWriterDoc", 0, segmentWriteState.segmentInfo.getId(), segmentWriteState.segmentSuffix);
            this.forUtil = new ForUtil(0.0f, this.docOut);
            if (segmentWriteState.fieldInfos.hasProx()) {
                this.posDeltaBuffer = new int[ForUtil.MAX_DATA_SIZE];
                String string = IndexFileNames.segmentFileName(segmentWriteState.segmentInfo.name, segmentWriteState.segmentSuffix, "pos");
                object = segmentWriteState.directory.createOutput(string, segmentWriteState.context);
                CodecUtil.writeIndexHeader((DataOutput)object, "Lucene50PostingsWriterPos", 0, segmentWriteState.segmentInfo.getId(), segmentWriteState.segmentSuffix);
                if (segmentWriteState.fieldInfos.hasPayloads()) {
                    this.payloadBytes = new byte[128];
                    this.payloadLengthBuffer = new int[ForUtil.MAX_DATA_SIZE];
                } else {
                    this.payloadBytes = null;
                    this.payloadLengthBuffer = null;
                }
                if (segmentWriteState.fieldInfos.hasOffsets()) {
                    this.offsetStartDeltaBuffer = new int[ForUtil.MAX_DATA_SIZE];
                    this.offsetLengthBuffer = new int[ForUtil.MAX_DATA_SIZE];
                } else {
                    this.offsetStartDeltaBuffer = null;
                    this.offsetLengthBuffer = null;
                }
                if (segmentWriteState.fieldInfos.hasPayloads() || segmentWriteState.fieldInfos.hasOffsets()) {
                    string = IndexFileNames.segmentFileName(segmentWriteState.segmentInfo.name, segmentWriteState.segmentSuffix, "pay");
                    indexOutput = segmentWriteState.directory.createOutput(string, segmentWriteState.context);
                    CodecUtil.writeIndexHeader(indexOutput, "Lucene50PostingsWriterPay", 0, segmentWriteState.segmentInfo.getId(), segmentWriteState.segmentSuffix);
                }
            } else {
                this.posDeltaBuffer = null;
                this.payloadLengthBuffer = null;
                this.offsetStartDeltaBuffer = null;
                this.offsetLengthBuffer = null;
                this.payloadBytes = null;
            }
            this.payOut = indexOutput;
            this.posOut = object;
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(new Closeable[]{this.docOut, object, indexOutput});
            throw throwable;
        }
        this.docDeltaBuffer = new int[ForUtil.MAX_DATA_SIZE];
        this.freqBuffer = new int[ForUtil.MAX_DATA_SIZE];
        this.skipWriter = new Lucene50SkipWriter(10, 128, segmentWriteState.segmentInfo.maxDoc(), this.docOut, (IndexOutput)object, indexOutput);
        this.encoded = new byte[512];
    }

    @Override
    public final Lucene50PostingsFormat.IntBlockTermState newTermState() {
        return new Lucene50PostingsFormat.IntBlockTermState();
    }

    @Override
    public final void init(IndexOutput indexOutput, SegmentWriteState segmentWriteState) throws IOException {
        CodecUtil.writeIndexHeader(indexOutput, "Lucene50PostingsWriterTerms", 0, segmentWriteState.segmentInfo.getId(), segmentWriteState.segmentSuffix);
        indexOutput.writeVInt(128);
    }

    @Override
    public final int setField(FieldInfo fieldInfo) {
        super.setField(fieldInfo);
        this.skipWriter.setField(this.writePositions, this.writeOffsets, this.writePayloads);
        this.lastState = emptyState;
        if (this.writePositions) {
            if (this.writePayloads || this.writeOffsets) {
                return 3;
            }
            return 2;
        }
        return 1;
    }

    @Override
    public final void startTerm() {
        this.docStartFP = this.docOut.getFilePointer();
        if (this.writePositions) {
            this.posStartFP = this.posOut.getFilePointer();
            if (this.writePayloads || this.writeOffsets) {
                this.payStartFP = this.payOut.getFilePointer();
            }
        }
        this.lastDocID = 0;
        this.lastBlockDocID = -1;
        this.skipWriter.resetSkip();
    }

    @Override
    public final void startDoc(int n2, int n3) throws IOException {
        if (this.lastBlockDocID != -1 && this.docBufferUpto == 0) {
            this.skipWriter.bufferSkip(this.lastBlockDocID, this.docCount, this.lastBlockPosFP, this.lastBlockPayFP, this.lastBlockPosBufferUpto, this.lastBlockPayloadByteUpto);
        }
        int n4 = n2 - this.lastDocID;
        if (n2 < 0 || this.docCount > 0 && n4 <= 0) {
            throw new CorruptIndexException("docs out of order (" + n2 + " <= " + this.lastDocID + " )", this.docOut);
        }
        this.docDeltaBuffer[this.docBufferUpto] = n4;
        if (this.writeFreqs) {
            this.freqBuffer[this.docBufferUpto] = n3;
        }
        ++this.docBufferUpto;
        ++this.docCount;
        if (this.docBufferUpto == 128) {
            this.forUtil.writeBlock(this.docDeltaBuffer, this.encoded, this.docOut);
            if (this.writeFreqs) {
                this.forUtil.writeBlock(this.freqBuffer, this.encoded, this.docOut);
            }
        }
        this.lastDocID = n2;
        this.lastPosition = 0;
        this.lastStartOffset = 0;
    }

    @Override
    public final void addPosition(int n2, BytesRef bytesRef, int n3, int n4) throws IOException {
        if (n2 > 0x7FFFFF7F) {
            throw new CorruptIndexException("position=" + n2 + " is too large (> IndexWriter.MAX_POSITION=2147483519)", this.docOut);
        }
        if (n2 < 0) {
            throw new CorruptIndexException("position=" + n2 + " is < 0", this.docOut);
        }
        this.posDeltaBuffer[this.posBufferUpto] = n2 - this.lastPosition;
        if (this.writePayloads) {
            if (bytesRef == null || bytesRef.length == 0) {
                this.payloadLengthBuffer[this.posBufferUpto] = 0;
            } else {
                this.payloadLengthBuffer[this.posBufferUpto] = bytesRef.length;
                if (this.payloadByteUpto + bytesRef.length > this.payloadBytes.length) {
                    this.payloadBytes = ArrayUtil.grow(this.payloadBytes, this.payloadByteUpto + bytesRef.length);
                }
                System.arraycopy(bytesRef.bytes, bytesRef.offset, this.payloadBytes, this.payloadByteUpto, bytesRef.length);
                this.payloadByteUpto += bytesRef.length;
            }
        }
        if (this.writeOffsets) {
            assert (n3 >= this.lastStartOffset);
            assert (n4 >= n3);
            this.offsetStartDeltaBuffer[this.posBufferUpto] = n3 - this.lastStartOffset;
            this.offsetLengthBuffer[this.posBufferUpto] = n4 - n3;
            this.lastStartOffset = n3;
        }
        ++this.posBufferUpto;
        this.lastPosition = n2;
        if (this.posBufferUpto == 128) {
            this.forUtil.writeBlock(this.posDeltaBuffer, this.encoded, this.posOut);
            if (this.writePayloads) {
                this.forUtil.writeBlock(this.payloadLengthBuffer, this.encoded, this.payOut);
                this.payOut.writeVInt(this.payloadByteUpto);
                this.payOut.writeBytes(this.payloadBytes, 0, this.payloadByteUpto);
                this.payloadByteUpto = 0;
            }
            if (this.writeOffsets) {
                this.forUtil.writeBlock(this.offsetStartDeltaBuffer, this.encoded, this.payOut);
                this.forUtil.writeBlock(this.offsetLengthBuffer, this.encoded, this.payOut);
            }
            this.posBufferUpto = 0;
        }
    }

    @Override
    public final void finishDoc() throws IOException {
        if (this.docBufferUpto == 128) {
            this.lastBlockDocID = this.lastDocID;
            if (this.posOut != null) {
                if (this.payOut != null) {
                    this.lastBlockPayFP = this.payOut.getFilePointer();
                }
                this.lastBlockPosFP = this.posOut.getFilePointer();
                this.lastBlockPosBufferUpto = this.posBufferUpto;
                this.lastBlockPayloadByteUpto = this.payloadByteUpto;
            }
            this.docBufferUpto = 0;
        }
    }

    @Override
    public final void finishTerm(BlockTermState blockTermState) throws IOException {
        long l2;
        int n2;
        int n3;
        blockTermState = (Lucene50PostingsFormat.IntBlockTermState)blockTermState;
        assert (((Lucene50PostingsFormat.IntBlockTermState)blockTermState).docFreq > 0);
        assert (((Lucene50PostingsFormat.IntBlockTermState)blockTermState).docFreq == this.docCount) : ((Lucene50PostingsFormat.IntBlockTermState)blockTermState).docFreq + " vs " + this.docCount;
        if (((Lucene50PostingsFormat.IntBlockTermState)blockTermState).docFreq == 1) {
            n3 = this.docDeltaBuffer[0];
        } else {
            n3 = -1;
            for (int i2 = 0; i2 < this.docBufferUpto; ++i2) {
                int n4 = this.docDeltaBuffer[i2];
                n2 = this.freqBuffer[i2];
                if (!this.writeFreqs) {
                    this.docOut.writeVInt(n4);
                    continue;
                }
                if (this.freqBuffer[i2] == 1) {
                    this.docOut.writeVInt(n4 << 1 | 1);
                    continue;
                }
                this.docOut.writeVInt(n4 << 1);
                this.docOut.writeVInt(n2);
            }
        }
        if (this.writePositions) {
            assert (((Lucene50PostingsFormat.IntBlockTermState)blockTermState).totalTermFreq != -1L);
            l2 = ((Lucene50PostingsFormat.IntBlockTermState)blockTermState).totalTermFreq > 128L ? this.posOut.getFilePointer() - this.posStartFP : -1L;
            if (this.posBufferUpto > 0) {
                n2 = -1;
                int n5 = -1;
                int n6 = 0;
                for (int i3 = 0; i3 < this.posBufferUpto; ++i3) {
                    int n7;
                    int n8 = this.posDeltaBuffer[i3];
                    if (this.writePayloads) {
                        n7 = this.payloadLengthBuffer[i3];
                        if (n7 != n2) {
                            n2 = n7;
                            this.posOut.writeVInt(n8 << 1 | 1);
                            this.posOut.writeVInt(n7);
                        } else {
                            this.posOut.writeVInt(n8 << 1);
                        }
                        if (n7 != 0) {
                            this.posOut.writeBytes(this.payloadBytes, n6, n7);
                            n6 += n7;
                        }
                    } else {
                        this.posOut.writeVInt(n8);
                    }
                    if (!this.writeOffsets) continue;
                    n7 = this.offsetStartDeltaBuffer[i3];
                    n8 = this.offsetLengthBuffer[i3];
                    if (n8 == n5) {
                        this.posOut.writeVInt(n7 << 1);
                        continue;
                    }
                    this.posOut.writeVInt(n7 << 1 | 1);
                    this.posOut.writeVInt(n8);
                    n5 = n8;
                }
                if (this.writePayloads) {
                    assert (n6 == this.payloadByteUpto);
                    this.payloadByteUpto = 0;
                }
            }
        } else {
            l2 = -1L;
        }
        long l3 = this.docCount > 128 ? this.skipWriter.writeSkip(this.docOut) - this.docStartFP : -1L;
        ((Lucene50PostingsFormat.IntBlockTermState)blockTermState).docStartFP = this.docStartFP;
        ((Lucene50PostingsFormat.IntBlockTermState)blockTermState).posStartFP = this.posStartFP;
        ((Lucene50PostingsFormat.IntBlockTermState)blockTermState).payStartFP = this.payStartFP;
        ((Lucene50PostingsFormat.IntBlockTermState)blockTermState).singletonDocID = n3;
        ((Lucene50PostingsFormat.IntBlockTermState)blockTermState).skipOffset = l3;
        ((Lucene50PostingsFormat.IntBlockTermState)blockTermState).lastPosBlockOffset = l2;
        this.docBufferUpto = 0;
        this.posBufferUpto = 0;
        this.lastDocID = 0;
        this.docCount = 0;
    }

    @Override
    public final void encodeTerm(long[] lArray, DataOutput dataOutput, FieldInfo object, BlockTermState blockTermState, boolean bl) throws IOException {
        object = (Lucene50PostingsFormat.IntBlockTermState)blockTermState;
        if (bl) {
            this.lastState = emptyState;
        }
        lArray[0] = ((Lucene50PostingsFormat.IntBlockTermState)object).docStartFP - this.lastState.docStartFP;
        if (this.writePositions) {
            lArray[1] = ((Lucene50PostingsFormat.IntBlockTermState)object).posStartFP - this.lastState.posStartFP;
            if (this.writePayloads || this.writeOffsets) {
                lArray[2] = ((Lucene50PostingsFormat.IntBlockTermState)object).payStartFP - this.lastState.payStartFP;
            }
        }
        if (((Lucene50PostingsFormat.IntBlockTermState)object).singletonDocID != -1) {
            dataOutput.writeVInt(((Lucene50PostingsFormat.IntBlockTermState)object).singletonDocID);
        }
        if (this.writePositions && ((Lucene50PostingsFormat.IntBlockTermState)object).lastPosBlockOffset != -1L) {
            dataOutput.writeVLong(((Lucene50PostingsFormat.IntBlockTermState)object).lastPosBlockOffset);
        }
        if (((Lucene50PostingsFormat.IntBlockTermState)object).skipOffset != -1L) {
            dataOutput.writeVLong(((Lucene50PostingsFormat.IntBlockTermState)object).skipOffset);
        }
        this.lastState = object;
    }

    @Override
    public final void close() throws IOException {
        block4: {
            try {
                if (this.docOut != null) {
                    CodecUtil.writeFooter(this.docOut);
                }
                if (this.posOut != null) {
                    CodecUtil.writeFooter(this.posOut);
                }
                if (this.payOut == null) break block4;
                CodecUtil.writeFooter(this.payOut);
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException(this.docOut, this.posOut, this.payOut);
                this.payOut = null;
                this.posOut = null;
                this.docOut = null;
                throw throwable;
            }
        }
        IOUtils.close(this.docOut, this.posOut, this.payOut);
        this.payOut = null;
        this.posOut = null;
        this.docOut = null;
    }
}

