/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.IOException;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.blocktree.BlockTreeTermsReader;
import org.apache.lucene.codecs.blocktree.BlockTreeTermsWriter;
import org.apache.lucene.codecs.d;
import org.apache.lucene.codecs.e;
import org.apache.lucene.codecs.lucene50.Lucene50PostingsReader;
import org.apache.lucene.codecs.lucene50.Lucene50PostingsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.q;
import org.apache.lucene.util.IOUtils;

public final class Lucene50PostingsFormat
extends PostingsFormat {
    public static final String DOC_EXTENSION = "doc";
    public static final String POS_EXTENSION = "pos";
    public static final String PAY_EXTENSION = "pay";
    static final int MAX_SKIP_LEVELS = 10;
    static final String TERMS_CODEC = "Lucene50PostingsWriterTerms";
    static final String DOC_CODEC = "Lucene50PostingsWriterDoc";
    static final String POS_CODEC = "Lucene50PostingsWriterPos";
    static final String PAY_CODEC = "Lucene50PostingsWriterPay";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;
    private final int minTermBlockSize;
    private final int maxTermBlockSize;
    public static final int BLOCK_SIZE = 128;

    public Lucene50PostingsFormat() {
        this(25, 48);
    }

    public Lucene50PostingsFormat(int n2, int n3) {
        super("Lucene50");
        BlockTreeTermsWriter.validateSettings(n2, n3);
        this.minTermBlockSize = n2;
        this.maxTermBlockSize = n3;
    }

    @Override
    public final String toString() {
        return this.getName() + "(blocksize=128)";
    }

    @Override
    public final d fieldsConsumer(SegmentWriteState object) throws IOException {
        Lucene50PostingsWriter lucene50PostingsWriter = new Lucene50PostingsWriter((SegmentWriteState)object);
        try {
            object = new BlockTreeTermsWriter((SegmentWriteState)object, lucene50PostingsWriter, this.minTermBlockSize, this.maxTermBlockSize);
            return object;
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(lucene50PostingsWriter);
            throw throwable;
        }
    }

    @Override
    public final e fieldsProducer(SegmentReadState object) throws IOException {
        Lucene50PostingsReader lucene50PostingsReader = new Lucene50PostingsReader((SegmentReadState)object);
        try {
            object = new BlockTreeTermsReader(lucene50PostingsReader, (SegmentReadState)object);
            return object;
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(lucene50PostingsReader);
            throw throwable;
        }
    }

    static final class IntBlockTermState
    extends BlockTermState {
        long docStartFP = 0L;
        long posStartFP = 0L;
        long payStartFP = 0L;
        long skipOffset = -1L;
        long lastPosBlockOffset = -1L;
        int singletonDocID = -1;

        IntBlockTermState() {
        }

        @Override
        public final IntBlockTermState clone() {
            IntBlockTermState intBlockTermState = new IntBlockTermState();
            intBlockTermState.copyFrom(this);
            return intBlockTermState;
        }

        @Override
        public final void copyFrom(q q2) {
            super.copyFrom(q2);
            q2 = (IntBlockTermState)q2;
            this.docStartFP = ((IntBlockTermState)q2).docStartFP;
            this.posStartFP = ((IntBlockTermState)q2).posStartFP;
            this.payStartFP = ((IntBlockTermState)q2).payStartFP;
            this.lastPosBlockOffset = ((IntBlockTermState)q2).lastPosBlockOffset;
            this.skipOffset = ((IntBlockTermState)q2).skipOffset;
            this.singletonDocID = ((IntBlockTermState)q2).singletonDocID;
        }

        @Override
        public final String toString() {
            return super.toString() + " docStartFP=" + this.docStartFP + " posStartFP=" + this.posStartFP + " payStartFP=" + this.payStartFP + " lastPosBlockOffset=" + this.lastPosBlockOffset + " singletonDocID=" + this.singletonDocID;
        }
    }
}

