/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.c;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.b;

public final class Lucene50FieldInfosFormat
extends c {
    static final String EXTENSION = "fnm";
    static final String CODEC_NAME = "Lucene50FieldInfos";
    static final int FORMAT_START = 0;
    static final int FORMAT_SAFE_MAPS = 1;
    static final int FORMAT_CURRENT = 1;
    static final byte STORE_TERMVECTOR = 1;
    static final byte OMIT_NORMS = 2;
    static final byte STORE_PAYLOADS = 4;

    @Override
    public final FieldInfos read(org.apache.lucene.store.c closeable, SegmentInfo object, String string, IOContext object2) throws IOException {
        FieldInfos fieldInfos;
        block17: {
            FieldInfo[] fieldInfoArray = IndexFileNames.segmentFileName(((SegmentInfo)object).name, string, EXTENSION);
            closeable = ((org.apache.lucene.store.c)closeable).openChecksumInput((String)fieldInfoArray, (IOContext)object2);
            object2 = null;
            try {
                fieldInfoArray = null;
                try {
                    int n2 = CodecUtil.checkIndexHeader((DataInput)((Object)closeable), CODEC_NAME, 0, 1, ((SegmentInfo)object).getId(), string);
                    int n3 = ((DataInput)((Object)closeable)).readVInt();
                    fieldInfoArray = new FieldInfo[n3];
                    Map<Object, Object> map = Collections.emptyMap();
                    for (int i2 = 0; i2 < n3; ++i2) {
                        String string2 = ((DataInput)((Object)closeable)).readString();
                        int n4 = ((DataInput)((Object)closeable)).readVInt();
                        if (n4 < 0) {
                            throw new CorruptIndexException("invalid field number for field: " + string2 + ", fieldNumber=" + n4, (DataInput)((Object)closeable));
                        }
                        int n5 = ((DataInput)((Object)closeable)).readByte();
                        boolean bl = (n5 & 1) != 0;
                        boolean bl2 = (n5 & 2) != 0;
                        n5 = (n5 & 4) != 0 ? 1 : 0;
                        IndexOptions indexOptions = Lucene50FieldInfosFormat.getIndexOptions((IndexInput)closeable, ((DataInput)((Object)closeable)).readByte());
                        DocValuesType docValuesType = Lucene50FieldInfosFormat.getDocValuesType((IndexInput)closeable, ((DataInput)((Object)closeable)).readByte());
                        long l2 = ((DataInput)((Object)closeable)).readLong();
                        Map<String, String> map2 = n2 > 0 ? ((DataInput)((Object)closeable)).readMapOfStrings() : Collections.unmodifiableMap(((DataInput)((Object)closeable)).readStringStringMap());
                        if (map2.equals(map)) {
                            map2 = map;
                        }
                        map = map2;
                        try {
                            fieldInfoArray[i2] = new FieldInfo(string2, n4, bl, bl2, n5 != 0, indexOptions, docValuesType, l2, map2);
                            fieldInfoArray[i2].checkConsistency();
                            continue;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw new CorruptIndexException("invalid fieldinfo for field: " + string2 + ", fieldNumber=" + n4, (DataInput)((Object)closeable), (Throwable)illegalStateException);
                        }
                    }
                }
                catch (Throwable throwable) {
                    CodecUtil.checkFooter((b)closeable, throwable);
                }
                catch (Throwable throwable) {
                    CodecUtil.checkFooter((b)closeable, null);
                    throw throwable;
                }
                CodecUtil.checkFooter((b)closeable, null);
                fieldInfos = new FieldInfos(fieldInfoArray);
                if (closeable == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    object = throwable;
                    object2 = throwable;
                    throw object;
                }
                catch (Throwable throwable2) {
                    if (closeable != null) {
                        if (object2 != null) {
                            try {
                                ((IndexInput)closeable).close();
                            }
                            catch (Throwable throwable3) {
                                ((Throwable)object2).addSuppressed(throwable3);
                            }
                        } else {
                            ((IndexInput)closeable).close();
                        }
                    }
                    throw throwable2;
                }
            }
            ((IndexInput)closeable).close();
        }
        return fieldInfos;
    }

    private static byte docValuesByte(DocValuesType docValuesType) {
        switch (docValuesType) {
            case NONE: {
                return 0;
            }
            case NUMERIC: {
                return 1;
            }
            case BINARY: {
                return 2;
            }
            case SORTED: {
                return 3;
            }
            case SORTED_SET: {
                return 4;
            }
            case SORTED_NUMERIC: {
                return 5;
            }
        }
        throw new AssertionError((Object)("unhandled DocValuesType: " + (Object)((Object)docValuesType)));
    }

    private static DocValuesType getDocValuesType(IndexInput indexInput, byte by) throws IOException {
        switch (by) {
            case 0: {
                return DocValuesType.NONE;
            }
            case 1: {
                return DocValuesType.NUMERIC;
            }
            case 2: {
                return DocValuesType.BINARY;
            }
            case 3: {
                return DocValuesType.SORTED;
            }
            case 4: {
                return DocValuesType.SORTED_SET;
            }
            case 5: {
                return DocValuesType.SORTED_NUMERIC;
            }
        }
        throw new CorruptIndexException("invalid docvalues byte: " + by, indexInput);
    }

    private static byte indexOptionsByte(IndexOptions indexOptions) {
        switch (indexOptions) {
            case NONE: {
                return 0;
            }
            case DOCS: {
                return 1;
            }
            case DOCS_AND_FREQS: {
                return 2;
            }
            case DOCS_AND_FREQS_AND_POSITIONS: {
                return 3;
            }
            case DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS: {
                return 4;
            }
        }
        throw new AssertionError((Object)("unhandled IndexOptions: " + (Object)((Object)indexOptions)));
    }

    private static IndexOptions getIndexOptions(IndexInput indexInput, byte by) throws IOException {
        switch (by) {
            case 0: {
                return IndexOptions.NONE;
            }
            case 1: {
                return IndexOptions.DOCS;
            }
            case 2: {
                return IndexOptions.DOCS_AND_FREQS;
            }
            case 3: {
                return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
            }
            case 4: {
                return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
            }
        }
        throw new CorruptIndexException("invalid IndexOptions byte: " + by, indexInput);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void write(org.apache.lucene.store.c closeable, SegmentInfo iterator, String object3, FieldInfos fieldInfos, IOContext object2) throws IOException {
        String string = IndexFileNames.segmentFileName(((SegmentInfo)((Object)iterator)).name, (String)object3, EXTENSION);
        closeable = ((org.apache.lucene.store.c)closeable).createOutput(string, (IOContext)object2);
        object2 = null;
        try {
            CodecUtil.writeIndexHeader((DataOutput)((Object)closeable), CODEC_NAME, 1, ((SegmentInfo)((Object)iterator)).getId(), (String)object3);
            ((DataOutput)((Object)closeable)).writeVInt(fieldInfos.size());
            for (Object object3 : fieldInfos) {
                ((FieldInfo)object3).checkConsistency();
                ((DataOutput)((Object)closeable)).writeString(((FieldInfo)object3).name);
                ((DataOutput)((Object)closeable)).writeVInt(((FieldInfo)object3).number);
                byte by = 0;
                if (((FieldInfo)object3).hasVectors()) {
                    by = 1;
                }
                if (((FieldInfo)object3).omitsNorms()) {
                    by = (byte)(by | 2);
                }
                if (((FieldInfo)object3).hasPayloads()) {
                    by = (byte)(by | 4);
                }
                ((DataOutput)((Object)closeable)).writeByte(by);
                ((DataOutput)((Object)closeable)).writeByte(Lucene50FieldInfosFormat.indexOptionsByte(((FieldInfo)object3).getIndexOptions()));
                ((DataOutput)((Object)closeable)).writeByte(Lucene50FieldInfosFormat.docValuesByte(((FieldInfo)object3).getDocValuesType()));
                ((DataOutput)((Object)closeable)).writeLong(((FieldInfo)object3).getDocValuesGen());
                ((DataOutput)((Object)closeable)).writeMapOfStrings(((FieldInfo)object3).attributes());
            }
            CodecUtil.writeFooter((IndexOutput)closeable);
            if (closeable == null) return;
        }
        catch (Throwable throwable) {
            try {
                iterator = throwable;
                object2 = throwable;
                throw iterator;
            }
            catch (Throwable throwable2) {
                if (closeable == null) throw throwable2;
                if (object2 != null) {
                    try {
                        ((IndexOutput)closeable).close();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        ((Throwable)object2).addSuppressed(throwable3);
                    }
                    throw throwable2;
                } else {
                    ((IndexOutput)closeable).close();
                }
                throw throwable2;
            }
        }
        ((IndexOutput)closeable).close();
        return;
    }

    static {
        assert (DocValuesType.values().length == 6);
        assert (IndexOptions.values().length == 5);
    }
}

