/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.b;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.a;
import org.apache.lucene.index.m;
import org.apache.lucene.index.n;
import org.apache.lucene.index.p;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.h;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.DirectReader;
import org.apache.lucene.util.packed.MonotonicBlockPackedReader;

class Lucene50DocValuesProducer
extends b
implements Closeable {
    private final Map<String, NumericEntry> numerics;
    private final Map<String, BinaryEntry> binaries;
    private final Map<String, SortedSetEntry> sortedSets;
    private final Map<String, SortedSetEntry> sortedNumerics;
    private final Map<String, NumericEntry> ords;
    private final Map<String, NumericEntry> ordIndexes;
    private final int numFields;
    private final AtomicLong ramBytesUsed;
    private final IndexInput data;
    private final int maxDoc;
    private final Map<String, MonotonicBlockPackedReader> addressInstances;
    private final Map<String, MonotonicBlockPackedReader> ordIndexInstances;
    private final Map<String, ReverseTermsIndex> reverseIndexInstances;
    private final boolean merging;

    Lucene50DocValuesProducer(Lucene50DocValuesProducer lucene50DocValuesProducer) throws IOException {
        this.numerics = new HashMap<String, NumericEntry>();
        this.binaries = new HashMap<String, BinaryEntry>();
        this.sortedSets = new HashMap<String, SortedSetEntry>();
        this.sortedNumerics = new HashMap<String, SortedSetEntry>();
        this.ords = new HashMap<String, NumericEntry>();
        this.ordIndexes = new HashMap<String, NumericEntry>();
        this.addressInstances = new HashMap<String, MonotonicBlockPackedReader>();
        this.ordIndexInstances = new HashMap<String, MonotonicBlockPackedReader>();
        this.reverseIndexInstances = new HashMap<String, ReverseTermsIndex>();
        assert (Thread.holdsLock(lucene50DocValuesProducer));
        this.numerics.putAll(lucene50DocValuesProducer.numerics);
        this.binaries.putAll(lucene50DocValuesProducer.binaries);
        this.sortedSets.putAll(lucene50DocValuesProducer.sortedSets);
        this.sortedNumerics.putAll(lucene50DocValuesProducer.sortedNumerics);
        this.ords.putAll(lucene50DocValuesProducer.ords);
        this.ordIndexes.putAll(lucene50DocValuesProducer.ordIndexes);
        this.numFields = lucene50DocValuesProducer.numFields;
        this.ramBytesUsed = new AtomicLong(lucene50DocValuesProducer.ramBytesUsed.get());
        this.data = lucene50DocValuesProducer.data.clone();
        this.maxDoc = lucene50DocValuesProducer.maxDoc;
        this.addressInstances.putAll(lucene50DocValuesProducer.addressInstances);
        this.ordIndexInstances.putAll(lucene50DocValuesProducer.ordIndexInstances);
        this.reverseIndexInstances.putAll(lucene50DocValuesProducer.reverseIndexInstances);
        this.merging = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Lucene50DocValuesProducer(SegmentReadState segmentReadState, String string, String string2, String object, String object2) throws IOException {
        int n2;
        int n3;
        block14: {
            this.numerics = new HashMap<String, NumericEntry>();
            this.binaries = new HashMap<String, BinaryEntry>();
            this.sortedSets = new HashMap<String, SortedSetEntry>();
            this.sortedNumerics = new HashMap<String, SortedSetEntry>();
            this.ords = new HashMap<String, NumericEntry>();
            this.ordIndexes = new HashMap<String, NumericEntry>();
            this.addressInstances = new HashMap<String, MonotonicBlockPackedReader>();
            this.ordIndexInstances = new HashMap<String, MonotonicBlockPackedReader>();
            this.reverseIndexInstances = new HashMap<String, ReverseTermsIndex>();
            object2 = IndexFileNames.segmentFileName(segmentReadState.segmentInfo.name, segmentReadState.segmentSuffix, (String)object2);
            this.maxDoc = segmentReadState.segmentInfo.maxDoc();
            this.merging = false;
            this.ramBytesUsed = new AtomicLong(RamUsageEstimator.shallowSizeOfInstance(this.getClass()));
            n3 = -1;
            n2 = -1;
            object2 = segmentReadState.directory.openChecksumInput((String)object2, segmentReadState.context);
            Throwable throwable = null;
            try {
                block13: {
                    try {
                        n3 = CodecUtil.checkIndexHeader((DataInput)object2, (String)object, 0, 1, segmentReadState.segmentInfo.getId(), segmentReadState.segmentSuffix);
                        n2 = this.readFields((IndexInput)object2, segmentReadState.fieldInfos);
                    }
                    catch (Throwable throwable2) {
                        CodecUtil.checkFooter((org.apache.lucene.store.b)object2, throwable2);
                        break block13;
                    }
                    catch (Throwable throwable3) {
                        CodecUtil.checkFooter((org.apache.lucene.store.b)object2, null);
                        throw throwable3;
                    }
                    CodecUtil.checkFooter((org.apache.lucene.store.b)object2, null);
                }
                if (object2 == null) break block14;
            }
            catch (Throwable throwable4) {
                try {
                    object = throwable4;
                    throwable = throwable4;
                    throw object;
                }
                catch (Throwable throwable5) {
                    if (object2 == null) throw throwable5;
                    if (throwable == null) {
                        ((IndexInput)object2).close();
                        throw throwable5;
                    }
                    try {
                        ((IndexInput)object2).close();
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                        throw throwable5;
                    }
                }
            }
            ((IndexInput)object2).close();
        }
        this.numFields = n2;
        object2 = IndexFileNames.segmentFileName(segmentReadState.segmentInfo.name, segmentReadState.segmentSuffix, string2);
        this.data = segmentReadState.directory.openInput((String)object2, segmentReadState.context);
        try {
            int n4 = CodecUtil.checkIndexHeader(this.data, string, 0, 1, segmentReadState.segmentInfo.getId(), segmentReadState.segmentSuffix);
            if (n3 != n4) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + n3 + ", data=" + n4, this.data);
            }
            CodecUtil.retrieveChecksum(this.data);
            return;
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(this.data);
            throw throwable;
        }
    }

    private void readSortedField(FieldInfo fieldInfo, IndexInput object) throws IOException {
        if (((DataInput)object).readVInt() != fieldInfo.number) {
            throw new CorruptIndexException("sorted entry for field: " + fieldInfo.name + " is corrupt", (DataInput)object);
        }
        if (((DataInput)object).readByte() != 1) {
            throw new CorruptIndexException("sorted entry for field: " + fieldInfo.name + " is corrupt", (DataInput)object);
        }
        BinaryEntry binaryEntry = Lucene50DocValuesProducer.readBinaryEntry((IndexInput)object);
        this.binaries.put(fieldInfo.name, binaryEntry);
        if (((DataInput)object).readVInt() != fieldInfo.number) {
            throw new CorruptIndexException("sorted entry for field: " + fieldInfo.name + " is corrupt", (DataInput)object);
        }
        if (((DataInput)object).readByte() != 0) {
            throw new CorruptIndexException("sorted entry for field: " + fieldInfo.name + " is corrupt", (DataInput)object);
        }
        object = this.readNumericEntry((IndexInput)object);
        this.ords.put(fieldInfo.name, (NumericEntry)object);
    }

    private void readSortedSetFieldWithAddresses(FieldInfo fieldInfo, IndexInput object) throws IOException {
        if (((DataInput)object).readVInt() != fieldInfo.number) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldInfo.name + " is corrupt", (DataInput)object);
        }
        if (((DataInput)object).readByte() != 1) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldInfo.name + " is corrupt", (DataInput)object);
        }
        Object object2 = Lucene50DocValuesProducer.readBinaryEntry((IndexInput)object);
        this.binaries.put(fieldInfo.name, (BinaryEntry)object2);
        if (((DataInput)object).readVInt() != fieldInfo.number) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldInfo.name + " is corrupt", (DataInput)object);
        }
        if (((DataInput)object).readByte() != 0) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldInfo.name + " is corrupt", (DataInput)object);
        }
        object2 = this.readNumericEntry((IndexInput)object);
        this.ords.put(fieldInfo.name, (NumericEntry)object2);
        if (((DataInput)object).readVInt() != fieldInfo.number) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldInfo.name + " is corrupt", (DataInput)object);
        }
        if (((DataInput)object).readByte() != 0) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldInfo.name + " is corrupt", (DataInput)object);
        }
        object = this.readNumericEntry((IndexInput)object);
        this.ordIndexes.put(fieldInfo.name, (NumericEntry)object);
    }

    private void readSortedSetFieldWithTable(FieldInfo fieldInfo, IndexInput object) throws IOException {
        if (((DataInput)object).readVInt() != fieldInfo.number) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldInfo.name + " is corrupt", (DataInput)object);
        }
        if (((DataInput)object).readByte() != 1) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldInfo.name + " is corrupt", (DataInput)object);
        }
        BinaryEntry binaryEntry = Lucene50DocValuesProducer.readBinaryEntry((IndexInput)object);
        this.binaries.put(fieldInfo.name, binaryEntry);
        if (((DataInput)object).readVInt() != fieldInfo.number) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldInfo.name + " is corrupt", (DataInput)object);
        }
        if (((DataInput)object).readByte() != 0) {
            throw new CorruptIndexException("sortedset entry for field: " + fieldInfo.name + " is corrupt", (DataInput)object);
        }
        object = this.readNumericEntry((IndexInput)object);
        this.ords.put(fieldInfo.name, (NumericEntry)object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int readFields(IndexInput indexInput, FieldInfos fieldInfos) throws IOException {
        int n2 = 0;
        int n3 = indexInput.readVInt();
        while (n3 != -1) {
            ++n2;
            FieldInfo fieldInfo = fieldInfos.fieldInfo(n3);
            if (fieldInfo == null) {
                throw new CorruptIndexException("Invalid field number: " + n3, indexInput);
            }
            byte by = indexInput.readByte();
            if (by == 0) {
                this.numerics.put(fieldInfo.name, this.readNumericEntry(indexInput));
            } else if (by == 1) {
                BinaryEntry binaryEntry = Lucene50DocValuesProducer.readBinaryEntry(indexInput);
                this.binaries.put(fieldInfo.name, binaryEntry);
            } else if (by == 2) {
                this.readSortedField(fieldInfo, indexInput);
            } else if (by == 3) {
                SortedSetEntry sortedSetEntry = this.readSortedSetEntry(indexInput);
                this.sortedSets.put(fieldInfo.name, sortedSetEntry);
                if (sortedSetEntry.format == 0) {
                    this.readSortedSetFieldWithAddresses(fieldInfo, indexInput);
                } else if (sortedSetEntry.format == 2) {
                    this.readSortedSetFieldWithTable(fieldInfo, indexInput);
                } else {
                    if (sortedSetEntry.format != 1) throw new AssertionError();
                    if (indexInput.readVInt() != n3) {
                        throw new CorruptIndexException("sortedset entry for field: " + fieldInfo.name + " is corrupt", indexInput);
                    }
                    if (indexInput.readByte() != 2) {
                        throw new CorruptIndexException("sortedset entry for field: " + fieldInfo.name + " is corrupt", indexInput);
                    }
                    this.readSortedField(fieldInfo, indexInput);
                }
            } else {
                if (by != 4) throw new CorruptIndexException("invalid type: " + by, indexInput);
                SortedSetEntry sortedSetEntry = this.readSortedSetEntry(indexInput);
                this.sortedNumerics.put(fieldInfo.name, sortedSetEntry);
                if (sortedSetEntry.format == 0) {
                    if (indexInput.readVInt() != n3) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + fieldInfo.name + " is corrupt", indexInput);
                    }
                    if (indexInput.readByte() != 0) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + fieldInfo.name + " is corrupt", indexInput);
                    }
                    this.numerics.put(fieldInfo.name, this.readNumericEntry(indexInput));
                    if (indexInput.readVInt() != n3) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + fieldInfo.name + " is corrupt", indexInput);
                    }
                    if (indexInput.readByte() != 0) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + fieldInfo.name + " is corrupt", indexInput);
                    }
                    NumericEntry numericEntry = this.readNumericEntry(indexInput);
                    this.ordIndexes.put(fieldInfo.name, numericEntry);
                } else if (sortedSetEntry.format == 2) {
                    if (indexInput.readVInt() != fieldInfo.number) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + fieldInfo.name + " is corrupt", indexInput);
                    }
                    if (indexInput.readByte() != 0) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + fieldInfo.name + " is corrupt", indexInput);
                    }
                    NumericEntry numericEntry = this.readNumericEntry(indexInput);
                    this.ords.put(fieldInfo.name, numericEntry);
                } else {
                    if (sortedSetEntry.format != 1) throw new AssertionError();
                    if (indexInput.readVInt() != n3) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + fieldInfo.name + " is corrupt", indexInput);
                    }
                    if (indexInput.readByte() != 0) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + fieldInfo.name + " is corrupt", indexInput);
                    }
                    this.numerics.put(fieldInfo.name, this.readNumericEntry(indexInput));
                }
            }
            n3 = indexInput.readVInt();
        }
        return n2;
    }

    private NumericEntry readNumericEntry(IndexInput indexInput) throws IOException {
        NumericEntry numericEntry = new NumericEntry();
        new NumericEntry().format = indexInput.readVInt();
        numericEntry.missingOffset = indexInput.readLong();
        numericEntry.offset = indexInput.readLong();
        numericEntry.count = indexInput.readVLong();
        switch (numericEntry.format) {
            case 4: {
                numericEntry.minValue = indexInput.readLong();
                if (numericEntry.count <= Integer.MAX_VALUE) break;
                throw new CorruptIndexException("illegal CONST_COMPRESSED count: " + numericEntry.count, indexInput);
            }
            case 1: {
                numericEntry.minValue = indexInput.readLong();
                numericEntry.gcd = indexInput.readLong();
                numericEntry.bitsPerValue = indexInput.readVInt();
                break;
            }
            case 2: {
                int n2 = indexInput.readVInt();
                if (n2 > 256) {
                    throw new CorruptIndexException("TABLE_COMPRESSED cannot have more than 256 distinct values, got=" + n2, indexInput);
                }
                numericEntry.table = new long[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    numericEntry.table[i2] = indexInput.readLong();
                }
                this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf(numericEntry.table));
                numericEntry.bitsPerValue = indexInput.readVInt();
                break;
            }
            case 0: {
                numericEntry.minValue = indexInput.readLong();
                numericEntry.bitsPerValue = indexInput.readVInt();
                break;
            }
            case 3: {
                numericEntry.packedIntsVersion = indexInput.readVInt();
                numericEntry.blockSize = indexInput.readVInt();
                break;
            }
            default: {
                throw new CorruptIndexException("Unknown format: " + numericEntry.format + ", input=", indexInput);
            }
        }
        numericEntry.endOffset = indexInput.readLong();
        return numericEntry;
    }

    static BinaryEntry readBinaryEntry(IndexInput indexInput) throws IOException {
        BinaryEntry binaryEntry = new BinaryEntry();
        new BinaryEntry().format = indexInput.readVInt();
        binaryEntry.missingOffset = indexInput.readLong();
        binaryEntry.minLength = indexInput.readVInt();
        binaryEntry.maxLength = indexInput.readVInt();
        binaryEntry.count = indexInput.readVLong();
        binaryEntry.offset = indexInput.readLong();
        switch (binaryEntry.format) {
            case 0: {
                break;
            }
            case 2: {
                binaryEntry.addressesOffset = indexInput.readLong();
                binaryEntry.packedIntsVersion = indexInput.readVInt();
                binaryEntry.blockSize = indexInput.readVInt();
                binaryEntry.reverseIndexOffset = indexInput.readLong();
                break;
            }
            case 1: {
                binaryEntry.addressesOffset = indexInput.readLong();
                binaryEntry.packedIntsVersion = indexInput.readVInt();
                binaryEntry.blockSize = indexInput.readVInt();
                break;
            }
            default: {
                throw new CorruptIndexException("Unknown format: " + binaryEntry.format, indexInput);
            }
        }
        return binaryEntry;
    }

    SortedSetEntry readSortedSetEntry(IndexInput indexInput) throws IOException {
        SortedSetEntry sortedSetEntry = new SortedSetEntry();
        new SortedSetEntry().format = indexInput.readVInt();
        if (sortedSetEntry.format == 2) {
            int n2;
            int n3 = indexInput.readInt();
            if (n3 > 256) {
                throw new CorruptIndexException("SORTED_SET_TABLE cannot have more than 256 values in its dictionary, got=" + n3, indexInput);
            }
            sortedSetEntry.table = new long[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                sortedSetEntry.table[n2] = indexInput.readLong();
            }
            this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf(sortedSetEntry.table));
            n2 = indexInput.readInt();
            if (n2 > n3 + 1) {
                throw new CorruptIndexException("SORTED_SET_TABLE cannot have more set ids than ords in its dictionary, got " + n3 + " ords and " + n2 + " sets", indexInput);
            }
            sortedSetEntry.tableOffsets = new int[n2 + 1];
            for (n3 = 1; n3 < sortedSetEntry.tableOffsets.length; ++n3) {
                sortedSetEntry.tableOffsets[n3] = sortedSetEntry.tableOffsets[n3 - 1] + indexInput.readInt();
            }
            this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf(sortedSetEntry.tableOffsets));
        } else if (sortedSetEntry.format != 1 && sortedSetEntry.format != 0) {
            throw new CorruptIndexException("Unknown format: " + sortedSetEntry.format, indexInput);
        }
        return sortedSetEntry;
    }

    @Override
    public m getNumeric(FieldInfo object) throws IOException {
        object = this.numerics.get(((FieldInfo)object).name);
        return this.getNumeric((NumericEntry)object);
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed.get();
    }

    @Override
    public synchronized Collection<org.apache.lucene.util.a> getChildResources() {
        ArrayList<org.apache.lucene.util.a> arrayList = new ArrayList<org.apache.lucene.util.a>();
        arrayList.addAll(org.apache.lucene.util.b.a("addresses field", this.addressInstances));
        arrayList.addAll(org.apache.lucene.util.b.a("ord index field", this.ordIndexInstances));
        arrayList.addAll(org.apache.lucene.util.b.a("reverse index field", this.reverseIndexInstances));
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.data);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.numFields + ")";
    }

    LongValues getNumeric(NumericEntry object) throws IOException {
        switch (((NumericEntry)object).format) {
            case 4: {
                final long l2 = ((NumericEntry)object).minValue;
                final Bits bits = this.getLiveBits(((NumericEntry)object).missingOffset, (int)((NumericEntry)object).count);
                return new LongValues(){

                    @Override
                    public long get(long l22) {
                        if (bits.get((int)l22)) {
                            return l2;
                        }
                        return 0L;
                    }
                };
            }
            case 0: {
                h h2 = this.data.randomAccessSlice(((NumericEntry)object).offset, ((NumericEntry)object).endOffset - ((NumericEntry)object).offset);
                final long l3 = ((NumericEntry)object).minValue;
                final LongValues longValues = DirectReader.a(h2, ((NumericEntry)object).bitsPerValue);
                return new LongValues(){

                    @Override
                    public long get(long l2) {
                        return l3 + longValues.get(l2);
                    }
                };
            }
            case 1: {
                h h3 = this.data.randomAccessSlice(((NumericEntry)object).offset, ((NumericEntry)object).endOffset - ((NumericEntry)object).offset);
                final long l4 = ((NumericEntry)object).minValue;
                final long l5 = ((NumericEntry)object).gcd;
                object = DirectReader.a(h3, ((NumericEntry)object).bitsPerValue);
                return new LongValues((LongValues)object){
                    final /* synthetic */ LongValues val$quotientReader;
                    {
                        this.val$quotientReader = longValues;
                    }

                    @Override
                    public long get(long l2) {
                        return l4 + l5 * this.val$quotientReader.get(l2);
                    }
                };
            }
            case 2: {
                h h4 = this.data.randomAccessSlice(((NumericEntry)object).offset, ((NumericEntry)object).endOffset - ((NumericEntry)object).offset);
                final long[] lArray = ((NumericEntry)object).table;
                final LongValues longValues = DirectReader.a(h4, ((NumericEntry)object).bitsPerValue);
                return new LongValues(){

                    @Override
                    public long get(long l2) {
                        return lArray[(int)longValues.get(l2)];
                    }
                };
            }
        }
        throw new AssertionError();
    }

    @Override
    public a getBinary(FieldInfo fieldInfo) throws IOException {
        BinaryEntry binaryEntry = this.binaries.get(fieldInfo.name);
        switch (binaryEntry.format) {
            case 0: {
                return this.getFixedBinary(fieldInfo, binaryEntry);
            }
            case 1: {
                return this.getVariableBinary(fieldInfo, binaryEntry);
            }
            case 2: {
                return this.getCompressedBinary(fieldInfo, binaryEntry);
            }
        }
        throw new AssertionError();
    }

    private a getFixedBinary(FieldInfo object, BinaryEntry binaryEntry) throws IOException {
        object = this.data.slice("fixed-binary", binaryEntry.offset, binaryEntry.count * (long)binaryEntry.maxLength);
        BytesRef bytesRef = new BytesRef(binaryEntry.maxLength);
        byte[] byArray = bytesRef.bytes;
        int n2 = bytesRef.length = binaryEntry.maxLength;
        return new LongBinaryDocValues((IndexInput)object, n2, byArray, bytesRef){
            final /* synthetic */ IndexInput val$data;
            final /* synthetic */ int val$length;
            final /* synthetic */ byte[] val$buffer;
            final /* synthetic */ BytesRef val$term;
            {
                this.val$data = indexInput;
                this.val$length = n2;
                this.val$buffer = byArray;
                this.val$term = bytesRef;
            }

            @Override
            public BytesRef get(long l2) {
                try {
                    this.val$data.seek(l2 * (long)this.val$length);
                    this.val$data.readBytes(this.val$buffer, 0, this.val$buffer.length);
                    return this.val$term;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        };
    }

    private synchronized MonotonicBlockPackedReader getAddressInstance(FieldInfo fieldInfo, BinaryEntry binaryEntry) throws IOException {
        MonotonicBlockPackedReader monotonicBlockPackedReader = this.addressInstances.get(fieldInfo.name);
        if (monotonicBlockPackedReader == null) {
            this.data.seek(binaryEntry.addressesOffset);
            monotonicBlockPackedReader = MonotonicBlockPackedReader.of(this.data, binaryEntry.packedIntsVersion, binaryEntry.blockSize, binaryEntry.count + 1L, false);
            if (!this.merging) {
                this.addressInstances.put(fieldInfo.name, monotonicBlockPackedReader);
                this.ramBytesUsed.addAndGet(monotonicBlockPackedReader.ramBytesUsed() + 4L);
            }
        }
        return monotonicBlockPackedReader;
    }

    private a getVariableBinary(FieldInfo object, BinaryEntry object2) throws IOException {
        object = this.getAddressInstance((FieldInfo)object, (BinaryEntry)object2);
        IndexInput indexInput = this.data.slice("var-binary", ((BinaryEntry)object2).offset, ((BinaryEntry)object2).addressesOffset - ((BinaryEntry)object2).offset);
        object2 = new BytesRef(Math.max(0, ((BinaryEntry)object2).maxLength));
        byte[] byArray = ((BytesRef)object2).bytes;
        return new LongBinaryDocValues((MonotonicBlockPackedReader)object, indexInput, byArray, (BytesRef)object2){
            final /* synthetic */ MonotonicBlockPackedReader val$addresses;
            final /* synthetic */ IndexInput val$data;
            final /* synthetic */ byte[] val$buffer;
            final /* synthetic */ BytesRef val$term;
            {
                this.val$addresses = monotonicBlockPackedReader;
                this.val$data = indexInput;
                this.val$buffer = byArray;
                this.val$term = bytesRef;
            }

            @Override
            public BytesRef get(long l2) {
                long l3 = this.val$addresses.get(l2);
                int n2 = (int)(this.val$addresses.get(l2 + 1L) - l3);
                try {
                    this.val$data.seek(l3);
                    this.val$data.readBytes(this.val$buffer, 0, n2);
                    this.val$term.length = n2;
                    return this.val$term;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        };
    }

    private synchronized MonotonicBlockPackedReader getIntervalInstance(FieldInfo fieldInfo, BinaryEntry binaryEntry) throws IOException {
        MonotonicBlockPackedReader monotonicBlockPackedReader = this.addressInstances.get(fieldInfo.name);
        if (monotonicBlockPackedReader == null) {
            this.data.seek(binaryEntry.addressesOffset);
            long l2 = binaryEntry.count + 15L >>> 4;
            monotonicBlockPackedReader = MonotonicBlockPackedReader.of(this.data, binaryEntry.packedIntsVersion, binaryEntry.blockSize, l2, false);
            if (!this.merging) {
                this.addressInstances.put(fieldInfo.name, monotonicBlockPackedReader);
                this.ramBytesUsed.addAndGet(monotonicBlockPackedReader.ramBytesUsed() + 4L);
            }
        }
        return monotonicBlockPackedReader;
    }

    private synchronized ReverseTermsIndex getReverseIndexInstance(FieldInfo fieldInfo, BinaryEntry object) throws IOException {
        ReverseTermsIndex reverseTermsIndex = this.reverseIndexInstances.get(fieldInfo.name);
        if (reverseTermsIndex == null) {
            reverseTermsIndex = new ReverseTermsIndex();
            this.data.seek(((BinaryEntry)object).reverseIndexOffset);
            long l2 = ((BinaryEntry)object).count + 1023L >>> 10;
            reverseTermsIndex.termAddresses = MonotonicBlockPackedReader.of(this.data, ((BinaryEntry)object).packedIntsVersion, ((BinaryEntry)object).blockSize, l2, false);
            long l3 = this.data.readVLong();
            object = new PagedBytes(15);
            ((PagedBytes)object).copy(this.data, l3);
            reverseTermsIndex.terms = ((PagedBytes)object).freeze(true);
            if (!this.merging) {
                this.reverseIndexInstances.put(fieldInfo.name, reverseTermsIndex);
                this.ramBytesUsed.addAndGet(reverseTermsIndex.ramBytesUsed());
            }
        }
        return reverseTermsIndex;
    }

    private a getCompressedBinary(FieldInfo object, BinaryEntry binaryEntry) throws IOException {
        MonotonicBlockPackedReader monotonicBlockPackedReader = this.getIntervalInstance((FieldInfo)object, binaryEntry);
        object = this.getReverseIndexInstance((FieldInfo)object, binaryEntry);
        assert (monotonicBlockPackedReader.size() > 0L);
        IndexInput indexInput = this.data.slice("terms", binaryEntry.offset, binaryEntry.addressesOffset - binaryEntry.offset);
        return new CompressedBinaryDocValues(binaryEntry, monotonicBlockPackedReader, (ReverseTermsIndex)object, indexInput);
    }

    @Override
    public SortedDocValues getSorted(FieldInfo object) throws IOException {
        int n2 = (int)this.binaries.get((Object)((FieldInfo)object).name).count;
        a a2 = this.getBinary((FieldInfo)object);
        object = this.ords.get(((FieldInfo)object).name);
        object = this.getNumeric((NumericEntry)object);
        return new SortedDocValues((LongValues)object, a2, n2){
            final /* synthetic */ LongValues val$ordinals;
            final /* synthetic */ a val$binary;
            final /* synthetic */ int val$valueCount;
            {
                this.val$ordinals = longValues;
                this.val$binary = a2;
                this.val$valueCount = n2;
            }

            @Override
            public int getOrd(int n2) {
                return (int)this.val$ordinals.get(n2);
            }

            @Override
            public BytesRef lookupOrd(int n2) {
                return this.val$binary.get(n2);
            }

            @Override
            public int getValueCount() {
                return this.val$valueCount;
            }

            @Override
            public int lookupTerm(BytesRef bytesRef) {
                if (this.val$binary instanceof CompressedBinaryDocValues) {
                    return (int)((CompressedBinaryDocValues)this.val$binary).lookupTerm(bytesRef);
                }
                return super.lookupTerm(bytesRef);
            }

            @Override
            public TermsEnum termsEnum() {
                if (this.val$binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)this.val$binary).getTermsEnum();
                }
                return super.termsEnum();
            }
        };
    }

    private synchronized MonotonicBlockPackedReader getOrdIndexInstance(FieldInfo fieldInfo, NumericEntry numericEntry) throws IOException {
        MonotonicBlockPackedReader monotonicBlockPackedReader = this.ordIndexInstances.get(fieldInfo.name);
        if (monotonicBlockPackedReader == null) {
            this.data.seek(numericEntry.offset);
            monotonicBlockPackedReader = MonotonicBlockPackedReader.of(this.data, numericEntry.packedIntsVersion, numericEntry.blockSize, numericEntry.count + 1L, false);
            if (!this.merging) {
                this.ordIndexInstances.put(fieldInfo.name, monotonicBlockPackedReader);
                this.ramBytesUsed.addAndGet(monotonicBlockPackedReader.ramBytesUsed() + 4L);
            }
        }
        return monotonicBlockPackedReader;
    }

    @Override
    public p getSortedNumeric(FieldInfo object) throws IOException {
        Object object2 = this.sortedNumerics.get(((FieldInfo)object).name);
        if (((SortedSetEntry)object2).format == 1) {
            NumericEntry numericEntry = this.numerics.get(((FieldInfo)object).name);
            LongValues longValues = this.getNumeric(numericEntry);
            object = this.getLiveBits(numericEntry.missingOffset, this.maxDoc);
            return DocValues.singleton(longValues, (Bits)object);
        }
        if (((SortedSetEntry)object2).format == 0) {
            NumericEntry numericEntry = this.numerics.get(((FieldInfo)object).name);
            LongValues longValues = this.getNumeric(numericEntry);
            object = this.getOrdIndexInstance((FieldInfo)object, this.ordIndexes.get(((FieldInfo)object).name));
            return new p((MonotonicBlockPackedReader)object, longValues){
                long startOffset;
                long endOffset;
                final /* synthetic */ MonotonicBlockPackedReader val$ordIndex;
                final /* synthetic */ LongValues val$values;
                {
                    this.val$ordIndex = monotonicBlockPackedReader;
                    this.val$values = longValues;
                }

                @Override
                public void setDocument(int n2) {
                    this.startOffset = this.val$ordIndex.get(n2);
                    this.endOffset = this.val$ordIndex.get((long)n2 + 1L);
                }

                @Override
                public long valueAt(int n2) {
                    return this.val$values.get(this.startOffset + (long)n2);
                }

                @Override
                public int count() {
                    return (int)(this.endOffset - this.startOffset);
                }
            };
        }
        if (((SortedSetEntry)object2).format == 2) {
            NumericEntry numericEntry = this.ords.get(((FieldInfo)object).name);
            final LongValues longValues = this.getNumeric(numericEntry);
            object = ((SortedSetEntry)object2).table;
            object2 = ((SortedSetEntry)object2).tableOffsets;
            return new p((int[])object2, (long[])object){
                int startOffset;
                int endOffset;
                final /* synthetic */ int[] val$offsets;
                final /* synthetic */ long[] val$table;
                {
                    this.val$offsets = nArray;
                    this.val$table = lArray;
                }

                @Override
                public void setDocument(int n2) {
                    n2 = (int)longValues.get(n2);
                    this.startOffset = this.val$offsets[n2];
                    this.endOffset = this.val$offsets[n2 + 1];
                }

                @Override
                public long valueAt(int n2) {
                    return this.val$table[this.startOffset + n2];
                }

                @Override
                public int count() {
                    return this.endOffset - this.startOffset;
                }
            };
        }
        throw new AssertionError();
    }

    @Override
    public SortedSetDocValues getSortedSet(FieldInfo fieldInfo) throws IOException {
        SortedSetEntry sortedSetEntry = this.sortedSets.get(fieldInfo.name);
        switch (sortedSetEntry.format) {
            case 1: {
                return DocValues.singleton(this.getSorted(fieldInfo));
            }
            case 0: {
                return this.getSortedSetWithAddresses(fieldInfo);
            }
            case 2: {
                return this.getSortedSetTable(fieldInfo, sortedSetEntry);
            }
        }
        throw new AssertionError();
    }

    private SortedSetDocValues getSortedSetWithAddresses(FieldInfo object) throws IOException {
        long l2 = this.binaries.get((Object)((FieldInfo)object).name).count;
        LongBinaryDocValues longBinaryDocValues = (LongBinaryDocValues)this.getBinary((FieldInfo)object);
        final LongValues longValues = this.getNumeric(this.ords.get(((FieldInfo)object).name));
        object = this.getOrdIndexInstance((FieldInfo)object, this.ordIndexes.get(((FieldInfo)object).name));
        return new n((MonotonicBlockPackedReader)object, longBinaryDocValues, l2){
            long startOffset;
            long offset;
            long endOffset;
            final /* synthetic */ MonotonicBlockPackedReader val$ordIndex;
            final /* synthetic */ LongBinaryDocValues val$binary;
            final /* synthetic */ long val$valueCount;
            {
                this.val$ordIndex = monotonicBlockPackedReader;
                this.val$binary = longBinaryDocValues;
                this.val$valueCount = l2;
            }

            @Override
            public long nextOrd() {
                if (this.offset == this.endOffset) {
                    return -1L;
                }
                long l2 = longValues.get(this.offset);
                ++this.offset;
                return l2;
            }

            @Override
            public void setDocument(int n2) {
                this.startOffset = this.offset = this.val$ordIndex.get(n2);
                this.endOffset = this.val$ordIndex.get((long)n2 + 1L);
            }

            @Override
            public BytesRef lookupOrd(long l2) {
                return this.val$binary.get(l2);
            }

            @Override
            public long getValueCount() {
                return this.val$valueCount;
            }

            @Override
            public long lookupTerm(BytesRef bytesRef) {
                if (this.val$binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)this.val$binary).lookupTerm(bytesRef);
                }
                return super.lookupTerm(bytesRef);
            }

            @Override
            public TermsEnum termsEnum() {
                if (this.val$binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)this.val$binary).getTermsEnum();
                }
                return super.termsEnum();
            }

            @Override
            public long ordAt(int n2) {
                return longValues.get(this.startOffset + (long)n2);
            }

            @Override
            public int cardinality() {
                return (int)(this.endOffset - this.startOffset);
            }
        };
    }

    private SortedSetDocValues getSortedSetTable(FieldInfo object, SortedSetEntry object2) throws IOException {
        long l2 = this.binaries.get((Object)((FieldInfo)object).name).count;
        LongBinaryDocValues longBinaryDocValues = (LongBinaryDocValues)this.getBinary((FieldInfo)object);
        object = this.getNumeric(this.ords.get(((FieldInfo)object).name));
        long[] lArray = ((SortedSetEntry)object2).table;
        object2 = ((SortedSetEntry)object2).tableOffsets;
        return new n((LongValues)object, (int[])object2, lArray, longBinaryDocValues, l2){
            int offset;
            int startOffset;
            int endOffset;
            final /* synthetic */ LongValues val$ordinals;
            final /* synthetic */ int[] val$offsets;
            final /* synthetic */ long[] val$table;
            final /* synthetic */ LongBinaryDocValues val$binary;
            final /* synthetic */ long val$valueCount;
            {
                this.val$ordinals = longValues;
                this.val$offsets = nArray;
                this.val$table = lArray;
                this.val$binary = longBinaryDocValues;
                this.val$valueCount = l2;
            }

            @Override
            public void setDocument(int n2) {
                n2 = (int)this.val$ordinals.get(n2);
                this.offset = this.startOffset = this.val$offsets[n2];
                this.endOffset = this.val$offsets[n2 + 1];
            }

            @Override
            public long ordAt(int n2) {
                return this.val$table[this.startOffset + n2];
            }

            @Override
            public long nextOrd() {
                if (this.offset == this.endOffset) {
                    return -1L;
                }
                return this.val$table[this.offset++];
            }

            @Override
            public int cardinality() {
                return this.endOffset - this.startOffset;
            }

            @Override
            public BytesRef lookupOrd(long l2) {
                return this.val$binary.get(l2);
            }

            @Override
            public long getValueCount() {
                return this.val$valueCount;
            }

            @Override
            public long lookupTerm(BytesRef bytesRef) {
                if (this.val$binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)this.val$binary).lookupTerm(bytesRef);
                }
                return super.lookupTerm(bytesRef);
            }

            @Override
            public TermsEnum termsEnum() {
                if (this.val$binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)this.val$binary).getTermsEnum();
                }
                return super.termsEnum();
            }
        };
    }

    private Bits getLiveBits(long l2, final int n2) throws IOException {
        if (l2 == -2L) {
            return new Bits.MatchNoBits(n2);
        }
        if (l2 == -1L) {
            return new Bits.MatchAllBits(n2);
        }
        int n3 = (int)((long)n2 + 7L >>> 3);
        final h h2 = this.data.randomAccessSlice(l2, n3);
        return new Bits(){

            @Override
            public boolean get(int n22) {
                try {
                    return (h2.readByte(n22 >> 3) & 1 << (n22 & 7)) != 0;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }

            @Override
            public int length() {
                return n2;
            }
        };
    }

    @Override
    public Bits getDocsWithField(FieldInfo object) throws IOException {
        switch (((FieldInfo)object).getDocValuesType()) {
            case SORTED_SET: {
                return DocValues.docsWithValue(this.getSortedSet((FieldInfo)object), this.maxDoc);
            }
            case SORTED_NUMERIC: {
                return DocValues.docsWithValue(this.getSortedNumeric((FieldInfo)object), this.maxDoc);
            }
            case SORTED: {
                return DocValues.docsWithValue(this.getSorted((FieldInfo)object), this.maxDoc);
            }
            case BINARY: {
                object = this.binaries.get(((FieldInfo)object).name);
                return this.getLiveBits(((BinaryEntry)object).missingOffset, this.maxDoc);
            }
            case NUMERIC: {
                object = this.numerics.get(((FieldInfo)object).name);
                return this.getLiveBits(((NumericEntry)object).missingOffset, this.maxDoc);
            }
        }
        throw new AssertionError();
    }

    @Override
    public synchronized b getMergeInstance() throws IOException {
        return new Lucene50DocValuesProducer(this);
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    static final class CompressedBinaryDocValues
    extends LongBinaryDocValues {
        final long numValues;
        final long numIndexValues;
        final int maxTermLength;
        final MonotonicBlockPackedReader addresses;
        final IndexInput data;
        final CompressedBinaryTermsEnum termsEnum;
        final PagedBytes.Reader reverseTerms;
        final MonotonicBlockPackedReader reverseAddresses;
        final long numReverseIndexValues;

        public CompressedBinaryDocValues(BinaryEntry binaryEntry, MonotonicBlockPackedReader monotonicBlockPackedReader, ReverseTermsIndex reverseTermsIndex, IndexInput indexInput) throws IOException {
            this.maxTermLength = binaryEntry.maxLength;
            this.numValues = binaryEntry.count;
            this.addresses = monotonicBlockPackedReader;
            this.numIndexValues = monotonicBlockPackedReader.size();
            this.data = indexInput;
            this.reverseTerms = reverseTermsIndex.terms;
            this.reverseAddresses = reverseTermsIndex.termAddresses;
            this.numReverseIndexValues = this.reverseAddresses.size();
            this.termsEnum = this.getTermsEnum(indexInput);
        }

        @Override
        public final BytesRef get(long l2) {
            try {
                this.termsEnum.seekExact(l2);
                return this.termsEnum.term();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        final long lookupTerm(BytesRef bytesRef) {
            try {
                switch (this.termsEnum.seekCeil(bytesRef)) {
                    case FOUND: {
                        return this.termsEnum.ord();
                    }
                    case NOT_FOUND: {
                        return -this.termsEnum.ord() - 1L;
                    }
                }
                return -this.numValues - 1L;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        final TermsEnum getTermsEnum() {
            try {
                return this.getTermsEnum(this.data.clone());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        private CompressedBinaryTermsEnum getTermsEnum(IndexInput indexInput) throws IOException {
            return new CompressedBinaryTermsEnum(indexInput);
        }

        class CompressedBinaryTermsEnum
        extends TermsEnum {
            private long currentOrd = -1L;
            private long currentBlockStart;
            private final IndexInput input;
            private final int[] offsets = new int[16];
            private final byte[] buffer = new byte[31];
            private final BytesRef term;
            private final BytesRef firstTerm;
            private final BytesRef scratch;

            CompressedBinaryTermsEnum(IndexInput indexInput) throws IOException {
                this.term = new BytesRef(CompressedBinaryDocValues.this.maxTermLength);
                this.firstTerm = new BytesRef(CompressedBinaryDocValues.this.maxTermLength);
                this.scratch = new BytesRef();
                this.input = indexInput;
                indexInput.seek(0L);
            }

            private void readHeader() throws IOException {
                this.firstTerm.length = this.input.readVInt();
                this.input.readBytes(this.firstTerm.bytes, 0, this.firstTerm.length);
                this.input.readBytes(this.buffer, 0, 15);
                if (this.buffer[0] == -1) {
                    this.readShortAddresses();
                } else {
                    this.readByteAddresses();
                }
                this.currentBlockStart = this.input.getFilePointer();
            }

            private void readByteAddresses() throws IOException {
                int n2 = 0;
                for (int i2 = 1; i2 < this.offsets.length; ++i2) {
                    this.offsets[i2] = n2 += 2 + (this.buffer[i2 - 1] & 0xFF);
                }
            }

            private void readShortAddresses() throws IOException {
                this.input.readBytes(this.buffer, 15, 16);
                int n2 = 0;
                for (int i2 = 1; i2 < this.offsets.length; ++i2) {
                    int n3 = i2 << 1;
                    this.offsets[i2] = n2 += 2 + (this.buffer[n3 - 1] << 8 | this.buffer[n3] & 0xFF);
                }
            }

            private void readFirstTerm() throws IOException {
                this.term.length = this.firstTerm.length;
                System.arraycopy(this.firstTerm.bytes, this.firstTerm.offset, this.term.bytes, 0, this.term.length);
            }

            private void readTerm(int n2) throws IOException {
                int n3 = this.input.readByte() & 0xFF;
                System.arraycopy(this.firstTerm.bytes, this.firstTerm.offset, this.term.bytes, 0, n3);
                n2 = this.offsets[n2] - this.offsets[n2 - 1] - 1;
                this.input.readBytes(this.term.bytes, n3, n2);
                this.term.length = n3 + n2;
            }

            @Override
            public BytesRef next() throws IOException {
                ++this.currentOrd;
                if (this.currentOrd >= CompressedBinaryDocValues.this.numValues) {
                    return null;
                }
                int n2 = (int)(this.currentOrd & 0xFL);
                if (n2 == 0) {
                    this.readHeader();
                    this.readFirstTerm();
                } else {
                    this.readTerm(n2);
                }
                return this.term;
            }

            long binarySearchIndex(BytesRef bytesRef) throws IOException {
                long l2 = 0L;
                long l3 = CompressedBinaryDocValues.this.numReverseIndexValues - 1L;
                while (l2 <= l3) {
                    long l4 = l2 + l3 >>> 1;
                    CompressedBinaryDocValues.this.reverseTerms.fill(this.scratch, CompressedBinaryDocValues.this.reverseAddresses.get(l4));
                    int n2 = this.scratch.compareTo(bytesRef);
                    if (n2 < 0) {
                        l2 = l4 + 1L;
                        continue;
                    }
                    if (n2 > 0) {
                        l3 = l4 - 1L;
                        continue;
                    }
                    return l4;
                }
                return l3;
            }

            long binarySearchBlock(BytesRef bytesRef, long l2, long l3) throws IOException {
                while (l2 <= l3) {
                    long l4 = l2 + l3 >>> 1;
                    this.input.seek(CompressedBinaryDocValues.this.addresses.get(l4));
                    this.term.length = this.input.readVInt();
                    this.input.readBytes(this.term.bytes, 0, this.term.length);
                    int n2 = this.term.compareTo(bytesRef);
                    if (n2 < 0) {
                        l2 = l4 + 1L;
                        continue;
                    }
                    if (n2 > 0) {
                        l3 = l4 - 1L;
                        continue;
                    }
                    return l4;
                }
                return l3;
            }

            @Override
            public TermsEnum.SeekStatus seekCeil(BytesRef bytesRef) throws IOException {
                long l2;
                long l3 = this.binarySearchIndex(bytesRef);
                if (l3 < 0L) {
                    l2 = 0L;
                } else {
                    long l4 = l3 << 6;
                    long l5 = Math.min(CompressedBinaryDocValues.this.numIndexValues - 1L, l4 + 63L);
                    l2 = Math.max(l4, this.binarySearchBlock(bytesRef, l4, l5));
                }
                this.input.seek(CompressedBinaryDocValues.this.addresses.get(l2));
                this.currentOrd = (l2 << 4) - 1L;
                while (this.next() != null) {
                    int n2 = this.term.compareTo(bytesRef);
                    if (n2 == 0) {
                        return TermsEnum.SeekStatus.FOUND;
                    }
                    if (n2 <= 0) continue;
                    return TermsEnum.SeekStatus.NOT_FOUND;
                }
                return TermsEnum.SeekStatus.END;
            }

            @Override
            public void seekExact(long l2) throws IOException {
                long l3 = l2 >>> 4;
                if (l3 != this.currentOrd >>> 4) {
                    this.input.seek(CompressedBinaryDocValues.this.addresses.get(l3));
                    this.readHeader();
                }
                this.currentOrd = l2;
                int n2 = (int)(l2 & 0xFL);
                if (n2 == 0) {
                    this.readFirstTerm();
                    return;
                }
                this.input.seek(this.currentBlockStart + (long)this.offsets[n2 - 1]);
                this.readTerm(n2);
            }

            @Override
            public BytesRef term() throws IOException {
                return this.term;
            }

            @Override
            public long ord() throws IOException {
                return this.currentOrd;
            }

            @Override
            public int docFreq() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public long totalTermFreq() throws IOException {
                return -1L;
            }

            @Override
            public PostingsEnum postings(PostingsEnum postingsEnum, int n2) throws IOException {
                throw new UnsupportedOperationException();
            }
        }
    }

    static class ReverseTermsIndex
    implements org.apache.lucene.util.a {
        public MonotonicBlockPackedReader termAddresses;
        public PagedBytes.Reader terms;

        ReverseTermsIndex() {
        }

        @Override
        public long ramBytesUsed() {
            return this.termAddresses.ramBytesUsed() + this.terms.ramBytesUsed();
        }

        @Override
        public Collection<org.apache.lucene.util.a> getChildResources() {
            ArrayList<org.apache.lucene.util.a> arrayList = new ArrayList<org.apache.lucene.util.a>();
            arrayList.add(org.apache.lucene.util.b.a("term bytes", this.terms));
            arrayList.add(org.apache.lucene.util.b.a("term addresses", this.termAddresses));
            return Collections.unmodifiableList(arrayList);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(size=" + this.termAddresses.size() + ")";
        }
    }

    static abstract class LongBinaryDocValues
    extends a {
        LongBinaryDocValues() {
        }

        @Override
        public final BytesRef get(int n2) {
            return this.get((long)n2);
        }

        abstract BytesRef get(long var1);
    }

    static class SortedSetEntry {
        int format;
        long[] table;
        int[] tableOffsets;

        private SortedSetEntry() {
        }
    }

    static class BinaryEntry {
        long missingOffset;
        long offset;
        int format;
        public long count;
        int minLength;
        int maxLength;
        public long addressesOffset;
        public long reverseIndexOffset;
        public int packedIntsVersion;
        public int blockSize;

        private BinaryEntry() {
        }
    }

    static class NumericEntry {
        long missingOffset;
        public long offset;
        public long endOffset;
        public int bitsPerValue;
        int format;
        public int packedIntsVersion;
        public long count;
        public int blockSize;
        long minValue;
        long gcd;
        long[] table;

        private NumericEntry() {
        }
    }
}

