/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LongsRef;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.h;
import org.apache.lucene.util.packed.DirectWriter;
import org.apache.lucene.util.packed.MonotonicBlockPackedWriter;

class Lucene50DocValuesConsumer
extends DocValuesConsumer
implements Closeable {
    IndexOutput data;
    IndexOutput meta;
    final int maxDoc;

    public Lucene50DocValuesConsumer(SegmentWriteState segmentWriteState, String string, String string2, String string3, String string4) throws IOException {
        try {
            string2 = IndexFileNames.segmentFileName(segmentWriteState.segmentInfo.name, segmentWriteState.segmentSuffix, string2);
            this.data = segmentWriteState.directory.createOutput(string2, segmentWriteState.context);
            CodecUtil.writeIndexHeader(this.data, string, 1, segmentWriteState.segmentInfo.getId(), segmentWriteState.segmentSuffix);
            string = IndexFileNames.segmentFileName(segmentWriteState.segmentInfo.name, segmentWriteState.segmentSuffix, string4);
            this.meta = segmentWriteState.directory.createOutput(string, segmentWriteState.context);
            CodecUtil.writeIndexHeader(this.meta, string3, 1, segmentWriteState.segmentInfo.getId(), segmentWriteState.segmentSuffix);
            this.maxDoc = segmentWriteState.segmentInfo.maxDoc();
            return;
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    @Override
    public void addNumericField(FieldInfo fieldInfo, Iterable<Number> iterable) throws IOException {
        this.addNumericField(fieldInfo, iterable, true);
    }

    /*
     * WARNING - void declaration
     */
    void addNumericField(FieldInfo object, Iterable<Number> object2, boolean bl) throws IOException {
        void var3_10;
        int n2;
        long l2;
        Iterator iterator;
        long l3 = 0L;
        long l4 = Long.MAX_VALUE;
        long l5 = Long.MIN_VALUE;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        HashSet<Long> hashSet = null;
        if (bl) {
            hashSet = new HashSet<Long>();
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                Number number = (Number)iterator.next();
                if (number == null) {
                    l2 = 0L;
                    ++l7;
                    ++l8;
                } else {
                    l2 = number.longValue();
                    if (l2 == 0L) {
                        ++l8;
                    }
                }
                if (l6 != 1L) {
                    if (l2 < -4611686018427387904L || l2 > 0x3FFFFFFFFFFFFFFFL) {
                        l6 = 1L;
                    } else if (l3 != 0L) {
                        l6 = h.a(l6, l2 - l4);
                    }
                }
                l4 = Math.min(l4, l2);
                l5 = Math.max(l5, l2);
                if (hashSet != null && hashSet.add(l2) && hashSet.size() > 256) {
                    hashSet = null;
                }
                ++l3;
            }
        } else {
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                l2 = ((Number)iterator.next()).longValue();
                l4 = Math.min(l4, l2);
                l5 = Math.max(l5, l2);
                ++l3;
            }
        }
        long l9 = l5 - l4;
        int n3 = DirectWriter.unsignedBitsRequired(l9);
        int n4 = n2 = hashSet == null ? Integer.MAX_VALUE : DirectWriter.bitsRequired(hashSet.size() - 1);
        if (hashSet != null && l3 <= Integer.MAX_VALUE && (hashSet.size() == 1 || hashSet.size() == 2 && l7 > 0L && l8 == l7)) {
            int n5 = 4;
        } else if (hashSet != null && n2 < n3) {
            int n6 = 2;
        } else if (l6 != 0L && l6 != 1L) {
            boolean bl2 = (long)DirectWriter.unsignedBitsRequired((l5 - l4) / l6) < (long)n3;
        } else {
            boolean bl3 = false;
        }
        this.meta.writeVInt(((FieldInfo)((Object)object)).number);
        this.meta.writeByte((byte)0);
        this.meta.writeVInt((int)var3_10);
        if (l7 == 0L) {
            this.meta.writeLong(-1L);
        } else if (l7 == l3) {
            this.meta.writeLong(-2L);
        } else {
            this.meta.writeLong(this.data.getFilePointer());
            this.writeMissingBitset((Iterable<?>)object2);
        }
        this.meta.writeLong(this.data.getFilePointer());
        this.meta.writeVLong(l3);
        switch (var3_10) {
            case 4: {
                this.meta.writeLong(l4 < 0L ? (Long)Collections.min(hashSet) : (Long)Collections.max(hashSet));
                break;
            }
            case 1: {
                this.meta.writeLong(l4);
                this.meta.writeLong(l6);
                int n5 = DirectWriter.unsignedBitsRequired((l5 - l4) / l6);
                this.meta.writeVInt(n5);
                DirectWriter directWriter = DirectWriter.getInstance(this.data, l3, n5);
                Iterator iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    Number number = (Number)iterator2.next();
                    long l10 = number == null ? 0L : number.longValue();
                    directWriter.add((l10 - l4) / l6);
                }
                directWriter.finish();
                break;
            }
            case 0: {
                long l11 = l9 < 0L ? 0L : l4;
                this.meta.writeLong(l11);
                this.meta.writeVInt(n3);
                DirectWriter directWriter = DirectWriter.getInstance(this.data, l3, n3);
                Iterator iterator3 = object2.iterator();
                while (iterator3.hasNext()) {
                    object = (Number)iterator3.next();
                    long l12 = object == null ? 0L : ((Number)object).longValue();
                    directWriter.add(l12 - l11);
                }
                directWriter.finish();
                break;
            }
            case 2: {
                Object[] objectArray = hashSet.toArray(new Long[hashSet.size()]);
                Arrays.sort(objectArray);
                object = new HashMap();
                this.meta.writeVInt(objectArray.length);
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    this.meta.writeLong((Long)objectArray[i2]);
                    ((HashMap)object).put(objectArray[i2], i2);
                }
                this.meta.writeVInt(n2);
                DirectWriter directWriter = DirectWriter.getInstance(this.data, l3, n2);
                Iterator iterator4 = object2.iterator();
                while (iterator4.hasNext()) {
                    object2 = (Number)iterator4.next();
                    directWriter.add(((Integer)((HashMap)object).get(object2 == null ? 0L : ((Number)object2).longValue())).intValue());
                }
                directWriter.finish();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.meta.writeLong(this.data.getFilePointer());
    }

    void writeMissingBitset(Iterable<?> object) throws IOException {
        byte by = 0;
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            if (n2 == 8) {
                this.data.writeByte(by);
                n2 = 0;
                by = 0;
            }
            if (e2 != null) {
                by = (byte)(by | 1 << (n2 & 7));
            }
            ++n2;
        }
        if (n2 > 0) {
            this.data.writeByte(by);
        }
    }

    @Override
    public void addBinaryField(FieldInfo fieldInfo, Iterable<BytesRef> object) throws IOException {
        this.meta.writeVInt(fieldInfo.number);
        this.meta.writeByte((byte)1);
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        long l2 = this.data.getFilePointer();
        long l3 = 0L;
        long l4 = 0L;
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            int n4;
            BytesRef bytesRef = object2.next();
            if (bytesRef == null) {
                n4 = 0;
                ++l4;
            } else {
                n4 = bytesRef.length;
            }
            n2 = Math.min(n2, n4);
            n3 = Math.max(n3, n4);
            if (bytesRef != null) {
                this.data.writeBytes(bytesRef.bytes, bytesRef.offset, bytesRef.length);
            }
            ++l3;
        }
        this.meta.writeVInt(n2 == n3 ? 0 : 1);
        if (l4 == 0L) {
            this.meta.writeLong(-1L);
        } else if (l4 == l3) {
            this.meta.writeLong(-2L);
        } else {
            this.meta.writeLong(this.data.getFilePointer());
            this.writeMissingBitset((Iterable<?>)object);
        }
        this.meta.writeVInt(n2);
        this.meta.writeVInt(n3);
        this.meta.writeVLong(l3);
        this.meta.writeLong(l2);
        if (n2 != n3) {
            this.meta.writeLong(this.data.getFilePointer());
            this.meta.writeVInt(2);
            this.meta.writeVInt(16384);
            object2 = new MonotonicBlockPackedWriter(this.data, 16384);
            long l5 = 0L;
            ((MonotonicBlockPackedWriter)object2).add(0L);
            Iterator<BytesRef> iterator = object.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (object != null) {
                    l5 += (long)((BytesRef)object).length;
                }
                ((MonotonicBlockPackedWriter)object2).add(l5);
            }
            ((MonotonicBlockPackedWriter)object2).finish();
        }
    }

    private void addTermsDict(FieldInfo fieldInfo, Iterable<BytesRef> iterable) throws IOException {
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        long l2 = 0L;
        for (BytesRef bytesRef : iterable) {
            n2 = Math.min(n2, bytesRef.length);
            n3 = Math.max(n3, bytesRef.length);
            ++l2;
        }
        if (n2 == n3) {
            this.addBinaryField(fieldInfo, iterable);
            return;
        }
        if (l2 < 1024L) {
            this.addBinaryField(fieldInfo, iterable);
            return;
        }
        assert (l2 > 0L);
        this.meta.writeVInt(fieldInfo.number);
        this.meta.writeByte((byte)1);
        this.meta.writeVInt(2);
        this.meta.writeLong(-1L);
        long l3 = this.data.getFilePointer();
        RAMOutputStream rAMOutputStream = new RAMOutputStream();
        MonotonicBlockPackedWriter monotonicBlockPackedWriter = new MonotonicBlockPackedWriter(rAMOutputStream, 16384);
        RAMOutputStream rAMOutputStream2 = new RAMOutputStream();
        RAMOutputStream rAMOutputStream3 = new RAMOutputStream();
        BytesRefBuilder bytesRefBuilder = new BytesRefBuilder();
        bytesRefBuilder.grow(n3);
        long l4 = 0L;
        int[] nArray = new int[16];
        for (BytesRef bytesRef : iterable) {
            int n4 = (int)(l4 & 0xFL);
            if (n4 == 0) {
                monotonicBlockPackedWriter.add(this.data.getFilePointer() - l3);
                rAMOutputStream3.writeVInt(bytesRef.length);
                rAMOutputStream3.writeBytes(bytesRef.bytes, bytesRef.offset, bytesRef.length);
                bytesRefBuilder.copyBytes(bytesRef);
            } else {
                int n5 = Math.min(255, StringHelper.bytesDifference(bytesRefBuilder.get(), bytesRef));
                rAMOutputStream2.writeByte((byte)n5);
                rAMOutputStream2.writeBytes(bytesRef.bytes, bytesRef.offset + n5, bytesRef.length - n5);
                nArray[n4] = bytesRef.length - n5 - 1;
            }
            if ((++l4 & 0xFL) != 0L) continue;
            this.flushTermsDictBlock(rAMOutputStream3, rAMOutputStream2, nArray);
        }
        int n6 = (int)(l4 & 0xFL);
        if (n6 > 0) {
            Arrays.fill(nArray, n6, 16, 0);
            this.flushTermsDictBlock(rAMOutputStream3, rAMOutputStream2, nArray);
        }
        long l5 = this.data.getFilePointer();
        monotonicBlockPackedWriter.finish();
        rAMOutputStream.writeTo(this.data);
        this.meta.writeVInt(n2);
        this.meta.writeVInt(n3);
        this.meta.writeVLong(l4);
        this.meta.writeLong(l3);
        this.meta.writeLong(l5);
        this.meta.writeVInt(2);
        this.meta.writeVInt(16384);
        this.addReverseTermIndex(fieldInfo, iterable, n3);
    }

    private void flushTermsDictBlock(RAMOutputStream rAMOutputStream, RAMOutputStream rAMOutputStream2, int[] nArray) throws IOException {
        int n2;
        boolean bl = false;
        for (n2 = 1; n2 < nArray.length; ++n2) {
            if (nArray[n2] <= 254) continue;
            bl = true;
        }
        if (bl) {
            rAMOutputStream.writeByte((byte)-1);
            for (n2 = 1; n2 < nArray.length; ++n2) {
                rAMOutputStream.writeShort((short)nArray[n2]);
            }
        } else {
            for (n2 = 1; n2 < nArray.length; ++n2) {
                rAMOutputStream.writeByte((byte)nArray[n2]);
            }
        }
        rAMOutputStream.writeTo(this.data);
        rAMOutputStream.reset();
        rAMOutputStream2.writeTo(this.data);
        rAMOutputStream2.reset();
    }

    private void addReverseTermIndex(FieldInfo object, Iterable<BytesRef> object2, int n2) throws IOException {
        long l2 = 0L;
        object = new BytesRefBuilder();
        ((BytesRefBuilder)object).grow(n2);
        BytesRef bytesRef = new BytesRef();
        long l3 = this.data.getFilePointer();
        PagedBytes pagedBytes = new PagedBytes(15);
        MonotonicBlockPackedWriter monotonicBlockPackedWriter = new MonotonicBlockPackedWriter(this.data, 16384);
        Iterator<BytesRef> iterator = object2.iterator();
        while (iterator.hasNext()) {
            BytesRef bytesRef2 = iterator.next();
            int n3 = (int)(l2 & 0x3FFL);
            if (n3 == 0) {
                n3 = StringHelper.sortKeyLength(((BytesRefBuilder)object).get(), bytesRef2);
                bytesRef.bytes = bytesRef2.bytes;
                bytesRef.offset = bytesRef2.offset;
                bytesRef.length = n3;
                monotonicBlockPackedWriter.add(pagedBytes.copyUsingLengthPrefix(bytesRef));
            } else if (n3 == 1023) {
                ((BytesRefBuilder)object).copyBytes(bytesRef2);
            }
            ++l2;
        }
        monotonicBlockPackedWriter.finish();
        long l4 = pagedBytes.getPointer();
        pagedBytes.freeze(true);
        object2 = pagedBytes.getDataInput();
        this.meta.writeLong(l3);
        this.data.writeVLong(l4);
        this.data.copyBytes((DataInput)object2, l4);
    }

    @Override
    public void addSortedField(FieldInfo fieldInfo, Iterable<BytesRef> iterable, Iterable<Number> iterable2) throws IOException {
        this.meta.writeVInt(fieldInfo.number);
        this.meta.writeByte((byte)2);
        this.addTermsDict(fieldInfo, iterable);
        this.addNumericField(fieldInfo, iterable2, false);
    }

    @Override
    public void addSortedNumericField(FieldInfo fieldInfo, Iterable<Number> iterable, Iterable<Number> iterable2) throws IOException {
        this.meta.writeVInt(fieldInfo.number);
        this.meta.writeByte((byte)4);
        if (Lucene50DocValuesConsumer.isSingleValued(iterable)) {
            this.meta.writeVInt(1);
            this.addNumericField(fieldInfo, Lucene50DocValuesConsumer.singletonView(iterable, iterable2, null));
            return;
        }
        SortedSet<LongsRef> sortedSet = this.uniqueValueSets(iterable, iterable2);
        if (sortedSet != null) {
            this.meta.writeVInt(2);
            this.writeDictionary(sortedSet);
            this.addNumericField(fieldInfo, this.docToSetId(sortedSet, iterable, iterable2), false);
            return;
        }
        this.meta.writeVInt(0);
        this.addNumericField(fieldInfo, iterable2, true);
        this.addAddresses(fieldInfo, iterable);
    }

    @Override
    public void addSortedSetField(FieldInfo fieldInfo, Iterable<BytesRef> iterable, Iterable<Number> iterable2, Iterable<Number> iterable3) throws IOException {
        this.meta.writeVInt(fieldInfo.number);
        this.meta.writeByte((byte)3);
        if (Lucene50DocValuesConsumer.isSingleValued(iterable2)) {
            this.meta.writeVInt(1);
            this.addSortedField(fieldInfo, iterable, Lucene50DocValuesConsumer.singletonView(iterable2, iterable3, -1L));
            return;
        }
        SortedSet<LongsRef> sortedSet = this.uniqueValueSets(iterable2, iterable3);
        if (sortedSet != null) {
            this.meta.writeVInt(2);
            this.writeDictionary(sortedSet);
            this.addTermsDict(fieldInfo, iterable);
            this.addNumericField(fieldInfo, this.docToSetId(sortedSet, iterable2, iterable3), false);
            return;
        }
        this.meta.writeVInt(0);
        this.addTermsDict(fieldInfo, iterable);
        this.addNumericField(fieldInfo, iterable3, false);
        this.addAddresses(fieldInfo, iterable2);
    }

    private SortedSet<LongsRef> uniqueValueSets(Iterable<Number> object, Iterable<Number> object2) {
        HashSet<LongsRef> hashSet = new HashSet<LongsRef>();
        LongsRef longsRef = new LongsRef(256);
        object = object.iterator();
        object2 = object2.iterator();
        int n2 = 0;
        while (object.hasNext()) {
            longsRef.length = ((Number)object.next()).intValue();
            if (longsRef.length > 256) {
                return null;
            }
            for (int i2 = 0; i2 < longsRef.length; ++i2) {
                longsRef.longs[i2] = ((Number)object2.next()).longValue();
            }
            if (hashSet.contains(longsRef)) continue;
            if ((n2 += longsRef.length) > 256) {
                return null;
            }
            hashSet.add(new LongsRef(Arrays.copyOf(longsRef.longs, longsRef.length), 0, longsRef.length));
        }
        assert (!object2.hasNext());
        return new TreeSet<LongsRef>(hashSet);
    }

    private void writeDictionary(SortedSet<LongsRef> sortedSet) throws IOException {
        int n2 = 0;
        for (LongsRef longsRef : sortedSet) {
            n2 += longsRef.length;
        }
        this.meta.writeInt(n2);
        for (LongsRef longsRef : sortedSet) {
            for (n2 = 0; n2 < longsRef.length; ++n2) {
                this.meta.writeLong(longsRef.longs[longsRef.offset + n2]);
            }
        }
        this.meta.writeInt(sortedSet.size());
        for (LongsRef longsRef : sortedSet) {
            this.meta.writeInt(longsRef.length);
        }
    }

    private Iterable<Number> docToSetId(SortedSet<LongsRef> sortedSet, final Iterable<Number> iterable, final Iterable<Number> iterable2) {
        final HashMap<LongsRef, Integer> hashMap = new HashMap<LongsRef, Integer>();
        int n2 = 0;
        for (LongsRef longsRef : sortedSet) {
            hashMap.put(longsRef, n2++);
        }
        assert (n2 == sortedSet.size());
        return new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                final Iterator iterator = iterable.iterator();
                final Iterator iterator2 = iterable2.iterator();
                final LongsRef longsRef = new LongsRef(256);
                return new Iterator<Number>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Number next() {
                        longsRef.length = ((Number)iterator.next()).intValue();
                        for (int i2 = 0; i2 < longsRef.length; ++i2) {
                            longsRef.longs[i2] = ((Number)iterator2.next()).longValue();
                        }
                        Integer n2 = (Integer)hashMap.get(longsRef);
                        assert (n2 != null);
                        return n2;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private void addAddresses(FieldInfo object, Iterable<Number> object2) throws IOException {
        this.meta.writeVInt(((FieldInfo)object).number);
        this.meta.writeByte((byte)0);
        this.meta.writeVInt(3);
        this.meta.writeLong(-1L);
        this.meta.writeLong(this.data.getFilePointer());
        this.meta.writeVLong(this.maxDoc);
        this.meta.writeVInt(2);
        this.meta.writeVInt(16384);
        object = new MonotonicBlockPackedWriter(this.data, 16384);
        long l2 = 0L;
        ((MonotonicBlockPackedWriter)object).add(0L);
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Number number = (Number)object2.next();
            ((MonotonicBlockPackedWriter)object).add(l2 += number.longValue());
        }
        ((MonotonicBlockPackedWriter)object).finish();
        this.meta.writeLong(this.data.getFilePointer());
    }

    @Override
    public void close() throws IOException {
        block3: {
            try {
                if (this.meta != null) {
                    this.meta.writeVInt(-1);
                    CodecUtil.writeFooter(this.meta);
                }
                if (this.data == null) break block3;
                CodecUtil.writeFooter(this.data);
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException(this.data, this.meta);
                this.data = null;
                this.meta = null;
                throw throwable;
            }
        }
        IOUtils.close(this.data, this.meta);
        this.data = null;
        this.meta = null;
    }
}

